<?php
class ModelSaleMetal extends Model {
	public function addmetal($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "metal SET metalname = '" . $this->db->escape($data['metalname']) . "', description = '" . $this->db->escape($data['description']) . "', metal_code = '" . $this->db->escape($data['metal_code']) . "', silver_ratio = '" . $this->db->escape($data['silver_ratio']) . "', image = '" . $this->db->escape($data['image']) . "', pricepergram = '" . $this->db->escape($data['pricepergram']) . "', sort_order = '" . $this->db->escape($data['sort_order']) . "', ccurrency = '" . $this->db->escape($data['ccurrency']) . "'");
	
		return $this->db->getLastId();
	}

	public function editmetal($metal_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "metal SET metalname = '" . $this->db->escape($data['metalname']) . "', description = '" . $this->db->escape($data['description']) . "', metal_code = '" . $this->db->escape($data['metal_code']) . "', silver_ratio = '" . $this->db->escape($data['silver_ratio']) . "', image = '" . $this->db->escape($data['image']) . "', pricepergram = '" . $this->db->escape($data['pricepergram']) . "', sort_order = '" . $this->db->escape($data['sort_order']) . "', ccurrency = '" . $this->db->escape($data['ccurrency']) . "' WHERE metal_id = '" . (int)$metal_id . "'");
	}

	public function deletemetal($metal_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "metal WHERE metal_id = " . (int)$metal_id);
	}

	public function getmetal($metal_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "metal WHERE metal_id = '" . (int)$metal_id . "'");

		return $query->row;
	}

	public function getmetals($data = array()) {
		$sql = "SELECT metal_id, metalname,metal_code, description,pricepergram,priceperounce FROM " . DB_PREFIX . "metal";

		$sort_data = array(
			'metal_code',
			'metalname',
			'description',
			'pricepergram',
			'priceperounce',
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY metalname";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalmetals() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "metal");

		return $query->row['total'];
	}
}
