<?php
class ModelSaleGemweight extends Model {
	public function addgemweight($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "gemstone_weight SET size_code = '" . $this->db->escape($data['size_code']) . "', weight = '" . $this->db->escape($data['weight']) . "', shape = '" . $this->db->escape($data['shape']) . "', gemstone_id = '" . $this->db->escape($data['gemstone_id']) . "'");
	
		return $this->db->getLastId();
	}

	public function editgemweight($gemstoneweight_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "gemstone_weight SET size_code = '" . $this->db->escape($data['size_code']) . "', weight = '" . $this->db->escape($data['weight']) . "', shape = '" . $this->db->escape($data['shape']) . "', gemstone_id = '" . $this->db->escape($data['gemstone_id']) . "' WHERE gemstoneweight_id = '" . (int)$gemstoneweight_id . "'");
	}

	public function deletegemweight($gemstoneweight_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "gemstone_weight WHERE gemstoneweight_id = " . (int)$gemstoneweight_id);
	}

	public function getgemweight($gemstoneweight_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "gemstone_weight WHERE gemstoneweight_id = '" . (int)$gemstoneweight_id . "'");

		return $query->row;
	}

	public function getgemweights($data = array()) {
		$sql = "SELECT gemstoneweight_id,gemstone_id,(select gs.gemname from gemstone gs where gs.gemstone_id = gw.gemstone_id) as gemname, size_code,weight FROM " . DB_PREFIX . "gemstone_weight gw";

		$sort_data = array(
			'gemstoneweight_id',
			'gemstone_id',
			'size_code',
			'weight',
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY gemname";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalgemweights() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "gemstone_weight");

		return $query->row['total'];
	}
}
