<?php
class ControllerSaleLabourwbc extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/labourwbc');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/labourwbc');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/labourwbc');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/labourwbc');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_labourwbc->addlabourwbc($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/labourwbc', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/labourwbc');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/labourwbc');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_labourwbc->editlabourwbc($this->request->get['weightcost_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/labourwbc', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/labourwbc');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/labourwbc');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $weightcost_id) {
				$this->model_sale_labourwbc->deletelabourwbc($weightcost_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/labourwbc', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'weightcost_id';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/labourwbc', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/labourwbc/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/labourwbc/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['labourwbc'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$labourwbc_total = $this->model_sale_labourwbc->getTotallabourwbcs();

		$results = $this->model_sale_labourwbc->getlabourwbcs($filter_data);

		foreach ($results as $result) {
			$data['labourwbc'][] =   array(
				'weightcost_id' 			=> $result['weightcost_id'],
				'low_weight'        		=> $result['low_weight'],
				'high_weight'     			=> $result['high_weight'],
				'cost'     					=> $result['cost'], 
				'edit'        		=> $this->url->link('sale/labourwbc/edit', 'user_token=' . $this->session->data['user_token'] . '&weightcost_id=' . $result['weightcost_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_low_weight'] = $this->url->link('sale/labourwbc', 'user_token=' . $this->session->data['user_token'] . '&sort=low_weight' . $url, true);
		$data['sort_high_weight'] = $this->url->link('sale/labourwbc', 'user_token=' . $this->session->data['user_token'] . '&sort=high_weight' . $url, true); 
		$data['sort_cost'] = $this->url->link('sale/labourwbc', 'user_token=' . $this->session->data['user_token'] . '&sort=cost' . $url, true); 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $labourwbc_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/labourwbc', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($labourwbc_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($labourwbc_total - $this->config->get('config_limit_admin'))) ? $labourwbc_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $labourwbc_total, ceil($labourwbc_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/labourwbc_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['weightcost_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['low_weight'])) {
			$data['error_low_weight'] = $this->error['low_weight'];
		} else {
			$data['error_low_weight'] = '';
		}
		if (isset($this->error['high_weight'])) {
			$data['error_high_weight'] = $this->error['high_weight'];
		} else {
			$data['error_high_weight'] = '';
		} 

		if (isset($this->error['cost'])) {
			$data['error_cost'] = $this->error['cost'];
		} else {
			$data['error_cost'] = '';
		} 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/labourwbc', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['weightcost_id'])) {
			$data['action'] = $this->url->link('sale/labourwbc/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/labourwbc/edit', 'user_token=' . $this->session->data['user_token'] .  '&weightcost_id=' . $this->request->get['weightcost_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/labourwbc', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['weightcost_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$labourwbc_info = $this->model_sale_labourwbc->getlabourwbc($this->request->get['weightcost_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');
 
		if (isset($this->request->post['low_weight'])) {
			$data['low_weight'] = $this->request->post['low_weight'];
		} elseif (!empty($labourwbc_info)) {
			$data['low_weight'] = $labourwbc_info['low_weight'];
		} else {
			$data['low_weight'] =   '';
		}

		if (isset($this->request->post['high_weight'])) {
			$data['high_weight'] = $this->request->post['high_weight'];
		} elseif (!empty($labourwbc_info)) {
			$data['high_weight'] = $labourwbc_info['high_weight'];
		} else {
			$data['high_weight'] = '';
		}
 
		
		if (isset($this->request->post['ccurrency'])) {
			$data['ccurrency'] = $this->request->post['ccurrency'];
		} elseif (!empty($labourwbc_info)) {
			$data['ccurrency'] = $labourwbc_info['ccurrency'];
		} else {
			$data['ccurrency'] = '';
		}
		if (isset($this->request->post['cost'])) {
			$data['cost'] = $this->request->post['cost'];
		} elseif (!empty($labourwbc_info)) {
			$data['cost'] = $labourwbc_info['cost'];
		} else {
			$data['cost'] = '';
		} 

		if (isset($this->request->post['supplier_group_id'])) {
			$data['supplier_group_id'] = $this->request->post['supplier_group_id'];
		} elseif (!empty($labourwbc_info)) {
			$data['supplier_group_id'] = $labourwbc_info['supplier_group_id'];
		} else {
			$data['supplier_group_id'] = '';
		} 
		
		$this->load->model('localisation/currency');

		$data['currencies'] = $this->model_localisation_currency->getCurrencies();
		
		$this->load->model('sale/supplier');
		$data['suppliers'] = $this->model_sale_supplier->getsuppliers();
  
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/labourwbc_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/labourwbc')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['low_weight']) < 1) || (utf8_strlen($this->request->post['low_weight']) > 32)) {
			$this->error['low_weight'] = $this->language->get('error_low_weight');
		} 

		if ((utf8_strlen($this->request->post['high_weight']) < 1) || (utf8_strlen($this->request->post['high_weight']) > 128)) {
			$this->error['high_weight'] = $this->language->get('error_high_weight');
		}
		
		if ((utf8_strlen($this->request->post['cost']) < 1) || (utf8_strlen($this->request->post['cost']) > 128)) {
			$this->error['cost'] = $this->language->get('error_cost');
		}
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/labourwbc')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}