<?php
class ControllerSaleGemshape extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/gemshape');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemshape');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/gemshape');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemshape');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemshape->addgemshape($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemshape', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/gemshape');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemshape');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemshape->editgemshape($this->request->get['shape_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemshape', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/gemshape');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemshape');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $shape_id) {
				$this->model_sale_gemshape->deletegemshape($shape_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemshape', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'shape';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/gemshape', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/gemshape/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/gemshape/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['gemshape'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$gemshape_total = $this->model_sale_gemshape->getTotalgemshapes();

		$results = $this->model_sale_gemshape->getgemshapes($filter_data);

		foreach ($results as $result) {
			$data['gemshape'][] =   array(
				'shape_id' 			=> $result['shape_id'],
				'shape'        		=> $result['shape'],
				'description'     			=> $result['description'],
				'edit'        		=> $this->url->link('sale/gemshape/edit', 'user_token=' . $this->session->data['user_token'] . '&shape_id=' . $result['shape_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_shape'] = $this->url->link('sale/gemshape', 'user_token=' . $this->session->data['user_token'] . '&sort=shape' . $url, true); 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $gemshape_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/gemshape', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($gemshape_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($gemshape_total - $this->config->get('config_limit_admin'))) ? $gemshape_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $gemshape_total, ceil($gemshape_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/gemshape_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['shape_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['shape'])) {
			$data['error_shape'] = $this->error['shape'];
		} else {
			$data['error_shape'] = '';
		}
		if (isset($this->error['description'])) {
			$data['error_description'] = $this->error['description'];
		} else {
			$data['error_description'] = '';
		} 

		if (isset($this->error['sort_order'])) {
			$data['error_sort_order'] = $this->error['sort_order'];
		} else {
			$data['error_sort_order'] = '';
		} 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/gemshape', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['shape_id'])) {
			$data['action'] = $this->url->link('sale/gemshape/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/gemshape/edit', 'user_token=' . $this->session->data['user_token'] .  '&shape_id=' . $this->request->get['shape_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/gemshape', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['shape_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$gemshape_info = $this->model_sale_gemshape->getgemshape($this->request->get['shape_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');

		if (isset($this->request->post['shape'])) {
			$data['shape'] = $this->request->post['shape'];
		} elseif (!empty($gemshape_info)) {
			$data['shape'] = $gemshape_info['shape'];
		} else {
			$data['shape'] =   '';
		}

		if (isset($this->request->post['description'])) {
			$data['description'] = $this->request->post['description'];
		} elseif (!empty($gemshape_info)) {
			$data['description'] = $gemshape_info['description'];
		} else {
			$data['description'] = '';
		}
		 
		if (isset($this->request->post['enable'])) {
			$data['enable'] = $this->request->post['enable'];
		} elseif (!empty($gemshape_info)) {
			$data['enable'] = $gemshape_info['enable'];
		} else {
			$data['enable'] = '';
		} 
		
		if (isset($this->request->post['image'])) {
			$data['image'] = $this->request->post['image'];
		} elseif (!empty($gemshape_info)) {
			$data['image'] = $gemshape_info['image'];
		} else {
			$data['image'] = '';
		}
		 
		if (isset($this->request->post['shape1'])) {
			$data['shape1'] = $this->request->post['shape1'];
		} elseif (!empty($gemshape_info)) {
			$data['shape1'] = $gemshape_info['shape1'];
		} else {
			$data['shape1'] = '';
		}
		 
		if (isset($this->request->post['shape2'])) {
			$data['shape2'] = $this->request->post['shape2'];
		} elseif (!empty($gemshape_info)) {
			$data['shape2'] = $gemshape_info['shape2'];
		} else {
			$data['shape2'] = '';
		}
		 

		$this->load->model('tool/image');

		if (isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 100, 100);
		} elseif (!empty($gemshape_info) && is_file(DIR_IMAGE . $gemshape_info['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($gemshape_info['image'], 100, 100);
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}
		if (isset($this->request->post['shape1']) && is_file(DIR_IMAGE . $this->request->post['shape1'])) {
			$data['thumb1'] = $this->model_tool_image->resize($this->request->post['shape1'], 100, 100);
		} elseif (!empty($gemshape_info) && is_file(DIR_IMAGE . $gemshape_info['shape1'])) {
			$data['thumb1'] = $this->model_tool_image->resize($gemshape_info['shape1'], 100, 100);
		} else {
			$data['thumb1'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}
		if (isset($this->request->post['shape2']) && is_file(DIR_IMAGE . $this->request->post['shape2'])) {
			$data['thumb2'] = $this->model_tool_image->resize($this->request->post['shape2'], 100, 100);
		} elseif (!empty($gemshape_info) && is_file(DIR_IMAGE . $gemshape_info['shape2'])) {
			$data['thumb2'] = $this->model_tool_image->resize($gemshape_info['shape2'], 100, 100);
		} else {
			$data['thumb2'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
 
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/gemshape_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/gemshape')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['shape']) < 1) || (utf8_strlen($this->request->post['shape']) > 32)) {
			$this->error['shape'] = $this->language->get('error_shape');
		} 

		if ((utf8_strlen($this->request->post['description']) < 1) || (utf8_strlen($this->request->post['description']) > 128)) {
			$this->error['description'] = $this->language->get('error_description');
		}
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/gemshape')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}