<?php
class ControllerSaleContestsample extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/contestsample');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/contestsample');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/contestsample');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/contestsample');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_contestsample->addcontestsample($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/contestsample', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/contestsample');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/contestsample');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_contestsample->editcontestsample($this->request->get['contest_sample_designs_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/contestsample', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/contestsample');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/contestsample');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $contest_sample_designs_id) {
				$this->model_sale_contestsample->deletecontestsample($contest_sample_designs_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/contestsample', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'theme';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/contestsample', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/contestsample/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/contestsample/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['contestsample'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$contestsample_total = $this->model_sale_contestsample->getTotalcontestsamples();

		$results = $this->model_sale_contestsample->getcontestsamples($filter_data);

		foreach ($results as $result) {
			$data['contestsample'][] =   array(
				'contest_sample_designs_id' 			=> $result['contest_sample_designs_id'],
				'theme'        		=> $result['theme'],
				'design_category'     			=> $result['design_category'],
				'edit'        		=> $this->url->link('sale/contestsample/edit', 'user_token=' . $this->session->data['user_token'] . '&contest_sample_designs_id=' . $result['contest_sample_designs_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_theme'] = $this->url->link('sale/contestsample', 'user_token=' . $this->session->data['user_token'] . '&sort=theme' . $url, true);
		$data['sort_gemcode'] = $this->url->link('sale/contestsample', 'user_token=' . $this->session->data['user_token'] . '&sort=gemcode' . $url, true); 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $contestsample_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/contestsample', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($contestsample_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($contestsample_total - $this->config->get('config_limit_admin'))) ? $contestsample_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $contestsample_total, ceil($contestsample_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/contestsample_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['contest_sample_designs_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['theme'])) {
			$data['error_theme'] = $this->error['theme'];
		} else {
			$data['error_theme'] = '';
		}
		if (isset($this->error['description'])) {
			$data['error_description'] = $this->error['description'];
		} else {
			$data['error_description'] = '';
		} 
		if (isset($this->error['design_category'])) {
			$data['error_design_category'] = $this->error['design_category'];
		} else {
			$data['error_design_category'] = '';
		} 

		if (isset($this->error['sort_order'])) {
			$data['error_sort_order'] = $this->error['sort_order'];
		} else {
			$data['error_sort_order'] = '';
		} 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/contestsample', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['contest_sample_designs_id'])) {
			$data['action'] = $this->url->link('sale/contestsample/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/contestsample/edit', 'user_token=' . $this->session->data['user_token'] .  '&contest_sample_designs_id=' . $this->request->get['contest_sample_designs_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/contestsample', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['contest_sample_designs_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$contestsample_info = $this->model_sale_contestsample->getcontestsample($this->request->get['contest_sample_designs_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');

		if (isset($this->request->post['theme'])) {
			$data['theme'] = $this->request->post['theme'];
		} elseif (!empty($contestsample_info)) {
			$data['theme'] = $contestsample_info['theme'];
		} else {
			$data['theme'] =   '';
		}

		if (isset($this->request->post['description'])) {
			$data['description'] = $this->request->post['description'];
		} elseif (!empty($contestsample_info)) {
			$data['description'] = $contestsample_info['description'];
		} else {
			$data['description'] = '';
		}
		if (isset($this->request->post['design_category'])) {
			$data['design_category'] = $this->request->post['design_category'];
		} elseif (!empty($contestsample_info)) {
			$data['design_category'] = $contestsample_info['design_category'];
		} else {
			$data['design_category'] = '';
		}
 
		if (isset($this->request->post['image'])) {
			$data['image'] = $this->request->post['image'];
		} elseif (!empty($contestsample_info)) {
			$data['image'] = $contestsample_info['image'];
		} else {
			$data['image'] = '';
		}
		
		$this->load->model('localisation/currency');

		$data['currencies'] = $this->model_localisation_currency->getCurrencies();

		$this->load->model('tool/image');

		if (isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 100, 100);
		} elseif (!empty($contestsample_info) && is_file(DIR_IMAGE . $contestsample_info['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($contestsample_info['image'], 100, 100);
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
 
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/contestsample_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/contestsample')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['theme']) < 1) || (utf8_strlen($this->request->post['theme']) > 32)) {
			$this->error['theme'] = $this->language->get('error_theme');
		} 

		if ((utf8_strlen($this->request->post['description']) < 1) || (utf8_strlen($this->request->post['description']) > 128)) {
			$this->error['description'] = $this->language->get('error_description');
		}

		if ((utf8_strlen($this->request->post['design_category']) < 1) || (utf8_strlen($this->request->post['design_category']) > 128)) {
			$this->error['design_category'] = $this->language->get('error_design_category');
		}
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/contestsample')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}