<?php
final class Affiliate {
	private $affiliate_id;
	private $firstname;
	private $lastname; 
	private $email;
	private $telephone;
	private $server_name;
	private $fax;
	private $newsletter;
	private $address_id;
	private $code;
	private $affiliate_server;


	private $flatfatesale_enable;
	private $paypersale_enable;
	private $paypercust_enable;
	private $paypersalecount_enable;
	private $payclickcount_enable;
	private $flatratesale;
	private $paypersale;
	private $paypercust;
	private $clickcount;
	private $payclickcount;

	
	private $address = array();

    public function __construct($registry) {
		$this->server_name=$_SERVER["SERVER_NAME"];
		$this->config = $registry->get('config');
		$this->customer = $registry->get('customer');
		$this->session = $registry->get('session');
		$this->db = $registry->get('db');
		$this->tax = $registry->get('tax');
		$this->weight = $registry->get('weight');
		$this->request = $registry->get('request');
		$this->affiliate_server=$this->config->get('affiliate');
		if (isset($this->session->data['affiliate_id'])) {
			$customer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "affiliate WHERE affiliate_id = '" . (int)$this->session->data['affiliate_id'] . "' AND status = '1'");

			if ($customer_query->num_rows) {
				$this->affiliate_id = $customer_query->row['affiliate_id'];
				$this->firstname = $customer_query->row['firstname'];
				$this->lastname = $customer_query->row['lastname'];
				$this->email = $customer_query->row['email'];
				$this->telephone = $customer_query->row['telephone'];
				$this->fax = $customer_query->row['fax'];
				$this->code = $customer_query->row['code'];
				$this->newsletter = $customer_query->row['newsletter'];
				$this->address_id = $customer_query->row['address_id'];


				$affilite_query = $this->db->query("select * from " . DB_PREFIX . "affiliate_group a," . DB_PREFIX . "affiliate b where a.affiliate_group_id=b.affiliate_group_id and b.affiliate_id= '" . $this->session->data['affiliate_id'] . "'");
				if ($affilite_query->num_rows) {
					$this->flatfatesale_enable = $affilite_query->row['flatfatesale_enable'];
					$this->paypersale_enable = $affilite_query->row['paypersale_enable'];
					$this->paypercust_enable = $affilite_query->row['paypercust_enable'];
					$this->paypersalecount_enable = $affilite_query->row['paypersalecount_enable'];
					$this->payclickcount_enable = $affilite_query->row['payclickcount_enable'];
					
					$this->flatratesale = $affilite_query->row['flatratesale'];
					$this->paypersale = $affilite_query->row['paypersale'];
					$this->paypercust = $affilite_query->row['paypercust'];
					$this->clickcount = $affilite_query->row['clickcount'];
					$this->payclickcount = $affilite_query->row['payclickcount'];
					
				}
				
				$address_query = $this->db->query("SELECT *, c.name AS country, z.name AS zone FROM " . DB_PREFIX . "affiliate a LEFT JOIN " . DB_PREFIX . "country c ON a.country_id = c.country_id LEFT JOIN " . DB_PREFIX . "zone z ON a.zone_id = z.zone_id WHERE a.affiliate_id = '" . (int)$this->session->data['affiliate_id'] . "'");

				foreach ($address_query->rows as $result) {
					$this->address[$result['address_id']] = array(
						'firstname'      => $result['firstname'],
						'lastname'       => $result['lastname'],
						'company'        => $result['company'],
						'address_1'      => $result['address_1'],
						'address_2'      => $result['address_2'],
						'postcode'       => $result['postcode'],
						'city'           => $result['city'],
						'country_id'     => $result['country_id'],
						'zone_id'        => $result['zone_id'],
						'iso_code_2'     => $result['iso_code_2'],
						'iso_code_3'     => $result['iso_code_3'],
						'code'           => $result['code'],
						'zone'           => $result['zone'],
						'country'        => $result['country'],
						'address_format' => $result['address_format']
					);
				}

      			$this->db->query("UPDATE " . DB_PREFIX . "affiliate SET cart = '" . $this->db->escape(serialize($this->session->data['cart'])) . "', ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "' WHERE affiliate_id = '" . (int)$this->session->data['affiliate_id'] . "'");
			} else {
				$this->logout();
			}
  		}
	}

  	public function login($email, $password) {
		$customer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "affiliate WHERE email = '" . $this->db->escape($email) . "' AND password = '" . $this->db->escape(md5($password)) . "' AND status = '1'");
	//	if($this->server_name!=$this->affiliate_server)exit;
		if ($customer_query->num_rows)
		{
			$this->session->data['affiliate_id'] = $customer_query->row['affiliate_id'];

			if (is_string($customer_query->row['cart'])) {
				$cart = unserialize($customer_query->row['cart']);

			/*	foreach ($cart as $key => $value) {
					if (!array_key_exists($key, $this->session->data['cart'])) {
						$this->session->data['cart'][$key] = $value;
					} else {
						$this->session->data['cart'][$key] += $value;
					}
				} */
			}

			$this->affiliate_id = $customer_query->row['affiliate_id'];
			$this->firstname = $customer_query->row['firstname'];
			$this->lastname = $customer_query->row['lastname'];
			$this->email = $customer_query->row['email'];
			$this->telephone = $customer_query->row['telephone'];
			$this->fax = $customer_query->row['fax'];
			$this->newsletter = $customer_query->row['newsletter'];
			$this->address_id = $customer_query->row['address_id'];

			$address_query = $this->db->query("SELECT *, c.name AS country, z.name AS zone FROM " . DB_PREFIX . "affaddress a LEFT JOIN " . DB_PREFIX . "country c ON a.country_id = c.country_id LEFT JOIN " . DB_PREFIX . "zone z ON a.zone_id = z.zone_id WHERE a.affiliate_id = '" . (int)$this->session->data['affiliate_id'] . "'");
				
			foreach ($address_query->rows as $result)
			{
				$this->address[$result['address_id']] = array(
					'firstname'      => $result['firstname'],
					'lastname'       => $result['lastname'],
					'company'        => $result['company'],
					'address_1'      => $result['address_1'],
					'address_2'      => $result['address_2'],
					'postcode'       => $result['postcode'],
					'city'           => $result['city'],
					'country_id'     => $result['country_id'],
					'zone_id'        => $result['zone_id'],
					'iso_code_2'     => $result['iso_code_2'],
					'iso_code_3'     => $result['iso_code_3'],
					'code'           => $result['code'],
					'zone'           => $result['zone'],
					'country'        => $result['country'],
					'address_format' => $result['address_format']
				);
			}

	  		return TRUE;
    		} else {
      			return FALSE;
    		}
  	}

  	public function logout() {
		unset($this->session->data['affiliate_id']);
		unset($this->session->data['customer_id']);
		$this->affiliate_id = '';
		$this->firstname = '';
		$this->lastname = '';
		$this->email = '';
		$this->telephone = '';
		$this->fax = '';
		$this->newsletter = '';
		$this->address_id = '';
		$this->address = array();
  	}

  	public function isLogged() {
    	return $this->affiliate_id;
  	}

  	public function getId() {
    	return $this->affiliate_id;
  	}

  	public function getFirstName() {
		return $this->firstname;
  	}

					
  	public function getFlatRateSaleEnable() {
		return $this->flatfatesale_enable;
  	}

  	public function getPayPerSaleEnable() {
		return $this->paypersale_enable;
  	}

  	public function getPayPerCustEnable() {
		return $this->paypercust_enable;
  	}

  	public function getPayPerSaleCountEnable() {
		return $this->paypersalecount_enable;
  	}

  	public function getPayClickEnable() {
		return $this->payclickcount_enable;
  	}

  	public function getPayFlatSale() {
		return $this->flatratesale;
  	}

  	public function getPayPerSale() {
		return $this->paypersale;
  	}

  	public function getPayperCust() {
		return $this->paypercust;
  	}

  	public function getClickCount() {
		return $this->clickcount;
  	}

  	public function getPayClickCount() {
		return $this->payclickcount;
  	}
		
	
  	public function getLastName() {
		return $this->lastname;
  	}

  	public function getEmail() {
		return $this->email;
  	}

  	public function affiliate_grp() {
		if($this->server_name!=$this->affiliate_server)
		{	$this->affiliate_grp=0; }
		else {  $this->affiliate_grp=1;	}
		return $this->affiliate_grp;
  	}

  	public function getTelephone() {
		return $this->telephone;
  	}

  	public function getFax() {
		return $this->fax;
  	}

  	public function getNewsletter() {
		return $this->newsletter;
  	}
  	public function getAddressId() {
		return $this->address_id;
  	}

	public function getAddress($address_id) {
		return (isset($this->address[$address_id]) ? $this->address[$address_id] : array());
	}

	public function affiliate_license() {
		if($this->license->affiliate!='shrimantech')
		{	$this->affiliate_key=0; }
		else {  $this->affiliate_key=1;	}
		return $this->affiliate_key;
  	}

	public function hasAddress($address_id) {
		return isset($this->address[$address_id]);
	}
	public function getCode() {
		return $this->code;
  	}	
}
?>