<?php
class ModelAffiliateInformation extends Model {
	public function addInformation($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "affinformation SET sort_order = '" . (int)$this->request->post['sort_order'] . "', status = '" . (int)$data['status'] . "'");

		$affinformation_id = $this->db->getLastId();

		foreach ($data['information_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "affinformation_description SET affinformation_id = '" . (int)$affinformation_id . "', language_id = '" . (int)$language_id . "', title = '" . $this->db->escape($value['title']) . "', description = '" . $this->db->escape($value['description']) . "'");
		}

		if (isset($data['information_store'])) {
			foreach ($data['information_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "affinformation_to_store SET affinformation_id = '" . (int)$affinformation_id . "', store_id = '" . (int)$store_id . "'");
			}
		}

		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'affinformation_id=" . (int)$affinformation_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}

		$this->cache->delete('affinformation');
	}

	public function editInformation($affinformation_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "affinformation SET sort_order = '" . (int)$data['sort_order'] . "', status = '" . (int)$data['status'] . "' WHERE affinformation_id = '" . (int)$affinformation_id . "'");

		$this->db->query("DELETE FROM " . DB_PREFIX . "affinformation_description WHERE affinformation_id = '" . (int)$affinformation_id . "'");

		foreach ($data['information_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "affinformation_description SET affinformation_id = '" . (int)$affinformation_id . "', language_id = '" . (int)$language_id . "', title = '" . $this->db->escape($value['title']) . "', description = '" . $this->db->escape($value['description']) . "'");
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "affinformation_to_store WHERE affinformation_id = '" . (int)$affinformation_id . "'");

		if (isset($data['information_store'])) {
			foreach ($data['information_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "affinformation_to_store SET affinformation_id = '" . (int)$affinformation_id . "', store_id = '" . (int)$store_id . "'");
			}
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'affinformation_id=" . (int)$affinformation_id. "'");

		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'affinformation_id=" . (int)$affinformation_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}

		$this->cache->delete('affinformation');
	}

	public function deleteInformation($affinformation_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "affinformation WHERE affinformation_id = '" . (int)$affinformation_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "affinformation_description WHERE affinformation_id = '" . (int)$affinformation_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "affinformation_to_store WHERE affinformation_id = '" . (int)$affinformation_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'affinformation_id=" . (int)$affinformation_id . "'");

		$this->cache->delete('affinformation');
	}

	public function getInformation($affinformation_id) {
		$query = $this->db->query("SELECT DISTINCT *, (SELECT keyword FROM " . DB_PREFIX . "url_alias WHERE query = 'affinformation_id=" . (int)$affinformation_id . "') AS keyword FROM " . DB_PREFIX . "affinformation WHERE affinformation_id = '" . (int)$affinformation_id . "'");

		return $query->row;
	}

	public function getInformations($data = array()) {
		if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "affinformation i LEFT JOIN " . DB_PREFIX . "affinformation_description id ON (i.affinformation_id = id.affinformation_id) WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "'";

			$sort_data = array(
				'id.title',
				'i.sort_order'
			);

			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
				$sql .= " ORDER BY " . $data['sort'];
			} else {
				$sql .= " ORDER BY id.title";
			}

			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}

			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}

				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}

			$query = $this->db->query($sql);

			return $query->rows;
		} else {
			$information_data = $this->cache->get('affinformation.' . $this->config->get('config_language_id'));

			if (!$information_data) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "affinformation i LEFT JOIN " . DB_PREFIX . "affinformation_description id ON (i.affinformation_id = id.affinformation_id) WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY id.title");

				$affinformation_data = $query->rows;

				$this->cache->set('affinformation.' . $this->config->get('config_language_id'), $affinformation_data);
			}

			return $information_data;
		}
	}

	public function getInformationDescriptions($affinformation_id) {
		$information_description_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "affinformation_description WHERE affinformation_id = '" . (int)$affinformation_id . "'");

		foreach ($query->rows as $result) {
			$information_description_data[$result['language_id']] = array(
				'title'       => $result['title'],
				'description' => $result['description']
			);
		}

		return $information_description_data;
	}

	public function getInformationStores($affinformation_id) {
		$information_store_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "affinformation_to_store WHERE affinformation_id = '" . (int)$affinformation_id . "'");

		foreach ($query->rows as $result) {
			$information_store_data[] = $result['store_id'];
		}

		return $information_store_data;
	}

	public function getTotalInformations() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "affinformation");

		return $query->row['total'];
	}
}
?>