<?php
class ControllerAffiliateAffiliateGroup extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('affiliate/affiliate_group');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('affiliate/affiliate_group');

		$this->getList();
	}

	public function insert() {
		$this->load->language('affiliate/affiliate_group');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('affiliate/affiliate_group');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

					if(!isset($this->request->post['flatfatesale_enable']))   $this->request->post['flatfatesale_enable']   ='';
					if(!isset($this->request->post['paypersale_enable']))     $this->request->post['paypersale_enable']     ='';
					if(!isset($this->request->post['paypercust_enable']))     $this->request->post['paypercust_enable']     ='';
					if(!isset($this->request->post['paypersalecount_enable']))$this->request->post['paypersalecount_enable']='';
					if(!isset($this->request->post['payclickcount_enable']))  $this->request->post['payclickcount_enable'] ='';
					if(!isset($this->request->post['guestreferral_enable']))  $this->request->post['guestreferral_enable'] ='';

			$this->model_affiliate_affiliate_group->addAffiliateGroup($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			$this->redirect(HTTPS_SERVER . 'index.php?route=affiliate/affiliate_group&token=' . $this->session->data['token'] . $url);
		}

		$this->getForm();
	}

	public function update() {
		$this->load->language('affiliate/affiliate_group');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('affiliate/affiliate_group');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			if(!isset($this->request->post['flatfatesale_enable']))   $this->request->post['flatfatesale_enable']   ='';
			if(!isset($this->request->post['paypersale_enable']))     $this->request->post['paypersale_enable']     ='';
			if(!isset($this->request->post['paypercust_enable']))     $this->request->post['paypercust_enable']     ='';
			if(!isset($this->request->post['paypersalecount_enable']))$this->request->post['paypersalecount_enable']='';
			if(!isset($this->request->post['payclickcount_enable']))  $this->request->post['payclickcount_enable'] ='';
			if(!isset($this->request->post['guestreferral_enable']))  $this->request->post['guestreferral_enable'] ='';


			$this->model_affiliate_affiliate_group->editAffiliateGroup($this->request->get['affiliate_group_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			$this->redirect(HTTPS_SERVER . 'index.php?route=affiliate/affiliate_group&token=' . $this->session->data['token'] . $url);
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('affiliate/affiliate_group');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('affiliate/affiliate_group');

		if (isset($this->request->post['selected'])) {
      		foreach ($this->request->post['selected'] as $affiliate_group_id) {
				$this->model_affiliate_affiliate_group->deleteAffiliateGroup($affiliate_group_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			$this->redirect(HTTPS_SERVER . 'index.php?route=affiliate/affiliate_group&token=' . $this->session->data['token'] . $url);
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		$url = '';

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

  		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=common/home&token=' . $this->session->data['token'],
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=affiliate/affiliate_group&token=' . $this->session->data['token'] . $url,
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);

		$this->data['insert'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliate_group/insert&token=' . $this->session->data['token'] . $url;
		$this->data['delete'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliate_group/delete&token=' . $this->session->data['token'] . $url;

		$this->data['affiliate_groups'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);

		$affiliate_group_total = $this->model_affiliate_affiliate_group->getTotalAffiliateGroups();

		$results = $this->model_affiliate_affiliate_group->getAffiliateGroups($data);

		foreach ($results as $result) {
			$action = array();

			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => HTTPS_SERVER . 'index.php?route=affiliate/affiliate_group/update&token=' . $this->session->data['token'] . '&affiliate_group_id=' . $result['affiliate_group_id'] . $url
			);

			$this->data['affiliate_groups'][] = array(
				'affiliate_group_id' => $result['affiliate_group_id'],
				'name'              => $result['name'] . (($result['affiliate_group_id'] == $this->config->get('config_affiliate_group_id')) ? $this->language->get('text_default') : NULL),
				'selected'          => isset($this->request->post['selected']) && in_array($result['affiliate_group_id'], $this->request->post['selected']),
				'action'            => $action
			);
		}
		
		$this->load->model('affiliate/setting');
		$affiliatesdt = $this->model_affiliate_setting->getaffiliateDt('affiliateid');
		$affiliateconfig = $this->model_affiliate_setting->getaffiliateDetail('affiliateid');

	//	if ( $affiliatesdt <> $affiliateconfig ) exit;

		$this->data['heading_title'] = $this->language->get('heading_title');
	//	if($this->config->get('affiliate')!=$_SERVER["SERVER_NAME"])exit;
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=' .  'DESC';
		} else {
			$url .= '&order=' .  'ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_name'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliate_group&token=' . $this->session->data['token'] .'&sort=name' . $url;

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $affiliate_group_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = HTTPS_SERVER . 'index.php?route=affiliate/affiliate_group&token=' . $this->session->data['token'] . $url . '&page={page}';

		$this->data['pagination'] = $pagination->render();

		$this->data['sort'] = $sort;
		$this->data['order'] = $order;

		$this->template = 'affiliate/affiliate_group_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
 	}

	private function getForm() {
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_flatratesale'] = $this->language->get('entry_flatratesale');
		$this->data['entry_paypersale'] = $this->language->get('entry_paypersale');
		$this->data['entry_paypercust'] = $this->language->get('entry_paypercust');
		$this->data['entry_paypersalecount'] = $this->language->get('entry_paypersalecount');
		$this->data['entry_clickcount'] = $this->language->get('entry_clickcount');
		$this->data['entry_payclickcount'] = $this->language->get('entry_payclickcount');
		$this->data['entry_flatfatesale_enable'] = $this->language->get('entry_flatfatesale_enable');
		$this->data['entry_paypersale_enable'] = $this->language->get('entry_paypersale_enable');
		$this->data['entry_paypercust_enable'] = $this->language->get('entry_paypercust_enable');
		$this->data['entry_paypersalecount_enable'] = $this->language->get('entry_paypersalecount_enable');
		$this->data['entry_payclickcount_enable'] = $this->language->get('entry_payclickcount_enable');
		$this->data['entry_guestreferral'] = $this->language->get('entry_guestreferral');
		$this->data['entry_descrip'] = $this->language->get('entry_descrip');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['name'])) {
			$this->data['error_name'] = $this->error['name'];
		} else {
			$this->data['error_name'] = '';
		}

		$url = '';

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

  		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=common/home&token=' . $this->session->data['token'],
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=affiliate/affiliate_group&token=' . $this->session->data['token'] . $url,
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['affiliate_group_id'])) {
			$this->data['action'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliate_group/insert&token=' . $this->session->data['token'] . $url;
		} else {
			$this->data['action'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliate_group/update&token=' . $this->session->data['token'] . '&affiliate_group_id=' . $this->request->get['affiliate_group_id'] . $url;
		}

    	$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliate_group&token=' . $this->session->data['token'] . $url;

		if (isset($this->request->get['affiliate_group_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$affiliate_group_info = $this->model_affiliate_affiliate_group->getAffiliateGroup($this->request->get['affiliate_group_id']);
		}

		if (isset($this->request->post['name'])) {
			$this->data['name'] = $this->request->post['name'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['name'] = $affiliate_group_info['name'];
		} else {
			$this->data['name'] = '';
		}
		
		if (isset($this->request->post['flatratesaledesc'])) {
			$this->data['flatratesaledesc'] = $this->request->post['flatratesaledesc'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['flatratesaledesc'] = $affiliate_group_info['flatratesaledesc'];
		} else {
			$this->data['flatratesaledesc'] = '';
		}
		
	
		if (isset($this->request->post['guestreferral_enable'])) {
			$this->data['guestreferral_enable'] = $this->request->post['guestreferral_enable'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['guestreferral_enable'] = $affiliate_group_info['guestreferral_enable'];
		} else {
			$this->data['guestreferral_enable'] = $this->config->get('config_guestreferral_enable');
		}
		
		if (isset($this->request->post['paypersaledesc'])) {
			$this->data['paypersaledesc'] = $this->request->post['paypersaledesc'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['paypersaledesc'] = $affiliate_group_info['paypersaledesc'];
		} else {
			$this->data['paypersaledesc'] = '';
		}
		
		if (isset($this->request->post['paypercustdesc'])) {
			$this->data['paypercustdesc'] = $this->request->post['paypercustdesc'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['paypercustdesc'] = $affiliate_group_info['paypercustdesc'];
		} else {
			$this->data['paypercustdesc'] = '';
		}
		
		if (isset($this->request->post['paypersalecountdesc'])) {
			$this->data['paypersalecountdesc'] = $this->request->post['paypersalecountdesc'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['paypersalecountdesc'] = $affiliate_group_info['paypersalecountdesc'];
		} else {
			$this->data['paypersalecountdesc'] = '';
		}
		
		if (isset($this->request->post['payclickdescr'])) {
			$this->data['payclickdescr'] = $this->request->post['payclickdescr'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['payclickdescr'] = $affiliate_group_info['payclickdescr'];
		} else {
			$this->data['payclickdescr'] = '';
		}
		
		
		if (isset($this->request->post['creditguestref'])) {
			$this->data['creditguestref'] = $this->request->post['creditguestref'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['creditguestref'] = $affiliate_group_info['creditguestref'];
		} else {
			$this->data['creditguestref'] = '';
		}
		
		if (isset($this->request->post['guestcredit'])) {
			$this->data['guestcredit'] = $this->request->post['guestcredit'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['guestcredit'] = $affiliate_group_info['guestcredit'];
		} else {
			$this->data['guestcredit'] =  '';
		}

		if (isset($this->request->post['flatratesale'])) {
			$this->data['flatratesale'] = $this->request->post['flatratesale'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['flatratesale'] = $affiliate_group_info['flatratesale'];
		} else {
			$this->data['flatratesale'] = '';
		}
		

		if (isset($this->request->post['paypersale'])) {
			$this->data['paypersale'] = $this->request->post['paypersale'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['paypersale'] = $affiliate_group_info['paypersale'];
		} else {
			$this->data['paypersale'] =  '';
		}
		if (isset($this->request->post['paypercust'])) {
			$this->data['paypercust'] = $this->request->post['paypercust'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['paypercust'] = $affiliate_group_info['paypercust'];
		} else {
			$this->data['paypercust'] =  '';
		}
		if (isset($this->request->post['paypersalecount'])) {
			$this->data['paypersalecount'] = $this->request->post['paypersalecount'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['paypersalecount'] = $affiliate_group_info['paypersalecount'];
		} else {
			$this->data['paypersalecount'] =  '';
		}
		if (isset($this->request->post['clickcount'])) {
			$this->data['clickcount'] = $this->request->post['clickcount'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['clickcount'] = $affiliate_group_info['clickcount'];
		} else {
			$this->data['clickcount'] =  '';
		}
		

		if (isset($this->request->post['payclickcount'])) {
			$this->data['payclickcount'] = $this->request->post['payclickcount'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['payclickcount'] = $affiliate_group_info['payclickcount'];
		} else {
			$this->data['payclickcount'] =  '';
		}


		if (isset($this->request->post['flatfatesale_enable'])) {
			$this->data['flatfatesale_enable'] = $this->request->post['flatfatesale_enable'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['flatfatesale_enable'] = $affiliate_group_info['flatfatesale_enable'];
		} else {
			$this->data['flatfatesale_enable'] = '';
		}
		if (isset($this->request->post['paypersale_enable'])) {
			$this->data['paypersale_enable'] = $this->request->post['paypersale_enable'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['paypersale_enable'] = $affiliate_group_info['paypersale_enable'];
		} else {
			$this->data['paypersale_enable'] =  '';
		}
    if (isset($this->request->post['paypercust_enable'])) {
			$this->data['paypercust_enable'] = $this->request->post['paypercust_enable'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['paypercust_enable'] = $affiliate_group_info['paypercust_enable'];
		} else {
			$this->data['paypercust_enable'] =  '';
		}
    if (isset($this->request->post['paypersalecount_enable'])) {
			$this->data['paypersalecount_enable'] = $this->request->post['paypersalecount_enable'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['paypersalecount_enable'] = $affiliate_group_info['paypersalecount_enable'];
		} else {
			$this->data['paypersalecount_enable'] =  '';
		}
    if (isset($this->request->post['payclickcount_enable'])) {
			$this->data['payclickcount_enable'] = $this->request->post['payclickcount_enable'];
		} elseif (isset($affiliate_group_info)) {
			$this->data['payclickcount_enable'] = $affiliate_group_info['payclickcount_enable'];
		} else {
			$this->data['payclickcount_enable'] =  '';
		}

		if($this->data['flatratesale']=="0"){$this->data['flatratesale']=""; }
		if($this->data['paypersale']=="0"){$this->data['paypersale']=""; }
		if($this->data['paypercust']=="0"){$this->data['paypercust']=""; }
		if($this->data['paypersalecount']=="0"){$this->data['paypersalecount']=""; }
		if($this->data['clickcount']=="0"){$this->data['clickcount']=""; }
		if($this->data['payclickcount']=="0"){$this->data['payclickcount']=""; }
		if($this->data['guestcredit']=="0"){$this->data['guestcredit']=""; }


		$this->template = 'affiliate/affiliate_group_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
	}

	private function validateForm() {
		if (!$this->user->hasPermission('modify', 'affiliate/affiliate_group')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((strlen(utf8_decode($this->request->post['name'])) < 3) || (strlen(utf8_decode($this->request->post['name'])) > 64)) {
			$this->error['name'] = $this->language->get('error_name');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}

	private function validateDelete() {
		if (!$this->user->hasPermission('modify', 'affiliate/affiliate_group')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		$this->load->model('setting/store');
		$this->load->model('affiliate/affiliate');

		foreach ($this->request->post['selected'] as $affiliate_group_id) {
    		if ($this->config->get('config_affiliate_group_id') == $affiliate_group_id) {
	  			$this->error['warning'] = $this->language->get('error_default');
			}

			$store_total = $this->model_affiliate_affiliate_group->getTotalStoresByAffiliateGroupId($affiliate_group_id);

			if ($store_total) {
				$this->error['warning'] = sprintf($this->language->get('error_store'), $store_total);
			}

			$affiliate_total = $this->model_affiliate_affiliate->getTotalAffiliatesByAffiliateGroupId($affiliate_group_id);

			if ($affiliate_total) {
				$this->error['warning'] = sprintf($this->language->get('error_affiliate'), $affiliate_total);
			}
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
}
?>