<?php
// Set the content-type
header('Content-Type: image/png');

// Create the image
$im = imagecreatetruecolor(400, 30);

// Create some colors
$white = imagecolorallocate($im, 255, 255, 255);
$grey = imagecolorallocate($im, 128, 128, 128);
$black = imagecolorallocate($im, 0, 0, 0);
imagefilledrectangle($im, 0, 0, 399, 29, $white);

// The text to draw
$text = 'Testing...';
// Replace path by your own font path
$font = 'times.ttf';

// Add some shadow to the text
imagettftext($im, 20, 0, 11, 21, $grey, $font, $text);

// Add the text
imagettftext($im, 20, 0, 10, 20, $black, $font, $text);

// Using imagepng() results in clearer text compared with imagejpeg()
imagepng($im);
imagedestroy($im);
?>

<?php
/*****************************************************
***              skewedtext.php                    ***
***                                                ***
***          Author : Barand June 2007             ***
******************************************************/

$text = "Asdf";

/**
* create the src image containing the text
*/
$src = imagecreate(250, 40);
$white = imagecolorallocate($src, 0xFF, 0xFF, 0xFF);
$black = imagecolorallocate($src, 0x00, 0x00, 0x00);
imagettftext($src, 24, 0, 50, 30, $black, $font, $text);

/**
* Create the destination image to receive the skewed text;
*/

$dest = imagecreate(250, 600);
$yellow = imagecolorallocate($dest, 0xFF, 0xFF, 0x00);
$red = imagecolorallocate($dest, 0xFF, 0x00, 0x00);


/**
* scan all pixels in the src image
*/

for ($y = 0; $y < imagesy($src); $y++)
{
    for ($x = 0; $x < imagesx($src); $x++)
    {
        $c = imagecolorat($src, $x, $y);       // get the pixel colour
        if ($c == $black)                      // is it part of the text?
        {
            /**
            * skew the text horizontally
            *   pixels pushed to the left (negative offset)
            *   zero pixels at the bottom to a max of maxskew at the top
            */
            $maxskew = -20;
            $offset = $maxskew * (imagesy($src) - $y) / imagesy($src);
            $xd = $x + $offset;
            
            /**
            * calc y pos on a sine curve
            *   amplitude controls the amount of vertical displacement
            *   frequency determines the number of waves 
            */
            $amp = 8;
            $freq = 5;
            $yd = $amp * sin($freq * deg2rad($x)) + $y + 10;     // add 10 to push image away from top edge
            
            /**
            * place pixel in dest image 
            */
            imagesetpixel($dest, $xd, $yd, $red);         
        }
    }
}
/**
* output the image 
*/
header("content-type: image/png");
imagepng($dest);
imagedestroy($src);
imagedestroy($dest);
?>