<?php  
class ControllerModuleBPSlideBanner extends Controller {
	protected function index($setting) {
		static $module = 0;
		
		$this->language->load('module/bp_slide_banner');
		
		$this->load->model('design/banner');
		$this->load->model('tool/image');
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['banners'] = array();
		
		if (isset($setting['banner_id'])) {
			$results = $this->model_design_banner->getBanner($setting['banner_id']);
			  
			foreach ($results as $result) {
				if (file_exists(DIR_IMAGE . $result['image'])) {
					$this->data['banners'][] = array(
						'title' => $result['title'],
						'link'  => $result['link'],
						'image' => $this->model_tool_image->resize($result['image'], $setting['width'], $setting['height']),
					);
				}
			}
		}
		
		$this->data['image_width'] = $setting['width'];
		$this->data['image_height'] = $setting['height'];

		$this->data['module'] = $module++;
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/bp_slide_banner.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/bp_slide_banner.tpl';
		} else {
			$this->template = 'default/template/module/bp_slide_banner.tpl';
		}
		
		$this->render();
	}
}
?>