<?php
class ControllerCommonSeoUrl extends Controller {
	public function index() {
		// Add rewrite to url class
		if ($this->config->get('config_seo_url')) {
			$this->url->addRewrite($this);
		}
		// Decode URL
		if (isset($this->request->get['_route_'])) {
		
			$pos = strpos($this->request->get['_route_'], 'post_id');


			$parts = explode('/', $this->request->get['_route_']);
			
			foreach ($parts as $part) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "url_alias WHERE keyword = '" . $this->db->escape($part) . "'");


				if ($query->num_rows) {
					$url = explode('=', $query->row['query']);
					
					if ($url[0] == 'product_id') {
						$this->request->get['product_id'] = $url[1];
					}
					
					if ($url[0] == 'category_id') {
						if (!isset($this->request->get['path'])) {
							$this->request->get['path'] = $url[1];
						} else {
							$this->request->get['path'] .= '_' . $url[1];
						}
					}	
					
					if ($url[0] == 'manufacturer_id') {
						$this->request->get['manufacturer_id'] = $url[1];
					}
					
					if ($url[0] == 'information_id') {
						$this->request->get['information_id'] = $url[1];
					}	
		
					if ($url[0] == 'newurl') {
						$this->request->get['newurl'] = $url[1];
					}
					
					if ($url[0] == 'blog_category_id'  ) { 
							$this->request->get['bpath'] = $url[1];
					}
					
					if ($url[0] == 'post_id') {
						$this->request->get['post_id'] = $url[1];
					}
					
					if ($url[0] == 'route') {
						$this->request->get['route'] = $url[1];
					}	

				} else {
					$this->request->get['route'] = 'error/not_found';	
				}
			}
			
			if (isset($this->request->get['product_id'])) {
			
				$this->load->model('catalog/product');		
				$product_info = $this->model_catalog_product->getProduct($this->request->get['product_id']);
				if($product_info['type']>0){
					$this->request->get['route'] = 'product/product1';
				}else{
					$this->request->get['route'] = 'product/product';
				}

				
			} elseif (isset($this->request->get['path'])) {
				$this->request->get['route'] = 'product/category';
			} elseif (isset($this->request->get['bpath'])) {
				$this->request->get['route'] = 'blog/category';
			} elseif (isset($this->request->get['manufacturer_id'])) {
				$this->request->get['route'] = 'product/manufacturer/product';
			} elseif (isset($this->request->get['information_id'])) {
				$this->request->get['route'] = 'information/information';
			}elseif (isset($this->request->get['post_id'])) {
					$this->request->get['route'] = 'blog/post';
			}
			
			if (isset($this->request->get['route'])) {
				return $this->forward($this->request->get['route']);
			}
		}
	}
	
	public function rewrite($link) {
		if ($this->config->get('config_seo_url')) {
			$url_data = parse_url(str_replace('&amp;', '&', $link));
		
			$url = ''; 
			
			$data = array();
			
			parse_str($url_data['query'], $data);

			foreach ($data as $key => $value) {
				if (isset($data['route'])) {
					if ( $data['route'] == 'information/contest' ) {
						$url .= '/Contest';
					}
					if (($data['route'] == 'product/product' && $key == 'product_id') || (($data['route'] == 'product/manufacturer/product' || $data['route'] == 'product/product') && $key == 'manufacturer_id') || ($data['route'] == 'information/information' && $key == 'information_id')) {
						$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "url_alias WHERE `query` = '" . $this->db->escape($key . '=' . (int)$value) . "'");
					
						if ($query->num_rows) {
							$url .= '/' . $query->row['keyword'];
							
							unset($data[$key]);
						}					
					} elseif ($key == 'path') {
						$categories = explode('_', $value);
						
						foreach ($categories as $category) {
							$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "url_alias WHERE `query` = 'category_id=" . (int)$category . "'");
					
							if ($query->num_rows) {
								$url .= '/' . $query->row['keyword'];
							}							
						}
						
						unset($data[$key]);
					} elseif ($key == 'bpath') {

						$pos = strpos($link, 'post_id');
						if ($pos === false) { 
							$categories = explode('_', $value);
				
							foreach ($categories as $category) {
								$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "url_alias WHERE `query` = 'blog_category_id=" . (int)$category . "'");
					
								if ($query->num_rows) {
									$url .= '/' . $query->row['keyword'];
								}							
							}
						}
							unset($data[$key]);
					} elseif ($key == 'post_id') {

							$categories = explode('_', $value);
				
							foreach ($categories as $category) {
								$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "url_alias WHERE `query` = 'post_id=" . (int)$category . "'");
					
								if ($query->num_rows) {
									$url .= '/' . $query->row['keyword'];
								}							
							}
						
							unset($data[$key]);
					}elseif ($key == 'newurl') {
						$url .= '/index.php?route=product/category';
						$categories = explode('-', $value);
						if($categories[0]<>''){
							$url .= '&path=' . $categories[0];
						}
						if($categories[1]<>''){
//							$query = $this->db->query("SELECT gemstone_id FROM gemstone WHERE gemname='" . $categories[1] . "'");
//							$url .= '&gemstone_id=' . $query->row['gemstone_id'];
							$url .= '&gemstone_id=' .  $categories[1];
						}
						if($categories[2]<>''){
//							$query = $this->db->query("SELECT metal_id FROM metal WHERE metalname='" . $categories[2] . "'");
//							$url .= '&metal_id=' . $query->row['metal_id'];
							$url .= '&metal_id=' . $categories[2];
						}
						if($categories[3]<>''){
//							$query = $this->db->query("SELECT shape_id FROM shape WHERE shape='" . $categories[3] . "'");
//							$url .= '&shape_id=' . $query->row['shape_id'];
							$url .= '&shape_id=' . $categories[3];
						}
						if(isset($categories[4]) && $categories[4]!=0){
//							$query = $this->db->query("SELECT shape_id FROM shape WHERE shape='" . $categories[3] . "'");
//							$url .= '&shape_id=' . $query->row['shape_id'];
							$url .= '&lp=' . $categories[4];
						}
						if(isset($categories[5]) && $categories[5]!=10000000){
//							$query = $this->db->query("SELECT shape_id FROM shape WHERE shape='" . $categories[3] . "'");
//							$url .= '&shape_id=' . $query->row['shape_id'];
							$url .= '&hp=' . $categories[5];
						}
						unset($data[$key]);

					}
				}
			}
		
			
			if ($url) {
				unset($data['route']);
			
				$query = '';
			
				if ($data) {
					foreach ($data as $key => $value) {
						$query .= '&' . $key . '=' . $value;
					}
					
					if ($query) {
						$query = '?' . trim($query, '&');
					}
				}

				return $url_data['scheme'] . '://' . $url_data['host'] . (isset($url_data['port']) ? ':' . $url_data['port'] : '') . str_replace('/index.php', '', $url_data['path']) . $url . $query;
			} else {
				return $link;
			}
		} else {
			return $link;
		}		
	}	
}
?>