<?php
class ControllerDesaccountCredit extends Controller {
	private $error = array();

	public function index() {
		if (!$this->designer->isLogged()) {
			$this->session->data['redirect'] = $this->url->link('desaccount/credit', '', 'SSL');

			$this->redirect($this->url->link('desaccount/login', '', 'SSL'));
		}

		$this->language->load('desaccount/credit');
		
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('desaccount/designer');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
			$this->model_desaccount_designer->editdesigner($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('desaccount/account', '', 'SSL'));
		}

      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),     	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('desaccount/account', '', 'SSL'),        	
        	'separator' => $this->language->get('text_separator')
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_edit'),
			'href'      => $this->url->link('desaccount/credit', '', 'SSL'),       	
        	'separator' => $this->language->get('text_separator')
      	);
		
		
		$this->load->model('information/myown');
		$this->data['credits'] = array();
		$results = $this->model_information_myown->getmycredits();
		
		foreach ($results as $result) {
		
		$this->data['credits'][] = array(
				'reward_id'    => $result['reward_id'],
				'customer_designer_id'    => $result['customer_designer_id'],
				'reward_amount'           => $result['reward_amount'].' '.$result['currency'],
				'sale_amount'            => $result['sale_amount'].' '.$result['currency'],
				'currency'            => $result['currency'],
				'cname'            => $result['firstname'].' '.$result['lastname'],
				'pname'            => $result['name'],
				'oname'            => $result['optionname'],
				'payment_details'            => $result['payment_details'],
				'order_id'           => $result['order_id'],
				'date_added'           => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
				'payment_date'           => date($this->language->get('date_format_short'), strtotime($result['payment_date'])),
				'customer_reward'           => $result['customer_reward']
			);
		}	
		
		
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_your_details'] = $this->language->get('text_your_details');

		$this->data['entry_firstname'] = $this->language->get('entry_firstname');
		$this->data['entry_lastname'] = $this->language->get('entry_lastname');
		$this->data['entry_email'] = $this->language->get('entry_email');
		$this->data['entry_fax'] = $this->language->get('entry_fax');
		$this->data['entry_password'] = $this->language->get('entry_password');
    	$this->data['entry_confirm'] = $this->language->get('entry_confirm');

		$this->data['button_continue'] = $this->language->get('button_continue');
		$this->data['button_back'] = $this->language->get('button_back');

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['firstname'])) {
			$this->data['error_firstname'] = $this->error['firstname'];
		} else {
			$this->data['error_firstname'] = '';
		}

		if (isset($this->error['lastname'])) {
			$this->data['error_lastname'] = $this->error['lastname'];
		} else {
			$this->data['error_lastname'] = '';
		}
		
		if (isset($this->error['email'])) {
			$this->data['error_email'] = $this->error['email'];
		} else {
			$this->data['error_email'] = '';
		}	
	
		
		if (isset($this->error['password'])) { 
			$this->data['error_password'] = $this->error['password'];
		} else {
			$this->data['error_password'] = '';
		}

		if (isset($this->error['confirm'])) { 
			$this->data['error_confirm'] = $this->error['confirm'];
		} else {
			$this->data['error_confirm'] = '';
		}

		$this->data['action'] = $this->url->link('desaccount/credit', '', 'SSL');

		if ($this->request->server['REQUEST_METHOD'] != 'POST') {
			$designer_info = $this->model_desaccount_designer->getdesigner($this->designer->getId());
		}

		if (isset($this->request->post['firstname'])) {
			$this->data['firstname'] = $this->request->post['firstname'];
		} elseif (isset($designer_info)) {
			$this->data['firstname'] = $designer_info['firstname'];
		} else {
			$this->data['firstname'] = '';
		}

		if (isset($this->request->post['lastname'])) {
			$this->data['lastname'] = $this->request->post['lastname'];
		} elseif (isset($designer_info)) {
			$this->data['lastname'] = $designer_info['lastname'];
		} else {
			$this->data['lastname'] = '';
		}

		if (isset($this->request->post['email'])) {
			$this->data['email'] = $this->request->post['email'];
		} elseif (isset($designer_info)) {
			$this->data['email'] = $designer_info['email'];
		} else {
			$this->data['email'] = '';
		}

		if (isset($this->request->post['newsletter'])) {
			$this->data['newsletter'] = $this->request->post['newsletter'];
		} else {
			$this->data['newsletter'] = '';
		}
		
		if (isset($this->request->post['password'])) {
    		$this->data['password'] = $this->request->post['password'];
		} else {
			$this->data['password'] = '';
		}

		if (isset($this->request->post['confirm'])) {
    		$this->data['confirm'] = $this->request->post['confirm'];
		} else {
			$this->data['confirm'] = '';
		}
		
		// address Starts
		
		$this->data['button_edit'] = $this->language->get('button_edit');
		$this->data['entry_newsletter'] = $this->language->get('entry_newsletter');
    	$this->data['button_delete'] = $this->language->get('button_delete');
		
		$this->data['addresses'] = array();
		$this->load->model('desaccount/address');
		$results = $this->model_desaccount_address->getAddresses();

    	foreach ($results as $result) {
			if ($result['address_format']) {
      			$format = $result['address_format'];
    		} else {
				$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
			}
		
    		$find = array(
	  			'{firstname}',
	  			'{lastname}',
	  			'{company}',
      			'{address_1}',
      			'{address_2}',
     			'{city}',
      			'{postcode}',
      			'{zone}',
				'{zone_code}',
      			'{country}'
			);
	
			$replace = array(
	  			'firstname' => $result['firstname'],
	  			'lastname'  => $result['lastname'],
	  			'company'   => $result['company'],
      			'address_1' => $result['address_1'],
      			'address_2' => $result['address_2'],
      			'city'      => $result['city'],
      			'postcode'  => $result['postcode'],
      			'zone'      => $result['zone'],
				'zone_code' => $result['zone_code'],
      			'country'   => $result['country']  
			);

      		$this->data['addresses'][] = array(
        		'address_id' => $result['address_id'],
        		'address'    => str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format)))),
        		'update'     => $this->url->link('desaccount/address/update', 'address_id=' . $result['address_id'], 'SSL'),
				'delete'     => $this->url->link('desaccount/address/delete', 'address_id=' . $result['address_id'], 'SSL')
      		);
    	}
		
		$this->data['newsletter'] = $this->designer->getNewsletter();
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		
		// address Ends

		$this->data['back'] = $this->url->link('desaccount/account', '', 'SSL');

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/desaccount/credit.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/desaccount/credit.tpl';
		} else {
			$this->template = 'default/template/desaccount/credit.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());	
	}

	private function validate() {
		if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen($this->request->post['firstname']) > 32)) {
			$this->error['firstname'] = $this->language->get('error_firstname');
		}

		if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen($this->request->post['lastname']) > 32)) {
			$this->error['lastname'] = $this->language->get('error_lastname');
		}

		if ((utf8_strlen($this->request->post['email']) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['email'])) {
			$this->error['email'] = $this->language->get('error_email');
		}
		
		if (($this->designer->getEmail() != $this->request->post['email']) && $this->model_desaccount_designer->getTotaldesignersByEmail($this->request->post['email'])) {
			$this->error['warning'] = $this->language->get('error_exists');
		}


		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>