<?php   
class ControllerCommonHome1 extends Controller {
	public function index() {
		$this->document->setTitle($this->config->get('config_title') );
		$this->document->setDescription($this->config->get('config_meta_description'));

		$this->data['heading_title'] = $this->config->get('config_title');
		
		//  Affiliate System -- Add on Starts Here
		if($this->config->get('config_affiliatepoints'))
		{
			if(isset($this->request->get['tracking']))
			{
				$this->load->model('affiliate/affiliate');			
				$this->session->data['referral_code'] = $this->request->get['tracking'];
				$affiliate_id=$this->model_affiliate_affiliate->getAffiliateId($this->session->data['referral_code']);
				if($affiliate_id){
					$this->session->data['referral_id'] = $affiliate_id;
					$this->model_affiliate_affiliate->AddUrlCount($affiliate_id);
					$this->data['mybanner'] = $this->model_affiliate_affiliate->getBannerURL($affiliate_id);
					if(strpos($this->data['mybanner'],'home')===false){
						//$this->redirect($this->data['mybanner']);
					}
				}
			}
		}
		//  Affiliate System -- Add on Ends   Here

		
		if (($this->request->server['REQUEST_METHOD'] == 'GET') && isset($this->request->get['c'])) {
      		$this->currency->set($this->request->get['c']);
   		}else{
   			$this->currency->set($this->config->get('config_currency'));
   		}
   		
		//Testimonial Starts Here
		$this->data['text_more'] = 'Read more testimonials>>';
		$this->data['isi_testimonial'] = 'hello';
		$this->load->model('fido/testimonial');
		$this->load->model('catalog/information');
		
		$this->data['testimonials'] = array();
		
		$results = $this->model_fido_testimonial->getTestimonialsnew(0, 1);
		
		$infor = $this->model_catalog_information->getInformationNew(25);
		$this->data['information'] = html_entity_decode($infor, ENT_QUOTES, 'UTF-8');
		
		foreach ($results as $result) {
			
			$this->data['testimonials'][] = array(											  
				'title'			=> $result['firstname'] . '' . $result['lastname'],
				'description'	=> html_entity_decode($result['testimony'], ENT_QUOTES, 'UTF-8')
				//'description'	=> nl2br(htmlentities(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')))
			);
		}
		
		
		$this->data['more'] = $this->url->link('information/testimonial');
		$this->data['isitesti'] = $this->url->link('product/isitestimonial');
		
		//Testimonial Ends Here
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/home.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/home.tpl';
		} else {
			$this->template = 'default/template/common/home.tpl';
		}
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'
		);
										
		$this->response->setOutput($this->render());
	}
}
?>