<!DOCTYPE html>
<html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>">
<head>
<meta charset="UTF-8" />
<title><?php echo $title; ?></title>
<base href="<?php echo $base; ?>" />
<?php if ($description) { ?>
<meta name="description" content="<?php echo $description; ?>" />
<?php } ?>
<?php if ($keywords) { ?>
<meta name="keywords" content="<?php echo $keywords; ?>" />
<?php } ?>
<?php if ($icon) { ?>
<link href="<?php echo $icon; ?>" rel="icon" />
<?php } ?>
<?php foreach ($links as $link) { ?>
<link href="<?php echo $link['href']; ?>" rel="<?php echo $link['rel']; ?>" />
<?php } ?>
<link href="http://fonts.googleapis.com/css?family=Yanone+Kaffeesatz:extralight,light,regular,bold&amp;subset=latin" rel="stylesheet" type="text/css" />
<!-- main stylesheet file is set from controller -->
<?php foreach ($styles as $style) { ?>
<link rel="<?php echo $style['rel']; ?>" type="text/css" href="<?php echo $style['href']; ?>" media="<?php echo $style['media']; ?>" />
<?php } ?>
<script type="text/javascript" src="catalog/view/javascript/jquery/jquery-1.7.1.min.js"></script>
<script type="text/javascript" src="catalog/view/javascript/jquery/ui/jquery-ui-1.8.16.custom.min.js"></script>
<link rel="stylesheet" type="text/css" href="catalog/view/javascript/jquery/ui/themes/ui-lightness/jquery-ui-1.8.16.custom.css" />
<script type="text/javascript" src="catalog/view/javascript/jquery/ui/external/jquery.cookie.js"></script>
<script type="text/javascript" src="catalog/view/javascript/jquery/colorbox/jquery.colorbox.js"></script>
<link rel="stylesheet" type="text/css" href="catalog/view/javascript/jquery/colorbox/colorbox.css" media="screen" />
<script type="text/javascript" src="catalog/view/javascript/jquery/tabs.js"></script>
<script type="text/javascript" src="catalog/view/javascript/jquery/jquery.slideto.js"></script>
<script type="text/javascript" src="catalog/view/javascript/jquery/jquery.ui.totop.js"></script>
<script type="text/javascript" src="catalog/view/javascript/jquery/jquery.easing.1.3.js"></script>
<script type="text/javascript" src="catalog/view/javascript/jquery/jquery.bxSlider.min.custom.js"></script>
<script type="text/javascript" src="catalog/view/javascript/blog_common.js"></script>

<?php foreach ($scripts as $script) { ?>
<script type="text/javascript" src="<?php echo $script; ?>"></script>
<?php } ?>
<!--[if IE 7]>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/default/stylesheet/ie7.css" />
<![endif]-->
<!--[if lt IE 7]>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/default/stylesheet/ie6.css" />
<script type="text/javascript" src="catalog/view/javascript/DD_belatedPNG_0.0.8a-min.js"></script>
<script type="text/javascript">
DD_belatedPNG.fix('#logo img');
</script>
<![endif]-->
<?php echo $google_analytics; ?>
<?php echo $whos_amung_us; ?>
</head>
<body>
<div id="container">
<div id="header">
  <div id="back-store"><a href=""><?php echo $text_back_store; ?></a></div>
  <?php echo $blog_language; ?>
  <div id="topnav">
	<ul>
		<li><a href="<?php echo $home; ?>"><?php echo $text_home; ?></a></li>
		<li class="last"><a href="<?php echo $rss; ?>"><?php echo $text_rss; ?></a></li>
	</ul>
  </div>	
  <?php if ($logo) { ?>
  <div id="logo"><a href="<?php echo $home; ?>"><img src="<?php echo $logo; ?>" title="<?php echo $name; ?>" alt="<?php echo $name; ?>" /></a></div>
  <?php } ?>
  
  <?php if ($bph_banners) { ?>	
  <div id="adbanner468">
	<div id="bp_gallery_header">
		<?php foreach($bph_banners as $banner) { ?>
		<?php if ($banner['link']) {?>	
		<div><a href="<?php echo $banner['link']; ?>" title="<?php echo $banner['title']; ?>" target="blank"><img src="<?php echo $banner['image']; ?>" alt="" /></a></div>
		<?php } else { ?>
		<div><img src="<?php echo $banner['image']; ?>" alt="" /></div>
		<?php } ?>
		<?php } ?>
	</div>
  </div>
  <?php } ?>

  </div>

<?php if ($categories) { ?>
<div id="menu">
	<ul>
		<li class="cat-item"><a href="<?php echo $home; ?>"><?php echo $text_home; ?></a></li>
		<?php foreach ($categories as $category) { ?>
		<li class="cat-item"><a href="<?php echo $category['href']; ?>"><?php echo $category['name']; ?></a>
			<?php if ($category['children']) { ?>
		   	<div>
				<?php for ($i = 0; $i < count($category['children']);) { ?>
				<ul class="children">
				  <?php $j = $i + ceil(count($category['children']) / $category['column']); ?>
				  <?php for (; $i < $j; $i++) { ?>
				  <?php if (isset($category['children'][$i])) { ?>
				  <li class="cat-item"><a href="<?php echo $category['children'][$i]['href']; ?>"><?php echo $category['children'][$i]['name']; ?></a></li>
				  <?php } ?>
				  <?php } ?>
				</ul>
				<?php } ?>
			</div>	
		  <?php } ?>
		</li>
		<?php } ?>
	</ul>
  	<div class="searchform">
		<input type="text" name="filter_name" value="<?php echo $filter_name; ?>"  class="searchfield" />
		<div class="searchbutton"></div>
	</div>	
</div>
<?php } ?>
<div id="notification"></div>
