<?php
class ControllerDesaccountDesignprofile extends Controller {
	private $error = array(); 

	public function index() {
	

		if(isset($_GET['dsid']))
		{
			$this->data['designer_id'] = $_GET['dsid'];
		}else{
		   if(isset($_GET['sid'])){
			$this->data['designer_id'] = $_GET['sid'];
		    } 
		}
		

		$this->language->load('desaccount/mydesign');
		
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('desaccount/designer');
		
		$this->load->model('account/customer');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
		
			if (! $this->customer->isLogged()) {
				$this->session->data['redirect'] = $this->url->link('desaccount/designprofile', 'dsid=' . $this->data['designer_id'] , 'SSL');
				$this->redirect($this->url->link('account/login', '', 'SSL')); 
			}
			
			$message =  '';
			
			$message .= 'Hi, <br><br>';
			$message .= "<b>".$this->customer->getFirstName() . "</b>&nbsp;" .' ('. $this->customer->getEmail() .') has enquired the sketch design with Sketch Id #' . $_GET['dsid'] . '<br><br>';
			$message .= "<b>Comments : </b>". $this->request->post['describe'] . "<br><br><br>";
			$message .= $this->url->link('desaccount/designprofile', 'dsid=' . $this->data['designer_id'] , 'SSL') .'<br><br>';
			
			$message .= 'Regards, <br><br>';
			$message .= 'Customer Service Team<br><br>';
			
			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->hostname = $this->config->get('config_smtp_host');
			$mail->username = $this->config->get('config_smtp_username');
			$mail->password = $this->config->get('config_smtp_password');
			$mail->port = $this->config->get('config_smtp_port');
			$mail->timeout = $this->config->get('config_smtp_timeout');				
			$mail->setTo($this->config->get('config_email'));
	  		$mail->setFrom($this->config->get('config_email'));
		  	$mail->setSender($this->config->get('config_name'));
	  		$mail->setSubject(sprintf('Design Sketch Enquiry from Customer ' . $this->customer->getName() ) );
	  		$mail->setHtml((html_entity_decode($message, ENT_QUOTES, 'UTF-8')));
      			
      			$mail->send();
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('information/information', 'information_id=63', 'SSL'));
		}

      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),     	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => 'Designer Profile',
			'href'      => $this->url->link('desaccount/designprofile', 'dsid=' . $_GET["dsid"] , 'SSL'),       	
        	'separator' => $this->language->get('text_separator')
      	);
		
		$this->data['logged'] = $this->customer->isLogged();
		
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_your_details'] = $this->language->get('text_your_details');

		$this->data['entry_firstname'] = $this->language->get('entry_firstname');
		$this->data['entry_lastname'] = $this->language->get('entry_lastname');
		$this->data['entry_email'] = $this->language->get('entry_email');
		$this->data['entry_fax'] = $this->language->get('entry_fax');
		$this->data['entry_password'] = $this->language->get('entry_password');
    	$this->data['entry_confirm'] = $this->language->get('entry_confirm');
    	$this->data['entry_dispname'] = $this->language->get('entry_dispname');
    	$this->data['entry_profpic'] = $this->language->get('entry_profpic');
		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');	
		$this->data['entry_gender'] = $this->language->get('entry_gender');	
		$this->data['text_male'] = $this->language->get('text_male');	
		$this->data['text_female'] = $this->language->get('text_female');	
		$this->data['text_english'] = $this->language->get('text_english');	
		$this->data['text_french'] = $this->language->get('text_french');	
		$this->data['text_italin'] = $this->language->get('text_italin');	
		$this->data['entry_yourself'] = $this->language->get('entry_yourself');	
		$this->data['entry_langknown'] = $this->language->get('entry_langknown');	
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['text_cheque'] = $this->language->get('text_cheque');
		$this->data['text_paypal'] = $this->language->get('text_paypal');
		$this->data['text_money'] = $this->language->get('text_money');
		$this->data['text_bank'] = $this->language->get('text_bank');
		$this->data['entry_paypalemail'] = $this->language->get('entry_paypalemail');
		$this->data['text_page_content'] = $this->language->get('text_page_content');
		$this->data['text_page_content2'] = $this->language->get('text_page_content2');

		$this->data['button_continue'] = $this->language->get('button_continue');
		$this->data['button_back'] = $this->language->get('button_back');

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['firstname'])) {
			$this->data['error_firstname'] = $this->error['firstname'];
		} else {
			$this->data['error_firstname'] = '';
		}

		if (isset($this->error['lastname'])) {
			$this->data['error_lastname'] = $this->error['lastname'];
		} else {
			$this->data['error_lastname'] = '';
		}
		
		if (isset($this->error['email'])) {
			$this->data['error_email'] = $this->error['email'];
		} else {
			$this->data['error_email'] = '';
		}	
	
		
		if (isset($this->error['password'])) { 
			$this->data['error_password'] = $this->error['password'];
		} else {
			$this->data['error_password'] = '';
		}

		if (isset($this->error['confirm'])) { 
			$this->data['error_confirm'] = $this->error['confirm'];
		} else {
			$this->data['error_confirm'] = '';
		}

		
		
		$this->data['designerid'] = $this->designer->getId();
		
		$this->data['designer_details'] = array();
		
		$this->load->model('tool/image');
		
	//	$this->data['idd'] = $_SESSION['views'];
		
		$results2 = $this->model_desaccount_designer->passing_designer_id($this->data['designerid']);
		
		foreach ($results2 as $result) {
			
		$this->data['designer_details'] = array(
					'product_id'  => $result['product_id'],
					'sketch_id'  => $result['sketch_id'],
					'image'  => $result['image']
				);
		}
		
		
			$this->data['designer_details_new'] = array();
			$result = $this->model_account_customer->getting_designer_newdetails_1($this->data['designer_id']);
			
			$this->data['des_imagee'] = $this->model_account_customer->getsketchidnew3_image($result['designer_id']);
			$this->data['desgn_img'] = $this->model_tool_image->resize($this->data['des_imagee'], 200, 200);
			
			$this->data['designer_details_new'] = array(
					'dispname'  => $result['dispname'],
					'image'  => $this->model_tool_image->resize($result['image'], 400, 400),
					'lang'  => $result['lang'],
					'lang1'  => $result['lang1'],
					'lang2'  => $result['lang2'],
					'about_yourself'  => $result['about_yourself'],
					'designerlink'  => $this->url->link('desaccount/designerprofile', 'dsid=' . $result['designer_id'], 'SSL')
					
				);
		
		if (isset($this->request->post['ones'])) {
    			$this->data['ones'] = $this->request->post['ones'];
		} else {
			$this->data['ones'] = '';
		}

				$this->data['action'] = $this->url->link('desaccount/designprofile', 'dsid=' . $this->data['designer_id'], 'SSL');

		
		
		
		
		
		
		if ($this->request->server['REQUEST_METHOD'] != 'POST') {
			$designer_info = $this->model_desaccount_designer->getdesigner($this->designer->getId());
		}

	/*	if (isset($this->request->post['firstname'])) {
			$this->data['firstname'] = $this->request->post['firstname'];
		} elseif (isset($designer_info)) {
			$this->data['firstname'] = $designer_info['firstname'];
		} else {
			$this->data['firstname'] = '';
		}

		if (isset($this->request->post['lastname'])) {
			$this->data['lastname'] = $this->request->post['lastname'];
		} elseif (isset($designer_info)) {
			$this->data['lastname'] = $designer_info['lastname'];
		} else {
			$this->data['lastname'] = '';
		}

		if (isset($this->request->post['email'])) {
			$this->data['email'] = $this->request->post['email'];
		} elseif (isset($designer_info)) {
			$this->data['email'] = $designer_info['email'];
		} else {
			$this->data['email'] = '';
		}  */

		if (isset($this->request->post['newsletter'])) {
			$this->data['newsletter'] = $this->request->post['newsletter'];
		} else {
			$this->data['newsletter'] = '';
		}
		
		if (isset($this->request->post['password'])) {
    		$this->data['password'] = $this->request->post['password'];
		} else {
			$this->data['password'] = '';
		}

		if (isset($this->request->post['confirm'])) {
    		$this->data['confirm'] = $this->request->post['confirm'];
		} else {
			$this->data['confirm'] = '';
		}
		
		// address Starts
		
		$this->data['button_edit'] = $this->language->get('button_edit');
		$this->data['entry_newsletter'] = $this->language->get('entry_newsletter');
    	$this->data['button_delete'] = $this->language->get('button_delete');
		
		$this->data['addresses'] = array();
		$this->load->model('desaccount/address');
		$results = $this->model_desaccount_address->getAddresses();

    	foreach ($results as $result) {
			if ($result['address_format']) {
      			$format = $result['address_format'];
    		} else {
				$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
			}
		
    		$find = array(
	  			'{firstname}',
	  			'{lastname}',
	  			'{company}',
      			'{address_1}',
      			'{address_2}',
     			'{city}',
      			'{postcode}',
      			'{zone}',
				'{zone_code}',
      			'{country}'
			);
	
			$replace = array(
	  			'firstname' => $result['firstname'],
	  			'lastname'  => $result['lastname'],
	  			'company'   => $result['company'],
      			'address_1' => $result['address_1'],
      			'address_2' => $result['address_2'],
      			'city'      => $result['city'],
      			'postcode'  => $result['postcode'],
      			'zone'      => $result['zone'],
				'zone_code' => $result['zone_code'],
      			'country'   => $result['country']  
			);

      		$this->data['addresses'][] = array(
        		'address_id' => $result['address_id'],
        		'address'    => str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format)))),
        		'update'     => $this->url->link('desaccount/address/update', 'address_id=' . $result['address_id'], 'SSL'),
				'delete'     => $this->url->link('desaccount/address/delete', 'address_id=' . $result['address_id'], 'SSL')
      		);
    	}
		
		$this->data['newsletter'] = $this->designer->getNewsletter();
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		
		// address Ends

		$this->data['back'] = $this->url->link('desaccount/account', '', 'SSL');

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/desaccount/designprofile.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/desaccount/designprofile.tpl';
		} else {
			$this->template = 'default/template/desaccount/designprofile.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());	
	}

	private function validate() {
		if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen($this->request->post['firstname']) > 32)) {
			$this->error['firstname'] = $this->language->get('error_firstname');
		}

		if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen($this->request->post['lastname']) > 32)) {
			$this->error['lastname'] = $this->language->get('error_lastname');
		}

		if ((utf8_strlen($this->request->post['email']) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['email'])) {
			$this->error['email'] = $this->language->get('error_email');
		}
		
		if (($this->designer->getEmail() != $this->request->post['email']) && $this->model_desaccount_designer->getTotaldesignersByEmail($this->request->post['email'])) {
			$this->error['warning'] = $this->language->get('error_exists');
		}


		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>