<?php
class ControllerSaleRingSize extends Controller {
	private $error = array();
 
	public function index() {
		$this->load->language('sale/ring_size');
 
		$this->document->setTitle($this->language->get('heading_title'));
 		
		$this->load->model('sale/ring_size');
		
		$this->getList();
	}

	public function insert() {
		$this->load->language('sale/ring_size');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/ring_size');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_ring_size->addRingSize($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/ring_size', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function update() {
		$this->load->language('sale/ring_size');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/ring_size');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_ring_size->editRingSize($this->request->get['ring_size_id'], $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/ring_size', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function delete() { 
		$this->load->language('sale/ring_size');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/ring_size');
		
		if (isset($this->request->post['selected'])) {
      		foreach ($this->request->post['selected'] as $ring_size_id) {
				$this->model_sale_ring_size->deleteRingSize($ring_size_id);	
			}
						
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/ring_size', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'ring_size';
			
		}
		 
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}	
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
			
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/ring_size', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		$this->data['insert'] = $this->url->link('sale/ring_size/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('sale/ring_size/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	
		$this->data['ring_sizes'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$ring_size_total = $this->model_sale_ring_size->getTotalRingSize();
		
		$results = $this->model_sale_ring_size->getRingSizes($data);

		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/ring_size/update', 'token=' . $this->session->data['token'] . '&ring_size_id=' . $result['ring_size_id'] . $url, 'SSL')
			);		
		
			$this->data['ring_sizes'][] = array(
				'ring_size_id' 		=> $result['ring_size_id'],
				'country'           => $result['country'] . (($result['ring_size_id'] == $this->config->get('config_ring_size_id')) ? $this->language->get('text_default') : null),
				'ring_size'         => $result['ring_size'] . (($result['ring_size_id'] == $this->config->get('config_ring_size_id')) ? $this->language->get('text_default') : null),
				'status'            => $result['status'] . (($result['ring_size_id'] == $this->config->get('config_ring_size_id')) ? $this->language->get('text_default') : null),			
				'selected'          => isset($this->request->post['selected']) && in_array($result['ring_size_id'], $this->request->post['selected']),
				'action'            => $action
				
			);
		}	
	
		$this->data['heading_title']    = $this->language->get('heading_title');		
		$this->data['text_no_results']  = $this->language->get('text_no_results');		
		$this->data['column_ring_size'] = $this->language->get('column_ring_size');
		$this->data['column_country']   = $this->language->get('column_country');	
		$this->data['column_status']    = $this->language->get('column_status');				
		$this->data['column_action']    = $this->language->get('column_action');
		$this->data['button_insert']    = $this->language->get('button_insert');
		$this->data['button_delete']    = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_ring_size'] = $this->url->link('sale/ring_size', 'token=' . $this->session->data['token'] . '&sort=ring_size' . $url, 'SSL');
		$this->data['sort_country']   = $this->url->link('sale/ring_size', 'token=' . $this->session->data['token'] . '&sort=country' . $url, 'SSL');
		$this->data['sort_status']    = $this->url->link('sale/ring_size', 'token=' . $this->session->data['token'] . '&sort=status' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $ring_size_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/ring_size', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		
		$this->data['pagination'] = $pagination->render();				

		$this->data['sort'] = $sort; 
		$this->data['order'] = $order;

		$this->template = 'sale/ring_size_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
 	}

	private function getForm() {
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_australia'] = $this->language->get('text_australia');
		$this->data['text_usa'] = $this->language->get('text_usa');
		$this->data['text_others'] = $this->language->get('text_others');
		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['entry_ring_size'] = $this->language->get('entry_ring_size');
		$this->data['entry_country'] = $this->language->get('entry_country');
		$this->data['entry_status'] = $this->language->get('entry_status');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
 		if (isset($this->error['ring_size'])) {
			$this->data['error_ring_size'] = $this->error['ring_size'];
		} else {
			$this->data['error_ring_size'] = '';
		}		                                         
		if (isset($this->error['country'])) {
			$this->data['error_country'] = $this->error['country'];
		} else {
			$this->data['error_country'] = '';
		}
		if (isset($this->error['status'])) {
			$this->data['error_staus'] = $this->error['status'];
		} else {
			$this->data['error_status'] = '';
		}
        		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/ring_size', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
			
		if (!isset($this->request->get['ring_size_id'])) {
			$this->data['action'] = $this->url->link('sale/ring_size/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('sale/ring_size/update', 'token=' . $this->session->data['token'] . '&ring_size_id=' . $this->request->get['ring_size_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('sale/ring_size', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if (isset($this->request->get['ring_size_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$customer_ring_info = $this->model_sale_ring_size->getRingSize($this->request->get['ring_size_id']);
		}

		if (isset($this->request->post['ring_size'])) {
			$this->data['ring_size'] = $this->request->post['ring_size'];
		} elseif (isset($customer_ring_info)) {
			$this->data['ring_size'] = $customer_ring_info['ring_size'];
		} else {
			$this->data['ring_size'] = '';
		}
		
		if (isset($this->request->post['country'])) {
			$this->data['country'] = $this->request->post['country'];
		} elseif (isset($customer_ring_info)) {
			$this->data['country'] = $customer_ring_info['country'];
		} else {
			$this->data['country'] = '';
		}
		
		if (isset($this->request->post['status'])) {
			$this->data['status'] = $this->request->post['status'];
		} elseif (isset($customer_ring_info)) {
			$this->data['status'] = $customer_ring_info['status'];
		} else {
			$this->data['status'] = '';
		}		
	
		$this->template = 'sale/ring_size_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render()); 
	}

	private function validateForm() {
		if (!$this->user->hasPermission('modify','sale/ring_size')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}	
		
		if ((utf8_strlen($this->request->post['ring_size']) < 1) || (utf8_strlen($this->request->post['ring_size']) > 64)) {
			$this->error['ring_size'] = $this->language->get('error_ring_size');
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	private function validateDelete() {
		if (!$this->user->hasPermission('modify','sale/ring_size')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$this->load->model('setting/store');
		$this->load->model('sale/customer');
      	
		foreach ($this->request->post['selected'] as $ring_size_id) {
    		if ($this->config->get('config_ring_size_id') == $ring_size_id) {
	  			$this->error['warning'] = $this->language->get('error_default');	
			}  
			
			$store_total = $this->model_setting_store->getTotalStoresByRingSizeId($ring_size_id);

			if ($store_total) {
				$this->error['warning'] = sprintf($this->language->get('error_store'), $store_total);
			}
			
			$ringsize_total = $this->model_sale_customer->getTotalCustomersByCustomerRingId($ring_size_id);

			if ($customer_total) {
				$this->error['warning'] = sprintf($this->language->get('error_customer'), $ringsize_total);
			}
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>