<?php
// autogenerated file 15.11.2010 08:29
// $Id: $
// $Log: $
//
//
require_once 'ItemType.php';
require_once 'AbstractRequestType.php';

/**
 * Defines a single new item and lists it on a specified eBay site. Returns theitem 
 * ID for the new listing, and returns fees the seller will incur for thelisting 
 * (not including the Final Value Fee, which cannot be calculated untilthe item is 
 * sold).<br><br>Sellers who engage in cross-border trade on sites that require a 
 * recoupment agreement, must agree to therecoupment terms before adding items to 
 * the site. This agreement allows eBay to reimbursea buyer during a dispute and 
 * then recoup the cost from the seller. Links to the agreementwill be posted to 
 * the eBay Developer Program website.<br><br>For the US, Canada (CA), French 
 * Canadian (CAFR), and US Motors sites, the FixedPriceItem listing formatwill be 
 * replacing the StoresFixedPrice listing format, and the StoresFixedPrice format 
 * will be deprecatedin early 2011. As of March 30, 2010, we will start a migration 
 * phase where AddItem and AddFixedPriceItemwill accept either FixedPriceItem or 
 * StoresFixedPrice as listing formats, but the item will be displayedas 
 * FixedPriceItem on the site and in search results. GetItem and other 'Get' calls 
 * will return the format you originallyused in the request. Therefore, the 
 * preferred format will be FixedPriceItem.<br><br>As part of the merge of the 
 * StoresFixedPrice and FixedPriceItem formats, the start price of all 
 * newFixedPriceItems must be 99 cents or greater. This change will also go into 
 * effect on March 30, 2010. 
 *
 * @link http://developer.ebay.com/DevZone/XML/docs/Reference/eBay/types/AddItemRequestType.html
 *
 */
class AddItemRequestType extends AbstractRequestType
{
	/**
	 * @var ItemType
	 */
	protected $Item;

	/**
	 * @return ItemType
	 */
	function getItem()
	{
		return $this->Item;
	}
	/**
	 * @return void
	 * @param ItemType $value 
	 */
	function setItem($value)
	{
		$this->Item = $value;
	}
	/**
	 * @return 
	 */
	function __construct()
	{
		parent::__construct('AddItemRequestType', 'urn:ebay:apis:eBLBaseComponents');
		if (!isset(self::$_elements[__CLASS__]))
				self::$_elements[__CLASS__] = array_merge(self::$_elements[get_parent_class()],
				array(
					'Item' =>
					array(
						'required' => false,
						'type' => 'ItemType',
						'nsURI' => 'urn:ebay:apis:eBLBaseComponents',
						'array' => false,
						'cardinality' => '0..1'
					)
				));
	}
}
?>
