<?php
final class Designer {
	private $designer_id;
	private $firstname;
	private $lastname;
	private $email;
	private $telephone;
	private $fax;
	private $newsletter;
	private $designer_group_id;
	private $address_id;
	private $dispname;
	
  	public function __construct($registry) {
		$this->config = $registry->get('config');
		$this->db = $registry->get('db');
		$this->request = $registry->get('request');
		$this->session = $registry->get('session');
				
		if (isset($this->session->data['designer_id'])) { 
			$designer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "designer WHERE designer_id = '" . (int)$this->session->data['designer_id'] . "' AND status = '1'");
			
			if ($designer_query->num_rows) {
				$this->designer_id = $designer_query->row['designer_id'];
				$this->firstname = $designer_query->row['firstname'];
				$this->lastname = $designer_query->row['lastname'];
				$this->email = $designer_query->row['email'];
				$this->telephone = $designer_query->row['telephone'];
				$this->fax = $designer_query->row['fax'];
				$this->newsletter = $designer_query->row['newsletter'];
				$this->designer_group_id = $designer_query->row['designer_group_id'];
				$this->address_id = $designer_query->row['address_id'];
				$this->dispname = $designer_query->row['dispname'];
							
      			$this->db->query("UPDATE " . DB_PREFIX . "designer SET cart = '" . $this->db->escape(isset($this->session->data['cart']) ? serialize($this->session->data['cart']) : '') . "', wishlist = '" . $this->db->escape(isset($this->session->data['wishlist']) ? serialize($this->session->data['wishlist']) : '') . "', ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "' WHERE designer_id = '" . (int)$this->session->data['designer_id'] . "'");
			
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "designer_ip WHERE designer_id = '" . (int)$this->session->data['designer_id'] . "' AND ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "'");
				
				if (!$query->num_rows) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "designer_ip SET designer_id = '" . (int)$this->session->data['designer_id'] . "', ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "', date_added = NOW()");
				}
			} else {
				$this->logout();
			}
  		}
	}
		
  	public function login($email, $password, $override = false) {
		if ($override) {
			$designer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "designer where LOWER(email) = '" . $this->db->escape(strtolower($email)) . "' AND status = '1'");
		} elseif (!$this->config->get('config_designer_approval')) {
			$designer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "designer WHERE LOWER(email) = '" . $this->db->escape(strtolower($email)) . "' AND password = '" . $this->db->escape(md5($password)) . "' AND status = '1'");
		} else {
			$designer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "designer WHERE LOWER(email) = '" . $this->db->escape(strtolower($email)) . "' AND password = '" . $this->db->escape(md5($password)) . "' AND status = '1' AND approved = '1'");
		}
		
		if ($designer_query->num_rows) {
			$this->session->data['designer_id'] = $designer_query->row['designer_id'];	
		    
			if ($designer_query->row['cart'] && is_string($designer_query->row['cart'])) {
				$cart = unserialize($designer_query->row['cart']);
				
				foreach ($cart as $key => $value) {
					if (!array_key_exists($key, $this->session->data['cart'])) {
						$this->session->data['cart'][$key] = $value;
					} else {
						$this->session->data['cart'][$key] += $value;
					}
				}			
			}

			if ($designer_query->row['wishlist'] && is_string($designer_query->row['wishlist'])) {
				if (!isset($this->session->data['wishlist'])) {
					$this->session->data['wishlist'] = array();
				}
								
				$wishlist = unserialize($designer_query->row['wishlist']);
			
				foreach ($wishlist as $product_id) {
					if (!in_array($product_id, $this->session->data['wishlist'])) {
						$this->session->data['wishlist'][] = $product_id;
					}
				}			
			}
									
			$this->designer_id = $designer_query->row['designer_id'];
			$this->firstname = $designer_query->row['firstname'];
			$this->lastname = $designer_query->row['lastname'];
			$this->email = $designer_query->row['email'];
			$this->telephone = $designer_query->row['telephone'];
			$this->fax = $designer_query->row['fax'];
			$this->newsletter = $designer_query->row['newsletter'];
			$this->designer_group_id = $designer_query->row['designer_group_id'];
			$this->address_id = $designer_query->row['address_id'];
			$this->dispname = $designer_query->row['dispname'];
          	
			$this->db->query("UPDATE " . DB_PREFIX . "designer SET ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "' WHERE designer_id = '" . (int)$designer_query->row['designer_id'] . "'");
			
	  		return true;
    	} else {
      		return false;
    	}
  	}
  	
	public function logout() {
		unset($this->session->data['designer_id']);

		$this->designer_id = '';
		$this->firstname = '';
		$this->lastname = '';
		$this->email = '';
		$this->telephone = '';
		$this->fax = '';
		$this->newsletter = '';
		$this->designer_group_id = '';
		$this->address_id = '';
		$this->dispname = '';
  	}
  
  	public function isLogged() {
    	return $this->designer_id;
  	}

  	public function getId() {
    	return $this->designer_id;
  	}
      
  	public function getFirstName() {
		return $this->firstname;
  	}
  
  	public function getLastName() {
		return $this->lastname;
  	}
  
  	public function getDisplayName() {
		return $this->dispname;
  	}
  
  	public function getEmail() {
		return $this->email;
  	}
  
  	public function getTelephone() {
		return $this->telephone;
  	}
  
  	public function getFax() {
		return $this->fax;
  	}
	
  	public function getNewsletter() {
		return $this->newsletter;	
  	}

  	public function getdesignerGroupId() {
		return $this->designer_group_id;	
  	}
	
  	public function getAddressId() {
		return $this->address_id;	
  	}
	
  	public function getBalance() {
		$query = $this->db->query("SELECT SUM(amount) AS total FROM " . DB_PREFIX . "designer_transaction WHERE designer_id = '" . (int)$this->designer_id . "'");
	
		return $query->row['total'];
  	}	
		
  	public function getRewardPoints() {
		$query = $this->db->query("SELECT SUM(points) AS total FROM " . DB_PREFIX . "designer_reward WHERE designer_id = '" . (int)$this->designer_id . "'");
	
		return $query->row['total'];	
  	}	
}
?>