<?php
class ControllerExtensionModuleGemstone extends Controller {
	public function index($setting) {
		$this->load->language('extension/module/gemstone');

  	$data['heading_title'] = $this->language->get('heading_title');

		$data['button_cart'] = $this->language->get('button_cart');

		$this->load->model('catalog/product');

		$this->load->model('tool/image');

		$data['gemstones'] = array();

		if (isset($this->request->get['path']))
		{
			$path = '';

			$parts = explode('_', (string)$this->request->get['path']);

			foreach ($parts as $path_id) {
				if (!$path) {
					$path = $path_id;
				} else {
					$path .= '_' . $path_id;
				}

				$category_info = $this->model_catalog_category->getCategory($path_id);

				if ($category_info) {
	       			$data['breadcrumbs'][] = array(
   	    				'text'      => $category_info['name'],
								'href'      => $this->url->link('product/category', 'path=' . $path),
        				'separator' => $this->language->get('text_separator')
        			);
				}
			}
			$category_id = array_pop($parts);
		} else {
			$category_id = 0;
		}

		$rno_path = "path=" . $category_id ;


		$data['gemname']='';
		$data['metalname']='';
		$data['shapename']='';

		if (isset($this->request->get['metal_id'])) {
			$metal_id = $this->request->get['metal_id'];
		} elseif (isset($category_info['metal_id'])) {
			$metal_id = $category_info['metal_id'];
		} else {
			$metal_id = 0;
		}
		if($metal_id >0)$rno_path .= "&metal_id=" . $metal_id ;

		if (isset($this->request->get['gemstone_id'])) {
			$gemstone_id = $this->request->get['gemstone_id'];
		} elseif (isset($category_info['gemstone_id'])){
			$gemstone_id = $category_info['gemstone_id'];
		}else {
			$gemstone_id = 0;
		}
		if($gemstone_id >0)$rno_path .= "&gemstone_id=" . $gemstone_id ;

		if (isset($this->request->get['shape_id'])) {
			$shape_id = $this->request->get['shape_id'];
		} elseif (isset($category_info['shape_id'])) {
			$shape_id = $category_info['shape_id'];
		} else {
			$shape_id = 0 ;
		}
		if($shape_id >0)$rno_path .= "&shape_id=" . $shape_id ;

		if (isset($this->request->get['lp'])) {
			$low_price = $this->request->get['lp'];
		} else {
			$low_price = 0 ;
		}
		if (isset($this->request->get['hp'])) {
			$high_price = $this->request->get['hp'];
		} else {
			$high_price = 10000000 ;
		}

		if (isset($this->request->get['style'])) {
			$style = $this->request->get['style'];
			$styleurladd = '&style=' . $this->request->get['style'];
		} else {
			$style = '1' ;
			$styleurladd = '';
		}

		$rno = '';
		if( isset( $this->request->get['rno'] )  ){
			$rno = '&rno=' . $this->request->get['rno'] . '&';
		}

		if( isset($this->request->get['metal_id']) <> 0 || isset($this->request->get['gemstone_id']) <> 0 || isset($this->request->get['shape_id']) <> 0 || isset($this->request->get['lp']) <> 0 || isset($this->request->get['hp']) <> 0   ){
			$data['filterMinimize']= $metal_id +  $gemstone_id+  $shape_id + $low_price + $high_price ;
		}else{
			$data['filterMinimize']= 0;
		}
		$data['low_price']= $low_price;
		$data['high_price']= $high_price;
		if($low_price==0 && $high_price==10000000){
			$data['pricerange']= '';
		}else{
			$data['pricerange']=  $this->currency->format($low_price) . ' to ' . $this->currency->format($high_price);
		}
		$data['priceemptyurl']=$this->url->link('product/newurl', $rno . 'newurl='.$category_id.'-'.$gemstone_id.'-'.$metal_id.'-'.$shape_id.'-0-10000000'. $styleurladd);

		$data['gemname']=$this->model_catalog_product->getGemName($gemstone_id);
		$data['metalname']=$this->model_catalog_product->getMetalName($metal_id);
		$data['shapename']=$this->model_catalog_product->getShapeName($shape_id);

		$data['emptyurl']=$this->url->link('product/newurl', $rno . 'newurl='.$category_id.'-0-0-0-0-10000000'. $styleurladd);
		$data['gememptyurl']=$this->url->link('product/newurl', $rno .  'newurl='.$category_id.'-0-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price . '-' . $style . $styleurladd );
		$data['metalemptyurl']=$this->url->link('product/newurl', $rno . 'newurl='.$category_id.'-'.$gemstone_id.'-0-'.$shape_id.'-'.$low_price.'-'.$high_price . '-' . $style . $styleurladd);
		$data['shapeemptyurl']=$this->url->link('product/newurl', $rno . 'newurl='.$category_id.'-'.$gemstone_id.'-'.$metal_id.'-0'.'-'.$low_price.'-'.$high_price . '-' . $style . $styleurladd);
		$data['rangehref']=$this->url->link('product/newurl', $rno . 'newurl='.$category_id.'-'.$gemstone_id.'-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price . '-' . $style . $styleurladd);
		$data['rangehref1']=$this->url->link('product/newurl', $rno . 'newurl='.$category_id.'-'.$gemstone_id.'-'.$metal_id.'-'.$shape_id . $styleurladd);

		$data['linkurl']=$this->url->link('product/newurl', $rno . 'newurl='.$category_id.'-'.$gemstone_id.'-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price . '-' . $style . $styleurladd);

		$gemImage = HTTP_IMAGE . 'data/Gemstones/DiamondThumbnail.png';
		if($data['gemname'] == '')$data['gemname'] = 'Select Gemstone';


		$data['enableGemstoneSelection'] = 1;
		$data['enableShapeSelection'] = 1;
		if (isset($this->request->get['rno'])){
				$data['rno'] = $this->request->get['rno'];
				$data['enableGemstoneSelection'] = 0;
				$data['enableShapeSelection'] = 0;
		}


		$product_info = $this->getGemstoneImages();
		foreach ($product_info as $product_info) {
			if($gemstone_id == $product_info['gemstone_id']){
				$data['gemImage'] = HTTP_IMAGE . $product_info['image1'];
			}
			if ($product_info) {
				if ($product_info['image1']) {
					//$image = $this->model_tool_image->resize($product_info['image1'], $setting['image_width'], $setting['image_height']);
					$image = 'image/' . $product_info['image1'];
				} else {
					$image = false;
				}
				$linkurl=$this->url->link('product/newurllogic', $rno . 'newurl='.$category_id.'-'.$product_info['gemstone_id'].'-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price . '-' . $style . $styleurladd);
				$data['gemstones'][] = array(
					'thumb'   => HTTP_IMAGE . $product_info['image1'],
					'name'   	=> $product_info['gemdescr'],
					'linkurl'   	=> $linkurl,
				);
			}
		}

		$data['metals'] = array();
		//$data['metalImage'] = HTTP_IMAGE . 'data/metal/9YELLOWGOLD.png';
		$data['metalImage'] = '';
		if($data['metalname'] == '')$data['metalname'] = 'Select Metal';
		$metal_info = $this->getMetalsImages();
		foreach ($metal_info as $metal_info) {
			if($metal_id == $metal_info['metal_id']){
				$data['metalImage'] = HTTP_IMAGE . $metal_info['image'];
			}
			if ($metal_info) {
				if ($metal_info['image']) {
					//$image = $this->model_tool_image->resize($metal_info['image'], $setting['image_width'], $setting['image_height']);
					$image = HTTP_IMAGE . $metal_info['image'];
				} else {
					$image = false;
				}
				$linkurl=$this->url->link('product/newurllogic', $rno . 'newurl='.$category_id.'-'.$gemstone_id .'-'.$metal_info['metal_id'].'-'.$shape_id.'-'.$low_price.'-'.$high_price . '-' . $style . $styleurladd);

				$data['metals'][] = array(
					'thumb'   	 => $image,
					'name'   	 => $metal_info['description'],
					'metal_id'   	 => $metal_info['metal_id'],
					'metal_code'   	 => $metal_info['metal_code'],
					//'href'  => $this->getMetalSeoKeyWord($metal_info['metal_code'])
					'href'  => $linkurl
				);
			}
		}

		$data['shapes'] = array();
		// $data['shapeImage'] = HTTP_IMAGE . 'data/GemstoneShapes/RoundShape.png';
		$data['shapeImage'] = '';
		if($data['shapename'] == '')$data['shapename'] = 'Select Shape';

		$shapes_info = $this->getShapesImages();
		foreach ($shapes_info as $shape_info) {
			if($shape_id == $shape_info['shape_id']){
				$data['shapeImage'] = HTTP_IMAGE . $shape_info['image'];
			}
			if ($shape_info) {
				if ($shape_info['image']) {
					$image = $this->model_tool_image->resize($shape_info['image'], 52, 72);
				} else {
					$image = false;
				}
				$linkurl=$this->url->link('product/newurllogic', $rno . 'newurl='.$category_id.'-'.$gemstone_id .'-'.$metal_id.'-'.$shape_info['shape_id'].'-'.$low_price.'-'.$high_price . $styleurladd);

				$data['shapes'][] = array(
					//'thumb'   	 => HTTP_IMAGE.$shape_info['image'],
					'thumb'   	 => HTTP_IMAGE . $shape_info['image'],
					'name'   	 => $shape_info['description'],
					'shape_id'   	 => $shape_info['shape_id'],
					//'href'  => $this->getMetalSeoKeyWord($metal_info['metal_code'])
					'href'  => $linkurl
				);
			}
		}




						$data['styles'] = array();

						//if( $category_id == 185 or $category_id == 60 ){
						if( $category_id == 185  ){

						switch($style){
							case 194:
								$data['stylename'] = 'Solitaire';
								$data['styleImage'] = HTTP_IMAGE . 'data/styles/Solitaire.png';
							break;
							case 195:
								$data['stylename'] = 'Pave';
								$data['styleImage'] = HTTP_IMAGE . 'data/styles/Pave.png';
							break;
							case 196:
								$data['stylename'] = 'Halo';
								$data['styleImage'] = HTTP_IMAGE . 'data/styles/Halo.png';
							break;
							case 197:
								$data['stylename'] = 'Three Stone';
								$data['styleImage'] = HTTP_IMAGE . 'data/styles/ThreeStone.png';
							break;
							default:
								$data['stylename'] = 'Select Style';
								$data['styleImage'] = HTTP_IMAGE . 'data/styles/Solitaire.png';
							break;
						}

							$data['styles'][] = array(
								'thumb'    => HTTP_IMAGE . 'data/styles/Solitaire.png',
								'name'   	 => 'Solitaire',
								'category_id' => 194,
								//'href'     => $this->url->link('product/newurllogic','newurl=194-'.$gemstone_id .'-'.$metal_id.'-'.$shape_info['shape_id'].'-'.$low_price.'-'.$high_price)
								'href'     => $this->url->link('product/newurllogic', $rno . 'newurl='.$category_id.'-'.$gemstone_id .'-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price . '-194' . $styleurladd)
							);
							$data['styles'][] = array(
								'thumb'    => HTTP_IMAGE . 'data/styles/Pave.png',
								'name'   	 => 'Pave',
								'category_id' => 195,
								//'href'     => $this->url->link('product/newurllogic','newurl=195-'.$gemstone_id .'-'.$metal_id.'-'.$shape_info['shape_id'].'-'.$low_price.'-'.$high_price)
								'href'     => $this->url->link('product/newurllogic', $rno . 'newurl='.$category_id.'-'.$gemstone_id .'-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price . '-195' . $styleurladd)
							);

							$data['styles'][] = array(
								'thumb'    => HTTP_IMAGE . 'data/styles/Halo.png',
								'name'   	 => 'Halo',
								'category_id' => 196,
								//'href'     => $this->url->link('product/newurllogic','newurl=196-'.$gemstone_id .'-'.$metal_id.'-'.$shape_info['shape_id'].'-'.$low_price.'-'.$high_price)
								'href'     => $this->url->link('product/newurllogic', $rno . 'newurl='.$category_id.'-'.$gemstone_id .'-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price . '-196' . $styleurladd)
							);
							$data['styles'][] = array(
								'thumb'    => HTTP_IMAGE . 'data/styles/ThreeStone.png',
								'name'   	 => 'Three stone',
								'category_id' => 197,
								//'href'     => $this->url->link('product/newurllogic','newurl=197-'.$gemstone_id .'-'.$metal_id.'-'.$shape_info['shape_id'].'-'.$low_price.'-'.$high_price)
								//'href'     => $this->url->link('product/newurllogic', $rno . 'newurl='.$category_id.'-'.$gemstone_id .'-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price . '-197' . $styleurladd)
								'href'     => $this->url->link('product/newurllogic', $rno . 'newurl='.$category_id.'-'.$gemstone_id .'-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price . '-197' )
							);

						// } elseif (  $category_id == 205 ) {
						} elseif(strpos( '0,205,199,200,201,202,203' , $category_id) !== false) {


								$query = $this->db->query(" SELECT a.category_id,b.name,a.image FROM category a ,category_description b WHERE a.category_id in ( 199,200,201,202,203 ) and a.category_id = b.category_id ");
								$categorys = $query->rows ;
								foreach ($categorys as $category) {
											if($category['category_id'] == $category_id){
												$data['stylename'] = $category['name'];
												$data['styleImage'] = HTTP_IMAGE . $category['image'];
											}
											$data['styles'][] = array(
													'thumb'    => HTTP_IMAGE . $category['image'],
													'name'   	 => $category['name'] ,
													'category_id' =>  $category['category_id'],
													'href'     => $this->url->link('product/newurllogic', $rno . 'newurl='.$category['category_id'].'-'.$gemstone_id .'-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price . '-1' )
											);
								}

						}else{

								$query = $this->db->query(" SELECT a.category_id,b.name,a.image FROM category a ,category_description b WHERE a.category_id in ( 60,62,59,141,186) and a.category_id = b.category_id ");
								$categorys = $query->rows ;
								foreach ($categorys as $category) {
											if($category['category_id'] == $category_id){
												$data['stylename'] = $category['name'];
												$data['styleImage'] = HTTP_IMAGE . $category['image'];
											}
											$data['styles'][] = array(
													'thumb'    => HTTP_IMAGE . $category['image'],
													'name'   	 => $category['name'] ,
													'category_id' =>  $category['category_id'],
													'href'     => $this->url->link('product/newurllogic', $rno . 'newurl='.$category['category_id'].'-'.$gemstone_id .'-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price . '-1' )
											);
								}

						}

		return $this->load->view('extension/module/gemstone',$data);



		/*if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/gemstone.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/gemstone.tpl';
		} else {
			$this->template = 'default/template/module/gemstone.tpl';
		}

		$this->render();*/
	}
	 public function getMetalsImages() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "metal WHERE BaseMetal=0 ORDER BY sort_order ASC");

		return $query->rows;
	}
	public function getMetalSeoKeyWord($metalname) {
		$query = $this->db->query("SELECT b.keyword as keyword FROM " . DB_PREFIX . "category_description a,url_alias b where a.language_id=1 and a.name='". $metalname ."' and b.query=concat('category_id=',a.category_id)  ");

		return $query->row['keyword'];
	}


	public function getShapesImages() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "shape where enable=1");

		return $query->rows;
	}

	public function getGemstoneImages() {
		$query = $this->db->query("SELECT gemstone_id,image1,gemname,gemdescr FROM " . DB_PREFIX . "gemstone where category_display=0 ORDER BY sort_order ASC");

		return $query->rows;
	}
}
?>
