<?php
class ControllerSaleStocks extends Controller {
	private $error = array();

  	public function index() {
		$this->load->language('sale/order');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/order');

    	$this->getList();
  	}

  	public function update() {
		$this->load->language('sale/order');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/order');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

			// $this->model_sale_order->editOrderStockist($this->request->get['order_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['filter_order_id'])) {
				$url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
			}

			if (isset($this->request->get['filter_customer'])) {
				$url .= '&filter_customer=' . $this->request->get['filter_customer'];
			}

			if (isset($this->request->get['filter_order_status_id'])) {
				$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
			}

			if (isset($this->request->get['filter_total'])) {
				$url .= '&filter_total=' . $this->request->get['filter_total'];
			}

			if (isset($this->request->get['filter_date_added'])) {
				$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
			}

			if (isset($this->request->get['filter_date_modified'])) {
				$url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			if (isset($this->request->get['control'])) {
				$url .= '&control=' . $this->request->get['control'];
			}

			$this->redirect($this->url->link('sale/stocks', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
		}

    	$this->getList();
  	}

  	public function costReady() {
		$this->load->language('sale/order');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/order');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

			$x = $this->model_sale_order->getGemCostingAvailability();
			$x = $this->model_sale_order->getMetalCostingAvailability();
			$x = $this->model_sale_order->updateGemCostingReady();
			$x = $this->model_sale_order->updateMetalCostingReady();

			$this->session->data['success'] = "Success: You have inserted a new order!";

			$url = '';

			if (isset($this->request->get['filter_date'])) {
				$url .= '&filter_total=' . $this->request->get['filter_date'];
			}
			if (isset($this->request->get['filter_product'])) {
				$url .= '&filter_total=' . $this->request->get['filter_product'];
			}

			if (isset($this->request->get['filter_date_to'])) {
				$url .= '&filter_total=' . $this->request->get['filter_date_to'];
			}

			if (isset($this->request->get['control'])) {
				$url .= '&control=' . $this->request->get['control'];
			}

			$this->redirect($this->url->link('sale/stocks', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
		}

    	$this->getList();
  	}
  	public function insert() {
		$this->load->language('sale/order');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/order');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

			if (($this->request->post['InsertUpdateFlag'] == 'Insert') && $this->validateForm()) {
				$this->model_sale_order->insertOrderStockist($this->request->post);
			}else{
				$this->model_sale_order->updateOrderStockist($this->request->post,"","");
			}

			$this->session->data['success'] = "Success: You have inserted a new order!";

			$url = '';

			if (isset($this->request->get['filter_order_id'])) {
				$url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
			}

			if (isset($this->request->get['filter_customer'])) {
				$url .= '&filter_customer=' . $this->request->get['filter_customer'];
			}

			if (isset($this->request->get['filter_order_status_id'])) {
				$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
			}

			if (isset($this->request->get['filter_total'])) {
				$url .= '&filter_total=' . $this->request->get['filter_total'];
			}

			if (isset($this->request->get['filter_date_added'])) {
				$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
			}

			if (isset($this->request->get['filter_date_modified'])) {
				$url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			if (isset($this->request->get['control'])) {
				$url .= '&control=' . $this->request->get['control'];
			}

			$this->redirect($this->url->link('sale/stocks', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
		}

    	$this->getList();
  	}

  	public function updateShipAll() {
		$this->load->language('sale/order');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/order');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

			if (isset($this->request->post['orderids']) && ($this->validateDelete())) {
				foreach ($this->request->post['orderids'] as $order_id) {
					$this->log->write($order_id);
					$this->model_sale_order->updateOrderStockist($this->request->post,$order_id,'ShipNow');
				}
			}
			$this->session->data['success'] = "Success: You have inserted a new order!";

			$url = '';

			if (isset($this->request->get['filter_order_id'])) {
				$url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
			}

			if (isset($this->request->get['filter_customer'])) {
				$url .= '&filter_customer=' . $this->request->get['filter_customer'];
			}

			if (isset($this->request->get['filter_order_status_id'])) {
				$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
			}

			if (isset($this->request->get['filter_total'])) {
				$url .= '&filter_total=' . $this->request->get['filter_total'];
			}

			if (isset($this->request->get['filter_date_added'])) {
				$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
			}

			if (isset($this->request->get['filter_date_modified'])) {
				$url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			if (isset($this->request->get['control'])) {
				$url .= '&control=' . $this->request->get['control'];
			}

			$this->redirect($this->url->link('sale/stocks', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
		}

    	$this->getList();
  	}

  	public function delete() {
		$this->load->language('sale/order');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/order');

    	if (isset($this->request->post['selected']) && ($this->validateDelete())) {
			foreach ($this->request->post['selected'] as $order_id) {
				$this->model_sale_order->deleteOrder($order_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['filter_order_id'])) {
				$url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
			}

			if (isset($this->request->get['filter_customer'])) {
				$url .= '&filter_customer=' . $this->request->get['filter_customer'];
			}

			if (isset($this->request->get['filter_order_status_id'])) {
				$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
			}

			if (isset($this->request->get['filter_total'])) {
				$url .= '&filter_total=' . $this->request->get['filter_total'];
			}

			if (isset($this->request->get['filter_date_added'])) {
				$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
			}

			if (isset($this->request->get['filter_date_modified'])) {
				$url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->redirect($this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
    	}

    	$this->getList();
  	}

  	private function getList() {

		if (isset($this->request->get['filter_order_id'])) {
			$filter_order_id = $this->request->get['filter_order_id'];
		} else {
			$filter_order_id = null;
		}

		if (isset($this->request->get['filter_customer'])) {
			$filter_customer = $this->request->get['filter_customer'];
		} else {
			$filter_customer = null;
		}


		if (isset($this->request->get['filter_total'])) {
			$filter_total = $this->request->get['filter_total'];
		} else {
			$filter_total = null;
		}

		if (isset($this->request->get['filter_date'])) {
			$filter_date = $this->request->get['filter_date'];
		}else{
			if (isset($this->request->post['filter_date'])) {
				$filter_date = $this->request->post['filter_date'];
			} else {
				$filter_date = null;
			}
		}
		if (isset($this->request->get['filter_product'])) {
			$filter_product = $this->request->get['filter_product'];
		}else{
			if (isset($this->request->post['filter_product'])) {
				$filter_product = $this->request->post['filter_product'];
			} else {
				$filter_product = null;
			}
		}
		if (isset($this->request->get['filter_date_to'])) {
			$filter_date_to = $this->request->get['filter_date_to'];
		}else{
			if (isset($this->request->post['filter_date_to'])) {
				$filter_date_to = $this->request->post['filter_date_to'];
			} else {
				$filter_date_to = null;
			}
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'o.order_id';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['filter_order_id'])) {
			$url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
		}

		if (isset($this->request->get['filter_customer'])) {
			$url .= '&filter_customer=' . $this->request->get['filter_customer'];
		}


		if (isset($this->request->get['filter_total'])) {
			$url .= '&filter_total=' . $this->request->get['filter_total'];
		}

		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}
		if (isset($this->request->post['filter_date'])) {
			$url .= '&filter_date=' . $this->request->post['filter_date'];
		}
		if (isset($this->request->post['filter_product'])) {
			$url .= '&filter_product=' . $this->request->post['filter_product'];
		}
		if (isset($this->request->post['filter_date_to'])) {
			$url .= '&filter_date_to=' . $this->request->post['filter_date_to'];
		}


		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$data['breadcrumbs'] = array();

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'user_token=' . $this->session->data['user_token'], 'SSL'),
      		'separator' => false
   		);

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$data['invoice'] = $this->url->link('sale/orderstockist/invoice', 'user_token=' . $this->session->data['user_token'], 'SSL');
		$data['delete'] = $this->url->link('sale/orderstockist/delete', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');

		$data['orders'] = array();

		$RowLimit = 50 ;

			if (isset($this->request->get['control'])){
				if ($this->request->get['control'] == 'shipementHistory') {
					$RowLimit = 200;
				}
			}
		$data = array(
			'filter_order_id'        => $filter_order_id,
			'filter_customer'	     => $filter_customer,
			//'filter_order_status_id' => $filter_order_status_id,
			'filter_total'           => $filter_total,
			//'filter_date_added'      => $filter_date_added,
			'filter_date'     		 => $filter_date,
			'filter_date_to'     		 => $filter_date_to,
			'filter_product'     		 => $filter_product,

			//'filter_date_modified'   => $filter_date_modified,
			'sort'                   => $sort,
			'order'                  => $order,
			'start'                  => ($page - 1) * $RowLimit, //$this->config->get('config_admin_limit'),
			'limit'                  => $RowLimit // $this->config->get('config_admin_limit')
		);

		$gemCodes = $this->model_sale_order->getGemCodes();
		$metalCodes = $this->model_sale_order->geMetalCodes();

		$data['settingCodes'] = $this->model_sale_order->getSettingCodes();
		$data['rhodiumCodes'] = $this->model_sale_order->getRhodiumCodes();
		$data['castingCodes'] = $this->model_sale_order->getCastingCodes();
		$data['platingCodes'] = $this->model_sale_order->getPlatingCodes();

		$data['gemCodes'] = $gemCodes;
		$data['metalCodes'] = $metalCodes;
		$data['gemSizes'] = $this->model_sale_order->getGemSizes();
		$data['gemShapes'] = $this->model_sale_order->getShapes();
		$data['otherCodes'] = $this->model_sale_order->getOtherCostCodes();

		$controlParameter = '';
			if (isset($this->request->get['control'])) {
				$url .= '&control=' . $this->request->get['control'];
				$controlParameter = '&control=' . $this->request->get['control'];

			}
		$data['action'] = $this->url->link('sale/stocks/insert', 'user_token=' . $this->session->data['user_token']  . $url, 'SSL');
		$data['updateShipAll'] = $this->url->link('sale/stocks/updateShipAll', 'user_token=' . $this->session->data['user_token']  . $url, 'SSL');
		$data['costReady'] = $this->url->link('sale/stocks/costReady', 'user_token=' . $this->session->data['user_token']  . $url, 'SSL');
		$data['filter'] = $this->url->link('sale/stocks', 'user_token=' . $this->session->data['user_token']  . $url, 'SSL');

			if (isset($this->request->get['control'])){
				if ($this->request->get['control'] == 'shipement') {
					$results = $this->model_sale_order->getShipments($data);
					$order_total = $this->model_sale_order->getTotalShipments($data);
				}
				if ($this->request->get['control'] == 'shipementHistory') {
					$results = $this->model_sale_order->getShipmentHistory($data);
					$order_total = $this->model_sale_order->getTotalShipmentsHistory($data);
				}
				if ($this->request->get['control'] == 'shipementError') {
					$results = $this->model_sale_order->getShipmentError($data);
					$order_total = $this->model_sale_order->getTotalShipmentsError($data);
				}
			}else{
				$results = $this->model_sale_order->getStocks($data);
				$order_total = $this->model_sale_order->getTotalOrderStockists($data);
			}


    	foreach ($results as $result) {
			$action = array();

			$action[] = array(
				'text' => $this->language->get('text_view'),
				'href' => $this->url->link('sale/orderstockist/update', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'] . $url, 'SSL')
			);

			/*
			Commented out until I can finish the order editing system.
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/order/update', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'] . $url, 'SSL')
			);
			*/
			$gemCode1 = "";$gemCode2 = "";$gemCode3 = "";$gemCode4 = "";$gemCode5 = "";$metalCode2 = "";$metalCode1 = "";
			if($result['M1'] > 0) $metalCode1 = $metalCodes[$this->searchForId($result['M1'] , $metalCodes, 'metal_id')]['metal_code'];
			if($result['M2'] > 0) $metalCode2 = $metalCodes[$this->searchForId($result['M2'] , $metalCodes, 'metal_id')]['metal_code'];
			if($result['G1'] >0) $gemCode1 = $gemCodes[$this->searchForId($result['G1'] , $gemCodes, 'gemstone_id')]['gemcode'];
			if($result['G2'] >0) $gemCode2 = $gemCodes[$this->searchForId($result['G2'] , $gemCodes, 'gemstone_id')]['gemcode'];
			if($result['G3'] >0) $gemCode3 = $gemCodes[$this->searchForId($result['G3'] , $gemCodes, 'gemstone_id')]['gemcode'];
			if($result['G4'] >0) $gemCode4 = $gemCodes[$this->searchForId($result['G4'] , $gemCodes, 'gemstone_id')]['gemcode'];
			if($result['G5'] >0) $gemCode5 = $gemCodes[$this->searchForId($result['G5'] , $gemCodes, 'gemstone_id')]['gemcode'];

			$Rhodium = 0;
			if($result['rhodium_cost_id'] > 0){
				$Rhodium = $result['rhodium_cost_id'] ;
			}else{
				if(isset($result['Defaultrhodium_cost_id'])){
					$Rhodium = $result['Defaultrhodium_cost_id'] ;
				}else{
					$Rhodium = 0;
				}
			}
			$Plating = 0;
			if($result['plating_cost_id'] > 0){
				$Plating = $result['plating_cost_id'] ;
			}else{
				if(isset($result['Defaultplating_cost_id'])){
					$Plating = $result['Defaultplating_cost_id'] ;
				}else{
					$Plating = 0;
				}
			}
			$Setting = 0;
			if($result['setting_cost_id'] > 0){
				$Setting = $result['setting_cost_id'] ;
			}else{
				if(isset($result['Defaultsetting_cost_id'])){
					$Setting = $result['Defaultsetting_cost_id'] ;
				}else{
					$Setting = 0 ;
				}
			}
			$Casting = 0;
			if($result['casting_cost_id'] > 0){
				$Casting = $result['casting_cost_id'] ;
			}else{
				if(isset($result['Defaultcasting_cost_id'])){
					$Setting = $result['Defaultcasting_cost_id'] ;
				}else{
					$Casting = 0 ;
				}
			}
			$FilingPolishing = 0;$DefaultFilingPolishing =0;
			if( isset($result['DefaultFilingPolishing'])) $DefaultFilingPolishing = $result['DefaultFilingPolishing'];
			if($result['FilingPolishing'] > 0){
				$FilingPolishing = $result['FilingPolishing'] ;
			}else{
				$FilingPolishing = $DefaultFilingPolishing ;
			}
			if ( $result['manual_record'] ==1 ) {
				$PrdName = $result['name'] .  $result['descr'] ;
			}else{
				$PrdName = $result['name'];
			}
			$pos = strpos($result['descr'], 'Ring Size');
			if ($pos === false) {
				$RingSize = '';
			}else{
				$RingSize = substr($result['descr'], $pos);
			}

			$data['orders'][] = array(
				'order_id'      => $result['order_id'],
				'customer'      => $result['customer'],
				//'status'        => $result['status'],
				'shipped'   => $result['shipped'],
				'name'   => $PrdName ,
				'RingSize'   => $RingSize ,
				'image'   => $result['image'],
				'manuf_user_Id'   => $result['manuf_user_Id'],
				'M1'   		=> $metalCode1,//$metalCodes[$this->searchForId($result['M1'] , $metalCodes, 'metal_id')]['metal_code'],
				//'M1Wt'  	=> $result['M1Wt'],
				'M1Wt'  	=> $result['M1GrossWt'],
				'M2'  	 	=>  $metalCode2,
				//'M2Wt'   	=> $result['M2Wt'],
				'M2Wt'  	=> $result['M2GrossWt'],

				'G1'   		=> $gemCode1, //$gemCodes[$this->searchForId($result['G1'] , $gemCodes, 'gemstone_id')]['gemcode'],
				'G1Wt'   	=> $result['G1Wt'],
				'G1_NO'   	=> $result['G1#'],
				'G1SizeId'  => $result['G1SizeId'],
				'G1ShapeId'  => $result['G1ShapeId'],
				'G2'   		=> $gemCode2, //$gemCodes[$this->searchForId($result['G2'] , $gemCodes, 'gemstone_id')]['gemcode'],
				'G2Wt'   	=> $result['G2Wt'],
				'G2_NO'   	=> $result['G2#'],
				'G2SizeId'  => $result['G2SizeId'],
				'G2ShapeId'  => $result['G2ShapeId'],
				'G3'   		=> $gemCode3, //$gemCodes[$this->searchForId($result['G3'] , $gemCodes, 'gemstone_id')]['gemcode'],
				'G3Wt'   	=> $result['G3Wt'],
				'G3_NO'   	=> $result['G3#'],
				'G3SizeId'  => $result['G3SizeId'],
				'G3ShapeId'  => $result['G3ShapeId'],
				'G4'   		=> $gemCode4, //$gemCodes[$this->searchForId($result['G4'] , $gemCodes, 'gemstone_id')]['gemcode'],
				'G4Wt'   	=> $result['G4Wt'],
				'G4_NO'   	=> $result['G4#'],
				'G4SizeId'  => $result['G4SizeId'],
				'G4ShapeId'  => $result['G4ShapeId'],
				'G5'   		=> $gemCode5, //$gemCodes[$this->searchForId($result['G5'] , $gemCodes, 'gemstone_id')]['gemcode'],
				'G5Wt'   	=> $result['G5Wt'],
				'G5_NO'   	=> $result['G5#'],
				'G5SizeId'  => $result['G5SizeId'],
				'G5ShapeId'  => $result['G5ShapeId'],
				'G1CostingError'  => $result['G1CostingError'],
				'G2CostingError'  => $result['G2CostingError'],
				'G3CostingError'  => $result['G3CostingError'],
				'G4CostingError'  => $result['G4CostingError'],
				'G5CostingError'  => $result['G5CostingError'],
				'M1CostingError'  => $result['M1CostingError'],
				'M2CostingError'  => $result['M2CostingError'],

				'otherCode'   => $result['other_cost_id'],
				//'Rhodium'   => $result['Rhodium'],
				//'Setting'   => $result['Setting'],
				//'FilingPolishing'   => $result['FilingPolishing'],
				//'Casting'   => $result['Casting'],
				//'Plating'   => $result['Plating'],

				'Setting'   => $Setting,
				'FilingPolishing'   => $FilingPolishing,
				'Rhodium'   => $Rhodium,
				'Casting'   => $Casting,
				'Plating'   => $Plating,
				'ProdComplete'   => $result['ProdComplete'],
				'OrdProdQty'   => $result['OrdProdQty'],

				'OtherCost'   => $result['OtherCost'],
				'ShipQty'   => $result['ShipQty'],

				'ProdShippingDate'   => $result['ProdShippingDate'],

				'shipped'   => $result['shipped'],
				'received'   => $result['received'],
				'descr'   => $result['descr'],
				'comment'   => $result['comment'],
				'total'   => $result['total'],
				//'date_added'   => $result['comment'],
				//'comment'   => $result['comment'],
				//'total'         => $this->currency->format($result['total'], $result['currency_code'], $result['currency_value']),
				'date_added'    => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
				//'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
				'selected'      => isset($this->request->post['selected']) && in_array($result['order_id'], $this->request->post['selected']),

				'action'        => $action
			);
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_abandoned_orders'] = $this->language->get('text_abandoned_orders');

		$data['column_order_id'] = $this->language->get('column_order_id');
    	$data['column_customer'] = $this->language->get('column_customer');
		$data['column_status'] = $this->language->get('column_status');
		$data['column_total'] = $this->language->get('column_total');
		$data['column_date_added'] = $this->language->get('column_date_added');
		$data['column_date_modified'] = $this->language->get('column_date_modified');
		$data['column_action'] = $this->language->get('column_action');

		$data['button_invoice'] = $this->language->get('button_invoice');
		$data['button_delete'] = $this->language->get('button_delete');
		$data['button_filter'] = $this->language->get('button_filter');

		$data['user_token'] = $this->session->data['user_token'];

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		$url = '';

		if (isset($this->request->get['filter_order_id'])) {
			$url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
		}

		if (isset($this->request->get['filter_customer'])) {
			$url .= '&filter_customer=' . $this->request->get['filter_customer'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_total'])) {
			$url .= '&filter_total=' . $this->request->get['filter_total'];
		}

		if (isset($this->request->get['filter_date'])) {
			$url .= '&filter_date=' . $this->request->get['filter_date'];
		}
		if (isset($this->request->get['filter_product'])) {
			$url .= '&filter_product=' . $this->request->get['filter_product'];
		}
		if (isset($this->request->get['filter_date_to'])) {
			$url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
		}

		if (isset($this->request->get['filter_date_modified'])) {
			$url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
		}

		if ($order == 'ASC') {
			$url .= '&order=' .  'DESC';
		} else {
			$url .= '&order=' .  'ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_order'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.order_id' . $url, 'SSL');
		$data['sort_customer'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=customer' . $url, 'SSL');
		$data['sort_status'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, 'SSL');
		$data['sort_total'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.total' . $url, 'SSL');
		$data['sort_date_added'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.date_added' . $url, 'SSL');
		$data['sort_date_modified'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.date_modified' . $url, 'SSL');

		$url = '';

		if (isset($this->request->get['filter_order_id'])) {
			$url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
		}

		if (isset($this->request->get['filter_customer'])) {
			$url .= '&filter_customer=' . $this->request->get['filter_customer'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_total'])) {
			$url .= '&filter_total=' . $this->request->get['filter_total'];
		}

		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}

		if (isset($this->request->get['filter_date_modified'])) {
			$url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $order_total;
		$pagination->page = $page;
		$pagination->limit = $RowLimit; //$this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');

		$filterDate = '';
		if (isset($this->request->get['filter_date'])) {
			$filterDate = '&filter_date=' . $this->request->get['filter_date'];
		}
		if (isset($this->request->get['filter_product'])) {
			$filterDate = '&filter_product=' . $this->request->get['filter_product'];
		}
		if (isset($this->request->get['filter_date_to'])) {
			$filterDate .= '&filter_date_to=' . $this->request->get['filter_date_to'];
		}
		$pagination->url = $this->url->link('sale/stocks', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}' . $controlParameter . $filterDate, 'SSL');

		$data['pagination'] = $pagination->render();

		$data['filter_order_id'] = $filter_order_id;
		$data['filter_customer'] = $filter_customer;
		//$data['filter_order_status_id'] = $filter_order_status_id;
		$data['filter_total'] = $filter_total;
		//$data['filter_date_added'] = $filter_date_added;
		$data['filter_date'] = $filter_date;
		$data['filter_product'] = $filter_product;

		$data['filter_date_to'] = $filter_date_to;

		//$data['filter_date_modified'] = $filter_date_modified;

		$this->load->model('localisation/order_status');

    	$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		$data['text_none'] = $this->language->get('text_none');

		$data['sort'] = $sort;
		$data['order'] = $order;


		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

			if (isset($this->request->get['control'])){
				if ($this->request->get['control'] == 'shipement') {
					//$this->template = 'sale/shipment_list.tpl';
					$this->response->setOutput($this->load->view('sale/shipment_list', $data));
				}
				if ($this->request->get['control'] == 'shipementHistory') {
					//$this->template = 'sale/shipment_history.tpl';
					$this->response->setOutput($this->load->view('sale/shipment_history', $data));
				}
				if ($this->request->get['control'] == 'shipementError') {
					//$this->template = 'sale/shipment_error.tpl';
					$this->response->setOutput($this->load->view('sale/shipment_error', $data));
				}
			}else{
				// $this->template = 'sale/stocks_list.tpl';
				$this->response->setOutput($this->load->view('sale/stocks_list', $data));

			}

			/*
		// $this->template = 'sale/stocks_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render());
		*/


  }

	function searchForId($id, $array, $keyField) {
		foreach ($array as $key => $val) {
			if ($val[$keyField] === $id) {
				return $key;
			}
		}
		return null;
	}

  	public function getForm() {
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_default'] = $this->language->get('text_default');
		$data['text_select'] = $this->language->get('text_select');
		$data['text_none'] = $this->language->get('text_none');
		$data['text_wait'] = $this->language->get('text_wait');

		$data['entry_store'] = $this->language->get('entry_store');
		$data['entry_customer'] = $this->language->get('entry_customer');
		$data['entry_customer_group'] = $this->language->get('entry_customer_group');
		$data['entry_firstname'] = $this->language->get('entry_firstname');
		$data['entry_lastname'] = $this->language->get('entry_lastname');
		$data['entry_email'] = $this->language->get('entry_email');
		$data['entry_telephone'] = $this->language->get('entry_telephone');
		$data['entry_fax'] = $this->language->get('entry_fax');
		$data['entry_order_status'] = $this->language->get('entry_order_status');
		$data['entry_comment'] = $this->language->get('entry_comment');
		$data['entry_affiliate'] = $this->language->get('entry_affiliate');
		$data['entry_address'] = $this->language->get('entry_address');
		$data['entry_company'] = $this->language->get('entry_company');
		$data['entry_address_1'] = $this->language->get('entry_address_1');
		$data['entry_address_2'] = $this->language->get('entry_address_2');
		$data['entry_city'] = $this->language->get('entry_city');
		$data['entry_postcode'] = $this->language->get('entry_postcode');
		$data['entry_zone'] = $this->language->get('entry_zone');
		$data['entry_zone_code'] = $this->language->get('entry_zone_code');
		$data['entry_country'] = $this->language->get('entry_country');
		$data['entry_product'] = $this->language->get('entry_product');
		$data['entry_option'] = $this->language->get('entry_option');
		$data['entry_quantity'] = $this->language->get('entry_quantity');
		$data['entry_shipping'] = $this->language->get('entry_shipping');
		$data['entry_payment'] = $this->language->get('entry_payment');
		$data['entry_voucher'] = $this->language->get('entry_voucher');
		$data['entry_reward'] = $this->language->get('entry_reward');

		$data['column_product'] = $this->language->get('column_product');
		$data['column_model'] = $this->language->get('column_model');
		$data['column_quantity'] = $this->language->get('column_quantity');
		$data['column_price'] = $this->language->get('column_price');
		$data['column_total'] = $this->language->get('column_total');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		$data['button_add_product'] = $this->language->get('button_add_product');
		$data['button_remove'] = $this->language->get('button_remove');
		$data['button_upload'] = $this->language->get('button_upload');

		$data['tab_order'] = $this->language->get('tab_order');
		$data['tab_payment'] = $this->language->get('tab_payment');
		$data['tab_shipping'] = $this->language->get('tab_shipping');
		$data['tab_product'] = $this->language->get('tab_product');
		$data['tab_total'] = $this->language->get('tab_total');

		$data['user_token'] = $this->session->data['user_token'];


		$url = '';

		if (isset($this->request->get['filter_order_id'])) {
			$url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
		}

		if (isset($this->request->get['filter_customer'])) {
			$url .= '&filter_customer=' . $this->request->get['filter_customer'];
		}

		if (isset($this->request->get['filter_total'])) {
			$url .= '&filter_total=' . $this->request->get['filter_total'];
		}

		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'user_token=' . $this->session->data['user_token'], 'SSL'),
			'separator' => false
		);

		$data['breadcrumbs'][] = array(
			'text'      => $this->language->get('heading_title') . ' Stockist',
			'href'      => $this->url->link('sale/orderstockist', 'user_token=' . $this->session->data['user_token'], 'SSL'),
			'separator' => ' :: '
		);

		if (!isset($this->request->get['order_id'])) {
			$data['action'] = $this->url->link('sale/orderstockist/insert', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
		} else {
			$data['action'] = $this->url->link('sale/orderstockist/update', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $this->request->get['order_id'] . $url, 'SSL');
		}

		$data['cancel'] = $this->url->link('sale/orderstockist', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');

    	if (isset($this->request->get['order_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$order_info = $this->model_sale_order->getOrderStockist($this->request->get['order_id']);
    	}


		if (isset($this->request->post['customer_id'])) {
			$data['customer_id'] = $this->request->post['customer_id'];
		} elseif (!empty($order_info)) {
			$data['customer_id'] = $order_info['customer_id'];
		} else {
			$data['customer_id'] = '';
		}

		if (isset($this->request->post['customer'])) {
			$data['customer'] = $this->request->post['customer'];
		} elseif (!empty($order_info)) {
			$data['customer'] = $order_info['customer'];
		} else {
			$data['customer'] = '';
		}

		if (isset($this->request->post['product_id'])) {
			$data['product_id'] = $this->request->post['product_id'];
		} elseif (!empty($order_info)) {
			$data['product_id'] = $order_info['product_id'];
		} else {
			$data['product_id'] = '';
		}
		if (isset($this->request->post['order_id'])) {
			$data['order_id'] = $this->request->post['order_id'];
		} elseif (!empty($order_info)) {
			$data['order_id'] = $order_info['order_id'];
		} else {
			$data['order_id'] = '';
		}

    	if (isset($this->request->post['descr'])) {
      		$data['descr'] = $this->request->post['descr'];
    	} elseif (!empty($order_info)) {
			$data['descr'] = $order_info['descr'];
		} else {
      		$data['descr'] = '';
    	}

    	if (isset($this->request->post['comment'])) {
      		$data['comment'] = $this->request->post['comment'];
    	} elseif (!empty($order_info)) {
			$data['comment'] = $order_info['comment'];
		} else {
      		$data['comment'] = '';
    	}

    	if (isset($this->request->post['shipped'])) {
      		$data['shipped'] = $this->request->post['shipped'];
    	} elseif (!empty($order_info)) {
			$data['shipped'] = $order_info['shipped'];
		} else {
      		$data['shipped'] = '';
    	}

    	if (isset($this->request->post['received'])) {
      		$data['received'] = $this->request->post['received'];
    	} elseif (!empty($order_info)) {
			$data['received'] = $order_info['received'];
		} else {
      		$data['received'] = '';
    	}

    	if (isset($this->request->post['comment'])) {
      		$data['comment'] = $this->request->post['comment'];
    	} elseif (!empty($order_info)) {
			$data['comment'] = $order_info['comment'];
		} else {
      		$data['comment'] = '';
    	}

    	if (isset($this->request->post['comment2'])) {
      		$data['comment2'] = $this->request->post['comment2'];
    	} elseif (!empty($order_info)) {
			$data['comment2'] = $order_info['comment2'];
		} else {
      		$data['comment2'] = '';
    	}

		if (isset($this->request->post['AJ_price'])) {
      		$data['AJ_price'] = $this->request->post['AJ_price'];
    	} elseif (!empty($order_info)) {
			$data['AJ_price'] = $order_info['total'];
		} else {
      		$data['AJ_price'] = array();
    	}

		if (isset($this->request->post['date_added'])) {
      		$data['date_added'] = $this->request->post['date_added'];
    	} elseif (!empty($order_info)) {
			$data['date_added'] = $order_info['date_added'];
		} else {
      		$data['date_added'] = array();
    	}

		$data['action'] =  $this->url->link('sale/orderstockist/update', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $this->request->get['order_id'] , 'SSL');


				$data['header'] = $this->load->controller('common/header');
				$data['column_left'] = $this->load->controller('common/column_left');
				$data['footer'] = $this->load->controller('common/footer');
				$this->response->setOutput($this->load->view('sale/orderstockist_form', $data));

		/*		$this->template = 'sale/orderstockist_form.tpl';

		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
		*/
	}

	public function info() {
		$this->load->model('sale/order');

		if (isset($this->request->get['order_id'])) {
			$order_id = $this->request->get['order_id'];
		} else {
			$order_id = 0;
		}

		$order_info = $this->model_sale_order->getOrder($order_id);

		if ($order_info) {
			$this->load->language('sale/order');

			$this->document->setTitle($this->language->get('heading_title'));

			$data['heading_title'] = $this->language->get('heading_title');

			$data['text_order_id'] = $this->language->get('text_order_id');
			$data['text_invoice_no'] = $this->language->get('text_invoice_no');
			$data['text_invoice_date'] = $this->language->get('text_invoice_date');
			$data['text_store_name'] = $this->language->get('text_store_name');
			$data['text_store_url'] = $this->language->get('text_store_url');
			$data['text_customer'] = $this->language->get('text_customer');
			$data['text_customer_group'] = $this->language->get('text_customer_group');
			$data['text_email'] = $this->language->get('text_email');
			$data['text_ip'] = $this->language->get('text_ip');
			$data['text_telephone'] = $this->language->get('text_telephone');
			$data['text_fax'] = $this->language->get('text_fax');
			$data['text_total'] = $this->language->get('text_total');
			$data['text_reward'] = $this->language->get('text_reward');
			$data['text_order_status'] = $this->language->get('text_order_status');
			$data['text_comment'] = $this->language->get('text_comment');
			$data['text_affiliate'] = $this->language->get('text_affiliate');
			$data['text_commission'] = $this->language->get('text_commission');
			$data['text_date_added'] = $this->language->get('text_date_added');
			$data['text_date_modified'] = $this->language->get('text_date_modified');
			$data['text_firstname'] = $this->language->get('text_firstname');
			$data['text_lastname'] = $this->language->get('text_lastname');
			$data['text_company'] = $this->language->get('text_company');
			$data['text_address_1'] = $this->language->get('text_address_1');
			$data['text_address_2'] = $this->language->get('text_address_2');
			$data['text_city'] = $this->language->get('text_city');
			$data['text_postcode'] = $this->language->get('text_postcode');
			$data['text_zone'] = $this->language->get('text_zone');
			$data['text_zone_code'] = $this->language->get('text_zone_code');
			$data['text_country'] = $this->language->get('text_country');
			$data['text_shipping_method'] = $this->language->get('text_shipping_method');
			$data['text_payment_method'] = $this->language->get('text_payment_method');
			$data['text_download'] = $this->language->get('text_download');
			$data['text_wait'] = $this->language->get('text_wait');
			$data['text_create_invoice_no'] = $this->language->get('text_create_invoice_no');
			$data['text_reward_add'] = $this->language->get('text_reward_add');
			$data['text_reward_remove'] = $this->language->get('text_reward_remove');
			$data['text_commission_add'] = $this->language->get('text_commission_add');
			$data['text_commission_remove'] = $this->language->get('text_commission_remove');
			$data['text_credit_add'] = $this->language->get('text_credit_add');
			$data['text_credit_remove'] = $this->language->get('text_credit_remove');

			$data['column_product'] = $this->language->get('column_product');
			$data['column_model'] = $this->language->get('column_model');
			$data['column_quantity'] = $this->language->get('column_quantity');
			$data['column_price'] = $this->language->get('column_price');
			$data['column_total'] = $this->language->get('column_total');
			$data['column_download'] = $this->language->get('column_download');
			$data['column_filename'] = $this->language->get('column_filename');
			$data['column_remaining'] = $this->language->get('column_remaining');

			$data['entry_order_status'] = $this->language->get('entry_order_status');
			$data['entry_notify'] = $this->language->get('entry_notify');
			$data['entry_comment'] = $this->language->get('entry_comment');

			$data['button_invoice'] = $this->language->get('button_invoice');
			$data['button_cancel'] = $this->language->get('button_cancel');
			$data['button_add_history'] = $this->language->get('button_add_history');

			$data['tab_order'] = $this->language->get('tab_order');
			$data['tab_payment'] = $this->language->get('tab_payment');
			$data['tab_shipping'] = $this->language->get('tab_shipping');
			$data['tab_product'] = $this->language->get('tab_product');
			$data['tab_order_history'] = $this->language->get('tab_order_history');

			$data['user_token'] = $this->session->data['user_token'];

			$url = '';

			if (isset($this->request->get['filter_order_id'])) {
				$url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
			}

			if (isset($this->request->get['filter_customer'])) {
				$url .= '&filter_customer=' . $this->request->get['filter_customer'];
			}

			if (isset($this->request->get['filter_order_status_id'])) {
				$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
			}

			if (isset($this->request->get['filter_total'])) {
				$url .= '&filter_total=' . $this->request->get['filter_total'];
			}

			if (isset($this->request->get['filter_date_added'])) {
				$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
			}

			if (isset($this->request->get['filter_date_modified'])) {
				$url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$data['breadcrumbs'] = array();

			$data['breadcrumbs'][] = array(
				'text'      => $this->language->get('text_home'),
				'href'      => $this->url->link('common/home', 'user_token=' . $this->session->data['user_token'], 'SSL'),
				'separator' => false
			);

			$data['breadcrumbs'][] = array(
				'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'], 'SSL'),
				'separator' => ' :: '
			);

			$data['invoice'] = $this->url->link('sale/order/invoice', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int)$this->request->get['order_id'], 'SSL');
			$data['cancel'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');

			$data['order_id'] = $this->request->get['order_id'];

			if ($order_info['invoice_no']) {
				$data['invoice_no'] = $order_info['invoice_prefix'] . $order_info['invoice_no'];
			} else {
				$data['invoice_no'] = '';
			}

			$data['store_name'] = $order_info['store_name'];
			$data['store_url'] = $order_info['store_url'];
			$data['firstname'] = $order_info['firstname'];
			$data['lastname'] = $order_info['lastname'];

			if ($order_info['customer_id']) {
				$data['customer'] = $this->url->link('sale/customer/update', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $order_info['customer_id'], 'SSL');
			} else {
				$data['customer'] = '';
			}

			$this->load->model('sale/customer_group');

			$customer_group_info = $this->model_sale_customer_group->getCustomerGroup($order_info['customer_group_id']);

			if ($customer_group_info) {
				$data['customer_group'] = $customer_group_info['name'];
			} else {
				$data['customer_group'] = '';
			}

			$data['email'] = $order_info['email'];
			$data['ip'] = $order_info['ip'];
			$data['telephone'] = $order_info['telephone'];
			$data['fax'] = $order_info['fax'];
			$data['comment'] = nl2br($order_info['comment']);
			$data['shipping_method'] = $order_info['shipping_method'];
			$data['payment_method'] = $order_info['payment_method'];
			$data['total'] = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']);
			$data['reward'] = $order_info['reward'];

			if ($order_info['total'] < 0) {
				$data['credit'] = $order_info['total'];
			} else {
				$data['credit'] = 0;
			}

			$this->load->model('sale/customer');

			$data['credit_total'] = $this->model_sale_customer->getTotalTransactionsByOrderId($this->request->get['order_id']);

			$data['reward_total'] = $this->model_sale_customer->getTotalCustomerRewardsByOrderId($this->request->get['order_id']);

			$data['affiliate_firstname'] = $order_info['affiliate_firstname'];
			$data['affiliate_lastname'] = $order_info['affiliate_lastname'];

			if ($order_info['affiliate_id']) {
				$data['affiliate'] = $this->url->link('sale/affiliate/update', 'user_token=' . $this->session->data['user_token'] . '&affiliate_id=' . $order_info['affiliate_id'], 'SSL');
			} else {
				$data['affiliate'] = '';
			}

			$data['commission'] = $this->currency->format($order_info['commission'], $order_info['currency_code'], $order_info['currency_value']);

			$this->load->model('sale/affiliate');

			$data['commission_total'] = $this->model_sale_affiliate->getTotalTransactionsByOrderId($this->request->get['order_id']);

			$this->load->model('localisation/order_status');

			$order_status_info = $this->model_localisation_order_status->getOrderStatus($order_info['order_status_id']);

			if ($order_status_info) {
				$data['order_status'] = $order_status_info['name'];
			} else {
				$data['order_status'] = '';
			}

			$data['date_added'] = date($this->language->get('date_format_short'), strtotime($order_info['date_added']));
			$data['date_modified'] = date($this->language->get('date_format_short'), strtotime($order_info['date_modified']));

			$data['payment_firstname'] = $order_info['payment_firstname'];
			$data['payment_lastname'] = $order_info['payment_lastname'];
			$data['payment_company'] = $order_info['payment_company'];
			$data['payment_address_1'] = $order_info['payment_address_1'];
			$data['payment_address_2'] = $order_info['payment_address_2'];
			$data['payment_city'] = $order_info['payment_city'];
			$data['payment_postcode'] = $order_info['payment_postcode'];
			$data['payment_zone'] = $order_info['payment_zone'];
			$data['payment_zone_code'] = $order_info['payment_zone_code'];
			$data['payment_country'] = $order_info['payment_country'];
			$data['shipping_firstname'] = $order_info['shipping_firstname'];
			$data['shipping_lastname'] = $order_info['shipping_lastname'];
			$data['shipping_company'] = $order_info['shipping_company'];
			$data['shipping_address_1'] = $order_info['shipping_address_1'];
			$data['shipping_address_2'] = $order_info['shipping_address_2'];
			$data['shipping_city'] = $order_info['shipping_city'];
			$data['shipping_postcode'] = $order_info['shipping_postcode'];
			$data['shipping_zone'] = $order_info['shipping_zone'];
			$data['shipping_zone_code'] = $order_info['shipping_zone_code'];
			$data['shipping_country'] = $order_info['shipping_country'];

			$data['products'] = array();

			$products = $this->model_sale_order->getOrderProducts($this->request->get['order_id']);

			foreach ($products as $product) {
				$option_data = array();

				$options = $this->model_sale_order->getOrderOptions($this->request->get['order_id'], $product['order_product_id']);
				$svgContents = $this->model_sale_order->getOrderSVG(  $product['product_id']);

				foreach ($options as $option) {
					if ($option['type'] != 'file') {
						$option_data[] = array(
							'name'  => $option['name'],
							'value' => $option['value'],
							'type'  => $option['type']
						);
					} else {
						$option_data[] = array(
							'name'  => $option['name'],
							'value' => utf8_substr($option['value'], 0, strrpos($option['value'], '.')),
							'type'  => $option['type'],
							'href'  => $this->url->link('sale/order/download', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $this->request->get['order_id'] . '&order_option_id=' . $option['order_option_id'], 'SSL')
						);
					}
				}
				if($product['ringsize']==''){
					$ringsize='';
				}else{
					$ringsize= '<br>Ring Size : ' . $product['ringsize'] .'('. $product['country'] . ')' ;
				}
				$imagerea = $this->model_sale_order->getImagefromProduct($product['product_id']);

				$this->load->model('tool/image');
				$imagereaimg = $this->model_tool_image->resize($imagerea, 200,200);


				$optionname=str_replace("\n","<br/>",$this->model_sale_order->getProductOptionName($product['product_id']));
				$data['products'][] = array(
					'order_product_id' => $product['order_product_id'],
					'product_id'       => $product['product_id'],
					'name'    	 	   => $product['name'],
					'optionname'       => $optionname.$ringsize,
					'svgContents'       => $svgContents,
					'ringsize' 		   => $ringsize,
					'engravetxt' 		   => $product['engravetxt'],
					'engravefont' 		   => $product['engravefont'],
					'imagerea'         => $imagerea,
					'imagereaimg'         => $imagereaimg,
					'model'    		   => $product['model'],
					'option'   		   => $option_data,
					'quantity'		   => $product['quantity'],
					'country'		   => $product['country'],
					'parent_price'     => $this->currency->format($product['parent_price'], $order_info['currency_code'], $order_info['currency_value']),
					'ringsize'		   => $product['ringsize'],
					'price'    		   => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
					'total'    		   => $this->currency->format($product['total'], $order_info['currency_code'], $order_info['currency_value']),
					'href'     		   => $this->url->link('catalog/product/update', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $product['product_id'], 'SSL')
				);
			}

			$data['totals'] = $this->model_sale_order->getOrderTotals($this->request->get['order_id']);

			$data['downloads'] = array();

			$results = $this->model_sale_order->getOrderDownloads($this->request->get['order_id']);

			foreach ($results as $result) {
				$data['downloads'][] = array(
					'name'      => $result['name'],
					'filename'  => $result['mask'],
					'remaining' => $result['remaining']
				);
			}

			$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

			$data['order_status_id'] = $order_info['order_status_id'];


					$data['header'] = $this->load->controller('common/header');
					$data['column_left'] = $this->load->controller('common/column_left');
					$data['footer'] = $this->load->controller('common/footer');
					$this->response->setOutput($this->load->view('sale/order_info', $data));
			/*
			$this->template = 'sale/order_info.tpl';

			$this->children = array(
				'common/header',
				'common/footer'
			);

			$this->response->setOutput($this->render());
			*/

		} else {
			$this->load->language('error/not_found');

			$this->document->setTitle($this->language->get('heading_title'));

			$data['heading_title'] = $this->language->get('heading_title');

			$data['text_not_found'] = $this->language->get('text_not_found');

			$data['breadcrumbs'] = array();

			$data['breadcrumbs'][] = array(
				'text'      => $this->language->get('text_home'),
				'href'      => $this->url->link('common/home', 'user_token=' . $this->session->data['user_token'], 'SSL'),
				'separator' => false
			);

			$data['breadcrumbs'][] = array(
				'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], 'SSL'),
				'separator' => ' :: '
			);
			/*
			$this->template = 'error/not_found.tpl';
			$this->children = array(
				'common/header',
				'common/footer'
			);

			$this->response->setOutput($this->render());
			*/
								$data['header'] = $this->load->controller('common/header');
								$data['column_left'] = $this->load->controller('common/column_left');
								$data['footer'] = $this->load->controller('common/footer');
								$this->response->setOutput($this->load->view('error/not_found', $data));
		}
	}

  	private function validateForm() {

		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}

   	private function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'sale/order')) {
			$this->error['warning'] = $this->language->get('error_permission');
    	}

		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}

	public function zone() {
		$output = '<option value="">' . $this->language->get('text_select') . '</option>';

		$this->load->model('localisation/zone');

		$results = $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']);

		foreach ($results as $result) {
			$output .= '<option value="' . $result['zone_id'] . '"';

			if (isset($this->request->get['zone_id']) && ($this->request->get['zone_id'] == $result['zone_id'])) {
				$output .= ' selected="selected"';
			}

			$output .= '>' . $result['name'] . '</option>';
		}

		if (!$results) {
			$output .= '<option value="0">' . $this->language->get('text_none') . '</option>';
		}

		$this->response->setOutput($output);
	}

	public function createInvoiceNo() {
		$this->language->load('sale/order');

		$json = array();

     	if (!$this->user->hasPermission('modify', 'sale/order')) {
      		$json['error'] = $this->language->get('error_permission');
		} elseif (isset($this->request->get['order_id'])) {
			$this->load->model('sale/order');
			$invoice_no = $this->model_sale_order->createInvoiceNo($this->request->get['order_id']);

			if ($invoice_no) {
				$json['invoice_no'] = $invoice_no;
			} else {
				$json['error'] = $this->language->get('error_action');
			}
		}

		$this->response->setOutput(json_encode($json));
  	}

	public function addCredit() {
		$this->language->load('sale/order');

		$json = array();

     	if (!$this->user->hasPermission('modify', 'sale/order')) {
      		$json['error'] = $this->language->get('error_permission');
    	} elseif (isset($this->request->get['order_id'])) {
			$this->load->model('sale/order');

			$order_info = $this->model_sale_order->getOrder($this->request->get['order_id']);

			if ($order_info && $order_info['customer_id']) {
				$this->load->model('sale/customer');

				$credit_total = $this->model_sale_customer->getTotalTransactionsByOrderId($this->request->get['order_id']);

				if (!$credit_total) {
					$this->model_sale_customer->addTransaction($order_info['customer_id'], $this->language->get('text_order_id') . ' #' . $this->request->get['order_id'], $order_info['total'], $this->request->get['order_id']);

					$json['success'] = $this->language->get('text_credit_added');
				} else {
					$json['error'] = $this->language->get('error_action');
				}
			}
		}

		$this->response->setOutput(json_encode($json));
  	}

	public function removeCredit() {
		$this->language->load('sale/order');

		$json = array();

     	if (!$this->user->hasPermission('modify', 'sale/order')) {
      		$json['error'] = $this->language->get('error_permission');
    	} elseif (isset($this->request->get['order_id'])) {
			$this->load->model('sale/order');

			$order_info = $this->model_sale_order->getOrder($this->request->get['order_id']);

			if ($order_info && $order_info['customer_id']) {
				$this->load->model('sale/customer');

				$this->model_sale_customer->deleteTransaction($this->request->get['order_id']);

				$json['success'] = $this->language->get('text_credit_removed');
			} else {
				$json['error'] = $this->language->get('error_action');
			}
		}

		$this->response->setOutput(json_encode($json));
  	}

	public function addReward() {
		$this->language->load('sale/order');

		$json = array();

     	if (!$this->user->hasPermission('modify', 'sale/order')) {
      		$json['error'] = $this->language->get('error_permission');
    	} elseif (isset($this->request->get['order_id'])) {
			$this->load->model('sale/order');

			$order_info = $this->model_sale_order->getOrder($this->request->get['order_id']);

			if ($order_info && $order_info['customer_id']) {
				$this->load->model('sale/customer');

				$reward_total = $this->model_sale_customer->getTotalCustomerRewardsByOrderId($this->request->get['order_id']);

				if (!$reward_total) {
					$this->model_sale_customer->addReward($order_info['customer_id'], $this->language->get('text_order_id') . ' #' . $this->request->get['order_id'], $order_info['reward'], $this->request->get['order_id']);

					$json['success'] = $this->language->get('text_reward_added');
				} else {
					$json['error'] = $this->language->get('error_action');
				}
			} else {
				$json['error'] = $this->language->get('error_action');
			}
		}

		$this->response->setOutput(json_encode($json));
  	}

	public function removeReward() {
		$this->language->load('sale/order');

		$json = array();

     	if (!$this->user->hasPermission('modify', 'sale/order')) {
      		$json['error'] = $this->language->get('error_permission');
    	} elseif (isset($this->request->get['order_id'])) {
			$this->load->model('sale/order');

			$order_info = $this->model_sale_order->getOrder($this->request->get['order_id']);

			if ($order_info && $order_info['customer_id']) {
				$this->load->model('sale/customer');

				$this->model_sale_customer->deleteReward($this->request->get['order_id']);

				$json['success'] = $this->language->get('text_reward_removed');
			} else {
				$json['error'] = $this->language->get('error_action');
			}
		}

		$this->response->setOutput(json_encode($json));
  	}

	public function addCommission() {
		$this->language->load('sale/order');

		$json = array();

     	if (!$this->user->hasPermission('modify', 'sale/order')) {
      		$json['error'] = $this->language->get('error_permission');
    	} elseif (isset($this->request->get['order_id'])) {
			$this->load->model('sale/order');

			$order_info = $this->model_sale_order->getOrder($this->request->get['order_id']);

			if ($order_info && $order_info['affiliate_id']) {
				$this->load->model('sale/affiliate');

				$affiliate_total = $this->model_sale_affiliate->getTotalTransactionsByOrderId($this->request->get['order_id']);

				if (!$affiliate_total) {
					$this->model_sale_affiliate->addTransaction($order_info['affiliate_id'], $this->language->get('text_order_id') . ' #' . $this->request->get['order_id'], $order_info['commission'], $this->request->get['order_id']);

					$json['success'] = $this->language->get('text_commission_added');
				} else {
					$json['error'] = $this->language->get('error_action');
				}
			} else {
				$json['error'] = $this->language->get('error_action');
			}
		}

		$this->response->setOutput(json_encode($json));
  	}

	public function removeCommission() {
		$this->language->load('sale/order');

		$json = array();

     	if (!$this->user->hasPermission('modify', 'sale/order')) {
      		$json['error'] = $this->language->get('error_permission');
    	} elseif (isset($this->request->get['order_id'])) {
			$this->load->model('sale/order');

			$order_info = $this->model_sale_order->getOrder($this->request->get['order_id']);

			if ($order_info && $order_info['affiliate_id']) {
				$this->load->model('sale/affiliate');

				$this->model_sale_affiliate->deleteTransaction($this->request->get['order_id']);

				$json['success'] = $this->language->get('text_commission_removed');
			} else {
				$json['error'] = $this->language->get('error_action');
			}
		}

		$this->response->setOutput(json_encode($json));
  	}

	public function history() {
    	$this->language->load('sale/order');

		$this->load->model('sale/order');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->user->hasPermission('modify', 'sale/order')) {
			$this->model_sale_order->addOrderHistory($this->request->get['order_id'], $this->request->post);

			$data['success'] = $this->language->get('text_success');
		} else {
			$data['success'] = '';
		}

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && !$this->user->hasPermission('modify', 'sale/order')) {
			$data['error_warning'] = $this->language->get('error_permission');
		} else {
			$data['error_warning'] = '';
		}

		$data['text_no_results'] = $this->language->get('text_no_results');

		$data['column_date_added'] = $this->language->get('column_date_added');
		$data['column_status'] = $this->language->get('column_status');
		$data['column_notify'] = $this->language->get('column_notify');
		$data['column_comment'] = $this->language->get('column_comment');

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$data['loggedUser'] = $this->user->isLogged();
		$data['histories'] = array();

		$results = $this->model_sale_order->getOrderHistories($this->request->get['order_id'], ($page - 1) * 10, 10);

		foreach ($results as $result) {
        	$data['histories'][] = array(
				'notify'     => $result['notify'] ? $this->language->get('text_yes') : $this->language->get('text_no'),
				'status'     => $result['status'],
				'comment'    => nl2br($result['comment']),
        		'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
        	);
      	}

		$history_total = $this->model_sale_order->getTotalOrderHistories($this->request->get['order_id']);

		$pagination = new Pagination();
		$pagination->total = $history_total;
		$pagination->page = $page;
		$pagination->limit = 10;
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/order/history', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $this->request->get['order_id'] . '&page={page}', 'SSL');

		$data['pagination'] = $pagination->render();
		/*
		$this->template = 'sale/order_history.tpl';

		$this->response->setOutput($this->render());
		*/

							$data['header'] = $this->load->controller('common/header');
							$data['column_left'] = $this->load->controller('common/column_left');
							$data['footer'] = $this->load->controller('common/footer');
							$this->response->setOutput($this->load->view('sale/order_history', $data));
	}

	public function download() {
		$this->load->model('sale/order');

		if (isset($this->request->get['order_option_id'])) {
			$order_option_id = $this->request->get['order_option_id'];
		} else {
			$order_option_id = 0;
		}

		$option_info = $this->model_sale_order->getOrderOption($this->request->get['order_id'], $order_option_id);

		if ($option_info && $option_info['type'] == 'file') {
			$file = DIR_DOWNLOAD . $option_info['value'];
			$mask = basename(utf8_substr($option_info['value'], 0, strrpos($option_info['value'], '.')));

			if (!headers_sent()) {
				if (file_exists($file)) {
					header('Content-Description: File Transfer');
					header('Content-Type: application/octet-stream');
					header('Content-Disposition: attachment; filename="' . ($mask ? $mask : basename($file)) . '"');
					header('Content-Transfer-Encoding: binary');
					header('Expires: 0');
					header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
					header('Pragma: public');
					header('Content-Length: ' . filesize($file));

					readfile($file, 'rb');
					exit;
				} else {
					exit('Error: Could not find file ' . $file . '!');
				}
			} else {
				exit('Error: Headers already sent out!');
			}
		} else {
			$this->load->language('error/not_found');

			$this->document->setTitle($this->language->get('heading_title'));

			$data['heading_title'] = $this->language->get('heading_title');

			$data['text_not_found'] = $this->language->get('text_not_found');

			$data['breadcrumbs'] = array();

			$data['breadcrumbs'][] = array(
				'text'      => $this->language->get('text_home'),
				'href'      => $this->url->link('common/home', 'user_token=' . $this->session->data['user_token'], 'SSL'),
				'separator' => false
			);

			$data['breadcrumbs'][] = array(
				'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], 'SSL'),
				'separator' => ' :: '
			);
			/*
			$this->template = 'error/not_found.tpl';
			$this->children = array(
				'common/header',
				'common/footer'
			);
			$this->response->setOutput($this->render());
			*/

										$data['header'] = $this->load->controller('common/header');
										$data['column_left'] = $this->load->controller('common/column_left');
										$data['footer'] = $this->load->controller('common/footer');
										$this->response->setOutput($this->load->view('error/not_found', $data));
		}
	}

	public function upload() {
		$this->language->load('sale/order');

		$json = array();

		if (!empty($this->request->files['file']['name'])) {
			$filename = html_entity_decode($this->request->files['file']['name'], ENT_QUOTES, 'UTF-8');

			if ((strlen($filename) < 3) || (strlen($filename) > 128)) {
        		$json['error'] = $this->language->get('error_filename');
	  		}

			$allowed = array();

			$filetypes = explode(',', $this->config->get('config_upload_allowed'));

			foreach ($filetypes as $filetype) {
				$allowed[] = trim($filetype);
			}

			if (!in_array(utf8_substr(strrchr($filename, '.'), 1), $allowed)) {
				$json['error'] = $this->language->get('error_filetype');
       		}

			if ($this->request->files['file']['error'] != UPLOAD_ERR_OK) {
				$json['error'] = $this->language->get('error_upload_' . $this->request->files['file']['error']);
			}
		} else {
			$json['error'] = $this->language->get('error_upload');
		}

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && !isset($json['error'])) {
			if (is_uploaded_file($this->request->files['file']['tmp_name']) && file_exists($this->request->files['file']['tmp_name'])) {
				$file = basename($filename) . '.' . md5(rand());

				$json['file'] = $file;

				move_uploaded_file($this->request->files['file']['tmp_name'], DIR_DOWNLOAD . $file);
			}

			$json['success'] = $this->language->get('text_upload');
		}

		$this->response->setOutput(json_encode($json));
	}

  	public function invoice() {
		$this->load->language('sale/order');

		$data['title'] = $this->language->get('heading_title');

		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$data['base'] = HTTPS_SERVER;
		} else {
			$data['base'] = HTTP_SERVER;
		}

		$data['direction'] = $this->language->get('direction');
		$data['language'] = $this->language->get('code');

		$data['text_invoice'] = $this->language->get('text_invoice');

		$data['text_order_id'] = $this->language->get('text_order_id');
		$data['text_invoice_no'] = $this->language->get('text_invoice_no');
		$data['text_invoice_date'] = $this->language->get('text_invoice_date');
		$data['text_date_added'] = $this->language->get('text_date_added');
		$data['text_telephone'] = $this->language->get('text_telephone');
		$data['text_fax'] = $this->language->get('text_fax');
		$data['text_to'] = $this->language->get('text_to');
		$data['text_ship_to'] = $this->language->get('text_ship_to');

		$data['column_product'] = $this->language->get('column_product');
		$data['column_model'] = $this->language->get('column_model');
		$data['column_quantity'] = $this->language->get('column_quantity');
		$data['column_price'] = $this->language->get('column_price');
		$data['column_total'] = $this->language->get('column_total');
		$data['column_comment'] = $this->language->get('column_comment');

		$this->load->model('sale/order');

		$this->load->model('setting/setting');

		$data['orders'] = array();

		$orders = array();

		if (isset($this->request->post['selected'])) {
			$orders = $this->request->post['selected'];
		} elseif (isset($this->request->get['order_id'])) {
			$orders[] = $this->request->get['order_id'];
		}

		foreach ($orders as $order_id) {
			$order_info = $this->model_sale_order->getOrder($order_id);

			if ($order_info) {
				$store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);

				if ($store_info) {
					$store_address = $store_info['config_address'];
					$store_email = $store_info['config_email'];
					$store_telephone = $store_info['config_telephone'];
					$store_fax = $store_info['config_fax'];
				} else {
					$store_address = $this->config->get('config_address');
					$store_email = $this->config->get('config_email');
					$store_telephone = $this->config->get('config_telephone');
					$store_fax = $this->config->get('config_fax');
				}

				if ($order_info['invoice_no']) {
					$invoice_no = $order_info['invoice_prefix'] . $order_info['invoice_no'];
				} else {
					$invoice_no = '';
				}

				if ($order_info['shipping_address_format']) {
					$format = $order_info['shipping_address_format'];
				} else {
					$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
				}

				$find = array(
					'{firstname}',
					'{lastname}',
					'{company}',
					'{address_1}',
					'{address_2}',
					'{city}',
					'{postcode}',
					'{zone}',
					'{zone_code}',
					'{country}'
				);

				$replace = array(
					'firstname' => $order_info['shipping_firstname'],
					'lastname'  => $order_info['shipping_lastname'],
					'company'   => $order_info['shipping_company'],
					'address_1' => $order_info['shipping_address_1'],
					'address_2' => $order_info['shipping_address_2'],
					'city'      => $order_info['shipping_city'],
					'postcode'  => $order_info['shipping_postcode'],
					'zone'      => $order_info['shipping_zone'],
					'zone_code' => $order_info['shipping_zone_code'],
					'country'   => $order_info['shipping_country']
				);

				$shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

				if ($order_info['payment_address_format']) {
					$format = $order_info['payment_address_format'];
				} else {
					$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
				}

				$find = array(
					'{firstname}',
					'{lastname}',
					'{company}',
					'{address_1}',
					'{address_2}',
					'{city}',
					'{postcode}',
					'{zone}',
					'{zone_code}',
					'{country}'
				);

				$replace = array(
					'firstname' => $order_info['payment_firstname'],
					'lastname'  => $order_info['payment_lastname'],
					'company'   => $order_info['payment_company'],
					'address_1' => $order_info['payment_address_1'],
					'address_2' => $order_info['payment_address_2'],
					'city'      => $order_info['payment_city'],
					'postcode'  => $order_info['payment_postcode'],
					'zone'      => $order_info['payment_zone'],
					'zone_code' => $order_info['payment_zone_code'],
					'country'   => $order_info['payment_country']
				);

				$payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

				$product_data = array();

				$products = $this->model_sale_order->getOrderProducts($order_id);

				foreach ($products as $product) {
					$option_data = array();

					$options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);

					foreach ($options as $option) {
						if ($option['type'] != 'file') {
							$option_data[] = array(
								'name'  => $option['name'],
								'value' => $option['value']
							);
						} else {
							$option_data[] = array(
								'name'  => $option['name'],
								'value' => utf8_substr($option['value'], 0, strrpos($option['value'], '.'))
							);
						}
					}

					$product_data[] = array(
						'name'     => $product['name'],
						'optionname'     => $product['optionname'],
						'model'    => $product['model'],
						'option'   => $option_data,
						'quantity' => $product['quantity'],
						'price'    => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
						'total'    => $this->currency->format($product['total'], $order_info['currency_code'], $order_info['currency_value'])
					);
				}

				$total_data = $this->model_sale_order->getOrderTotals($order_id);

				$data['orders'][] = array(
					'order_id'	       => $order_id,
					'invoice_no'       => $invoice_no,
					'date_added'       => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
					'store_name'       => $order_info['store_name'],
					'store_url'        => rtrim($order_info['store_url'], '/'),
					'store_address'    => nl2br($store_address),
					'store_email'      => $store_email,
					'store_telephone'  => $store_telephone,
					'store_fax'        => $store_fax,
					'email'            => $order_info['email'],
					'telephone'        => $order_info['telephone'],
					'shipping_address' => $shipping_address,
					'payment_address'  => $payment_address,
					'product'          => $product_data,
					'total'            => $total_data,
					'comment'          => nl2br($order_info['comment'])
				);
			}
		}

		//$this->template = 'sale/order_invoice.tpl';
		// $this->response->setOutput($this->render());


									$data['header'] = $this->load->controller('common/header');
									$data['column_left'] = $this->load->controller('common/column_left');
									$data['footer'] = $this->load->controller('common/footer');
									$this->response->setOutput($this->load->view('sale/order_invoice', $data));
	}
}
?>
