# Klarna Checkout REST PHP SDK
[![Packagist Version][packagist-image]](https://packagist.org/packages/klarna/kco_rest)
[![Build Status][travis-image]](https://travis-ci.org/klarna/kco_rest_php)
[![Coverage Status][coveralls-image]](https://coveralls.io/r/klarna/kco_rest_php?branch=v2.2)

Klarna Checkout is a revolutionary new payment solution that is changing the way
people shop online. First, consumers verify their purchase with a minimal
amount of information through intelligent identification, securing your order
immediately, and then complete their payment afterwards – separating buying
from paying and dramatically increasing conversion. Klarna Checkout also allows
merchants to offer all payment methods through one supplier, minimizing
administration, costs and integration time.


## Get started

### Prerequisites
* PHP 5.4 or above
* API credentials


### Usage
Example files can be found in the [docs/](docs/) directory.


## Documentation
Additional documentation can be found at https://developers.klarna.com.


## Questions and feedback
If you have any questions concerning this product or the implementation,
please contact [integration@klarna.com](mailto:integration@klarna.com).


## How to contribute
At Klarna, we strive toward achieving the highest possible quality for our
products. Therefore, we require you to follow these guidelines if you wish
to contribute.

To contribute, the following criteria needs to be fulfilled:

* Description regarding what has been changed and why
* Pull requests should implement a boxed change
* All code and documentation must follow the [PSR-2 standard](http://www.php-fig.org/psr/psr-2/)
* New features and bug fixes must have accompanying unit tests:
    * Positive tests
    * Negative tests
    * Boundary tests (if possible)
    * No less than 90% decision coverage
* All tests should pass


## Acknowledgements
* Christer Gustavsson ([@ChristerGustavsson](https://github.com/ChristerGustavsson))
* David Keijser ([@keis](https://github.com/keis))
* Joakim Löfgren ([@JoakimLofgren](https://github.com/JoakimLofgren))
* Majid Garmaroudi ([@dijam](https://github.com/dijam))
* Omer Karadagli ([@ockcyp](https://github.com/ockcyp))


## License
Klarna Checkout REST PHP SDK is licensed under
[Apache License, Version 2.0](http://www.apache.org/LICENSE-2.0)

[packagist-image]: https://img.shields.io/packagist/v/klarna/kco_rest.svg?style=flat
[travis-image]: https://img.shields.io/travis/klarna/kco_rest_php/v2.2.svg?style=flat
[coveralls-image]: https://img.shields.io/coveralls/klarna/kco_rest_php/v2.2.svg?style=flat
