<?php
class ModelSaleSize extends Model {
	public function addsize($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "size SET size_code = '" . $this->db->escape($data['size_code']) . "', measlength = '" . $this->db->escape($data['measlength']) . "', measwidth = '" . $this->db->escape($data['measwidth']) . "'");
	
		return $this->db->getLastId();
	}

	public function editsize($size_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "size SET size_code = '" . $this->db->escape($data['size_code']) ."', measlength = '" . $this->db->escape($data['measlength']) . "', measwidth = '" . $this->db->escape($data['measwidth']) . "' WHERE size_id = '" . (int)$size_id . "'");
	}

	public function deletesize($size_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "size WHERE size_id = " . (int)$size_id);
	}

	public function getsize($size_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "size WHERE size_id = '" . (int)$size_id . "'");

		return $query->row;
	}

	public function getsizes($data = array()) {
		$sql = "SELECT size_id, size_code,measlength,measwidth FROM " . DB_PREFIX . "size";

		$sort_data = array(
			'size_code', 
			'measlength', 
			'measwidth', 
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY size_code";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalsizes() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "size");

		return $query->row['total'];
	}
}
