<?php
class ModelSaleGemcolor extends Model {
	public function addgemcolor($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "colour_clarity SET colour_id = '" . $this->db->escape($data['colour_id']) . "', clarity_id = '" . $this->db->escape($data['clarity_id']) . "', gemstone_id = '" . $this->db->escape($data['gemstone_id']) . "'");
	
		return $this->db->getLastId();
	}

	public function editgemcolor($colorclarity_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "colour_clarity SET colour_id = '" . $this->db->escape($data['colour_id']) . "', clarity_id = '" . $this->db->escape($data['clarity_id']) . "', gemstone_id = '" . $this->db->escape($data['gemstone_id']) . "' WHERE colorclarity_id = '" . (int)$colorclarity_id . "'");
	}

	public function deletegemcolor($colorclarity_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "colour_clarity WHERE colorclarity_id = " . (int)$colorclarity_id);
	}

	public function getgemcolor($colorclarity_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "colour_clarity WHERE colorclarity_id = '" . (int)$colorclarity_id . "'");

		return $query->row;
	}

	public function getgemcolors($data = array()) {
		$sql = "SELECT colorclarity_id,clarity_id,gemstone_id,(select gs.gemname from gemstone gs where gs.gemstone_id = cc.gemstone_id) as gemname, colour_id FROM " . DB_PREFIX . "colour_clarity cc";

		$sort_data = array(
			'colorclarity_id',
			'gemstone_id',
			'colour_id', 
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY gemname";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalgemcolors() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "colour_clarity");

		return $query->row['total'];
	}
	
	public function getcolourcodes($data = array()) {
		$sql = "SELECT colour_id, colour_code FROM " . DB_PREFIX . "colour";

		$sort_data = array(
			'colour_code', 
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY colour_code";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}
	
	public function getclaritycodes($data = array()) {
		$sql = "SELECT clarity_id, clarity_code FROM " . DB_PREFIX . "clarity";

		$sort_data = array(
			'clarity_code', 
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY clarity_code";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}
}
