<?php
class ControllerSaleGemcolor extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/gemcolor');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemcolor');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/gemcolor');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemcolor');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemcolor->addgemcolor($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemcolor', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/gemcolor');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemcolor');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemcolor->editgemcolor($this->request->get['colorclarity_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemcolor', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/gemcolor');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemcolor');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $colorclarity_id) {
				$this->model_sale_gemcolor->deletegemcolor($colorclarity_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemcolor', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'colorclarity_id';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/gemcolor', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/gemcolor/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/gemcolor/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['gemcolor'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$gemcolor_total = $this->model_sale_gemcolor->getTotalgemcolors();

		$results = $this->model_sale_gemcolor->getgemcolors($filter_data);

		foreach ($results as $result) {
			$data['gemcolor'][] =   array(
				'colorclarity_id' 			=> $result['colorclarity_id'],
				'clarity_id'        		=> $result['clarity_id'], 
				'colour_id'        		=> $result['colour_id'], 
				'gemstone_id'        		=> $result['gemstone_id'], 
				'gemname'        		=> $result['gemname'],  
				'edit'        		=> $this->url->link('sale/gemcolor/edit', 'user_token=' . $this->session->data['user_token'] . '&colorclarity_id=' . $result['colorclarity_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_colour_id'] = $this->url->link('sale/gemcolor', 'user_token=' . $this->session->data['user_token'] . '&sort=colour_id' . $url, true);
		$data['sort_clarity_id'] = $this->url->link('sale/gemcolor', 'user_token=' . $this->session->data['user_token'] . '&sort=clarity_id' . $url, true);
		$data['sort_gemname'] = $this->url->link('sale/gemcolor', 'user_token=' . $this->session->data['user_token'] . '&sort=gemname' . $url, true);
		 
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $gemcolor_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/gemcolor', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($gemcolor_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($gemcolor_total - $this->config->get('config_limit_admin'))) ? $gemcolor_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $gemcolor_total, ceil($gemcolor_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/gemcolor_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['colorclarity_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['colour_id'])) {
			$data['error_colour_id'] = $this->error['colour_id'];
		} else {
			$data['error_colour_id'] = '';
		}
 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/gemcolor', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['colorclarity_id'])) {
			$data['action'] = $this->url->link('sale/gemcolor/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/gemcolor/edit', 'user_token=' . $this->session->data['user_token'] .  '&colorclarity_id=' . $this->request->get['colorclarity_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/gemcolor', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['colorclarity_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$gemcolor_info = $this->model_sale_gemcolor->getgemcolor($this->request->get['colorclarity_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');
 
		if (isset($this->request->post['colour_id'])) {
			$data['colour_id'] = $this->request->post['colour_id'];
		} elseif (!empty($gemcolor_info)) {
			$data['colour_id'] = $gemcolor_info['colour_id'];
		} else {
			$data['colour_id'] =   '';
		}
		
		if (isset($this->request->post['clarity_id'])) {
			$data['clarity_id'] = $this->request->post['clarity_id'];
		} elseif (!empty($gemcolor_info)) {
			$data['clarity_id'] = $gemcolor_info['clarity_id'];
		} else {
			$data['clarity_id'] = '';
		} 

		if (isset($this->request->post['gemstone_id'])) {
			$data['gemstone_id'] = $this->request->post['gemstone_id'];
		} elseif (!empty($gemcolor_info)) {
			$data['gemstone_id'] = $gemcolor_info['gemstone_id'];
		} else {
			$data['gemstone_id'] = '';
		} 
		   
		$this->load->model('sale/colourcode');
		$data['colors'] = $this->model_sale_colourcode->getcolourcodes();
		$this->load->model('sale/claritycode');
		$data['clarities'] = $this->model_sale_claritycode->getclaritycodes();
		$this->load->model('sale/gemstone');
		$data['gemstones'] = $this->model_sale_gemstone->getgemstones();
  
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/gemcolor_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/gemcolor')) {
			$this->error['warning'] = $this->language->get('error_permission');
		} 
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/gemcolor')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}