<?php
class ControllerSaleoccasion extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/occasion');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/occasion');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/occasion');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/occasion');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_occasion->addoccasion($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/occasion', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/occasion');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/occasion');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_occasion->editoccasion($this->request->get['occasionmaster_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/occasion', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/occasion');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/occasion');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $occasionmaster_id) {
				$this->model_sale_occasion->deleteoccasion($occasionmaster_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/occasion', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'description';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/occasion', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/occasion/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/occasion/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['occasion'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$occasion_total = $this->model_sale_occasion->getTotaloccasions();

		$results = $this->model_sale_occasion->getoccasions($filter_data);

		foreach ($results as $result) {
			$data['occasion'][] =   array(
				'occasionmaster_id' 			=> $result['occasionmaster_id'],
				'description'        		=> $result['description'], 
				'edit'        		=> $this->url->link('sale/occasion/edit', 'user_token=' . $this->session->data['user_token'] . '&occasionmaster_id=' . $result['occasionmaster_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_description'] = $this->url->link('sale/occasion', 'user_token=' . $this->session->data['user_token'] . '&sort=description' . $url, true); 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $occasion_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/occasion', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($occasion_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($occasion_total - $this->config->get('config_limit_admin'))) ? $occasion_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $occasion_total, ceil($occasion_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/occasion_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['occasionmaster_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['description'])) {
			$data['error_description'] = $this->error['description'];
		} else {
			$data['error_description'] = '';
		}
		

		if (isset($this->error['detailed_description'])) {
			$data['error_detailed_description'] = $this->error['detailed_description'];
		} else {
			$data['error_detailed_description'] = '';
		}
		

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/occasion', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['occasionmaster_id'])) {
			$data['action'] = $this->url->link('sale/occasion/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/occasion/edit', 'user_token=' . $this->session->data['user_token'] .  '&occasionmaster_id=' . $this->request->get['occasionmaster_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/occasion', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['occasionmaster_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$occasion_info = $this->model_sale_occasion->getoccasion($this->request->get['occasionmaster_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');

		if (isset($this->request->post['description'])) {
			$data['description'] = $this->request->post['description'];
		} elseif (!empty($occasion_info)) {
			$data['description'] = $occasion_info['description'];
		} else {
			$data['description'] =   '';
		} 
		if (isset($this->request->post['detailed_description'])) {
			$data['detailed_description'] = $this->request->post['detailed_description'];
		} elseif (!empty($occasion_info)) {
			$data['detailed_description'] = $occasion_info['detailed_description'];
		} else {
			$data['detailed_description'] =   '';
		} 

		if (isset($this->request->post['occasionmaster_id'])) {
			$data['occasionmaster_id'] = $this->request->post['occasionmaster_id'];
		} elseif (!empty($occasion_info)) {
			$data['occasionmaster_id'] = $occasion_info['occasionmaster_id'];
		} else {
			$data['occasionmaster_id'] = '';
		} 
		
		$this->load->model('localisation/currency');

		$data['currencies'] = $this->model_localisation_currency->getCurrencies();
  
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/occasion_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/occasion')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['description']) < 1) || (utf8_strlen($this->request->post['description']) > 32)) {
			$this->error['description'] = $this->language->get('error_description');
		} 
 
		if ((utf8_strlen($this->request->post['detailed_description']) < 1) || (utf8_strlen($this->request->post['detailed_description']) > 32)) {
			$this->error['detailed_description'] = $this->language->get('error_detailed_description');
		} 
 
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/occasion')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}