<?php
class ControllerSaleLaboursc extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/laboursc');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/laboursc');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/laboursc');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/laboursc');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_laboursc->addlaboursc($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/laboursc', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/laboursc');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/laboursc');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_laboursc->editlaboursc($this->request->get['setting_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/laboursc', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/laboursc');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/laboursc');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $setting_id) {
				$this->model_sale_laboursc->deletelaboursc($setting_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/laboursc', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'setting_id';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/laboursc', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/laboursc/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/laboursc/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['laboursc'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$laboursc_total = $this->model_sale_laboursc->getTotallabourscs();

		$results = $this->model_sale_laboursc->getlabourscs($filter_data);

		foreach ($results as $result) {
			$data['laboursc'][] =   array(
				'setting_id' 			=> $result['setting_id'],
				'setting'        		=> $result['setting'], 
				'cost'     					=> $result['cost'], 
				'edit'        		=> $this->url->link('sale/laboursc/edit', 'user_token=' . $this->session->data['user_token'] . '&setting_id=' . $result['setting_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_setting'] = $this->url->link('sale/laboursc', 'user_token=' . $this->session->data['user_token'] . '&sort=setting' . $url, true);
		$data['sort_cost'] = $this->url->link('sale/laboursc', 'user_token=' . $this->session->data['user_token'] . '&sort=cost' . $url, true); 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $laboursc_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/laboursc', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($laboursc_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($laboursc_total - $this->config->get('config_limit_admin'))) ? $laboursc_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $laboursc_total, ceil($laboursc_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/laboursc_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['setting_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['setting'])) {
			$data['error_setting'] = $this->error['setting'];
		} else {
			$data['error_setting'] = '';
		}

		if (isset($this->error['cost'])) {
			$data['error_cost'] = $this->error['cost'];
		} else {
			$data['error_cost'] = '';
		} 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/laboursc', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['setting_id'])) {
			$data['action'] = $this->url->link('sale/laboursc/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/laboursc/edit', 'user_token=' . $this->session->data['user_token'] .  '&setting_id=' . $this->request->get['setting_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/laboursc', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['setting_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$laboursc_info = $this->model_sale_laboursc->getlaboursc($this->request->get['setting_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');
 
		if (isset($this->request->post['setting'])) {
			$data['setting'] = $this->request->post['setting'];
		} elseif (!empty($laboursc_info)) {
			$data['setting'] = $laboursc_info['setting'];
		} else {
			$data['setting'] =   '';
		}
		
		if (isset($this->request->post['ccurrency'])) {
			$data['ccurrency'] = $this->request->post['ccurrency'];
		} elseif (!empty($laboursc_info)) {
			$data['ccurrency'] = $laboursc_info['ccurrency'];
		} else {
			$data['ccurrency'] = '';
		}
		if (isset($this->request->post['cost'])) {
			$data['cost'] = $this->request->post['cost'];
		} elseif (!empty($laboursc_info)) {
			$data['cost'] = $laboursc_info['cost'];
		} else {
			$data['cost'] = '';
		} 

		if (isset($this->request->post['supplier_group_id'])) {
			$data['supplier_group_id'] = $this->request->post['supplier_group_id'];
		} elseif (!empty($laboursc_info)) {
			$data['supplier_group_id'] = $laboursc_info['supplier_group_id'];
		} else {
			$data['supplier_group_id'] = '';
		} 
		
		$this->load->model('localisation/currency');

		$data['currencies'] = $this->model_localisation_currency->getCurrencies();
		
		$this->load->model('sale/supplier');
		$data['suppliers'] = $this->model_sale_supplier->getsuppliers();
  
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/laboursc_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/laboursc')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['setting']) < 1) || (utf8_strlen($this->request->post['setting']) > 32)) {
			$this->error['setting'] = $this->language->get('error_setting');
		} 

		
		if ((utf8_strlen($this->request->post['cost']) < 1) || (utf8_strlen($this->request->post['cost']) > 128)) {
			$this->error['cost'] = $this->language->get('error_cost');
		}
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/laboursc')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}