<?php 
class ControllerExtrasBlogSearch extends Controller {
	private $error = array();
	
	public function index() {  
    	$this->language->load('extras/blog_search');
		
		$this->load->model('extras/blog_search');	
		
		$this->data['breadcrumbs']  = array();
		
      	$this->data['breadcrumbs'] [] = array(
        	'href'      => $this->url->link('common/home'),
        	'text'      => $this->language->get('text_home'),
        	'separator' => FALSE
      	);
		
		$this->getBlogs();
	}
		
	public function getBlogs() { 
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$this->language->load('extras/blog_search');
		
		$this->load->model('extras/blog_search');
		
		//$this->load->model('tool/seo_url');
		$this->load->model('tool/image');
		
		$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),        	
        	'separator' => false
      	);
		
		      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_blog'),
			'href'      => $this->url->link('extras/blog'),
        	'separator' => $this->language->get('text_separator')
      	);	

      	//$this->data['breadcrumbs'][] = array(
        //	'text'      => $this->language->get('text_blog_result'),
		//	'href'      => $this->url->link('extras/blog_search'),
        //	'separator' => $this->language->get('text_separator')
      	//);	
		
		if (isset($this->request->get['blog_keyword'])) {
			$filter_keyword = $this->request->get['blog_keyword'];
		} else {
			$filter_keyword = '';
		} 
		
		if (isset($this->request->get['filter_blog_title'])) {
			$filter_blog_title = $this->request->get['filter_blog_title'];
		} else {
			$filter_blog_title = '';
		} 
		
		if (isset($this->request->get['filter_blog_description'])) {
			$filter_blog_description = $this->request->get['filter_blog_description'];
		} else {
			$filter_blog_description = '';
		} 
		
		$this->data['blogs'] = array();

		$data = array(
			'filter_keyword'         => $filter_keyword, 
			'filter_blog_title'      => $filter_blog_title, 
			'filter_blog_description'=> $filter_blog_description, 
			'start' => ($page - 1) * $this->config->get('blog_setting_blog_per_page'),
			'limit' => $this->config->get('blog_setting_blog_per_page')
		);
		
		$blog_total = $this->model_extras_blog_search->getTotalBlogs($data);
	
		$results = $this->model_extras_blog_search->getBlogs(($page - 1) * $this->config->get('blog_setting_blog_per_page'), $this->config->get('blog_setting_blog_per_page'), $data);
 
    	foreach ($results as $result) {
						
			$this->data['blogs'][] = array(
			   'count_read' => $result['count_read'],
				'blog_id' => $result['blog_id'],
				'title'      => $result['title'],
				'short_description'      => substr(strip_tags(html_entity_decode($result['short_description'], ENT_QUOTES, 'UTF-8')), 0, $this->config->get('blog_setting_blog_list_short_description_max_chars')) . ' <a href="' . $this->url->link('extras/blog/getblog', 'blog_id=' . $result['blog_id']) . '" title="' . $this->language->get('text_read_more') . '">[...]</a>',
				'date_added' => $result['date_added'],
				'image'   		=> $this->model_tool_image->resize($result['image'], $this->config->get('blog_setting_blog_list_image_dimension_width'), $this->config->get('blog_setting_blog_list_image_dimension_height')),
				//'sort_order' => $result['sort_order'],
				'href' => $this->url->link('extras/blog/getblog', 'blog_id=' . $result['blog_id'])
			);
			
		}	
		$this->document->setTitle($this->language->get('text_blog_result')); 
		
		$this->data['heading_title'] = $this->language->get('text_blog_result');
		
		$this->data['text_posted_on'] = $this->language->get('text_posted_on');
		$this->data['text_read'] = $this->language->get('text_read');
		$this->data['text_time'] = $this->language->get('text_time');
		$this->data['text_not_found'] = $this->language->get('text_not_found');
		$this->data['text_read_more'] = $this->language->get('text_read_more');
		
		$url = '';
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$url = '';
		
		$pagination = new Pagination();
		$pagination->total = $blog_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('blog_setting_blog_per_page');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('extras/blog_search', $url . '&page={page}');
			
		$this->data['pagination'] = $pagination->render();
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/extras/blog_search.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/extras/blog_search.tpl';
			} else {
				$this->template = 'default/template/extras/blog_search.tpl';
			}
			
			$this->children = array(
				'common/column_left',
				'common/column_right',
				'common/content_top',
				'common/content_bottom',
				'common/footer',
				'common/header'
			);	
		
		$this->response->setOutput($this->render()); 
	}
				
}
?>