<?php 
class ControllerDesaccountLogin extends Controller {
	private $error = array();
	
	public function index() {
		// Login override for admin users
		if (!empty($this->request->get['token'])) {
			$this->designer->logout();
			
			$this->load->model('desaccount/designer');
		
			
			$designer_info = $this->model_desaccount_designer->getdesignerByToken($this->request->get['token']);
			
		 	if ($designer_info && $this->designer->login($designer_info['email'], '', true)) {
				$this->redirect($this->url->link('desaccount/edit', '', 'SSL')); 
			}
		}		
		
		if ($this->designer->isLogged()) {
      		$this->redirect($this->url->link('desaccount/edit', '', 'SSL'));
    	}
	
    	$this->language->load('desaccount/login');

    	$this->document->setTitle($this->language->get('heading_title'));
								
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->customer->logout();
			$this->valuer->logout();
			unset($this->session->data['guest']);
			
			// Added strpos check to pass McAfee PCI compliance test (http://forum.opencart.com/viewtopic.php?f=10&t=12043&p=151494#p151295)
			if (isset($this->request->post['redirect']) && (strpos($this->request->post['redirect'], HTTP_SERVER) !== false || strpos($this->request->post['redirect'], HTTPS_SERVER) !== false)) {
				$this->redirect(str_replace('&amp;', '&', $this->request->post['redirect']));
			} else {
				$this->redirect($this->url->link('desaccount/edit', '', 'SSL')); 
			}
    	}  
		
      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),       	
        	'separator' => false
      	);
  
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('desaccount/account', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
		
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_login'),
			'href'      => $this->url->link('desaccount/login', '', 'SSL'),      	
        	'separator' => $this->language->get('text_separator')
      	);
				
    	$this->data['heading_title'] = $this->language->get('heading_title');

    	$this->data['text_new_designer'] = $this->language->get('text_new_designer');
    	$this->data['text_register'] = $this->language->get('text_register');
    	$this->data['text_register_account'] = $this->language->get('text_register_account');
		$this->data['text_returning_designer'] = $this->language->get('text_returning_designer');
		$this->data['text_i_am_returning_designer'] = $this->language->get('text_i_am_returning_designer');
    	$this->data['text_forgotten'] = $this->language->get('text_forgotten');
    	$this->data['text_agree'] = $this->language->get('text_agree');
		
		$this->load->model('catalog/information');
    	$this->data['info35'] = 35;
		
		$information_info = $this->model_catalog_information->getInformationof35($this->data['info35']);
		$this->data['text_agree'] = sprintf($this->language->get('text_agree'), $this->url->link('information/information/info', 'information_id=' . $this->data['info35'], 'SSL'), $information_info['title'], $information_info['title']);

    	$this->data['entry_email'] = $this->language->get('entry_email');
    	$this->data['entry_password'] = $this->language->get('entry_password');

    	$this->data['button_continue'] = $this->language->get('button_continue');
		$this->data['button_login'] = $this->language->get('button_login');

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		$this->data['action'] = $this->url->link('desaccount/login', '', 'SSL');
		$this->data['register'] = $this->url->link('desaccount/register', '', 'SSL');
		$this->data['forgotten'] = $this->url->link('desaccount/forgotten', '', 'SSL');

    	// Added strpos check to pass McAfee PCI compliance test (http://forum.opencart.com/viewtopic.php?f=10&t=12043&p=151494#p151295)
		if (isset($this->request->post['redirect']) && (strpos($this->request->post['redirect'], HTTP_SERVER) !== false || strpos($this->request->post['redirect'], HTTPS_SERVER) !== false)) {
			$this->data['redirect'] = $this->request->post['redirect'];
		} elseif (isset($this->session->data['redirect'])) {
      		$this->data['redirect'] = $this->session->data['redirect'];
	  		
			unset($this->session->data['redirect']);		  	
    	} else {
			$this->data['redirect'] = '';
		}

		if (isset($this->session->data['success'])) {
    		$this->data['success'] = $this->session->data['success'];
    
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$this->load->model('desaccount/designer');
		
		$this->data['des_description'] = html_entity_decode($this->model_desaccount_designer->get_designer_content());
	

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/desaccount/login.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/desaccount/login.tpl';
		} else {
			$this->template = 'default/template/desaccount/login.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());
  	}
  
  	private function validate() {
    	if (!$this->designer->login($this->request->post['email'], $this->request->post['password'])) {
      		$this->error['warning'] = $this->language->get('error_login');
    	}
	
    	if (!$this->error) {
      		return true;
    	} else {
      		return false;
    	}  	
  	}
}
?>