<?php
class ControllerAccountOverall extends Controller {
	private $error = array();

	public function index() {
		if (!$this->customer->isLogged()) {
		    $query = HTTP_SERVER.$_SERVER['REQUEST_URI'];
			$this->session->data['redirect'] =$query;

			$this->redirect($this->url->link('account/login', '', 'SSL'));
		}

		$this->language->load('account/overall');
		
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('account/customer');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
		
			if ($this->request->post['mr_task'] == 'edit') {
			
			$this->model_account_customer->editCustomer($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('account/account', '', 'SSL'));
			}
			
			if ($this->request->post['mr_task'] == 'comm') { 
			
			$this->model_account_customer->add_comments($this->request->post);
			
			$cid_url = $_GET['cid'];
			
			$storelogo = $this->db->query("	SELECT value FROM `setting` a,contest_master b where `key`='config_logo' and a.store_id=b.store_id and b.contest_id='" . $this->request->post['contest_id'] . "'");
			$contestlogo='<p>	<img alt="" src="'. HTTPS_IMAGE . $storelogo->row['value'] .'"  /></p>' . '<br>';

			$this->load->model('catalog/information');
			$information_info = $this->model_catalog_information->getInformation(43);
			
			$subject = 'Congratulations!';
			
			$infomessage = $contestlogo . html_entity_decode($information_info['description'], ENT_QUOTES, 'UTF-8');
			
			$alldesignersmaster = $this->db->query("SELECT distinct d.email,d.dispname,c.firstname,cm.contest_id,cm.name from " . DB_PREFIX . "designer d ," . DB_PREFIX . "contest_sketch_assignment csa ," . DB_PREFIX . "sketches_master sm ," . DB_PREFIX . "customer c , " . DB_PREFIX . "contest_master cm where csa.sketch_id = sm.sketch_id AND cm.contest_id = csa.contest_id and cm.customer_id = c.customer_id and sm.designer_id = d.designer_id and csa.contest_id='" . (int)$cid_url  . "'");
			
			$subject = 'Message from customer';
		//	$message .= '<p class="p1">	Regards<br>Customer Service Team</p><p class="p2">&nbsp;</p></font>';
			
			if($alldesignersmaster->num_rows != 0)
			{
			$alldesigners = $alldesignersmaster->rows;

			//$emails = array();
			// $emails[] = $mailcmd->row['email'];
			//$emails = array_unique($emails);
			foreach ($alldesigners as $designer) {
			$message = $infomessage;	
			$message = str_replace('%DesignerDisplayName%',$designer['dispname'],$message);
			$message = str_replace('%CustomerFirstName%',$designer['firstname'],$message);
			$message = str_replace('%ContestName%',$designer['name'],$message);
			$message = str_replace('%Message%',$this->request->post['comment'],$message);
			$message = str_replace('%ContestId%',$cid_url,$message);
			
			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->hostname = $this->config->get('config_smtp_host');
			$mail->username = $this->config->get('config_smtp_username');
			$mail->password = $this->config->get('config_smtp_password');
			$mail->port = $this->config->get('config_smtp_port');
			$mail->timeout = $this->config->get('config_smtp_timeout');				
			$mail->setTo($designer['email']);
	  		$mail->setFrom($this->config->get('config_email'));
	  		$mail->setSender($this->config->get('config_name'));
	  		$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
	  		$mail->setHtml((html_entity_decode($message, ENT_QUOTES, 'UTF-8')));
		//	$mail->addAttachment(DIR_IMAGE . $this->config->get('config_logo'));
      		$mail->send();
			}
			}
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$this->redirect($this->url->link('account/overall&cid=' . $_GET["cid"], 'SSL'));
			
			}
			
		}

      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),     	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('account/account', '', 'SSL'),        	
        	'separator' => $this->language->get('text_separator')
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_edit'),
			'href'      => $this->url->link('account/overall', '', 'SSL'),       	
        	'separator' => $this->language->get('text_separator')
      	);
		
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_your_details'] = $this->language->get('text_your_details');

		$this->data['entry_firstname'] = $this->language->get('entry_firstname');
		$this->data['entry_lastname'] = $this->language->get('entry_lastname');
		$this->data['entry_email'] = $this->language->get('entry_email');
		$this->data['entry_fax'] = $this->language->get('entry_fax');
		$this->data['entry_password'] = $this->language->get('entry_password');
    	$this->data['entry_confirm'] = $this->language->get('entry_confirm');
    	$this->data['entry_dispname'] = $this->language->get('entry_dispname');
    	$this->data['entry_profpic'] = $this->language->get('entry_profpic');
		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');	
		$this->data['entry_gender'] = $this->language->get('entry_gender');	
		$this->data['text_male'] = $this->language->get('text_male');	
		$this->data['text_female'] = $this->language->get('text_female');	
		$this->data['text_english'] = $this->language->get('text_english');	
		$this->data['text_french'] = $this->language->get('text_french');	
		$this->data['text_italin'] = $this->language->get('text_italin');	
		$this->data['entry_yourself'] = $this->language->get('entry_yourself');	
		$this->data['entry_langknown'] = $this->language->get('entry_langknown');	
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['text_cheque'] = $this->language->get('text_cheque');
		$this->data['text_paypal'] = $this->language->get('text_paypal');
		$this->data['text_money'] = $this->language->get('text_money');
		$this->data['text_bank'] = $this->language->get('text_bank');
		$this->data['entry_paypalemail'] = $this->language->get('entry_paypalemail');

		$this->data['button_continue'] = $this->language->get('button_continue');
		$this->data['button_back'] = $this->language->get('button_back');

		
		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['firstname'])) {
			$this->data['error_firstname'] = $this->error['firstname'];
		} else {
			$this->data['error_firstname'] = '';
		}

		if (isset($this->error['lastname'])) {
			$this->data['error_lastname'] = $this->error['lastname'];
		} else {
			$this->data['error_lastname'] = '';
		}
		
		if (isset($this->error['email'])) {
			$this->data['error_email'] = $this->error['email'];
		} else {
			$this->data['error_email'] = '';
		}	
	
		
		if (isset($this->error['password'])) { 
			$this->data['error_password'] = $this->error['password'];
		} else {
			$this->data['error_password'] = '';
		}

		if (isset($this->error['confirm'])) { 
			$this->data['error_confirm'] = $this->error['confirm'];
		} else {
			$this->data['error_confirm'] = '';
		}

	//	$this->data['action'] = $this->url->link('account/overall', '', 'SSL');
		$this->data['action'] = $this->url->link('account/overall&cid=' . $_GET["cid"], 'SSL');
		
		if (isset($this->request->post['comment'])) {
    		$this->data['comment'] = $this->request->post['comment'];
		} else {
			$this->data['comment'] = '';
		}
		
		if (isset($this->request->post['contest_id'])) {
    		$this->data['contest_id'] = $this->request->post['contest_id'];
		} else {
			$this->data['contest_id'] = '';
		}
		
		// Overall Entries Tab - Starts
		
		$this->data['sketch_masters'] = array();
		
		$this->load->model('account/customer');
		$this->load->model('desaccount/designer');
		$this->load->model('tool/image');
		
		$this->data['con_id'] = $_GET['cid'];
		
		$this->data['con_name'] =	$this->model_desaccount_designer->get_contest_name($this->data['con_id']);
		$this->data['con_status'] =	$this->model_desaccount_designer->getStatus($this->data['con_id']);
		$this->data['con_status_name'] =	$this->model_desaccount_designer->getStatusname($this->data['con_status']);
		$this->data['customer_id'] =	$this->customer->isLogged();
		
		$results = $this->model_account_customer->getsketchesmaster($this->data['con_id']);
		
		foreach ($results as $result) {
		
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], 175, 175);
			} else {
				$image = false;
			}
			
			$this->data['sketch_masters'][] = array(
					'contest_id'  => $result['contest_id'],
					'sketch_id'  => $result['sketch_id'],
					'rating'  => $result['rating'],
					'winner'  => $result['winner'],
					'eliminated'  => $result['eliminated'],
					'withdrawn'  => $result['withdrawn'],
					'reported'  => $result['reported'],
					'sketch_assignment_id'  => $result['sketch_assignment_id'],
					'designer_id'  => $this->model_account_customer->getdesignername($result['designer_id']),
					'design_id'  => $result['designer_id'],
					'thumb'       => $image
				);
		}
		
		// Overall Entries Tab - Ends
		
		// $this->data['attribute_groups'] = $this->model_account_customer->get_designer_prof_pics();
		// Overall Designers Tab - Starts
		
		$this->data['profile_pics'] = array();
		
		$results = $this->model_account_customer->get_designer_prof_pics();
		
		if( $results != ''){
		foreach ($results as $result) {
			if ($result['profileimg']) {
				$profileimg = $this->model_tool_image->resize($result['profileimg'], 140, 140);
			} else {
				$profileimg = false;
			}
			
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], 175, 175);
			} else {
				$image = false;
			}
				
			$this->data['profile_pics'][] = array(
					'thumb'       => $image,
					'designer_id'  => $result['designer_id'],
					'thumb_prof'       => $profileimg
				);
		}
		}
		// Overall Designers Tab - Ends
		
		
		// sketch id retriving from db - ends

		$this->data['sketch_ids'] = array();
		
		$results = $this->model_account_customer->getsketchid($this->data['con_id']);	
		
		foreach ($results as $result) {
				$this->data['sketch_ids'][] = array(
					'designer_id'  => $result['designer_id'],
					'rating'  => $result['rating'],
					'winner'  => $result['winner'],
					'eliminated'  => $result['eliminated'],
					'withdrawn'  => $result['withdrawn'],
					'designer_name'  => $this->model_account_customer->getdesignername($result['designer_id']),
					'designer_sketch'  => $this->model_account_customer->get_sketchid_for_designer($result['designer_id']),
					'designerimage'  => $this->model_tool_image->resize($result['designerimage'], 100, 100),
					'sketchimage'  => $this->model_tool_image->resize($result['sketchimage'], 170, 170)
				);
		}	
		
		// sketch id retriving from db - ends
		
		// brief starts here
		
		$this->data['cur_cus_id'] = $this->model_account_customer->getsketchesmaster($this->data['con_id']);
		
		$this->data['customers'] = array();
		
		$results = $this->model_account_customer->getCusdetails($this->data['con_id']);
		
		foreach ($results as $result) {
		
				$this->data['customers'][] = array(
					'customer_id'  			=> $result['customer_id'],
					'special_ocassion' 	 	=> $result['special_ocassion'],
					'prize_amount'  		=> $result['prize_amount'],
					'name'  		=> $result['name'],
					'masculine_feminine'  	=> $result['masculine_feminine'],
					'youthful_mature'  		=> $result['youthful_mature'],
					'funky_graceful' 	 	=> $result['funky_graceful'],
					'bold_subtle'  			=> $result['bold_subtle'],
					'simple_intricate'  	=> $result['simple_intricate'],
					'classic_contemporary'  => $result['classic_contemporary'],
					'name'  			    => $result['firstname'].' '.$result['lastname'],
					'description'			=> $result['description'],
					'born'  				=> $result['born'],
					'email'  				=> $result['email']
				);
		}
		
		$this->data['customers_uploads_img'] = $this->model_account_customer->getCusdetails2($this->data['con_id']);		

		$this->data['customers_uploads_result'] = $this->model_tool_image->resize($this->data['customers_uploads_img'], 175, 175);
	
		$this->data['multi_images'] = array();
		
		$results = $this->model_account_customer->getting_multi_imgs($this->data['con_id']);
		
		foreach ($results as $result) {
			
		$this->data['multi_images'][] = array(
					'selectedimage'  => $this->model_tool_image->resize($result['image'], 175, 175)
		);
		
		}
		
		
		$this->data['cust_comments'] = array();
		$this->data['current_customer'] = $this->customer->getid();
		$results = $this->model_account_customer->get_cust_comments($this->data['con_id']);
		
		foreach ($results as $result) {
			
		$this->data['cust_comments'][] = array(
					'contest_id'  => $result['contest_id'],
					'comment'  => $result['comment'],
					'creation_date_time'  => $result['creation_date_time'],
					'customer_designer_id'  => $this->model_account_customer->cus_name_commnt($result['customer_designer_id'])
		);
		
		}
		

		if ($this->request->server['REQUEST_METHOD'] != 'POST') {
			$customer_info = $this->model_account_customer->getCustomer($this->customer->getId());
		}

		if (isset($this->request->post['firstname'])) {
			$this->data['firstname'] = $this->request->post['firstname'];
		} elseif (isset($customer_info)) {
			$this->data['firstname'] = $customer_info['firstname'];
		} else {
			$this->data['firstname'] = '';
		}

		if (isset($this->request->post['lastname'])) {
			$this->data['lastname'] = $this->request->post['lastname'];
		} elseif (isset($customer_info)) {
			$this->data['lastname'] = $customer_info['lastname'];
		} else {
			$this->data['lastname'] = '';
		}

		if (isset($this->request->post['email'])) {
			$this->data['email'] = $this->request->post['email'];
		} elseif (isset($customer_info)) {
			$this->data['email'] = $customer_info['email'];
		} else {
			$this->data['email'] = '';
		}

		if (isset($this->request->post['newsletter'])) {
			$this->data['newsletter'] = $this->request->post['newsletter'];
		} else {
			$this->data['newsletter'] = '';
		}
		
		if (isset($this->request->post['password'])) {
    		$this->data['password'] = $this->request->post['password'];
		} else {
			$this->data['password'] = '';
		}

		if (isset($this->request->post['confirm'])) {
    		$this->data['confirm'] = $this->request->post['confirm'];
		} else {
			$this->data['confirm'] = '';
		}
		
		// address Starts
		
		$this->data['button_edit'] = $this->language->get('button_edit');
		$this->data['entry_newsletter'] = $this->language->get('entry_newsletter');
    	$this->data['button_delete'] = $this->language->get('button_delete');
		
		$this->data['addresses'] = array();
		$this->load->model('account/address');
		$results = $this->model_account_address->getAddresses();

    	foreach ($results as $result) {
			if ($result['address_format']) {
      			$format = $result['address_format'];
    		} else {
				$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
			}
		
    		$find = array(
	  			'{firstname}',
	  			'{lastname}',
	  			'{company}',
      			'{address_1}',
      			'{address_2}',
     			'{city}',
      			'{postcode}',
      			'{zone}',
				'{zone_code}',
      			'{country}'
			);
	
			$replace = array(
	  			'firstname' => $result['firstname'],
	  			'lastname'  => $result['lastname'],
	  			'company'   => $result['company'],
      			'address_1' => $result['address_1'],
      			'address_2' => $result['address_2'],
      			'city'      => $result['city'],
      			'postcode'  => $result['postcode'],
      			'zone'      => $result['zone'],
				'zone_code' => $result['zone_code'],
      			'country'   => $result['country']  
			);

      		$this->data['addresses'][] = array(
        		'address_id' => $result['address_id'],
        		'address'    => str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format)))),
        		'update'     => $this->url->link('account/address/update', 'address_id=' . $result['address_id'], 'SSL'),
				'delete'     => $this->url->link('account/address/delete', 'address_id=' . $result['address_id'], 'SSL')
      		);
    	}
		
		$this->data['newsletter'] = $this->customer->getNewsletter();
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		
		// address Ends

		$this->data['back'] = $this->url->link('account/account', '', 'SSL');

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/account/overall.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/account/overall.tpl';
		} else {
			$this->template = 'default/template/account/overall.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());	
	}
	public function rating() {
		$this->db->query("UPDATE " . DB_PREFIX . "contest_sketch_assignment SET rating = '" . $this->request->get['rate'] . "' WHERE sketch_assignment_id = '" . $this->request->post['sketch_id'] . "'");
			
			$mailcmd = $this->db->query("SELECT distinct d.email,d.dispname,c.firstname,csa.contest_id from " . DB_PREFIX . "designer d ," . DB_PREFIX . "contest_sketch_assignment csa ," . DB_PREFIX . "sketches_master sm ," . DB_PREFIX . "customer c , " . DB_PREFIX . "contest_master cm where csa.sketch_id = sm.sketch_id and cm.customer_id = c.customer_id and sm.designer_id = d.designer_id and csa.sketch_assignment_id = '" . $this->request->post['sketch_id'] . "' and csa.contest_id=cm.contest_id");
			
			$storelogo = $this->db->query("	SELECT value FROM `setting` a,contest_master b where `key`='config_logo' and a.store_id=b.store_id and b.contest_id='" . $mailcmd->row['contest_id'] . "'");
			$contestlogo='<p>	<img alt="" src="'. HTTPS_IMAGE . $storelogo->row['value'] .'"  /></p>' . '<br>';

			$subject = 'Message from customer';
			if($mailcmd->num_rows != 0)
			{			
			$link = HTTP_SERVER.'index.php?route=desaccount/overall&cid='. $mailcmd->row['contest_id'];

			$message = $contestlogo;	 		
			$message .= 'Hi '.$mailcmd->row['dispname'] . ',<br><br>';
			$message .= trim(ucfirst($mailcmd->row['firstname'])) . ' has just rated your design.<br><br>';
			$message .= 'View the rating here:' . "<br>" . $link . '<br><br>';			
			$message .= 'Regards <br><br>';
			$message .= 'Customer Service Team <br><br>';
			
			$emails = array();
			$emails[] = $mailcmd->row['email'];
			$emails = array_unique($emails);
			foreach ($emails as $email) {
				$mail = new Mail();
				$mail->protocol = $this->config->get('config_mail_protocol');
				$mail->parameter = $this->config->get('config_mail_parameter');
				$mail->hostname = $this->config->get('config_smtp_host');
				$mail->username = $this->config->get('config_smtp_username');
				$mail->password = $this->config->get('config_smtp_password');
				$mail->port = $this->config->get('config_smtp_port');
				$mail->timeout = $this->config->get('config_smtp_timeout');				
				$mail->setTo($email);
		  		$mail->setFrom($this->config->get('config_email'));
		  		$mail->setSender($this->config->get('config_name'));
	  			$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
	  			$mail->setHtml((html_entity_decode($message, ENT_QUOTES, 'UTF-8')));
			//	$mail->addAttachment(DIR_IMAGE . $this->config->get('config_logo'));
	      		$mail->send();
			}
		}
		  
	}
	public function item() {
		$this->db->query("UPDATE " . DB_PREFIX . "contest_sketch_assignment SET " . $this->request->get['title'] . " = 'y'  WHERE sketch_assignment_id = '" . $this->request->post['sketch_id'] . "'");
		if($this->request->get['title'] == 'winner'){
			$query = $this->db->query("SELECT contest_id FROM " . DB_PREFIX . "contest_sketch_assignment WHERE sketch_assignment_id = '" . $this->request->post['sketch_id'] . "'");
			$this->db->query("UPDATE " . DB_PREFIX . "contest_master SET status = 4  WHERE contest_id = '" . $query->row['contest_id'] . "'");
			
			
			$storelogo = $this->db->query("	SELECT value FROM `setting` a,contest_master b where `key`='config_logo' and a.store_id=b.store_id and b.contest_id='" . $query->row['contest_id'] . "'");
			$contestlogo='<p>	<img alt="" src="'. HTTPS_IMAGE . $storelogo->row['value'] .'"  /></p>' . '<br>';

			
			// Mail to Winner
			$mailcmd = $this->db->query("SELECT distinct cm.store_id,d.email,cm.name,sm.sketch_id ,d.email,d.dispname,c.firstname,csa.contest_id from " . DB_PREFIX . "designer d ," . DB_PREFIX . "contest_sketch_assignment csa ," . DB_PREFIX . "sketches_master sm ," . DB_PREFIX . "customer c , " . DB_PREFIX . "contest_master cm where csa.sketch_id = sm.sketch_id and cm.customer_id = c.customer_id and sm.designer_id = d.designer_id and csa.sketch_assignment_id = '" . $this->request->post['sketch_id'] . "' and csa.contest_id=cm.contest_id");
			$designerwin=$mailcmd->row['dispname']; 
			$contestid=$mailcmd->row['contest_id'];
			$sketchwinid=$mailcmd->row['sketch_id'];
			$contestname=$mailcmd->row['name'];
			$designeremail=$mailcmd->row['email'];
			
		  if($mailcmd->num_rows != 0)
		  {			
			$link = HTTP_SERVER.'index.php?route=desaccount/overall&cid='. $contestid;
			$this->load->model('catalog/information');
			$information_info = $this->model_catalog_information->getInformation(41);
			
//			$subject = html_entity_decode($information_info['title'], ENT_QUOTES, 'UTF-8');
			$subject = 'Congratulations!';
			
			$message = $contestlogo . html_entity_decode($information_info['description'], ENT_QUOTES, 'UTF-8');
			$message = str_replace('%DesingerDisplayName%',$mailcmd->row['dispname'],$message);
			$message = str_replace('%Contest Id%',$mailcmd->row['contest_id'],$message);
			$message = str_replace('%DesignId%',$mailcmd->row['sketch_id'],$message);
			$message = str_replace('%ContestName%',$contestname,$message);
			
			$winnerid='';
			$emails = array();
			$emails[] = $mailcmd->row['email'];
			$emails = array_unique($emails);
			foreach ($emails as $email) {
				$mail = new Mail();
				$mail->protocol = $this->config->get('config_mail_protocol');
				$mail->parameter = $this->config->get('config_mail_parameter');
				$mail->hostname = $this->config->get('config_smtp_host');
				$mail->username = $this->config->get('config_smtp_username');
				$mail->password = $this->config->get('config_smtp_password');
				$mail->port = $this->config->get('config_smtp_port');
				$mail->timeout = $this->config->get('config_smtp_timeout');				
				$mail->setTo($email);
//				$mail->setCc($this->config->get('config_email');
		  		$mail->setFrom($this->config->get('config_email'));
		  		$mail->setSender($this->config->get('config_name'));
	  			$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
	  			$mail->setHtml((html_entity_decode($message, ENT_QUOTES, 'UTF-8')));
	      		$mail->send();
			}
			
			
		  // Mail to Customer
		    $link = HTTP_SERVER.'index.php?route=desaccount/overall&cid='. $contestid;
			$this->load->model('catalog/information');
			
			$information_info = $this->model_catalog_information->getInformation(42); 
			$subject = html_entity_decode($information_info['title'], ENT_QUOTES, 'UTF-8');
			$subject = 'Winner Announced!';
			$message = $contestlogo . html_entity_decode($information_info['description'], ENT_QUOTES, 'UTF-8');
			
			$message = str_replace('%CustomerFirstName%',$this->customer->getFirstName(),$message);
			$message = str_replace('%Contest Id%',$contestid,$message);
			$message = str_replace('%ContestName%',$contestname,$message);
			
				$mail = new Mail();
				$mail->protocol = $this->config->get('config_mail_protocol');
				$mail->parameter = $this->config->get('config_mail_parameter');
				$mail->hostname = $this->config->get('config_smtp_host');
				$mail->username = $this->config->get('config_smtp_username');
				$mail->password = $this->config->get('config_smtp_password');
				$mail->port = $this->config->get('config_smtp_port');
				$mail->timeout = $this->config->get('config_smtp_timeout');				
				$mail->setTo($this->customer->getEmail());
//				$mail->setCc($this->config->get('config_email');
		  		$mail->setFrom($this->config->get('config_email'));
		  		$mail->setSender($this->config->get('config_name'));
	  			$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
	  			$mail->setHtml((html_entity_decode($message, ENT_QUOTES, 'UTF-8')));
	      		$mail->send();
			
		  
		  // Except the winner
			
			$information_info = $this->model_catalog_information->getInformation(40); 
//			$subject = html_entity_decode($information_info['title'], ENT_QUOTES, 'UTF-8');
			$subject = 'Contest closed- thanks for participating';
			$message1 = $contestlogo .  html_entity_decode($information_info['description'], ENT_QUOTES, 'UTF-8');
			$message1 = str_replace('%Contest Id%',$contestid,$message1);
			$message1 = str_replace('%ContestName%',$contestname,$message1);
			
		  $alldesignersmaster = $this->db->query("SELECT distinct d.email,csa.contest_id,  sm.designer_id,d.dispname, csa.contest_id  from designer d ,contest_sketch_assignment csa ,sketches_master sm ,contest_master cm where csa.sketch_id = sm.sketch_id and sm.designer_id = d.designer_id   and csa.contest_id=cm.contest_id and cm.contest_id =  '". $contestid . "'");
//		  $this->log->write($alldesignersmaster->num_rows . ' ' . $designeremail . ' '  );

		  if($alldesignersmaster->num_rows != 0)
		  {		
			$link = HTTP_SERVER.'index.php?route=desaccount/overall&cid='. $contestid; 
			$this->load->model('catalog/information');
			$alldesigners = $alldesignersmaster->rows;

			foreach ($alldesigners  as $alldesigner) {
			    //$this->log->write($designeremail . ' - ' . $alldesigner['email'] . ' - ' . $alldesigner['dispname']  );
				$message2 = str_replace('%DesignerDisplayName%',$alldesigner['dispname'],$message1);
				if($designeremail != $alldesigner['email']){
				$mail = new Mail();
				$mail->protocol = $this->config->get('config_mail_protocol');
				$mail->parameter = $this->config->get('config_mail_parameter');
				$mail->hostname = $this->config->get('config_smtp_host');
				$mail->username = $this->config->get('config_smtp_username');
				$mail->password = $this->config->get('config_smtp_password');
				$mail->port = $this->config->get('config_smtp_port');
				$mail->timeout = $this->config->get('config_smtp_timeout');				
				$mail->setTo($alldesigner['email']);
//				$mail->setCc($this->config->get('config_email');
		  		$mail->setFrom($this->config->get('config_email'));
		  		$mail->setSender($this->config->get('config_name'));
	  			$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
	  			$mail->setHtml((html_entity_decode($message2, ENT_QUOTES, 'UTF-8')));
	      		$mail->send();
				}
			}
			
		  }
			
			
		}
		  
	  }
	}

	private function validate() {
		if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen($this->request->post['firstname']) > 32)) {
			$this->error['firstname'] = $this->language->get('error_firstname');
		}

		if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen($this->request->post['lastname']) > 32)) {
			$this->error['lastname'] = $this->language->get('error_lastname');
		}

		if ((utf8_strlen($this->request->post['email']) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['email'])) {
			$this->error['email'] = $this->language->get('error_email');
		}
		
		if (($this->customer->getEmail() != $this->request->post['email']) && $this->model_account_customer->getTotalCustomersByEmail($this->request->post['email'])) {
			$this->error['warning'] = $this->language->get('error_exists');
		}


		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>