<?php
final class Valuer {
	private $valuer_id;
	private $firstname;
	private $lastname;
	private $email;
	private $telephone;
	private $fax;
	private $newsletter;
	private $valuer_group_id;
	private $address_id;
	
  	public function __construct($registry) {
		$this->config = $registry->get('config');
		$this->db = $registry->get('db');
		$this->request = $registry->get('request');
		$this->session = $registry->get('session');
				
		if (isset($this->session->data['valuer_id'])) { 
			$valuer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "valuer WHERE valuer_id = '" . (int)$this->session->data['valuer_id'] . "' AND status = '1'");
			
			if ($valuer_query->num_rows) {
				$this->valuer_id = $valuer_query->row['valuer_id'];
				$this->firstname = $valuer_query->row['firstname'];
				$this->lastname = $valuer_query->row['lastname'];
				$this->email = $valuer_query->row['email'];
				$this->telephone = $valuer_query->row['telephone'];
				$this->fax = $valuer_query->row['fax'];
				$this->newsletter = $valuer_query->row['newsletter'];
				$this->valuer_group_id = $valuer_query->row['valuer_group_id'];
				$this->address_id = $valuer_query->row['address_id'];
							
      			$this->db->query("UPDATE " . DB_PREFIX . "valuer SET cart = '" . $this->db->escape(isset($this->session->data['cart']) ? serialize($this->session->data['cart']) : '') . "', wishlist = '" . $this->db->escape(isset($this->session->data['wishlist']) ? serialize($this->session->data['wishlist']) : '') . "', ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "' WHERE valuer_id = '" . (int)$this->session->data['valuer_id'] . "'");
			
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "valuer_ip WHERE valuer_id = '" . (int)$this->session->data['valuer_id'] . "' AND ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "'");
				
				if (!$query->num_rows) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "valuer_ip SET valuer_id = '" . (int)$this->session->data['valuer_id'] . "', ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "', date_added = NOW()");
				}
			} else {
				$this->logout();
			}
  		}
	}
		
  	public function login($email, $password, $override = false) {
		if ($override) {
			$valuer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "valuer where LOWER(email) = '" . $this->db->escape(strtolower($email)) . "' AND status = '1'");
		} elseif (!$this->config->get('config_valuer_approval')) {
			$valuer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "valuer WHERE LOWER(email) = '" . $this->db->escape(strtolower($email)) . "' AND password = '" . $this->db->escape(md5($password)) . "' AND status = '1'");
		} else {
			$valuer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "valuer WHERE LOWER(email) = '" . $this->db->escape(strtolower($email)) . "' AND password = '" . $this->db->escape(md5($password)) . "' AND status = '1' AND approved = '1'");
		}
		
		if ($valuer_query->num_rows) {
			$this->session->data['valuer_id'] = $valuer_query->row['valuer_id'];	
		    
			if ($valuer_query->row['cart'] && is_string($valuer_query->row['cart'])) {
				$cart = unserialize($valuer_query->row['cart']);
				
				foreach ($cart as $key => $value) {
					if (!array_key_exists($key, $this->session->data['cart'])) {
						$this->session->data['cart'][$key] = $value;
					} else {
						$this->session->data['cart'][$key] += $value;
					}
				}			
			}

			if ($valuer_query->row['wishlist'] && is_string($valuer_query->row['wishlist'])) {
				if (!isset($this->session->data['wishlist'])) {
					$this->session->data['wishlist'] = array();
				}
								
				$wishlist = unserialize($valuer_query->row['wishlist']);
			
				foreach ($wishlist as $product_id) {
					if (!in_array($product_id, $this->session->data['wishlist'])) {
						$this->session->data['wishlist'][] = $product_id;
					}
				}			
			}
									
			$this->valuer_id = $valuer_query->row['valuer_id'];
			$this->firstname = $valuer_query->row['firstname'];
			$this->lastname = $valuer_query->row['lastname'];
			$this->email = $valuer_query->row['email'];
			$this->telephone = $valuer_query->row['telephone'];
			$this->fax = $valuer_query->row['fax'];
			$this->newsletter = $valuer_query->row['newsletter'];
			$this->valuer_group_id = $valuer_query->row['valuer_group_id'];
			$this->address_id = $valuer_query->row['address_id'];
          	
			$this->db->query("UPDATE " . DB_PREFIX . "valuer SET ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "' WHERE valuer_id = '" . (int)$valuer_query->row['valuer_id'] . "'");
			
	  		return true;
    	} else {
      		return false;
    	}
  	}
  	
	public function logout() {
		unset($this->session->data['valuer_id']);

		$this->valuer_id = '';
		$this->firstname = '';
		$this->lastname = '';
		$this->email = '';
		$this->telephone = '';
		$this->fax = '';
		$this->newsletter = '';
		$this->valuer_group_id = '';
		$this->address_id = '';
  	}
  
  	public function isLogged() {
    	return $this->valuer_id;
  	}

  	public function getId() {
    	return $this->valuer_id;
  	}
      
  	public function getFirstName() {
		return $this->firstname;
  	}
  
  	public function getLastName() {
		return $this->lastname;
  	}
  
  	public function getEmail() {
		return $this->email;
  	}
  
  	public function getTelephone() {
		return $this->telephone;
  	}
  
  	public function getFax() {
		return $this->fax;
  	}
	
  	public function getNewsletter() {
		return $this->newsletter;	
  	}

  	public function getvaluerGroupId() {
		return $this->valuer_group_id;	
  	}
	
  	public function getAddressId() {
		return $this->address_id;	
  	}
	
  	public function getBalance() {
		$query = $this->db->query("SELECT SUM(amount) AS total FROM " . DB_PREFIX . "valuer_transaction WHERE valuer_id = '" . (int)$this->valuer_id . "'");
	
		return $query->row['total'];
  	}	
		
  	public function getRewardPoints() {
		$query = $this->db->query("SELECT SUM(points) AS total FROM " . DB_PREFIX . "valuer_reward WHERE valuer_id = '" . (int)$this->valuer_id . "'");
	
		return $query->row['total'];	
  	}	
}
?>