<?php
class ModelTotalGiftWrap extends Model {
	public function getTotal(&$total_data, &$total, &$taxes) {

			$this->load->language('total/gift_wrap');
			$package_cost = 0;
			if($this->config->get('calculation_base')=='per_order'){
				$package_cost = $this->config->get('gift_wrap_fee');
			}
			if($this->config->get('calculation_base')=='per_product'){
				$package_cost = $this->config->get('gift_wrap_fee') * $this->cart->countProducts();
			}
			if($this->config->get('calculation_base')=='per_item'){
				$package_cost = $this->config->get('gift_wrap_fee') * $this->cart->hasProducts();
			}
			$total_data[] = array( 
				'code'       => 'gift_wrap',
        		'title'      => $this->language->get('text_gift'),
        		'text'       => $this->currency->format($package_cost),
        		'value'      => $package_cost,
				'sort_order' => $this->config->get('gift_wrap_sort_order')
			);

			if ($this->config->get('gift_wrap_tax_class_id')) {
				$tax_rates = $this->tax->getRates($package_cost, $this->config->get('gift_wrap_tax_class_id'));
				
				foreach ($tax_rates as $tax_rate) {
					if (!isset($taxes[$tax_rate['tax_rate_id']])) {
						$taxes[$tax_rate['tax_rate_id']] = $tax_rate['amount'];
					} else {
						$taxes[$tax_rate['tax_rate_id']] += $tax_rate['amount'];
					}
				}
			}
			
			$total += $package_cost;
		
	}
}
?>