<?php
class ControllerValuersEdit extends Controller {
	private $error = array();
 
	public function index() {
		if (!$this->valuer->isLogged()) {
			$this->session->data['redirect'] = $this->url->link('valuers/edit', '', 'SSL');

			$this->redirect($this->url->link('valuers/login', '', 'SSL'));
		}

		$this->language->load('valuers/edit');
		
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('valuers/valuer');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_valuers_valuer->editvaluer($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('valuers/account', '', 'SSL'));
		}

      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),     	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('valuers/account', '', 'SSL'),        	
        	'separator' => $this->language->get('text_separator')
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_edit'),
			'href'      => $this->url->link('valuers/edit', '', 'SSL'),       	
        	'separator' => $this->language->get('text_separator')
      	);
		
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_your_details'] = $this->language->get('text_your_details');

		$this->data['entry_firstname'] = $this->language->get('entry_firstname');
		$this->data['entry_lastname'] = $this->language->get('entry_lastname');
		$this->data['entry_email'] = $this->language->get('entry_email');
		$this->data['entry_fax'] = $this->language->get('entry_fax');
		$this->data['entry_password'] = $this->language->get('entry_password');
    	$this->data['entry_confirm'] = $this->language->get('entry_confirm');
    	$this->data['entry_dispname'] = $this->language->get('entry_dispname');
    	$this->data['entry_qualification'] = $this->language->get('entry_qualification');
    	$this->data['entry_certificates'] = $this->language->get('entry_certificates');
    	$this->data['entry_profpic'] = $this->language->get('entry_profpic');
		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');	
		$this->data['entry_gender'] = $this->language->get('entry_gender');	
		$this->data['text_male'] = $this->language->get('text_male');	
		$this->data['text_female'] = $this->language->get('text_female');	
		$this->data['text_english'] = $this->language->get('text_english');	
		$this->data['text_french'] = $this->language->get('text_french');	
		$this->data['text_italin'] = $this->language->get('text_italin');	
		$this->data['entry_yourself'] = $this->language->get('entry_yourself');	
		$this->data['entry_langknown'] = $this->language->get('entry_langknown');	
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['text_cheque'] = $this->language->get('text_cheque');
		$this->data['text_paypal'] = $this->language->get('text_paypal');
		$this->data['text_money'] = $this->language->get('text_money');
		$this->data['text_bank'] = $this->language->get('text_bank');
		$this->data['entry_paypalemail'] = $this->language->get('entry_paypalemail');
		$this->data['text_cheque'] = $this->language->get('text_cheque');
		$this->data['text_paypal'] = $this->language->get('text_paypal');
		$this->data['text_moneybrookers'] = $this->language->get('text_moneybrookers');
		$this->data['text_banktransfer'] = $this->language->get('text_banktransfer');
		
		$this->data['entry_bank_name'] = $this->language->get('entry_bank_name');
		$this->data['entry_bank_branch_number'] = $this->language->get('entry_bank_branch_number');
		$this->data['entry_bank_swift_code'] = $this->language->get('entry_bank_swift_code');
		$this->data['entry_bank_account_name'] = $this->language->get('entry_bank_account_name');
		$this->data['entry_bank_account_number'] = $this->language->get('entry_bank_account_number');
		$this->data['text_cheque_payeename'] = $this->language->get('text_cheque_payeename');

		$this->data['button_continue'] = $this->language->get('button_continue');
		$this->data['button_back'] = $this->language->get('button_back');
		
		$this->data['insert'] = $this->url->link('valuers/address/insert', '', 'SSL');

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['firstname'])) {
			$this->data['error_firstname'] = $this->error['firstname'];
		} else {
			$this->data['error_firstname'] = '';
		}

		if (isset($this->error['lastname'])) {
			$this->data['error_lastname'] = $this->error['lastname'];
		} else {
			$this->data['error_lastname'] = '';
		}
		
		if (isset($this->error['email'])) {
			$this->data['error_email'] = $this->error['email'];
		} else {
			$this->data['error_email'] = '';
		}	
	
		
		if (isset($this->error['password'])) { 
			$this->data['error_password'] = $this->error['password'];
		} else {
			$this->data['error_password'] = '';
		}

		if (isset($this->error['confirm'])) { 
			$this->data['error_confirm'] = $this->error['confirm'];
		} else {
			$this->data['error_confirm'] = '';
		}

		$this->data['action'] = $this->url->link('valuers/edit', '', 'SSL');

		if ($this->request->server['REQUEST_METHOD'] != 'POST') {
			$valuer_info = $this->model_valuers_valuer->getvaluer($this->valuer->getId());
		}
		$this->load->model('tool/image');
		
		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);	

		if (isset($this->request->post['image'])) {
			$this->data['image'] = $this->request->post['image'];
		} elseif (isset($valuer_info)) {
			$this->data['image'] = $this->model_tool_image->resize($valuer_info['image'], 100, 100);
		} else {
			$this->data['image'] =  'no_image.jpg';
		}
		if (isset($this->request->post['thumb'])) {
			$this->data['thumb'] = $this->request->post['thumb'];
		} elseif (isset($valuer_info)) {
			$this->data['thumb'] = $this->model_tool_image->resize($valuer_info['image'], 100, 100);
		} else {
		$this->data['thumb'] = 'no_image.jpg';
		}
		if (isset($this->request->post['firstname'])) {
			$this->data['firstname'] = $this->request->post['firstname'];
		} elseif (isset($valuer_info)) {
			$this->data['firstname'] = $valuer_info['firstname'];
		} else {
			$this->data['firstname'] = '';
		}

		if (isset($this->request->post['lastname'])) {
			$this->data['lastname'] = $this->request->post['lastname'];
		} elseif (isset($valuer_info)) {
			$this->data['lastname'] = $valuer_info['lastname'];
		} else {
			$this->data['lastname'] = '';
		}

		if (isset($this->request->post['email'])) {
			$this->data['email'] = $this->request->post['email'];
		} elseif (isset($valuer_info)) {
			$this->data['email'] = $valuer_info['email'];
		} else {
			$this->data['email'] = '';
		}

		if (isset($this->request->post['gender'])) {
			$this->data['gender'] = $this->request->post['gender'];
		} elseif (isset($valuer_info)) {
			$this->data['gender'] = $valuer_info['gender'];
		} else {
			$this->data['gender'] = '';
		}

		if (isset($this->request->post['bank_name'])) {
			$this->data['bank_name'] = $this->request->post['bank_name'];
		} elseif (isset($valuer_info)) {
			$this->data['bank_name'] = $valuer_info['bank_name'];
		} else {
			$this->data['bank_name'] = '';
		}

		if (isset($this->request->post['bank_branch_number'])) {
			$this->data['bank_branch_number'] = $this->request->post['bank_branch_number'];
		} elseif (isset($valuer_info)) {
			$this->data['bank_branch_number'] = $valuer_info['bank_branch_number'];
		} else {
			$this->data['bank_branch_number'] = '';
		}

		if (isset($this->request->post['bank_swift_code'])) {
			$this->data['bank_swift_code'] = $this->request->post['bank_swift_code'];
		} elseif (isset($valuer_info)) {
			$this->data['bank_swift_code'] = $valuer_info['bank_swift_code'];
		} else {
			$this->data['bank_swift_code'] = '';
		}

		if (isset($this->request->post['bank_account_name'])) {
			$this->data['bank_account_name'] = $this->request->post['bank_account_name'];
		} elseif (isset($valuer_info)) {
			$this->data['bank_account_name'] = $valuer_info['bank_account_name'];
		} else {
			$this->data['bank_account_name'] = '';
		}

		if (isset($this->request->post['bank_account_number'])) {
			$this->data['bank_account_number'] = $this->request->post['bank_account_number'];
		} elseif (isset($valuer_info)) {
			$this->data['bank_account_number'] = $valuer_info['bank_account_number'];
		} else {
			$this->data['bank_account_number'] = '';
		}

		if (isset($this->request->post['lang'])) {
			$this->data['lang'] = $this->request->post['lang'];
		} elseif (!empty($valuer_info)) {
			$this->data['lang'] = $valuer_info['lang'];
		} else {
			$this->data['lang'] = 0;
		}

		if (isset($this->request->post['lang2'])) {
			$this->data['lang2'] = $this->request->post['lang2'];
		} elseif (!empty($valuer_info)) {
			$this->data['lang2'] = $valuer_info['lang2'];
		} else {
			$this->data['lang2'] = 0;
		}

		if (isset($this->request->post['lang1'])) {
			$this->data['lang1'] = $this->request->post['lang1'];
		} elseif (!empty($valuer_info)) {
			$this->data['lang1'] = $valuer_info['lang1'];
		} else {
			$this->data['lang1'] = 0;
		}

		if (isset($this->request->post['dispname'])) {
			$this->data['dispname'] = $this->request->post['dispname'];
		} elseif (isset($valuer_info)) {
			$this->data['dispname'] = $valuer_info['dispname'];
		} else {
			$this->data['dispname'] = '';
		}

		if (isset($this->request->post['qualification'])) {
			$this->data['qualification'] = $this->request->post['qualification'];
		} elseif (isset($valuer_info)) {
			$this->data['qualification'] = $valuer_info['qualification'];
		} else {
			$this->data['qualification'] = '';
		}

		if (isset($this->request->post['about_yourself'])) {
			$this->data['about_yourself'] = $this->request->post['about_yourself'];
		} elseif (isset($valuer_info)) {
			$this->data['about_yourself'] = $valuer_info['about_yourself'];
		} else {
			$this->data['about_yourself'] = '';
		}

		if (isset($this->request->post['cheque'])) {
			$this->data['cheque'] = $this->request->post['cheque'];
		} elseif (!empty($valuer_info)) {
			$this->data['cheque'] = $valuer_info['cheque'];
		} else {
			$this->data['cheque'] = '';
		}

		if (isset($this->request->post['paypal'])) {
			$this->data['paypal'] = $this->request->post['paypal'];
		} elseif (isset($valuer_info)) {
			$this->data['paypal'] = $valuer_info['paypal'];
		} else {
			$this->data['paypal'] = '';
		}

		if (isset($this->request->post['moneybrookers'])) {
			$this->data['moneybrookers'] = $this->request->post['moneybrookers'];
		} elseif (!empty($valuer_info)) {
			$this->data['moneybrookers'] = $valuer_info['moneybrookers'];
		} else {
			$this->data['moneybrookers'] = '';
		}

		if (isset($this->request->post['payment'])) {
			$this->data['payment'] = $this->request->post['payment'];
		} elseif (!empty($valuer_info)) {
			$this->data['payment'] = $valuer_info['payment'];
		} else {
			$this->data['payment'] = 'cheque';
		}

		if (isset($this->request->post['banktransfer'])) {
			$this->data['banktransfer'] = $this->request->post['banktransfer'];
		} elseif (!empty($valuer_info)) {
			$this->data['banktransfer'] = $valuer_info['banktransfer'];
		} else {
			$this->data['banktransfer'] = '';
		}

		if (isset($this->request->post['paypalemail'])) {
			$this->data['paypalemail'] = $this->request->post['paypalemail'];
		} elseif (isset($valuer_info)) {
			$this->data['paypalemail'] = $valuer_info['paypalemail'];
		} else {
			$this->data['paypalemail'] = '';
		}

		if (isset($this->request->post['certificate'])) {
			$this->data['certificate'] = $this->request->post['certificate'];
		} else {
			$this->data['certificate'] = '';
		}

		if (isset($this->request->post['newsletter'])) {
			$this->data['newsletter'] = $this->request->post['newsletter'];
		} else {
			$this->data['newsletter'] = '';
		}
		
		if (isset($this->request->post['password'])) {
    		$this->data['password'] = $this->request->post['password'];
		} else {
			$this->data['password'] = '';
		}

		if (isset($this->request->post['confirm'])) {
    		$this->data['confirm'] = $this->request->post['confirm'];
		} else {
			$this->data['confirm'] = '';
		}
		
		// address Starts
		
		$this->data['button_edit'] = $this->language->get('button_edit');
		$this->data['entry_newsletter'] = $this->language->get('entry_newsletter');
    	$this->data['button_delete'] = $this->language->get('button_delete');
		
		$this->data['addresses'] = array();
		$this->load->model('valuers/address');
		$results = $this->model_valuers_address->getAddresses();

    	foreach ($results as $result) {
			if ($result['address_format']) {
      			$format = $result['address_format'];
    		} else {
				$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
			}
		
    		$find = array(
	  			'{firstname}',
	  			'{lastname}',
	  			'{company}',
      			'{address_1}',
      			'{address_2}',
     			'{city}',
      			'{postcode}',
      			'{zone}',
				'{zone_code}',
      			'{country}'
			);
	
			$replace = array(
	  			'firstname' => $result['firstname'],
	  			'lastname'  => $result['lastname'],
	  			'company'   => $result['company'],
      			'address_1' => $result['address_1'],
      			'address_2' => $result['address_2'],
      			'city'      => $result['city'],
      			'postcode'  => $result['postcode'],
      			'zone'      => $result['zone'],
				'zone_code' => $result['zone_code'],
      			'country'   => $result['country']  
			);

      		$this->data['addresses'][] = array(
        		'address_id' => $result['address_id'],
        		'address'    => str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format)))),
        		'update'     => $this->url->link('valuers/address/update', 'address_id=' . $result['address_id'], 'SSL'),
				'delete'     => $this->url->link('valuers/address/delete', 'address_id=' . $result['address_id'], 'SSL')
      		);
    	}
		
		$this->data['newsletter'] = $this->valuer->getNewsletter();
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		
		// address Ends

		$this->data['back'] = $this->url->link('valuers/account', '', 'SSL');

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/valuers/edit.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/valuers/edit.tpl';
		} else {
			$this->template = 'default/template/valuers/edit.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());	
	}
	
	public function upload() {
		
		$json = array();
		
		if (!empty($this->request->files['file']['name'])) {
			$filename = basename(html_entity_decode($this->request->files['file']['name'], ENT_QUOTES, 'UTF-8'));
			
			if ((strlen($filename) < 3) || (strlen($filename) > 128)) {
        		$json['error'] = $this->language->get('error_filename');
	  		}	  	
			
			$allowed = array();
			
			$filetypes = explode(',', "jpg, JPG, jpeg, gif, png, txt, doc, pdf, pptx");
			
			foreach ($filetypes as $filetype) {
				$allowed[] = trim($filetype);
			}
			
			if (!in_array(substr(strrchr($filename, '.'), 1), $allowed)) {
				$json['error'] = $this->language->get('error_filetype');
       		}	
						
			if ($this->request->files['file']['error'] != UPLOAD_ERR_OK) {
				$json['error'] = $this->language->get('error_upload_' . $this->request->files['file']['error']);
			}
		} else {
			$json['error'] = $this->language->get('error_upload');
		}
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && !isset($json['error'])) {
			if (is_uploaded_file($this->request->files['file']['tmp_name']) && file_exists($this->request->files['file']['tmp_name'])) {
				$file = basename($filename);
				
				// Hide the uploaded file name sop people can not link to it directly.
				$this->load->library('encryption');
				
				$encryption = new Encryption($this->config->get('config_encryption'));
				
				$json['file'] = $file;
				
				move_uploaded_file($this->request->files['file']['tmp_name'], DIR_CERTIFICATES . $file);
				
			}
						
			$json['success'] = $this->language->get('text_upload');
		}	
		
		$this->response->setOutput(json_encode($json));		
	}

	private function validate() {
		if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen($this->request->post['firstname']) > 32)) {
			$this->error['firstname'] = $this->language->get('error_firstname');
		}

		if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen($this->request->post['lastname']) > 32)) {
			$this->error['lastname'] = $this->language->get('error_lastname');
		}

		if ((utf8_strlen($this->request->post['email']) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['email'])) {
			$this->error['email'] = $this->language->get('error_email');
		}
		
		if (($this->valuer->getEmail() != $this->request->post['email']) && $this->model_valuers_valuer->getTotalvaluersByEmail($this->request->post['email'])) {
			$this->error['warning'] = $this->language->get('error_exists');
		}


		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>