<?php
class ControllerTotalGiftWrap extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('total/gift_wrap');

		
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->model_setting_setting->editSetting('gift_wrap', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect(HTTPS_SERVER . 'index.php?route=extension/total&token=' . $this->session->data['token']);
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_none'] = $this->language->get('text_none');
		$this->data['text_calculation_base'] = $this->language->get('text_calculation_base');
		$this->data['text_per_product']      = $this->language->get('text_per_product');
		$this->data['text_per_item']         = $this->language->get('text_per_item');
		$this->data['text_per_order']        = $this->language->get('text_per_order');
		$this->data['text_use_note_field']   = $this->language->get('text_use_note_field');

		$this->data['entry_fee'] = $this->language->get('entry_fee');
		$this->data['entry_tax'] = $this->language->get('entry_tax');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_total'),
			'href'      => $this->url->link('extension/total', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('total/handling', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
   		

		$this->data['action'] = HTTPS_SERVER . 'index.php?route=total/gift_wrap&token=' . $this->session->data['token'];

		$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=extension/total&token=' . $this->session->data['token'];

		if (isset($this->request->post['gift_wrap_fee'])) {
			$this->data['gift_wrap_fee'] = $this->request->post['gift_wrap_fee'];
		} else {
			$this->data['gift_wrap_fee'] = $this->config->get('gift_wrap_fee');
		}

		if (isset($this->request->post['gift_wrap_tax_class_id'])) {
			$this->data['gift_wrap_tax_class_id'] = $this->request->post['gift_wrap_tax_class_id'];
		} else {
			$this->data['gift_wrap_tax_class_id'] = $this->config->get('gift_wrap_tax_class_id');
		}

		if (isset($this->request->post['gift_wrap_status'])) {
			$this->data['gift_wrap_status'] = $this->request->post['gift_wrap_status'];
		} else {
			$this->data['gift_wrap_status'] = $this->config->get('gift_wrap_status');
		}

		if (isset($this->request->post['gift_wrap_sort_order'])) {
			$this->data['gift_wrap_sort_order'] = $this->request->post['gift_wrap_sort_order'];
		} else {
			$this->data['gift_wrap_sort_order'] = $this->config->get('gift_wrap_sort_order');
		}

		if (isset($this->request->post['calculation_base'])) {
			$this->data['calculation_base'] = $this->request->post['calculation_base'];
		} else {
			$this->data['calculation_base'] = $this->config->get('calculation_base');
		}

		if (isset($this->request->post['use_note_field'])) {
			$this->data['gift_wrap_use_note_field'] = $this->request->post['gift_wrap_use_note_field'];
		} else {
			$this->data['gift_wrap_use_note_field'] = $this->config->get('gift_wrap_use_note_field');
		}

		$this->load->model('localisation/tax_class');

		$this->data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

		$this->template = 'total/gift_wrap.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'total/gift_wrap')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
}
?>