<?php 
class ControllerSalelaboursettingcost extends Controller {
	private $error = array();
 
	public function index() {
		$this->load->language('sale/laboursettingcost');
 
		$this->document->setTitle($this->language->get('heading_title'));
 		
		$this->load->model('sale/laboursettingcost');
		
		$this->getList();
	}

	public function insert() {
		$this->load->language('sale/laboursettingcost');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/laboursettingcost');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_laboursettingcost->addCustomerGroup($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/laboursettingcost', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function update() {
		$this->load->language('sale/laboursettingcost');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/laboursettingcost');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_laboursettingcost->editCustomerGroup($this->request->get['setting_id'], $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/laboursettingcost', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function delete() { 
		$this->load->language('sale/laboursettingcost');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/laboursettingcost');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
      		foreach ($this->request->post['selected'] as $setting_id) {
				$this->model_sale_laboursettingcost->deleteCustomerGroup($setting_id);	
			}
						
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/laboursettingcost', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'shape';
		}
		 
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}	
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
			
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/laboursettingcost', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		$this->data['insert'] = $this->url->link('sale/laboursettingcost/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('sale/laboursettingcost/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	
	
		$this->data['laboursettingcosts'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$laboursettingcost_total = $this->model_sale_laboursettingcost->getTotalCustomerGroups();
		
		$results = $this->model_sale_laboursettingcost->getCustomerGroups($data);

		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/laboursettingcost/update', 'token=' . $this->session->data['token'] . '&setting_id=' . $result['setting_id'] . $url, 'SSL')
			);		
		
			$this->data['laboursettingcosts'][] = array(
				'setting_id' => $result['setting_id'],
				'setting'              => $result['setting'] . (($result['setting_id'] == $this->config->get('config_setting_id')) ? $this->language->get('text_default') : null),
				'cost' => $result['cost'],
				'selected'          => isset($this->request->post['selected']) && in_array($result['setting_id'], $this->request->post['selected']),
				'action'            => $action
			);
		}	
	
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_cost'] = $this->language->get('column_cost');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_shape'] = $this->url->link('sale/laboursettingcost', 'token=' . $this->session->data['token'] . '&sort=shape' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $laboursettingcost_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/laboursettingcost', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		
		$this->data['pagination'] = $pagination->render();				

		$this->data['sort'] = $sort; 
		$this->data['order'] = $order;

		$this->template = 'sale/laboursettingcost_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
 	}

	private function getForm() {
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_cost'] = $this->language->get('entry_cost');
		$this->data['entry_description'] = $this->language->get('entry_description');
		$this->data['entry_currency'] = $this->language->get('entry_currency');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['setting'])) {
			$this->data['error_setting'] = $this->error['setting'];
		} else {
			$this->data['error_setting'] = '';
		}
		
 		if (isset($this->error['cost'])) {
			$this->data['error_cost'] = $this->error['cost'];
		} else {
			$this->data['error_cost'] = '';
		}
		
 		if (isset($this->error['supplier_group_id'])) {
			$this->data['error_name'] = $this->error['supplier_group_id'];
		} else {
			$this->data['error_name'] = '';
		}

		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/laboursettingcost', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
			
		if (!isset($this->request->get['setting_id'])) {
			$this->data['action'] = $this->url->link('sale/laboursettingcost/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('sale/laboursettingcost/update', 'token=' . $this->session->data['token'] . '&setting_id=' . $this->request->get['setting_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('sale/laboursettingcost', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if (isset($this->request->get['setting_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$laboursettingcost_info = $this->model_sale_laboursettingcost->getCustomerGroup($this->request->get['setting_id']);
		}

		if (isset($this->request->post['setting'])) {
			$this->data['setting'] = $this->request->post['setting'];
		} elseif (isset($laboursettingcost_info)) {
			$this->data['setting'] = $laboursettingcost_info['setting'];
		} else {
			$this->data['setting'] = '';
		}

		if (isset($this->request->post['cost'])) {
			$this->data['cost'] = $this->request->post['cost'];
		} elseif (isset($laboursettingcost_info)) {
			$this->data['cost'] = $laboursettingcost_info['cost'];
		} else {
			$this->data['cost'] = '';
		}
		$this->load->model('sale/supplier_group');
		
    	$this->data['suppliers'] = $this->model_sale_supplier_group->getCustomerGroups();

    	if (isset($this->request->post['supplier_group_id'])) {
      		$this->data['supplier_group_id'] = $this->request->post['supplier_group_id'];
		} elseif (isset($laboursettingcost_info)) {
			$this->data['supplier_group_id'] = $laboursettingcost_info['supplier_group_id'];
		} else {
      		$this->data['supplier_group_id'] = '';
    	} 		
		
		if ($this->config->get('config_currency_auto')) {
			$this->load->model('localisation/currency');
		
			$this->model_localisation_currency->updateCurrencies();
		}	

		if (isset($this->request->post['ccurrency'])) {
			$this->data['ccurrency'] = $this->request->post['ccurrency'];
		} elseif (isset($laboursettingcost_info)) {
			$this->data['ccurrency'] = $laboursettingcost_info['ccurrency'];
		} else {
			$this->data['ccurrency'] = '';
		}
		
		$this->load->model('localisation/currency');
		
		$this->data['currencies'] = $this->model_localisation_currency->getCurrencies();
		
		
	
		$this->template = 'sale/laboursettingcost_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render()); 
	}

	private function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/laboursettingcost')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['setting']) < 1) || (utf8_strlen($this->request->post['setting']) > 64)) {
			$this->error['setting'] = $this->language->get('error_setting');
		}

		if ((utf8_strlen($this->request->post['cost']) < 1) || (utf8_strlen($this->request->post['cost']) > 64)) {
			$this->error['cost'] = $this->language->get('error_cost');
		}

		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	private function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/laboursettingcost')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$this->load->model('setting/store');
		$this->load->model('sale/customer');
      	
		foreach ($this->request->post['selected'] as $setting_id) {
    		if ($this->config->get('config_setting_id') == $setting_id) {
	  			$this->error['warning'] = $this->language->get('error_default');	
			}  
			
			$store_total = $this->model_setting_store->getTotalStoresByCustomerGroupId($setting_id);

			if ($store_total) {
				$this->error['warning'] = sprintf($this->language->get('error_store'), $store_total);
			}
			
			$customer_total = $this->model_sale_customer->getTotalCustomersByCustomerGroupId($setting_id);

			if ($customer_total) {
				$this->error['warning'] = sprintf($this->language->get('error_customer'), $customer_total);
			}
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>