<?php
class ControllerSaleGemstoneweight extends Controller {
	private $error = array();
   
	public function index() {
		$this->load->language('sale/gemstoneweight');
 
		$this->document->setTitle($this->language->get('heading_title'));
 		
		$this->load->model('sale/gemstoneweight');
		
		$this->getList();
	}

	public function insert() {
		$this->load->language('sale/gemstoneweight');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/gemstoneweight');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemstoneweight->addGemStoneWeight($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/gemstoneweight', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function update() {
		$this->load->language('sale/gemstoneweight');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/gemstoneweight');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemstoneweight->editGemStoneWeight($this->request->get['gemstoneweight_id'], $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/gemstoneweight', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function delete() { 
		$this->load->language('sale/gemstoneweight');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/gemstoneweight');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
      		foreach ($this->request->post['selected'] as $gemstoneweight_id) {
				$this->model_sale_gemstoneweight->deleteGemStoneWeight($gemstoneweight_id);	
			}
						
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/gemstoneweight', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'metal_code';
		}
		 
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}	
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
			
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/gemstoneweight', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		$this->data['insert'] = $this->url->link('sale/gemstoneweight/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('sale/gemstoneweight/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	
	
		$this->data['gemstoneweights'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$gemstoneweight_total = $this->model_sale_gemstoneweight->getTotalGemStoneWeights();
		
		$results = $this->model_sale_gemstoneweight->getGemStoneWeights($data);

		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/gemstoneweight/update', 'token=' . $this->session->data['token'] . '&gemstoneweight_id=' . $result['gemstoneweight_id'] . $url, 'SSL')
			);		
		
			$this->data['gemstoneses'][] = array(
				'gemstoneweight_id' => $result['gemstoneweight_id'],
				'gemname' => $result['gemname'],
				'gemstone_id' => $result['gemstone_id'],
				'weight' => $result['weight'],
			
				
				'selected'          => isset($this->request->post['selected']) && in_array($result['gemstoneweight_id'], $this->request->post['selected']),
				'action'            => $action
			);
		}	
	
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_gemstone'] = $this->language->get('column_gemstone');
		$this->data['column_action'] = $this->language->get('column_action');
		$this->data['column_weight'] = $this->language->get('column_weight');
		$this->data['column_cost'] = $this->language->get('column_cost');
		$this->data['column_weight'] = $this->language->get('column_weight');
			
		$this->data['column_appilicablecost'] = $this->language->get('column_appilicablecost');

		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_metal_code'] = $this->url->link('sale/gemstoneweight', 'token=' . $this->session->data['token'] . '&sort=metal_code' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $gemstoneweight_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/gemstoneweight', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		
		$this->data['pagination'] = $pagination->render();				

		$this->data['sort'] = $sort; 
		$this->data['order'] = $order;

		$this->template = 'sale/gemstoneweight_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
 	}

	private function getForm() {
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['entry_code'] = $this->language->get('entry_code');
		$this->data['entry_gemstone'] = $this->language->get('entry_gemstone');
		$this->data['entry_lowcolor'] = $this->language->get('entry_lowcolor');
		$this->data['entry_highcolor'] = $this->language->get('entry_highcolor');
		$this->data['entry_weight'] = $this->language->get('entry_weight');
		$this->data['entry_shape'] = $this->language->get('entry_shape');
		$this->data['entry_size'] = $this->language->get('entry_size');
		
		$this->data['entry_currency'] = $this->language->get('entry_currency');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['low_weight'])) {
			$this->data['error_low_weight'] = $this->error['low_weight'];
		} else {
			$this->data['error_low_weight'] = '';
		}
		
 		if (isset($this->error['high_weight'])) {
			$this->data['error_high_weight'] = $this->error['high_weight'];
		} else {
			$this->data['error_high_weight'] = '';
		}
		
 		if (isset($this->error['cost'])) {
			$this->data['error_cost'] = $this->error['cost'];
		} else {
			$this->data['error_cost'] = '';
		}
		
 		if (isset($this->error['weight'])) {
			$this->data['error_weight'] = $this->error['weight'];
		} else {
			$this->data['error_weight'] = '';
		}
		
 	
		
 		
		
 		
		
 		if (isset($this->error['code'])) {
			$this->data['error_code'] = $this->error['code'];
		} else {
			$this->data['error_code'] = '';
		}
		
 		if (isset($this->error['applicable_cost'])) {
			$this->data['error_applicable_cost'] = $this->error['applicable_cost'];
		} else {
			$this->data['error_applicable_cost'] = '';
		}

		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/gemstoneweight', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
			
		if (!isset($this->request->get['gemstoneweight_id'])) {
			$this->data['action'] = $this->url->link('sale/gemstoneweight/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('sale/gemstoneweight/update', 'token=' . $this->session->data['token'] . '&gemstoneweight_id=' . $this->request->get['gemstoneweight_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('sale/gemstoneweight', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if (isset($this->request->get['gemstoneweight_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$gemstoneweight_info = $this->model_sale_gemstoneweight->getGemStoneInfo($this->request->get['gemstoneweight_id']);
		}
		$this->load->model('sale/supplier_group');
		
    	$this->data['suppliers'] = $this->model_sale_supplier_group->getCustomerGroups();

    	if (isset($this->request->post['supplier_group_id'])) {
      		$this->data['supplier_group_id'] = $this->request->post['supplier_group_id'];
		} elseif (!empty($product_info)) {
			$this->data['supplier_group_id'] = $product_info['supplier_group_id'];
		} else {
      		$this->data['supplier_group_id'] = 0;
    	} 	
		if (isset($this->request->post['code'])) {
			$this->data['code'] = $this->request->post['code'];
		} elseif (isset($gemstoneweight_info)) {
			$this->data['code'] = $gemstoneweight_info['code'];
		} else {
			$this->data['code'] = '';
		}

		if (isset($this->request->post['weight'])) {
			$this->data['weight'] = $this->request->post['weight'];
		} elseif (isset($gemstoneweight_info)) {
			$this->data['weight'] = $gemstoneweight_info['weight'];
		} else {
			$this->data['weight'] = '';
		}

	

		

		

		
	
		
		
		
		$this->load->model('sale/gemstonelist');
			
		$this->data['gemstonelists'] = $this->model_sale_gemstonelist->getCustomerGroups();

    	if (isset($this->request->post['gemstone_id'])) {
      		$this->data['gemstone_id'] = $this->request->post['gemstone_id'];
    	} elseif (isset($gemstoneweight_info)) { 
			$this->data['gemstone_id'] = $gemstoneweight_info['gemstone_id'];
		} else {
      		$this->data['gemstone_id'] = '';
    	}
		
		$this->load->model('sale/clarity_master');
			
		$this->data['claritymasters'] = $this->model_sale_clarity_master->getCustomerGroups();

    	
	
		$this->load->model('sale/clarity_master');
			
		$this->data['highclaritymasters'] = $this->model_sale_clarity_master->getCustomerGroups();

    	
	
		$this->load->model('sale/colour_master');
			
		$this->data['lowcolorclaritys'] = $this->model_sale_colour_master->getCustomerGroups();

    	
	
		$this->load->model('sale/colour_master');
			
		$this->data['highcolorclaritys'] = $this->model_sale_colour_master->getCustomerGroups();

    	
		
		$this->load->model('sale/size_master');
			
		$this->data['sizes'] = $this->model_sale_size_master->getSizes();

    	if (isset($this->request->post['size_code'])) {
      		$this->data['size_code'] = $this->request->post['size_code'];
    	} elseif (isset($gemstoneweight_info)) { 
			$this->data['size_code'] = $gemstoneweight_info['size_code'];
		} 
		
		
		$this->load->model('sale/gemstone');
			
		$this->data['gemshapes'] = $this->model_sale_gemstone->getCustomerGroups();

    	if (isset($this->request->post['shape'])) {
      		$this->data['shape'] = $this->request->post['shape'];
    	} elseif (isset($gemstoneweight_info)) { 
			$this->data['shape'] = $gemstoneweight_info['shape'];
		} else {
      		$this->data['shape'] = $this->config->get('config_shape_id');
    	}
		
	
		$this->template = 'sale/gemstoneweight_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render()); 
	}

	private function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/gemstoneweight')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['weight']) < 1) || (utf8_strlen($this->request->post['weight']) > 64)) {
			$this->error['weight'] = $this->language->get('error_weight');
		}

		
		

		if ((utf8_strlen($this->request->post['code']) < 1) || (utf8_strlen($this->request->post['code']) > 64)) {
			$this->error['code'] = $this->language->get('error_code');
		}


		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	private function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/gemstoneweight')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$this->load->model('setting/store');
		$this->load->model('sale/customer');
      	
		foreach ($this->request->post['selected'] as $gemstoneweight_id) {
    		if ($this->config->get('config_gemstoneweight_id') == $gemstoneweight_id) {
	  			$this->error['warning'] = $this->language->get('error_default');	
			}  
			
			$store_total = $this->model_setting_store->getTotalStoresByCustomerGroupId($gemstoneweight_id);

			if ($store_total) {
				$this->error['warning'] = sprintf($this->language->get('error_store'), $store_total);
			}
			
			$customer_total = $this->model_sale_customer->getTotalCustomersByCustomerGroupId($gemstoneweight_id);

			if ($customer_total) {
				$this->error['warning'] = sprintf($this->language->get('error_customer'), $customer_total);
			}
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>