<?php
class ControllerModuleBPFPP extends Controller {
	private $error = array(); 
	
	public function index() {   
		$this->load->language('module/bp_fpp');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {			
			$this->model_setting_setting->editSetting('bp_fpp', $this->request->post);		
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}
				
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');

		
		$this->data['entry_product'] = $this->language->get('entry_product');
				$this->data['entry_image'] = $this->language->get('entry_image');
		$this->data['entry_status'] = $this->language->get('entry_status');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->error['image'])) {
			$this->data['error_image'] = $this->error['image'];
		} else {
			$this->data['error_image'] = '';
		}
				
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_module'),
			'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('module/bp_fpp', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['action'] = $this->url->link('module/bp_fpp', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['token'] = $this->session->data['token'];

		if (isset($this->request->post['bp_fpp_product'])) {
			$this->data['bp_fpp_product'] = $this->request->post['bp_fpp_product'];
		} else {
			$this->data['bp_fpp_product'] = $this->config->get('bp_fpp_product');
		}	
				
		$this->load->model('catalog/product');
				
		if (isset($this->request->post['bp_fpp_product'])) {
			$products = explode(',', $this->request->post['bp_fpp_product']);
		} else {		
			$products = explode(',', $this->config->get('bp_fpp_product'));
		}
		
		$this->data['products'] = array();
		
		foreach ($products as $product_id) {
			$product_info = $this->model_catalog_product->getProduct($product_id);
			
			if ($product_info) {
				$this->data['products'][] = array(
					'product_id' => $product_info['product_id'],
					'name'       => $product_info['name']
				);
			}
		}	
		
		if (isset($this->request->post['bp_fpp_image_width'])) {
			$this->data['bp_fpp_image_width'] = $this->request->post['bp_fpp_image_width'];
		} elseif ($this->config->get('bp_fpp_image_width')) { 
			$this->data['bp_fpp_image_width'] = $this->config->get('bp_fpp_image_width');
		} else {
			$this->data['bp_fpp_image_width'] = '';
		}

		if (isset($this->request->post['bp_fpp_image_height'])) {
			$this->data['bp_fpp_image_height'] = $this->request->post['bp_fpp_image_height'];
		} elseif ($this->config->get('bp_fpp_image_height')) { 
			$this->data['bp_fpp_image_height'] = $this->config->get('bp_fpp_image_height');
		} else {
			$this->data['bp_fpp_image_height'] = '';
		}
		
		if (isset($this->request->post['bp_fpp_status'])) {
			$this->data['bp_fpp_status'] = $this->request->post['bp_fpp_status'];
		} elseif ($this->config->get('bp_fpp_status')) { 
			$this->data['bp_fpp_status'] = $this->config->get('bp_fpp_status');
		} else {
			$this->data['bp_fpp_status'] = '';
		}
		
		$this->template = 'module/bp_fpp.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	
	private function validate() {
		if (!$this->user->hasPermission('modify', 'module/bp_fpp')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if ( utf8_strlen($this->request->post['bp_fpp_image_width']) < 1 || !is_numeric($this->request->post['bp_fpp_image_width']) || utf8_strlen($this->request->post['bp_fpp_image_height']) < 1 || !is_numeric($this->request->post['bp_fpp_image_height'])) {
			$this->error['image'] = $this->language->get('error_image');
		}
				
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>