<?php
class ControllerExtrasBlog extends Controller { 
	private $error = array();

	public function index() {
		$this->load->language('extras/blog');

		$this->document->setTitle($this->language->get('heading_title'));
		 
		$this->load->model('extras/blog');

		$this->getList();
	}

	public function insert() {
		$this->load->language('extras/blog');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('extras/blog');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_extras_blog->addBlog($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			
			$this->redirect($this->url->link('extras/blog', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function update() {
		$this->load->language('extras/blog');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('extras/blog');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_extras_blog->editBlog($this->request->get['blog_id'], $this->request->post);
			
			if (isset($this->request->post['selected'])) {
				if($this->request->post['with_selected'] == 'delete'){
					foreach ($this->request->post['selected'] as $blog_comment_id) {
						$this->model_extras_blog->deleteComments($blog_comment_id);
					}
				}elseif($this->request->post['with_selected'] == 'unapprove'){
					foreach ($this->request->post['selected'] as $blog_comment_id) {
						$this->model_extras_blog->unapproveComments($blog_comment_id);
					}
				}elseif($this->request->post['with_selected'] == 'approve'){
					foreach ($this->request->post['selected'] as $blog_comment_id) {
						$this->model_extras_blog->approveComments($blog_comment_id);
					}
				}
			}
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			
			$this->redirect($this->url->link('extras/blog', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}
 
	public function delete() {
		$this->load->language('extras/blog');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('extras/blog');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $blog_id) {
				$this->model_extras_blog->deleteBlog($blog_id);
			}
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			
			$this->redirect($this->url->link('extras/blog', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'i.blog_id';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		$url = '';
			
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('extras/blog', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		$this->data['insert'] = $this->url->link('extras/blog/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('extras/blog/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');		

		$this->data['blogs'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$blog_total = $this->model_extras_blog->getTotalBlogs();
	
		$results = $this->model_extras_blog->getBlogs($data);
 
    	foreach ($results as $result) {
			$action = array();
						
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('extras/blog/update', 'token=' . $this->session->data['token'] . '&blog_id=' . $result['blog_id'] . $url, 'SSL')
			);
						
			$this->data['blogs'][] = array(
				'blog_id' => $result['blog_id'],
				'title'      => $result['title'],
				'date_added'      => $result['date_added'],
				'comment_total' => $this->model_extras_blog->getTotalCommentsByBlogId($result['blog_id']),
				'approved_comment' => $this->model_extras_blog->getTotalApprovedCommentsByBlogId($result['blog_id']),
				'unapproved_comment' => $this->model_extras_blog->getTotalUnapprovedCommentsByBlogId($result['blog_id']),
				'sort_order' => $result['sort_order'],
				'selected'   => isset($this->request->post['selected']) && in_array($result['blog_id'], $this->request->post['selected']),
				'action'     => $action
			);
		}	
	
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_title'] = $this->language->get('column_title');
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_comment_total'] = $this->language->get('column_comment_total');
		$this->data['column_approved_comments'] = $this->language->get('column_approved_comments');
		$this->data['column_unapproved_comments'] = $this->language->get('column_unapproved_comments');
		$this->data['column_tc'] = $this->language->get('column_tc');
		$this->data['column_ac'] = $this->language->get('column_ac');
		$this->data['column_uc'] = $this->language->get('column_uc');
		$this->data['column_sort_order'] = $this->language->get('column_sort_order');
		$this->data['column_action'] = $this->language->get('column_action');		
		
		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$this->data['sort_title'] = $this->url->link('extras/blog', 'token=' . $this->session->data['token'] . '&sort=id.title' . $url, 'SSL');
		$this->data['sort_sort_order'] = $this->url->link('extras/blog', 'token=' . $this->session->data['token'] . '&sort=i.sort_order' . $url, 'SSL');
		$this->data['sort_date_added'] = $this->url->link('extras/blog', 'token=' . $this->session->data['token'] . '&sort=i.date_added' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $blog_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('extras/blog', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
					
		$this->data['pagination'] = $pagination->render();

		$this->data['sort'] = $sort;
		$this->data['order'] = $order;
		
		$this->template = 'extras/blog_list.tpl';
		$this->children = array(
			'common/header',	
			'common/footer'	
		);
		
		$this->response->setOutput($this->render()); 
	}

	private function getForm() {
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['tab_general'] = $this->language->get('tab_general');
		$this->data['tab_data'] = $this->language->get('tab_data');
		$this->data['tab_related_blog'] = $this->language->get('tab_related_blog');
		$this->data['tab_comments'] = $this->language->get('tab_comments');
		$this->data['tab_design'] = $this->language->get('tab_design');
		
		$this->data['text_default'] = $this->language->get('text_default');
		$this->data['text_enabled'] = $this->language->get('text_enabled');
    	$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_all_users'] = $this->language->get('text_all_users');
		$this->data['text_member_only'] = $this->language->get('text_member_only');
		$this->data['text_please_select'] = $this->language->get('text_please_select');
    	$this->data['text_approve'] = $this->language->get('text_approve');
    	$this->data['text_unapprove'] = $this->language->get('text_unapprove');
    	$this->data['text_delete'] = $this->language->get('text_delete');
		$this->data['text_approved'] = $this->language->get('text_approved');
    	$this->data['text_unapproved'] = $this->language->get('text_unapproved');
		$this->data['text_no_comments'] = $this->language->get('text_no_comments');
		
		$this->data['entry_title'] = $this->language->get('entry_title');
		$this->data['entry_meta_keyword'] = $this->language->get('entry_meta_keyword');
		$this->data['entry_meta_description'] = $this->language->get('entry_meta_description');
		$this->data['entry_description'] = $this->language->get('entry_description');
		$this->data['entry_short_description'] = $this->language->get('entry_short_description');
		$this->data['entry_category'] = $this->language->get('entry_category');
		$this->data['entry_store'] = $this->language->get('entry_store');
		$this->data['entry_image'] = $this->language->get('entry_image');
		$this->data['entry_keyword'] = $this->language->get('entry_keyword');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_allow_comment'] = $this->language->get('entry_allow_comment');
		$this->data['entry_comment_permission'] = $this->language->get('entry_comment_permission');
		$this->data['entry_comment_need_approval'] = $this->language->get('entry_comment_need_approval');
		$this->data['entry_with_selected'] = $this->language->get('entry_with_selected');
		$this->data['entry_layout'] = $this->language->get('entry_layout');
		
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_email'] = $this->language->get('column_email');
		$this->data['column_date'] = $this->language->get('column_date');
		$this->data['column_comment'] = $this->language->get('column_comment');
		$this->data['column_status'] = $this->language->get('column_status');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['token'] = $this->session->data['token'];

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['title'])) {
			$this->data['error_title'] = $this->error['title'];
		} else {
			$this->data['error_title'] = '';
		}
		
	 	if (isset($this->error['description'])) {
			$this->data['error_description'] = $this->error['description'];
		} else {
			$this->data['error_description'] = '';
		}
		
		if (isset($this->error['short_description'])) {
			$this->data['error_short_description'] = $this->error['short_description'];
		} else {
			$this->data['error_short_description'] = '';
		}
		
		$url = '';
			
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),     		
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('extras/blog', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		if (!isset($this->request->get['blog_id'])) {
			$this->data['action'] = $this->url->link('extras/blog/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('extras/blog/update', 'token=' . $this->session->data['token'] . '&blog_id=' . $this->request->get['blog_id'] . $url, 'SSL');
		}
		
		$this->data['cancel'] = $this->url->link('extras/blog', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if (isset($this->request->get['blog_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$blog_info = $this->model_extras_blog->getBlog($this->request->get['blog_id']);
		}
		
		$this->load->model('localisation/language');
		
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		
		if (isset($this->request->post['blog_description'])) {
			$this->data['blog_description'] = $this->request->post['blog_description'];
		} elseif (isset($this->request->get['blog_id'])) {
			$this->data['blog_description'] = $this->model_extras_blog->getBlogDescriptions($this->request->get['blog_id']);
		} else {
			$this->data['blog_description'] = array();
		}

		if (isset($this->request->post['status'])) {
			$this->data['status'] = $this->request->post['status'];
		} elseif (isset($blog_info)) {
			$this->data['status'] = $blog_info['status'];
		} else {
			$this->data['status'] = 1;
		}
		
		if (isset($this->request->post['allow_comment'])) {
			$this->data['allow_comment'] = $this->request->post['allow_comment'];
		} elseif (isset($blog_info)) {
			$this->data['allow_comment'] = $blog_info['allow_comment'];
		} else {
			$this->data['allow_comment'] = 1;
		}
		
		if (isset($this->request->post['comment_permission'])) {
			$this->data['comment_permission'] = $this->request->post['comment_permission'];
		} elseif (isset($blog_info)) {
			$this->data['comment_permission'] = $blog_info['comment_permission'];
		} else {
			$this->data['comment_permission'] = 1;
		}
		
		if (isset($this->request->post['comment_need_approval'])) {
			$this->data['comment_need_approval'] = $this->request->post['comment_need_approval'];
		} elseif (isset($blog_info)) {
			$this->data['comment_need_approval'] = $blog_info['comment_need_approval'];
		} else {
			$this->data['comment_need_approval'] = 1;
		}
		
		$this->load->model('setting/store');
		
		$this->data['stores'] = $this->model_setting_store->getStores();
		
		if (isset($this->request->post['blog_store'])) {
			$this->data['blog_store'] = $this->request->post['blog_store'];
		} elseif (isset($blog_info)) {
			$this->data['blog_store'] = $this->model_extras_blog->getBlogStores($this->request->get['blog_id']);
		} else {
			$this->data['blog_store'] = array(0);
		}	
		
		if (isset($this->request->post['image'])) {
			$this->data['image'] = $this->request->post['image'];
		} elseif (isset($blog_info)) {
			$this->data['image'] = $blog_info['image'];
		} else {
			$this->data['image'] = '';
		}

		$this->load->model('tool/image');

		if (isset($blog_info) && $blog_info['image'] && file_exists(DIR_IMAGE . $blog_info['image'])) {
			$this->data['thumb'] = $this->model_tool_image->resize($blog_info['image'], 100, 100);
		} else {
			$this->data['thumb'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		}
		
		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		
		$this->load->model('extras/blog_category');
				
		$this->data['blog_categories'] = $this->model_extras_blog_category->getBlogCategories(0);
		
		if (isset($this->request->post['this_blog_category'])) {
			$this->data['this_blog_category'] = $this->request->post['this_blog_category'];
		} elseif (isset($blog_info)) {
			$this->data['this_blog_category'] = $this->model_extras_blog->getBlogCategories($this->request->get['blog_id']);
		} else {
			$this->data['this_blog_category'] = array();
		}
		
		if (isset($this->request->post['keyword'])) {
			$this->data['keyword'] = $this->request->post['keyword'];
		} elseif (isset($blog_info)) {
			$this->data['keyword'] = $blog_info['keyword'];
		} else {
			$this->data['keyword'] = '';
		}
		
		if (isset($this->request->post['sort_order'])) {
			$this->data['sort_order'] = $this->request->post['sort_order'];
		} elseif (isset($blog_info)) {
			$this->data['sort_order'] = $blog_info['sort_order'];
		} else {
			$this->data['sort_order'] = '';
		}
		
		// Related Blog start
		$this->data['blogs'] = $this->model_extras_blog->getBlogs(0);
		
		if (isset($this->request->post['related_blog'])) {
			$this->data['related_blog'] = $this->request->post['related_blog'];
		} elseif (isset($blog_info)) {
			$this->data['related_blog'] = $this->model_extras_blog->getRelatedBlog($this->request->get['blog_id']);
		} else {
			$this->data['related_blog'] = array();
		}
		// Related Blog end
		// Get Comment start
		$this->data['comments'] = array();
			
		if(!empty($this->request->get['blog_id'])){
			
			$results = $this->model_extras_blog->getCommentsByBlogId($this->request->get['blog_id']);
      		
			foreach ($results as $result) {
        		$this->data['comments'][] = array(
        			'blog_comment_id'     => $result['blog_comment_id'],
        			'name'     => $result['name'],
					'email'     => $result['email'],
					'comment'       => strip_tags($result['comment']),
					'selected'   => isset($this->request->post['selected']) && in_array($result['blog_comment_id'], $this->request->post['selected']),
        			'date_added' => $result['date_added'],
        			'status' => $result['status']
        		);
      	}	
      			
		}
		// Get Comment end
		
		if (isset($this->request->post['blog_layout'])) {
			$this->data['blog_layout'] = $this->request->post['blog_layout'];
		} elseif (isset($blog_info)) {
			$this->data['blog_layout'] = $this->model_extras_blog->getBlogLayouts($this->request->get['blog_id']);
		} else {
			$this->data['blog_layout'] = array();
		}

		$this->load->model('design/layout');
		
		$this->data['layouts'] = $this->model_design_layout->getLayouts();
		
		$this->template = 'extras/blog_form.tpl';
		$this->children = array(
			'common/header',	
			'common/footer'	
		);
		
		$this->response->setOutput($this->render()); 
	}

	private function validateForm() {
		if (!$this->user->hasPermission('modify', 'extras/blog')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		foreach ($this->request->post['blog_description'] as $language_id => $value) {
			if ((strlen(utf8_decode($value['title'])) < 3) || (strlen(utf8_decode($value['title'])) > 128)) {
				$this->error['title'][$language_id] = $this->language->get('error_title');
			}
		
			if (strlen(utf8_decode($value['description'])) < 3) {
				$this->error['description'][$language_id] = $this->language->get('error_description');
			}
			
			if (strlen(utf8_decode($value['short_description'])) < 3) {
				$this->error['short_description'][$language_id] = $this->language->get('error_short_description');
			}
		}

		if (!$this->error) {
			return TRUE;
		} else {
			if (!isset($this->error['warning'])) {
				$this->error['warning'] = $this->language->get('error_required_data');
			}
			return FALSE;
		}
	}

	private function validateDelete() {
		if (!$this->user->hasPermission('modify', 'extras/blog')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
}
?>