<?php
class ControllerAffiliateSetting extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('affiliate/setting');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('affiliate/setting');
		
		$this->data['affiliate_groups'] = $this->model_affiliate_setting->getAffiliateGroups();

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			if (isset($this->request->post['config_token_ignore'])) {
				$this->request->post['config_token_ignore'] = serialize($this->request->post['config_token_ignore']);
			}

			$this->model_affiliate_setting->editSetting('affiliate_config', $this->request->post);

			if ($this->config->get('config_currency_auto')) {
				$this->load->model('localisation/currency');

				$this->model_localisation_currency->updateCurrencies();
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('affiliate/setting', 'token=' . $this->session->data['token'], 'SSL'));

		}
		
		$this->load->model('affiliate/setting');
		$affiliatesdt = $this->model_affiliate_setting->getaffiliateDt('affiliateid');
		$affiliateconfig = $this->model_affiliate_setting->getaffiliateDetail('affiliateid');

	//	if ( $affiliatesdt <> $affiliateconfig ) exit;
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['Title'] = $this->language->get('Title');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');
		$this->data['entry_affiliate_points'] = $this->language->get('entry_affiliate_points');
		$this->data['entry_affiliate_price'] = $this->language->get('entry_affiliate_price');
		$this->data['tab_about'] = $this->language->get('tab_about');
		$this->data['tab_banner'] = $this->language->get('tab_banner');
		$this->data['tab_commission'] = $this->language->get('tab_commission');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       	
       		'text'      => $this->language->get('text_home'),
         	'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'],'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		
       		'text'      => $this->language->get('heading_title'),
                'href'      => $this->url->link('affiliate/setting', 'token=' . $this->session->data['token'],'SSL'),
      		'separator' => ' :: '
   		);

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}


		$this->data['cancel'] =$this->url->link('affiliate/setting','token=' . $this->session->data['token'], 'SSL');

        	 
		$this->data['action'] = $this->url->link('affiliate/setting', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['stores'] = array();

		$this->data['stores'][] = array(
                      
			'name' => $this->language->get('text_default'),
			'href' => $this->url->link('affiliate/setting', 'token=' . $this->session->data['token'],'SSL'),
		);

		$this->load->model('localisation/language');
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		$languages = $this->model_localisation_language->getLanguages();

		if (isset($this->request->post['config_description_affabout'])) {
			$this->data['config_description_affabout'] = $this->request->post['config_description_affabout'];
		} else {
			$this->data['config_description_affabout'] = $this->config->get('config_description_affabout');
		}
		if (isset($this->request->post['config_refcustomer'])) {
			$this->data['config_refcustomer'] = $this->request->post['config_refcustomer'];
		} else {
			$this->data['config_refcustomer'] = $this->config->get('config_refcustomer');
		}
		
		if (isset($this->request->post['config_affiliate_ipaddress'])) {
			$this->data['config_affiliate_ipaddress'] = $this->request->post['config_affiliate_ipaddress'];
		} else {
			$this->data['config_affiliate_ipaddress'] = $this->config->get('config_affiliate_ipaddress');
		}
		

		if (isset($this->request->post['config_affiliate_autocredit'])) {
			$this->data['config_affiliate_autocredit'] = $this->request->post['config_affiliate_autocredit'];
		} else {
			$this->data['config_affiliate_autocredit'] = $this->config->get('config_affiliate_autocredit');
		}
		

		if (isset($this->request->post['config_affiliate_points'])) {
			$this->data['config_affiliate_points'] = $this->request->post['config_affiliate_points'];
		} else {
			$this->data['config_affiliate_points'] = $this->config->get('config_affiliate_points');
		}
		if (isset($this->request->post['config_affiliate_price'])) {
			$this->data['config_affiliate_price'] = $this->request->post['config_affiliate_price'];
		} else {
			$this->data['config_affiliate_price'] = $this->config->get('config_affiliate_price');
		}
		

		if (isset($this->request->post['config_description_affabouthead'])) {
			$this->data['config_description_affabouthead'] = $this->request->post['config_description_affabouthead'];
		} else {
			$this->data['config_description_affabouthead'] = $this->config->get('config_description_affabouthead');
		}


		$this->data['tab_affiliate'] = $this->language->get('tab_affiliate');

		$this->data['entry_paypercust'] = $this->language->get('entry_paypercust');
		$this->data['entry_flatratesale'] = $this->language->get('entry_flatratesale');
		$this->data['entry_paypersale'] = $this->language->get('entry_paypersale');
		$this->data['entry_clickcount'] = $this->language->get('entry_clickcount');
		$this->data['entry_payclickcount'] = $this->language->get('entry_payclickcount');
		$this->data['entry_paypersalecount'] = $this->language->get('entry_paypersalecount');
		$this->data['entry_payperaffiliate'] = $this->language->get('entry_payperaffiliate');
		$this->data['entry_affiliatepoints'] = $this->language->get('entry_affiliatepoints');
		$this->data['entry_affiliate_override'] = $this->language->get('entry_affiliate_override');

		$this->data['entry_bannerimgurl'] = $this->language->get('entry_bannerimgurl');
		$this->data['entry_bannertext'] = $this->language->get('entry_bannertext');
		$this->data['entry_bannerflashurl'] = $this->language->get('entry_bannerflashurl');

		$this->data['entry_paypercust_enable'] = $this->language->get('entry_paypercust_enable');
		$this->data['entry_flatratesale_enable'] = $this->language->get('entry_flatratesale_enable');
		$this->data['entry_paypersale_enable'] = $this->language->get('entry_paypersale_enable');
		$this->data['entry_payclickcount_enable'] = $this->language->get('entry_payclickcount_enable');
 	    $this->data['entry_paysalecount_enable'] = $this->language->get('entry_paysalecount_enable');
		$this->data['entry_review'] = $this->language->get('entry_review');
		$this->data['entry_alert_emails'] = $this->language->get('entry_alert_emails');
		$this->data['entry_maintenance'] = $this->language->get('entry_maintenance');
		$this->data['entry_token_ignore'] = $this->language->get('entry_token_ignore');
		
		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_default'] = $this->language->get('text_default');
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
 		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');	
		$this->data['text_yes'] = $this->language->get('text_yes');	
		$this->data['text_no'] = $this->language->get('text_no');
		$this->data['entry_default_group'] = $this->language->get('entry_default_group');

		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_title'] = $this->language->get('entry_title');
		$this->data['entry_link'] = $this->language->get('entry_link');
		$this->data['entry_image'] = $this->language->get('entry_image');		
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_ipaddress'] = $this->language->get('entry_ipaddress');
		$this->data['entry_autocredit'] = $this->language->get('entry_autocredit');
		$this->data['entry_refcustomer'] = $this->language->get('entry_refcustomer');
		$this->data['entry_affcommdriven'] = $this->language->get('entry_affcommdriven');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_add_banner'] = $this->language->get('button_add_banner');
		$this->data['button_remove'] = $this->language->get('button_remove');
		

		$this->data['token'] = $this->session->data['token'];

		$this->data['checkbox'] = $this->language->get('checkbox');
	  
         if (isset($this->error['name'])) {
			$this->data['error_name'] = $this->error['name'];
		} else {
			$this->data['error_name'] = '';
		}
		
		 if (isset($this->error['banner_image'])) {
			$this->data['error_banner_image'] = $this->error['banner_image'];
		} else {
			$this->data['error_banner_image'] = array();
		}	
		
		if (isset($this->request->get['banner_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$banner_info = $this->model_design_banner->getBanner($this->request->get['banner_id']);
		}

		if (isset($this->request->post['name'])) {
			$this->data['name'] = $this->request->post['name'];
		} elseif (!empty($banner_info)) {
			$this->data['name'] = $banner_info['name'];
		} else {
			$this->data['name'] = '';
		}
		
		if (isset($this->request->post['status'])) {
			$this->data['status'] = $this->request->post['status'];
		} elseif (!empty($banner_info)) {
			$this->data['status'] = $banner_info['status'];
		} else {
			$this->data['status'] = true;
		}	
	
		$this->load->model('tool/image');
	
		if (isset($this->request->post['banner_image'])) {
			$banner_images = $this->request->post['banner_image'];
		} elseif (isset($this->request->get['banner_id'])) {
			$banner_images = $this->model_design_banner->getBannerImages($this->request->get['banner_id']);	
		} else {
			$banner_images = array();
		}
		
		$this->data['banner_images'] = array();
		
		foreach ($banner_images as $banner_image) {
			if ($banner_image['image'] && file_exists(DIR_IMAGE . $banner_image['image'])) {
				$image = $banner_image['image'];
			} else {
				$image = 'no_image.jpg';
			}			
			
			$this->data['banner_images'][] = array(
				'banner_image_description' => $banner_image['banner_image_description'],
				'link'                     => $banner_image['link'],
				'image'                    => $image,
				'thumb'                    => $this->model_tool_image->resize($image, 100, 100)
			);	
		} 
	
		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);		

	  

		if (isset($this->request->post['config_paypercust'])) {
			$this->data['config_paypercust'] = $this->request->post['config_paypercust'];
		} else {
			$this->data['config_paypercust'] = $this->config->get('config_paypercust');
		}

		if (isset($this->request->post['config_flatratesale'])) {
			$this->data['config_flatratesale'] = $this->request->post['config_flatratesale'];
		} else {
			$this->data['config_flatratesale'] = $this->config->get('config_flatratesale');
		}
		
		if (isset($this->request->post['config_affiliatepoints'])) {
			$this->data['config_affiliatepoints'] = $this->request->post['config_affiliatepoints'];
		} else {
			$this->data['config_affiliatepoints'] = $this->config->get('config_affiliatepoints');
		}
		
		if (isset($this->request->post['config_affiliate_group'])) {
			$this->data['config_affiliate_group'] = $this->request->post['config_affiliate_group'];
		} else {
			$this->data['config_affiliate_group'] = $this->config->get('config_affiliate_group');
		}
		if (isset($this->request->post['config_affiliate_override'])) {
			$this->data['config_affiliate_override'] = $this->request->post['config_affiliate_override'];
		} else {
			$this->data['config_affiliate_override'] = $this->config->get('config_affiliate_override');
		}
		
		if (isset($this->request->post['config_flatratesale_descr'])) {
			$this->data['config_flatratesale_descr'] = $this->request->post['config_flatratesale_descr'];
		} else {
			$this->data['config_flatratesale_descr'] = $this->config->get('config_flatratesale_descr');
		}
		
		if (isset($this->request->post['config_paypersale_descr'])) {
			$this->data['config_paypersale_descr'] = $this->request->post['config_paypersale_descr'];
		} else {
			$this->data['config_paypersale_descr'] = $this->config->get('config_paypersale_descr');
		}
		
		if (isset($this->request->post['config_paypercust_descr'])) {
			$this->data['config_paypercust_descr'] = $this->request->post['config_paypercust_descr'];
		} else {
			$this->data['config_paypercust_descr'] = $this->config->get('config_paypercust_descr');
		}
		
		if (isset($this->request->post['config_paypernoofsales_descr'])) {
			$this->data['config_paypernoofsales_descr'] = $this->request->post['config_paypernoofsales_descr'];
		} else {
			$this->data['config_paypernoofsales_descr'] = $this->config->get('config_paypernoofsales_descr');
		}
		if (isset($this->request->post['config_payperaffiliate_descr'])) {
			$this->data['config_payperaffiliate_descr'] = $this->request->post['config_payperaffiliate_descr'];
		} else {
			$this->data['config_payperaffiliate_descr'] = $this->config->get('config_payperaffiliate_descr');
		}
		
		if (isset($this->request->post['config_customervisitcount_descr'])) {
			$this->data['config_customervisitcount_descr'] = $this->request->post['config_customervisitcount_descr'];
		} else {
			$this->data['config_customervisitcount_descr'] = $this->config->get('config_customervisitcount_descr');
		}
		
		if (isset($this->request->post['config_payforcustomervisitcount_descr'])) {
			$this->data['config_payforcustomervisitcount_descr'] = $this->request->post['config_payforcustomervisitcount_descr'];
		} else {
			$this->data['config_payforcustomervisitcount_descr'] = $this->config->get('config_payforcustomervisitcount_descr');
		}
		
	//	if($this->config->get('affiliate')!=$_SERVER["SERVER_NAME"])exit;
		if (isset($this->request->post['config_paypersale'])) {
			$this->data['config_paypersale'] = $this->request->post['config_paypersale'];
		} else {
			$this->data['config_paypersale'] = $this->config->get('config_paypersale');
		}

		if (isset($this->request->post['config_clickcount'])) {
			$this->data['config_clickcount'] = $this->request->post['config_clickcount'];
		} else {
			$this->data['config_clickcount'] = $this->config->get('config_clickcount');
		}

		if (isset($this->request->post['config_payclickcount'])) {
			$this->data['config_payclickcount'] = $this->request->post['config_payclickcount'];
		} else {
			$this->data['config_payclickcount'] = $this->config->get('config_payclickcount');
		}

		if (isset($this->request->post['config_paypersalecount'])) {
			$this->data['config_paypersalecount'] = $this->request->post['config_paypersalecount'];
		} else {
			$this->data['config_paypersalecount'] = $this->config->get('config_paypersalecount');
		}
		if (isset($this->request->post['config_payperaffiliate'])) {
			$this->data['config_payperaffiliate'] = $this->request->post['config_payperaffiliate'];
		} else {
			$this->data['config_payperaffiliate'] = $this->config->get('config_payperaffiliate');
		}


		if (isset($this->request->post['config_paypercust_enable'])) {
			$this->data['config_paypercust_enable'] = $this->request->post['config_paypercust_enable'];
		} else {
			$this->data['config_paypercust_enable'] = $this->config->get('config_paypercust_enable');
		}

		if (isset($this->request->post['config_flatratesale_enable'])) {
			$this->data['config_flatratesale_enable'] = $this->request->post['config_flatratesale_enable'];
		} else {
			$this->data['config_flatratesale_enable'] = $this->config->get('config_flatratesale_enable');
		}

		if (isset($this->request->post['config_paypersale_enable'])) {
			$this->data['config_paypersale_enable'] = $this->request->post['config_paypersale_enable'];
		} else {
			$this->data['config_paypersale_enable'] = $this->config->get('config_paypersale_enable');
		}

		if (isset($this->request->post['config_clickcount_enable'])) {
			$this->data['config_clickcount_enable'] = $this->request->post['config_clickcount_enable'];
		} else {
			$this->data['config_clickcount_enable'] = $this->config->get('config_clickcount_enable');
		}

		if (isset($this->request->post['config_payclickcount_enable'])) {
			$this->data['config_payclickcount_enable'] = $this->request->post['config_payclickcount_enable'];
		} else {
			$this->data['config_payclickcount_enable'] = $this->config->get('config_payclickcount_enable');
		}
		
		if (isset($this->request->post['config_customervisitcount_enable'])) {
			$this->data['config_customervisitcount_enable'] = $this->request->post['config_customervisitcount_enable'];
		} else {
			$this->data['config_customervisitcount_enable'] = $this->config->get('config_customervisitcount_enable');
		}

		if (isset($this->request->post['config_paypersalecount_enable'])) {
			$this->data['config_paypersalecount_enable'] = $this->request->post['config_paypersalecount_enable'];
		} else {
			$this->data['config_paypersalecount_enable'] = $this->config->get('config_paypersalecount_enable');
		}
		if (isset($this->request->post['config_payperaffiliate_enable'])) {
			$this->data['config_payperaffiliate_enable'] = $this->request->post['config_payperaffiliate_enable'];
		} else {
			$this->data['config_payperaffiliate_enable'] = $this->config->get('config_payperaffiliate_enable');
		}


		if (isset($this->request->post['config_bannerimgurl'])) {
			$this->data['config_bannerimgurl'] = $this->request->post['config_bannerimgurl'];
		} else {
			$this->data['config_bannerimgurl'] = $this->config->get('config_bannerimgurl');
		}

		if(!isset($this->data['config_bannerimgurl']))
		{
			$this->data['config_bannerimgurl']=$this->config->get('config_logo');
		}

		$this->data['config_fullbannerimgurl']=$this->config->get('config_url').'image/'.$this->data['config_bannerimgurl'];

		if (isset($this->request->post['config_bannertext'])) {
			$this->data['config_bannertext'] = $this->request->post['config_bannertext'];
		} else {
			$this->data['config_bannertext'] = $this->config->get('config_bannertext');
		}

		$this->data['config_htmlbannertext']=html_entity_decode($this->data['config_bannertext'], ENT_QUOTES, 'UTF-8');


		if (isset($this->request->post['config_bannerflashurl'])) {
			$this->data['config_bannerflashurl'] = $this->request->post['config_bannerflashurl'];
		} else {
			$this->data['config_bannerflashurl'] = $this->config->get('config_bannerflashurl');
		}

		$this->data['config_fullbannerflashurl']=$this->config->get('config_url').'image/'.$this->data['config_bannerflashurl'];


//  Affiliate System -- Add on Ends   Here


		$ignore = array(
			'common/login',
			'common/logout',
			'error/not_found',
			'error/permission'
		);

		$this->data['tokens'] = array();

		$files = glob(DIR_APPLICATION . 'controller/*/*.php');

		foreach ($files as $file) {
			$data = explode('/', dirname($file));

			$token = end($data) . '/' . basename($file, '.php');

			if (!in_array($token, $ignore)) {
				$this->data['tokens'][] = $token;
			}
		}

		if (isset($this->request->post['config_token_ignore'])) {
			$this->data['config_token_ignore'] = $this->request->post['config_token_ignore'];
		} elseif ($this->config->get('config_token_ignore')) {
			$this->data['config_token_ignore'] = unserialize($this->config->get('config_token_ignore'));
		} else {
			$this->data['config_token_ignore'] = array();
		}


		$this->template = 'affiliate/setting.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render());		

					
	}
	

	private function validate() {
		if (!$this->user->hasPermission('modify', 'affiliate/setting')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return true;
		} else {
			if (!isset($this->error['warning'])) {
				$this->error['warning'] = $this->language->get('error_required_data');
			}
			return false;
		}
	}
}
?>