<?php 
class ControllerProducttestimonial extends Controller {
	private $page_limit = 12;
	
	public function index() {  
    	$this->language->load('product/testimonial');
		
		$this->load->model('catalog/testimonial');
		$this->load->model('tool/seo_url');  
		
		$this->document->breadcrumbs = array();
		
      	$this->document->breadcrumbs[] = array(
        	'href'      => HTTP_SERVER . 'index.php?route=common/home',
			
        	'text'      => $this->language->get('text_home'),
        	'separator' => FALSE
      	);
		
		$testimonial_total = $this->model_catalog_testimonial->getTotalTestimonials();
			
		if ($testimonial_total) {

	  		$this->document->title = $this->language->get('heading_title');

      		$this->document->breadcrumbs[] = array(
        		'href'      => HTTP_SERVER . 'index.php?route=product/testimonial',
        		'text'      => $this->language->get('heading_title'),
        		'separator' => $this->language->get('text_separator')
      		);		
						
      		$this->data['heading_title'] = $this->language->get('heading_title');
      		
      		$this->data['button_continue'] = $this->language->get('button_continue');
			
			$this->data['continue'] = HTTP_SERVER . 'index.php?route=common/home';
			$this->data['isitesti'] = HTTP_SERVER . 'index.php?route=product/isitestimonial';
			$this->data['isi_testimonial'] = 'Write Testimonial';
		
			if (isset($this->request->get['page'])) {
				$page = $this->request->get['page'];
			} else { 
				$page = 1;
			}	

			$this->data['testimonials'] = array();
			
			$results = $this->model_catalog_testimonial->getTestimonials(($page - 1) * $this->page_limit, $this->page_limit);
			
			foreach ($results as $result) {
				
				$this->data['testimonials'][] = array(
					'title'    => $result['title'],
					'description'	=> html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')
				);
			}
			
			$url = '';
	
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$pagination = new Pagination();
			$pagination->total = $testimonial_total;
			$pagination->page = $page;
			$pagination->limit = $this->page_limit; 
			$pagination->text = $this->language->get('text_pagination');
			$pagination->url = $this->model_tool_seo_url->rewrite(HTTP_SERVER . 'index.php?route=product/testimonial' . $url . '&page={page}');
		
			$this->data['pagination'] = $pagination->render();	


			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/product/testimonial.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/product/testimonial.tpl';
			} else {
				$this->template = 'default/template/product/testimonial.tpl';
			}
			
			$this->children = array(
				'common/header',
				'common/footer',
				'common/column_left',
				'common/column_right'
			);		
			
	  		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
    	} else {
      		$this->document->breadcrumbs[] = array(
        		'href'      => HTTP_SERVER . 'index.php?route=testimonial/testimonial&testimonial_id=' . $this->request->get['testimonial_id'],
        		'text'      => $this->language->get('text_error'),
        		'separator' => $this->language->get('text_separator')
      		);
				
	  		$this->document->title = $this->language->get('text_error');
			
      		$this->data['heading_title'] = $this->language->get('text_error');

      		$this->data['text_error'] = $this->language->get('text_error');

      		$this->data['button_continue'] = $this->language->get('button_continue');

      		$this->data['continue'] = HTTP_SERVER . 'index.php?route=common/home';

			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/error/not_found.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/error/not_found.tpl';
			} else {
				$this->template = 'default/template/error/not_found.tpl';
			}
			
			$this->children = array(
				'common/header',
				'common/footer',
				'common/column_left',
				'common/column_right'
			);
		
	  		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
    	}
  	}
}
?>