<?php echo $header; ?>
<div id="content">
  <div class="breadcrumb">
    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
    <?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
    <?php } ?> 
  </div>
  <?php if ($error_warning) { ?>
  <div class="warning"><?php echo $error_warning; ?></div>
  <?php } ?>
  <div class="box">
    <div class="heading">
      <h1><img src="view/image/product.png" alt="" /> <?php echo $heading_title; ?></h1>
      <div class="buttons"><a onclick="$('#form').submit();" class="button"><?php echo $button_save; ?></a><a onclick="location = '<?php echo $cancel; ?>';" class="button"><?php echo $button_cancel; ?></a></div>
    </div>
    <div class="content">
      <div id="tabs" class="htabs"><a href="#tab-general"><?php echo $tab_general; ?></a><a href="#tab-data"><?php echo $tab_data; ?></a><a href="#tab-links"><?php echo $tab_links; ?></a><a href="#tab-attribute"><?php echo $tab_attribute; ?></a><a href="#tab-option"><?php echo $tab_option; ?></a><a href="#tab-discount"><?php echo $tab_discount; ?></a>
	  <a href="#tab-special"><?php echo $tab_special; ?></a><a href="#tab-image"><?php echo $tab_image; ?></a><a href="#tab-reward"><?php echo $tab_reward; ?></a><a href="#tab-design"><?php echo $tab_design; ?></a>
	  <a href="#tab-metalcontent"><?php echo $tab_metalcontent; ?></a><a href="#tab-metalavail"><?php echo $tab_metalavail; ?></a>
	  <a href="#tab-gemcontent"><?php echo $tab_gemcontent; ?></a><a href="#tab-gemavail"><?php echo $tab_gemavail; ?></a></div>
      <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
        <div id="tab-general">
          <div id="languages" class="htabs">
            <?php foreach ($languages as $language) { ?>
            <a href="#language<?php echo $language['language_id']; ?>"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /> <?php echo $language['name']; ?></a>
            <?php } ?>
          </div>
          <?php foreach ($languages as $language) { ?>
          <div id="language<?php echo $language['language_id']; ?>">
            <table class="form">
              <tr>
                <td><span class="required">*</span> <?php echo $entry_name; ?></td>
                <td><input type="text" name="product_description[<?php echo $language['language_id']; ?>][name]" size="100" value="<?php echo isset($product_description[$language['language_id']]) ? $product_description[$language['language_id']]['name'] : ''; ?>" />
                  <?php if (isset($error_name[$language['language_id']])) { ?>
                  <span class="error"><?php echo $error_name[$language['language_id']]; ?></span>
                  <?php } ?></td>
              </tr>
			   <tr>
                <td><?php echo $entry_optionname; ?></td>
                <td><input type="text" name="product_description[<?php echo $language['language_id']; ?>][optionname]" size="40" value="<?php echo isset($product_description[$language['language_id']]) ? $product_description[$language['language_id']]['optionname'] : ''; ?>" />
                 </td>
              </tr>
			    <tr>
                <td> <?php echo $entry_commonname; ?></td>
                <td><input type="text" name="product_description[<?php echo $language['language_id']; ?>][commonname]" size="40" value="<?php echo isset($product_description[$language['language_id']]) ? $product_description[$language['language_id']]['commonname'] : ''; ?>" />
                  </td>
              </tr>
              <tr>
                <td><?php echo $entry_meta_description; ?></td>
                <td><textarea name="product_description[<?php echo $language['language_id']; ?>][meta_description]" cols="40" rows="5"><?php echo isset($product_description[$language['language_id']]) ? $product_description[$language['language_id']]['meta_description'] : ''; ?></textarea></td>
              </tr>
              <tr>
                <td><?php echo $entry_meta_keyword; ?></td>
                <td><textarea name="product_description[<?php echo $language['language_id']; ?>][meta_keyword]" cols="40" rows="5"><?php echo isset($product_description[$language['language_id']]) ? $product_description[$language['language_id']]['meta_keyword'] : ''; ?></textarea></td>
              </tr>
              <tr>
                <td><?php echo $entry_description; ?></td>
                <td><textarea name="product_description[<?php echo $language['language_id']; ?>][description]" id="description<?php echo $language['language_id']; ?>"><?php echo isset($product_description[$language['language_id']]) ? $product_description[$language['language_id']]['description'] : ''; ?></textarea></td>
              </tr>
              <tr>
                <td><?php echo $entry_tag; ?></td>
                <td><input type="text" name="product_tag[<?php echo $language['language_id']; ?>]" value="<?php echo isset($product_tag[$language['language_id']]) ? $product_tag[$language['language_id']] : ''; ?>" size="80" /></td>
              </tr>
            </table>
          </div>
          <?php } ?>
        </div>
        <div id="tab-data">
          <table class="form">
            <tr>
              <td><span class="required">*</span> <?php echo $entry_model; ?></td>
              <td><input type="text" name="model" value="<?php echo $model; ?>" />
                <?php if ($error_model) { ?>
                <span class="error"><?php echo $error_model; ?></span>
                <?php } ?></td>
            </tr>
			<tr>
              <td>Overriding Markup Absolute:</td>
              <td><input type="text" name="overriding_mark_up_ubsolute" value="<?php echo $overriding_mark_up_ubsolute; ?>" /></td>
            </tr>
			<tr>
              <td>Overriding Markup Percentage:</td>
              <td><input type="text" name="overriding_markup_percentage" value="<?php echo $overriding_markup_percentage; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_sku; ?></td>
              <td><input type="text" name="sku" value="<?php echo $sku; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_upc; ?></td>
              <td><input type="text" name="upc" value="<?php echo $upc; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_location; ?></td>
              <td><input type="text" name="location" value="<?php echo $location; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_price; ?></td>
              <td><input type="text" name="price" value="<?php echo $price; ?>" /></td>
            </tr>
			<tr>
              <td>Supplier Group:</td>
              <td><select name="supplier_group_id">
                  <option value="0" selected="selected"><?php echo $text_none; ?></option>
                  <?php foreach ($suppliers as $supplier) { ?>
                  <?php if ($supplier['supplier_group_id'] == $supplier_group_id) { ?>
                  <option value="<?php echo $supplier['supplier_group_id']; ?>" selected="selected"><?php echo $supplier['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $supplier['supplier_group_id']; ?>"><?php echo $supplier['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_tax_class; ?></td>
              <td><select name="tax_class_id">
                  <option value="0"><?php echo $text_none; ?></option>
                  <?php foreach ($tax_classes as $tax_class) { ?>
                  <?php if ($tax_class['tax_class_id'] == $tax_class_id) { ?>
                  <option value="<?php echo $tax_class['tax_class_id']; ?>" selected="selected"><?php echo $tax_class['title']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $tax_class['tax_class_id']; ?>"><?php echo $tax_class['title']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_quantity; ?></td>
              <td><input type="text" name="quantity" value="<?php echo $quantity; ?>" size="2" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_minimum; ?></td>
              <td><input type="text" name="minimum" value="<?php echo $minimum; ?>" size="2" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_subtract; ?></td>
              <td><select name="subtract">
                  <?php if ($subtract) { ?>
                  <option value="1" selected="selected"><?php echo $text_yes; ?></option>
                  <option value="0"><?php echo $text_no; ?></option>
                  <?php } else { ?>
                  <option value="1"><?php echo $text_yes; ?></option>
                  <option value="0" selected="selected"><?php echo $text_no; ?></option>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_stock_status; ?></td>
              <td><select name="stock_status_id">
                  <?php foreach ($stock_statuses as $stock_status) { ?>
                  <?php if ($stock_status['stock_status_id'] == $stock_status_id) { ?>
                  <option value="<?php echo $stock_status['stock_status_id']; ?>" selected="selected"><?php echo $stock_status['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $stock_status['stock_status_id']; ?>"><?php echo $stock_status['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_shipping; ?></td>
              <td><?php if ($shipping) { ?>
                <input type="radio" name="shipping" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="shipping" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="shipping" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="shipping" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_keyword; ?></td>
              <td><input type="text" name="keyword" value="<?php echo $keyword; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_image; ?></td>
              <td><div class="image"><img src="<?php echo $thumb; ?>" alt="" id="thumb" /><br />
                  <input type="hidden" name="image" value="<?php echo $image; ?>" id="image" />
                  <a onclick="image_upload('image', 'thumb');"><?php echo $text_browse; ?></a>&nbsp;&nbsp;|&nbsp;&nbsp;<a onclick="$('#thumb').attr('src', '<?php echo $no_image; ?>'); $('#image').attr('value', '');"><?php echo $text_clear; ?></a></div></td>
            </tr>
            <tr>
              <td><?php echo $entry_date_available; ?></td>
              <td><input type="text" name="date_available" value="<?php echo $date_available; ?>" size="12" class="date" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_dimension; ?></td>
              <td><input type="text" name="length" value="<?php echo $length; ?>" size="4" />
                <input type="text" name="width" value="<?php echo $width; ?>" size="4" />
                <input type="text" name="height" value="<?php echo $height; ?>" size="4" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_length; ?></td>
              <td><select name="length_class_id">
                  <?php foreach ($length_classes as $length_class) { ?>
                  <?php if ($length_class['length_class_id'] == $length_class_id) { ?>
                  <option value="<?php echo $length_class['length_class_id']; ?>" selected="selected"><?php echo $length_class['title']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $length_class['length_class_id']; ?>"><?php echo $length_class['title']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_weight; ?></td>
              <td><input type="text" name="weight" value="<?php echo $weight; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_weight_class; ?></td>
              <td><select name="weight_class_id">
                  <?php foreach ($weight_classes as $weight_class) { ?>
                  <?php if ($weight_class['weight_class_id'] == $weight_class_id) { ?>
                  <option value="<?php echo $weight_class['weight_class_id']; ?>" selected="selected"><?php echo $weight_class['title']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $weight_class['weight_class_id']; ?>"><?php echo $weight_class['title']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_status; ?></td>
              <td><select name="status">
                  <?php if ($status) { ?>
                  <option value="1" selected="selected"><?php echo $text_enabled; ?></option>
                  <option value="0"><?php echo $text_disabled; ?></option>
                  <?php } else { ?>
                  <option value="1"><?php echo $text_enabled; ?></option>
                  <option value="0" selected="selected"><?php echo $text_disabled; ?></option>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_sort_order; ?></td>
              <td><input type="text" name="sort_order" value="<?php echo $sort_order; ?>" size="2" /></td>
            </tr>
          </table>
        </div>
        <div id="tab-links">
          <table class="form">
            <tr>
              <td><?php echo $entry_manufacturer; ?></td>
              <td><select name="manufacturer_id">
                  <option value="0" selected="selected"><?php echo $text_none; ?></option>
                  <?php foreach ($manufacturers as $manufacturer) { ?>
                  <?php if ($manufacturer['manufacturer_id'] == $manufacturer_id) { ?>
                  <option value="<?php echo $manufacturer['manufacturer_id']; ?>" selected="selected"><?php echo $manufacturer['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $manufacturer['manufacturer_id']; ?>"><?php echo $manufacturer['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_category; ?></td>
              <td><div class="scrollbox">
                  <?php $class = 'odd'; ?>
                  <?php foreach ($categories as $category) { ?>
                  <?php $class = ($class == 'even' ? 'odd' : 'even'); ?>
                  <div class="<?php echo $class; ?>">
                    <?php if (in_array($category['category_id'], $product_category)) { ?>
                    <input type="checkbox" name="product_category[]" value="<?php echo $category['category_id']; ?>" checked="checked" />
                    <?php echo $category['name']; ?>
                    <?php } else { ?>
                    <input type="checkbox" name="product_category[]" value="<?php echo $category['category_id']; ?>" />
                    <?php echo $category['name']; ?>
                    <?php } ?>
                  </div>
                  <?php } ?>
                </div>
                <a onclick="$(this).parent().find(':checkbox').attr('checked', true);"><?php echo $text_select_all; ?></a> / <a onclick="$(this).parent().find(':checkbox').attr('checked', false);"><?php echo $text_unselect_all; ?></a></td>
            </tr>
            <tr>
              <td><?php echo $entry_store; ?></td>
              <td><div class="scrollbox">
                  <?php $class = 'even'; ?>
                  <div class="<?php echo $class; ?>">
                    <?php if (in_array(0, $product_store)) { ?>
                    <input type="checkbox" name="product_store[]" value="0" checked="checked" />
                    <?php echo $text_default; ?>
                    <?php } else { ?>
                    <input type="checkbox" name="product_store[]" value="0" />
                    <?php echo $text_default; ?>
                    <?php } ?>
                  </div>
                  <?php foreach ($stores as $store) { ?>
                  <?php $class = ($class == 'even' ? 'odd' : 'even'); ?>
                  <div class="<?php echo $class; ?>">
                    <?php if (in_array($store['store_id'], $product_store)) { ?>
                    <input type="checkbox" name="product_store[]" value="<?php echo $store['store_id']; ?>" checked="checked" />
                    <?php echo $store['name']; ?>
                    <?php } else { ?>
                    <input type="checkbox" name="product_store[]" value="<?php echo $store['store_id']; ?>" />
                    <?php echo $store['name']; ?>
                    <?php } ?>
                  </div>
                  <?php } ?>
                </div></td>
            </tr>
            <tr>
              <td><?php echo $entry_download; ?></td>
              <td><div class="scrollbox">
                  <?php $class = 'odd'; ?>
                  <?php foreach ($downloads as $download) { ?>
                  <?php $class = ($class == 'even' ? 'odd' : 'even'); ?>
                  <div class="<?php echo $class; ?>">
                    <?php if (in_array($download['download_id'], $product_download)) { ?>
                    <input type="checkbox" name="product_download[]" value="<?php echo $download['download_id']; ?>" checked="checked" />
                    <?php echo $download['name']; ?>
                    <?php } else { ?>
                    <input type="checkbox" name="product_download[]" value="<?php echo $download['download_id']; ?>" />
                    <?php echo $download['name']; ?>
                    <?php } ?>
                  </div>
                  <?php } ?>
                </div></td>
            </tr>
            <tr>
              <td><?php echo $entry_related; ?></td>
              <td><input type="text" name="related" value="" /></td>
            </tr>
            <tr>
              <td>&nbsp;</td>
              <td><div class="scrollbox" id="product-related">
                  <?php $class = 'odd'; ?>
                  <?php foreach ($product_related as $product_related) { ?>
                  <?php $class = ($class == 'even' ? 'odd' : 'even'); ?>
                  <div id="product-related<?php echo $product_related['product_id']; ?>" class="<?php echo $class; ?>"> <?php echo $product_related['name']; ?><img src="view/image/delete.png" />
                    <input type="hidden" name="product_related[]" value="<?php echo $product_related['product_id']; ?>" />
                  </div>
                  <?php } ?>
                </div></td>
            </tr>
          </table>
        </div>
        <div id="tab-attribute">
          <table id="attribute" class="list">
            <thead>
              <tr>
                <td class="left"><?php echo $entry_attribute; ?></td>
                <td class="left"><?php echo $entry_text; ?></td>
                <td></td>
              </tr>
            </thead>
            <?php $attribute_row = 0; ?>
            <?php foreach ($product_attributes as $product_attribute) { ?>
            <tbody id="attribute-row<?php echo $attribute_row; ?>">
              <tr>
                <td class="left"><input type="text" name="product_attribute[<?php echo $attribute_row; ?>][name]" value="<?php echo $product_attribute['name']; ?>" />
                  <input type="hidden" name="product_attribute[<?php echo $attribute_row; ?>][attribute_id]" value="<?php echo $product_attribute['attribute_id']; ?>" /></td>
                <td class="left"><?php foreach ($languages as $language) { ?>
                  <textarea name="product_attribute[<?php echo $attribute_row; ?>][product_attribute_description][<?php echo $language['language_id']; ?>][text]" cols="40" rows="5"><?php echo isset($product_attribute['product_attribute_description'][$language['language_id']]) ? $product_attribute['product_attribute_description'][$language['language_id']]['text'] : ''; ?></textarea>
                  <img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /><br />
                  <?php } ?></td>
                <td class="left"><a onclick="$('#attribute-row<?php echo $attribute_row; ?>').remove();" class="button"><?php echo $button_remove; ?></a></td>
              </tr>
            </tbody>
            <?php $attribute_row++; ?>
            <?php } ?>
            <tfoot>
              <tr>
                <td colspan="2"></td>
                <td class="left"><a onclick="addAttribute();" class="button"><?php echo $button_add_attribute; ?></a></td>
              </tr>
            </tfoot>
          </table>
        </div>
        <div id="tab-option">
          <div id="vtab-option" class="vtabs">
            <?php $option_row = 0; ?>
            <?php foreach ($product_options as $product_option) { ?>
            <a href="#tab-option-<?php echo $option_row; ?>" id="option-<?php echo $option_row; ?>"><?php echo $product_option['name']; ?>&nbsp;<img src="view/image/delete.png" alt="" onclick="$('#vtabs a:first').trigger('click'); $('#option-<?php echo $option_row; ?>').remove(); $('#tab-option-<?php echo $option_row; ?>').remove(); return false;" /></a>
            <?php $option_row++; ?>
            <?php } ?>
            <span id="option-add">
            <input name="option" value="" style="width: 130px;" />
            &nbsp;<img src="view/image/add.png" alt="<?php echo $button_add_option; ?>" title="<?php echo $button_add_option; ?>" /></span></div>
          <?php $option_row = 0; ?>
          <?php $option_value_row = 0; ?>
          <?php foreach ($product_options as $product_option) { ?>
          <div id="tab-option-<?php echo $option_row; ?>" class="vtabs-content">
            <input type="hidden" name="product_option[<?php echo $option_row; ?>][product_option_id]" value="<?php echo $product_option['product_option_id']; ?>" />
            <input type="hidden" name="product_option[<?php echo $option_row; ?>][name]" value="<?php echo $product_option['name']; ?>" />
            <input type="hidden" name="product_option[<?php echo $option_row; ?>][option_id]" value="<?php echo $product_option['option_id']; ?>" />
            <input type="hidden" name="product_option[<?php echo $option_row; ?>][type]" value="<?php echo $product_option['type']; ?>" />
            <table class="form">
              <tr>
                <td><?php echo $entry_required; ?></td>
                <td><select name="product_option[<?php echo $option_row; ?>][required]">
                    <?php if ($product_option['required']) { ?>
                    <option value="1" selected="selected"><?php echo $text_yes; ?></option>
                    <option value="0"><?php echo $text_no; ?></option>
                    <?php } else { ?>
                    <option value="1"><?php echo $text_yes; ?></option>
                    <option value="0" selected="selected"><?php echo $text_no; ?></option>
                    <?php } ?>
                  </select></td>
              </tr>
              <?php if ($product_option['type'] == 'text') { ?>
              <tr>
                <td><?php echo $entry_option_value; ?></td>
                <td><input type="text" name="product_option[<?php echo $option_row; ?>][option_value]" value="<?php echo $product_option['option_value']; ?>" /></td>
              </tr>
              <?php } ?>
              <?php if ($product_option['type'] == 'textarea') { ?>
              <tr>
                <td><?php echo $entry_option_value; ?></td>
                <td><textarea name="product_option[<?php echo $option_row; ?>][option_value]" cols="40" rows="5"><?php echo $product_option['option_value']; ?></textarea></td>
              </tr>
              <?php } ?>
              <?php if ($product_option['type'] == 'file') { ?>
              <tr style="display: none;">
                <td><?php echo $entry_option_value; ?></td>
                <td><input type="text" name="product_option[<?php echo $option_row; ?>][option_value]" value="<?php echo $product_option['option_value']; ?>" /></td>
              </tr>
              <?php } ?>
              <?php if ($product_option['type'] == 'date') { ?>
              <tr>
                <td><?php echo $entry_option_value; ?></td>
                <td><input type="text" name="product_option[<?php echo $option_row; ?>][option_value]" value="<?php echo $product_option['option_value']; ?>" class="date" /></td>
              </tr>
              <?php } ?>
              <?php if ($product_option['type'] == 'datetime') { ?>
              <tr>
                <td><?php echo $entry_option_value; ?></td>
                <td><input type="text" name="product_option[<?php echo $option_row; ?>][option_value]" value="<?php echo $product_option['option_value']; ?>" class="datetime" /></td>
              </tr>
              <?php } ?>
              <?php if ($product_option['type'] == 'time') { ?>
              <tr>
                <td><?php echo $entry_option_value; ?></td>
                <td><input type="text" name="product_option[<?php echo $option_row; ?>][option_value]" value="<?php echo $product_option['option_value']; ?>" class="time" /></td>
              </tr>
              <?php } ?>
            </table>
            <?php if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') { ?>
            <table id="option-value<?php echo $option_row; ?>" class="list">
              <thead>
                <tr>
                  <td class="left"><?php echo $entry_option_value; ?></td>
                  <td class="right"><?php echo $entry_quantity; ?></td>
                  <td class="left"><?php echo $entry_subtract; ?></td>
                  <td class="right"><?php echo $entry_price; ?></td>
                  <td class="right"><?php echo $entry_option_points; ?></td>
                  <td class="right"><?php echo $entry_weight; ?></td>
                  <td></td>
                </tr>
              </thead>
              <?php foreach ($product_option['product_option_value'] as $product_option_value) { ?>
              <tbody id="option-value-row<?php echo $option_value_row; ?>">
                <tr>
                  <td class="left"><select name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][option_value_id]">
                    </select>
                    <input type="hidden" name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][product_option_value_id]" value="<?php echo $product_option_value['product_option_value_id']; ?>" /></td>
                  <td class="right"><input type="text" name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][quantity]" value="<?php echo $product_option_value['quantity']; ?>" size="3" /></td>
                  <td class="left"><select name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][subtract]">
                      <?php if ($product_option_value['subtract']) { ?>
                      <option value="1" selected="selected"><?php echo $text_yes; ?></option>
                      <option value="0"><?php echo $text_no; ?></option>
                      <?php } else { ?>
                      <option value="1"><?php echo $text_yes; ?></option>
                      <option value="0" selected="selected"><?php echo $text_no; ?></option>
                      <?php } ?>
                    </select></td>
                  <td class="right"><select name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][price_prefix]">
                      <?php if ($product_option_value['price_prefix'] == '+') { ?>
                      <option value="+" selected="selected">+</option>
                      <?php } else { ?>
                      <option value="+">+</option>
                      <?php } ?>
                      <?php if ($product_option_value['price_prefix'] == '-') { ?>
                      <option value="-" selected="selected">-</option>
                      <?php } else { ?>
                      <option value="-">-</option>
                      <?php } ?>
                    </select>
                    <input type="text" name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][price]" value="<?php echo $product_option_value['price']; ?>" size="5" /></td>
                  <td class="right"><select name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][points_prefix]">
                      <?php if ($product_option_value['points_prefix'] == '+') { ?>
                      <option value="+" selected="selected">+</option>
                      <?php } else { ?>
                      <option value="+">+</option>
                      <?php } ?>
                      <?php if ($product_option_value['points_prefix'] == '-') { ?>
                      <option value="-" selected="selected">-</option>
                      <?php } else { ?>
                      <option value="-">-</option>
                      <?php } ?>
                    </select>
                    <input type="text" name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][points]" value="<?php echo $product_option_value['points']; ?>" size="5" /></td>
                  <td class="right"><select name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][weight_prefix]">
                      <?php if ($product_option_value['weight_prefix'] == '+') { ?>
                      <option value="+" selected="selected">+</option>
                      <?php } else { ?>
                      <option value="+">+</option>
                      <?php } ?>
                      <?php if ($product_option_value['weight_prefix'] == '-') { ?>
                      <option value="-" selected="selected">-</option>
                      <?php } else { ?>
                      <option value="-">-</option>
                      <?php } ?>
                    </select>
                    <input type="text" name="product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][weight]" value="<?php echo $product_option_value['weight']; ?>" size="5" /></td>
                  <td class="left"><a onclick="$('#option-value-row<?php echo $option_value_row; ?>').remove();" class="button"><?php echo $button_remove; ?></a></td>
                </tr>
              </tbody>
              <?php $option_value_row++; ?>
              <?php } ?>
              <tfoot>
                <tr>
                  <td colspan="6"></td>
                  <td class="left"><a onclick="addOptionValue('<?php echo $option_row; ?>');" class="button"><?php echo $button_add_option_value; ?></a></td>
                </tr>
              </tfoot>
            </table>
            <?php } ?>
          </div>
          <?php $option_row++; ?>
          <?php } ?>
          <!--
          <script type="text/javascript">
          <?php $option_row = 0; ?>
          <?php $option_value_row = 0; ?>		  
		  <?php foreach ($product_options as $product_option) { ?>
          <?php if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') { ?>
		  <?php foreach ($product_option['product_option_value'] as $product_option_value) { ?>
		  $('select[name=\'product_option[<?php echo $option_row; ?>][product_option_value][<?php echo $option_value_row; ?>][option_value_id]\']').load('index.php?route=catalog/product/option&token=<?php echo $token; ?>&option_id=<?php echo $product_option['option_id']; ?>&option_value_id=<?php echo $product_option_value['option_value_id']; ?>');
		  <?php $option_value_row++; ?>
		  <?php } ?>
		  <?php } ?>
		  <?php $option_row++; ?>
          <?php } ?>
		  //</script> 
          -->
        </div>
        <div id="tab-discount">
          <table id="discount" class="list">
            <thead>
              <tr>
                <td class="left"><?php echo $entry_customer_group; ?></td>
                <td class="right"><?php echo $entry_quantity; ?></td>
                <td class="right"><?php echo $entry_priority; ?></td>
                <td class="right"><?php echo $entry_price; ?></td>
                <td class="left"><?php echo $entry_date_start; ?></td>
                <td class="left"><?php echo $entry_date_end; ?></td>
                <td></td>
              </tr>
            </thead>
            <?php $discount_row = 0; ?>
            <?php foreach ($product_discounts as $product_discount) { ?>
            <tbody id="discount-row<?php echo $discount_row; ?>">
              <tr>
                <td class="left"><select name="product_discount[<?php echo $discount_row; ?>][customer_group_id]">
                    <?php foreach ($customer_groups as $customer_group) { ?>
                    <?php if ($customer_group['customer_group_id'] == $product_discount['customer_group_id']) { ?>
                    <option value="<?php echo $customer_group['customer_group_id']; ?>" selected="selected"><?php echo $customer_group['name']; ?></option>
                    <?php } else { ?>
                    <option value="<?php echo $customer_group['customer_group_id']; ?>"><?php echo $customer_group['name']; ?></option>
                    <?php } ?>
                    <?php } ?>
                  </select></td>
                <td class="right"><input type="text" name="product_discount[<?php echo $discount_row; ?>][quantity]" value="<?php echo $product_discount['quantity']; ?>" size="2" /></td>
                <td class="right"><input type="text" name="product_discount[<?php echo $discount_row; ?>][priority]" value="<?php echo $product_discount['priority']; ?>" size="2" /></td>
                <td class="right"><input type="text" name="product_discount[<?php echo $discount_row; ?>][price]" value="<?php echo $product_discount['price']; ?>" /></td>
                <td class="left"><input type="text" name="product_discount[<?php echo $discount_row; ?>][date_start]" value="<?php echo $product_discount['date_start']; ?>" class="date" /></td>
                <td class="left"><input type="text" name="product_discount[<?php echo $discount_row; ?>][date_end]" value="<?php echo $product_discount['date_end']; ?>" class="date" /></td>
                <td class="left"><a onclick="$('#discount-row<?php echo $discount_row; ?>').remove();" class="button"><?php echo $button_remove; ?></a></td>
              </tr>
            </tbody>
            <?php $discount_row++; ?>
            <?php } ?>
            <tfoot>
              <tr>
                <td colspan="6"></td>
                <td class="left"><a onclick="addDiscount();" class="button"><?php echo $button_add_discount; ?></a></td>
              </tr>
            </tfoot>
          </table>
        </div>
        <div id="tab-special">
          <table id="special" class="list">
            <thead>
              <tr>
                <td class="left"><?php echo $entry_customer_group; ?></td>
                <td class="right"><?php echo $entry_priority; ?></td>
                <td class="right"><?php echo $entry_price; ?></td>
                <td class="left"><?php echo $entry_date_start; ?></td>
                <td class="left"><?php echo $entry_date_end; ?></td>
                <td></td>
              </tr>
            </thead>
            <?php $special_row = 0; ?>
            <?php foreach ($product_specials as $product_special) { ?>
            <tbody id="special-row<?php echo $special_row; ?>">
              <tr>
                <td class="left"><select name="product_special[<?php echo $special_row; ?>][customer_group_id]">
                    <?php foreach ($customer_groups as $customer_group) { ?>
                    <?php if ($customer_group['customer_group_id'] == $product_special['customer_group_id']) { ?>
                    <option value="<?php echo $customer_group['customer_group_id']; ?>" selected="selected"><?php echo $customer_group['name']; ?></option>
                    <?php } else { ?>
                    <option value="<?php echo $customer_group['customer_group_id']; ?>"><?php echo $customer_group['name']; ?></option>
                    <?php } ?>
                    <?php } ?>
                  </select></td>
                <td class="right"><input type="text" name="product_special[<?php echo $special_row; ?>][priority]" value="<?php echo $product_special['priority']; ?>" size="2" /></td>
                <td class="right"><input type="text" name="product_special[<?php echo $special_row; ?>][price]" value="<?php echo $product_special['price']; ?>" /></td>
                <td class="left"><input type="text" name="product_special[<?php echo $special_row; ?>][date_start]" value="<?php echo $product_special['date_start']; ?>" class="date" /></td>
                <td class="left"><input type="text" name="product_special[<?php echo $special_row; ?>][date_end]" value="<?php echo $product_special['date_end']; ?>" class="date" /></td>
                <td class="left"><a onclick="$('#special-row<?php echo $special_row; ?>').remove();" class="button"><?php echo $button_remove; ?></a></td>
              </tr>
            </tbody>
            <?php $special_row++; ?>
            <?php } ?>
            <tfoot>
              <tr>
                <td colspan="5"></td>
                <td class="left"><a onclick="addSpecial();" class="button"><?php echo $button_add_special; ?></a></td>
              </tr>
            </tfoot>
          </table>
        </div>
        <div id="tab-image">
          <table id="images" class="list">
            <thead>
              <tr>
                <td class="left"><?php echo $entry_image; ?></td>
                <td class="right"><?php echo $entry_sort_order; ?></td>
                <td></td>
              </tr>
            </thead>
            <?php $image_row = 0; ?>
            <?php foreach ($product_images as $product_image) { ?>
            <tbody id="image-row<?php echo $image_row; ?>">
              <tr>
                <td class="left"><div class="image"><img src="<?php echo $product_image['thumb']; ?>" alt="" id="thumb<?php echo $image_row; ?>" />
                    <input type="hidden" name="product_image[<?php echo $image_row; ?>][image]" value="<?php echo $product_image['image']; ?>" id="image<?php echo $image_row; ?>" />
                    <br />
                    <a onclick="image_upload('image<?php echo $image_row; ?>', 'thumb<?php echo $image_row; ?>');"><?php echo $text_browse; ?></a>&nbsp;&nbsp;|&nbsp;&nbsp;<a onclick="$('#thumb<?php echo $image_row; ?>').attr('src', '<?php echo $no_image; ?>'); $('#image<?php echo $image_row; ?>').attr('value', '');"><?php echo $text_clear; ?></a></div></td>
                <td class="right"><input type="text" name="product_image[<?php echo $image_row; ?>][sort_order]" value="<?php echo $product_image['sort_order']; ?>" size="2" /></td>
                <td class="left"><a onclick="$('#image-row<?php echo $image_row; ?>').remove();" class="button"><?php echo $button_remove; ?></a></td>
              </tr>
            </tbody>
            <?php $image_row++; ?>
            <?php } ?>
            <tfoot>
              <tr>
                <td colspan="2"></td>
                <td class="left"><a onclick="addImage();" class="button"><?php echo $button_add_image; ?></a></td>
              </tr>
            </tfoot>
          </table>
        </div>
        <div id="tab-reward">
          <table class="form">
            <tr>
              <td><?php echo $entry_points; ?></td>
              <td><input type="text" name="points" value="<?php echo $points; ?>" /></td>
            </tr>
          </table>
          <table class="list">
            <thead>
              <tr>
                <td class="left"><?php echo $entry_customer_group; ?></td>
                <td class="right"><?php echo $entry_reward; ?></td>
              </tr>
            </thead>
            <?php foreach ($customer_groups as $customer_group) { ?>
            <tbody>
              <tr>
                <td class="left"><?php echo $customer_group['name']; ?></td>
                <td class="right"><input type="text" name="product_reward[<?php echo $customer_group['customer_group_id']; ?>][points]" value="<?php echo isset($product_reward[$customer_group['customer_group_id']]) ? $product_reward[$customer_group['customer_group_id']]['points'] : ''; ?>" /></td>
              </tr>
            </tbody>
            <?php } ?>
          </table>
        </div>
        <div id="tab-design">
          <table class="list">
            <thead>
              <tr>
                <td class="left"><?php echo $entry_store; ?></td>
                <td class="left"><?php echo $entry_layout; ?></td>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td class="left"><?php echo $text_default; ?></td>
                <td class="left"><select name="product_layout[0][layout_id]">
                    <option value=""></option>
                    <?php foreach ($layouts as $layout) { ?>
                    <?php if (isset($product_layout[0]) && $product_layout[0] == $layout['layout_id']) { ?>
                    <option value="<?php echo $layout['layout_id']; ?>" selected="selected"><?php echo $layout['name']; ?></option>
                    <?php } else { ?>
                    <option value="<?php echo $layout['layout_id']; ?>"><?php echo $layout['name']; ?></option>
                    <?php } ?>
                    <?php } ?>
                  </select></td>
              </tr>
            </tbody>
            <?php foreach ($stores as $store) { ?>
            <tbody>
              <tr>
                <td class="left"><?php echo $store['name']; ?></td>
                <td class="left"><select name="product_layout[<?php echo $store['store_id']; ?>][layout_id]">
                    <option value=""></option>
                    <?php foreach ($layouts as $layout) { ?>
                    <?php if (isset($product_layout[$store['store_id']]) && $product_layout[$store['store_id']] == $layout['layout_id']) { ?>
                    <option value="<?php echo $layout['layout_id']; ?>" selected="selected"><?php echo $layout['name']; ?></option>
                    <?php } else { ?>
                    <option value="<?php echo $layout['layout_id']; ?>"><?php echo $layout['name']; ?></option>
                    <?php } ?>
                    <?php } ?>
                  </select></td>
              </tr>
            </tbody>
            <?php } ?>
          </table>
        </div>
		 <div id="tab-metalcontent">
          <table id="metalcontent" class="list">
            <thead>
              <tr>
                <td class="right">Metal</td>
              
                <td class="left">Silver Weight </td>
                <td></td>
              </tr>
            </thead>
            <?php $metalcontent_row = 0;?>
            <?php foreach ($product_metalcontents as $product_metalcontent) { ?>
            <tbody id="metalcontent-row<?php echo $metalcontent_row; ?>">
              <tr>
                <!-- <td class="right"><input type="text" name="product_metalcontent[<?php echo $metalcontent_row; ?>][metal]" value="<?php echo $product_metalcontent['metal']; ?>" size="2" /></td> -->
				<td class="right"><select name="product_metalcontent[<?php echo $metalcontent_row; ?>][metal]">
					  <?php for($i=1; $i<6; $i++) { ?>
                    <?php if ($i == $product_metalcontent['metal']) { ?>
                    <option value="<?php echo $i; ?>" selected="selected"><?php echo $i; ?></option>
                    <?php } else { ?>
                    <option value="<?php echo $i; ?>"><?php echo $i; ?></option>
                    <?php } ?>
                    <?php } ?>
				</select></td>
                <td class="left"><input type="text" name="product_metalcontent[<?php echo $metalcontent_row; ?>][weight]" value="<?php echo $product_metalcontent['weight']; ?>"  /></td>
     <td class="left"><a onclick="$('#metalcontent-row<?php echo $metalcontent_row; ?>').remove();" class="button"><?php echo $button_remove; ?></a></td>
           
				  </tr>
            </tbody>
            <?php $metalcontent_row++; ?>
            <?php } ?>
            <tfoot>
              <tr>
                <td colspan="2"></td>
                <td class="left"><a onclick="addMetalcontent();" class="button">Add Metal Content</a></td>
              </tr>
            </tfoot>
          </table>
        </div>
		 <div id="tab-metalavail">
          <table id="metalavail" class="list">
            <thead>
              <tr>
                <td class="right">Metal</td>
                <td class="right">MetalCode</td>
                <td class="left">Image</td>
                <td class="left">SupplierPrice</td>
                <td class="left">Currency</td>
                <td class="left">Default</td>
                <td class="left">Enable</td>
                <td></td>
              </tr>
            </thead>
            <?php $metalavail_row = 0; ?>
            <?php foreach ($product_metalavails as $product_metalavail) { ?>
            <tbody id="metalavail-row<?php echo $metalavail_row; ?>">
              <tr>
               <!-- <td class="right"><input type="text" name="product_metalavail[<?php // echo $metalavail_row; ?>][metal]" value="<?php //echo $product_metalavail['metal']; ?>" size="2" /></td>
                <td class="right"><input type="text" name="product_metalavail[<?php // echo $metalavail_row; ?>][metalcode]" value="<?php //echo $product_metalavail['metalcode']; ?>" /></td> -->
				<td class="right"><select name="product_metalavail[<?php echo $metalavail_row; ?>][metal]">
					  <?php for($i=1; $i<6; $i++) { ?>
                    <?php if ($i == $product_metalavail['metal']) { ?>
                    <option value="<?php echo $i; ?>" selected="selected"><?php echo $i; ?></option>
                    <?php } else { ?>
                    <option value="<?php echo $i; ?>"><?php echo $i; ?></option>
                    <?php } ?>
                    <?php } ?>
				</select></td>
				<td class="right"><select name="product_metalavail[<?php echo $metalavail_row; ?>][metal_id]">
                    <?php foreach ($metalcos as $metalco) { ?>
                    <?php if ($metalco['metal_id'] == $product_metalavail['metal_id']) { ?>
                    <option value="<?php echo $metalco['metal_id']; ?>" selected="selected"><?php echo $metalco['metal_code']; ?></option>
                    <?php } else { ?>
                    <option value="<?php echo $metalco['metal_id']; ?>"><?php echo $metalco['metal_code']; ?></option>
                    <?php } ?>
                    <?php } ?>
                  </select></td>
				
                <td class="left"><div class="image"><img src="<?php echo $product_metalavail['thumb']; ?>" alt="" id="bthumb<?php echo $metalavail_row; ?>" />
                    <input type="hidden" name="product_metalavail[<?php echo $metalavail_row; ?>][image]" value="<?php echo $product_metalavail['image']; ?>" id="bimage<?php echo $metalavail_row; ?>" />
                    <br />
                    <a onclick="image_upload('bimage<?php echo $metalavail_row; ?>', 'bthumb<?php echo $metalavail_row; ?>');"><?php echo $text_browse; ?></a>&nbsp;&nbsp;|&nbsp;&nbsp;<a onclick="$('#thumb<?php echo $metalavail_row; ?>').attr('src', '<?php echo $no_image; ?>'); $('#image<?php echo $metalavail_row; ?>').attr('value', '');"><?php echo $text_clear; ?></a></div></td>
                <td class="left"><input type="text" name="product_metalavail[<?php echo $metalavail_row; ?>][price]" value="<?php echo $product_metalavail['price']; ?>"  /></td>
                <td class="left"><select name="product_metalavail[<?php echo $metalavail_row; ?>][currency]">
                    <?php foreach ($currencies as $currency) { ?>
                    <?php if ($currency['code'] == $product_metalavail['currency']) { ?>
                    <option value="<?php echo $currency['code']; ?>" selected="selected"><?php echo $currency['title']; ?></option>
                    <?php } else { ?>
                    <option value="<?php echo $currency['code']; ?>"><?php echo $currency['title']; ?></option>
                    <?php } ?>
                    <?php } ?>
                  </select></td>
				  <!-- <td class="left"><input type="text" name="product_metalavail[<?php echo $metalavail_row; ?>][defaultnew]" value="<?php echo $product_metalavail['defaultnew']; ?>"  /></td>-->
				  <td class="left"><?php if ($product_metalavail['defaultnew']) { ?>
                <input type="checkbox" name="product_metalavail[<?php echo $metalavail_row; ?>][defaultnew]" value="1" checked="checked" />
                <?php } else { ?>
                <input type="checkbox" name="product_metalavail[<?php echo $metalavail_row; ?>][defaultnew]" value="1" />
                <?php } ?></td>
				<td class="left"><?php if ($product_metalavail['statusnew']) { ?>
                <input type="checkbox" name="product_metalavail[<?php echo $metalavail_row; ?>][statusnew]" value="1" checked="checked" />
                <?php } else { ?>
                <input type="checkbox" name="product_metalavail[<?php echo $metalavail_row; ?>][statusnew]" value="1" />
                <?php } ?></td>
                <td class="left"><a onclick="$('#metalavail-row<?php echo $metalavail_row; ?>').remove();" class="button"><?php echo $button_remove; ?></a></td>
              </tr>
            </tbody>
            <?php $metalavail_row++; ?>
            <?php } ?>
            <tfoot>
              <tr>
                <td colspan="7"></td>
                <td class="left"><a onclick="addMetalavail();" class="button">Add Metal Content</a></td>
              </tr>
            </tfoot>
          </table>
        </div>
		
		 <div id="tab-gemcontent">
          <table id="gemcontent" class="list">
            <thead>
              <tr>
                <td class="right">Gem</td>
                <td class="right">Shape</td>
                <!-- <td class="left">Weight Per Piece</td>  -->
                <td class="left">Count</td>
                <td class="left">Size</td>
                <td class="left">Setting Type</td>
                <td></td>
              </tr>
            </thead>
            <?php $gemcontent_row = 0; ?>
            <?php foreach ($product_gemcontents as $product_gemcontent) { ?>
            <tbody id="gemcontent-row<?php echo $gemcontent_row; ?>">
              <tr>
              <!---  <td class="right"><input type="text" name="product_gemcontent[<?php echo $gemcontent_row; ?>][gem]" value="<?php echo $product_gemcontent['gem']; ?>" size="2" /></td> -->
					<td class="right"><select name="product_gemcontent[<?php echo $gemcontent_row; ?>][gem]">
					  <?php for($i=1; $i<6; $i++) { ?>
                    <?php if ($i == $product_gemcontent['gem']) { ?>
                    <option value="<?php echo $i; ?>" selected="selected"><?php echo $i; ?></option>
                    <?php } else { ?>
                    <option value="<?php echo $i; ?>"><?php echo $i; ?></option>
                    <?php } ?>
                    <?php } ?>
				</select></td>
					<td class="right"><select name="product_gemcontent[<?php echo $gemcontent_row; ?>][shape_id]">
                    <?php foreach ($shapess as $shapes) { ?>
                    <?php if ($shapes['shape_id'] == $product_gemcontent['shape_id']) { ?>
                    <option value="<?php echo $shapes['shape_id']; ?>" selected="selected"><?php echo $shapes['shape']; ?></option>
                    <?php } else { ?>
                    <option value="<?php echo $shapes['shape_id']; ?>"><?php echo $shapes['shape']; ?></option>
                    <?php } ?>
                    <?php } ?>
                  </select></td>
					<input type="hidden" name="product_gemcontent[<?php echo $gemcontent_row; ?>][weight]" value="0" />
                <!--- <td class="left"><input type="text" name="product_gemcontent[<?php echo $gemcontent_row; ?>][weight]" value="<?php echo $product_gemcontent['weight']; ?>"  /></td> -->
                <td class="left"><input type="text" name="product_gemcontent[<?php echo $gemcontent_row; ?>][count]" value="<?php echo $product_gemcontent['count']; ?>"  /></td>
                <td class="left"><select name="product_gemcontent[<?php echo $gemcontent_row; ?>][size]">
                    <?php foreach ($sizes as $size) { ?>
                    <?php if ($size['size_id'] == $product_gemcontent['size']) { ?>
                    <option value="<?php echo $size['size_id']; ?>" selected="selected"><?php echo $size['size_code']; ?></option>
                    <?php } else { ?>
                    <option value="<?php echo $size['size_id']; ?>"><?php echo $size['size_code']; ?></option>
                    <?php } ?>
                    <?php } ?>
                  </select>
				<!-- <input type="text" name="product_gemcontent[<?php echo $gemcontent_row; ?>][size]" value="<?php echo $product_gemcontent['size']; ?>"  /></td>-->
				<td class="left"><select name="product_gemcontent[<?php echo $gemcontent_row; ?>][setting_id]">
                    <?php foreach ($labours as $hi1) { ?>
                    <?php if ($hi1['setting_id'] == $product_gemcontent['setting_id']) { ?>
                    <option value="<?php echo $hi1['setting_id']; ?>" selected="selected"><?php echo $hi1['setting']; ?></option>
                    <?php } else { ?>
                    <option value="<?php echo $hi1['setting_id']; ?>"><?php echo $hi1['setting']; ?></option>
                    <?php } ?>
                    <?php } ?>
                  </select></td>
                <td class="left"><a onclick="$('#gemcontent-row<?php echo $gemcontent_row; ?>').remove();" class="button"><?php echo $button_remove; ?></a></td>
              </tr>
            </tbody>
            <?php $gemcontent_row++; ?>
            <?php } ?>
            <tfoot>
              <tr>
                <td colspan="5"></td>
                <td class="left"><a onclick="addGemcontent();" class="button">Add Gem Content</a></td>
              </tr>
            </tfoot>
          </table>
        </div>
		 <div id="tab-gemavail">
          <table id="gemavail" class="list">
            <thead>
              <tr>
                <td class="right">Gem</td>
                <td class="right">Gem</td>
                <td class="left">Image</td>
                <td class="left">SupplierPrice</td>
                <td class="left">Default</td>
                <td class="left">Enable</td>
                <td></td>
              </tr>
            </thead>
            <?php $gemavail_row = 0; ?>
            <?php foreach ($product_gemavails as $product_gemavail) { ?>
            <tbody id="gemavail-row<?php echo $gemavail_row; ?>">
              <tr>
					<td class="right"><select name="product_gemavail[<?php echo $gemavail_row; ?>][gem]">
						<?php for($i=1; $i<6; $i++) { ?>
						<?php if ($i == $product_gemavail['gem']) { ?>
						<option value="<?php echo $i; ?>" selected="selected"><?php echo $i; ?></option>
						<?php } else { ?>
						<option value="<?php echo $i; ?>"><?php echo $i; ?></option>
						<?php } ?>
						<?php } ?>
					</select></td>
					<td class="right"><select name="product_gemavail[<?php echo $gemavail_row; ?>][gemstone_id]">
                    <?php foreach ($gemlists as $gemlist) { ?>
                    <?php if ($gemlist['gemstone_id'] == $product_gemavail['gemstone_id']) { ?>
                    <option value="<?php echo $gemlist['gemstone_id']; ?>" selected="selected"><?php echo $gemlist['gemname']; ?></option>
                    <?php } else { ?>
                    <option value="<?php echo $gemlist['gemstone_id']; ?>"><?php echo $gemlist['gemname']; ?></option>
                    <?php } ?>
                    <?php } ?>
                  </select></td>
				
				<td class="left"><div class="image"><img src="<?php echo $product_gemavail['thumb']; ?>" alt="" id="athumb<?php echo $gemavail_row; ?>" />
                    <input type="hidden" name="product_gemavail[<?php echo $gemavail_row; ?>][image]" value="<?php echo $product_gemavail['image']; ?>" id="aimage<?php echo $gemavail_row; ?>" />
                    <br />
                    <a onclick="image_upload('aimage<?php echo $gemavail_row; ?>', 'athumb<?php echo $gemavail_row; ?>');"><?php echo $text_browse; ?></a>&nbsp;&nbsp;|&nbsp;&nbsp;<a onclick="$('#thumb<?php echo $gemavail_row; ?>').attr('src', '<?php echo $no_image; ?>'); $('#image<?php echo $gemavail_row; ?>').attr('value', '');"><?php echo $text_clear; ?></a></div></td>
                <!-- <td class="left"><input type="text" name="product_gemavail[<?php echo $gemavail_row; ?>][defaultnew]" value="<?php echo $product_gemavail['defaultnew']; ?>"  /></td>--->
                <td class="left"><input type="text" name="product_gemavail[<?php echo $gemavail_row; ?>][price]" value="<?php echo $product_gemavail['price']; ?>"  /></td>
				<td class="left"><?php if ($product_gemavail['defaultnew']) { ?>
                <input type="checkbox" name="product_gemavail[<?php echo $gemavail_row; ?>][defaultnew]" value="1" checked="checked" />
                <?php } else { ?>
                <input type="checkbox" name="product_gemavail[<?php echo $gemavail_row; ?>][defaultnew]" value="1" />
                <?php } ?></td>
				<td class="left"><?php if ($product_gemavail['statusnew']) { ?>
                <input type="checkbox" name="product_gemavail[<?php echo $gemavail_row; ?>][statusnew]" value="1" checked="checked" />
                <?php } else { ?>
                <input type="checkbox" name="product_gemavail[<?php echo $gemavail_row; ?>][statusnew]" value="1" />
                <?php } ?></td>
                <td class="left"><a onclick="$('#gemavail-row<?php echo $gemavail_row; ?>').remove();" class="button"><?php echo $button_remove; ?></a></td>
              </tr>
            </tbody>
            <?php $gemavail_row++; ?>
            <?php } ?>
            <tfoot>
              <tr>
                <td colspan="6"></td>
                <td class="left"><a onclick="addGemavail();" class="button">Add Gem Content</a></td>
              </tr>
            </tfoot>
          </table>
        </div>
		
      </form>
    </div>
  </div>
</div>

<script type="text/javascript"><!--
$('.content > #tabs a').bind('click', function() {
		//$('#tab-gemavail').addClass('active');
		//delay: 0,
		//alert('fdsf');
			$.ajax({
				url: 'index.php?route=catalog/product/gemupdate&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request.term),
				dataType: 'json',
				success: function(json) {	
					response($.map(json, function(item) {
						return {
							category: item.attribute_group,
							label: item.name,
							value: item.attribute_id
						}
					}));
				}
			});
	});
//--></script> 

<script type="text/javascript"><!--
var  gemavail_row = <?php echo $gemavail_row; ?>;

function addGemavail() {
	html  = '<tbody id="gemavail-row' + gemavail_row + '">';
	html += '  <tr>'; 	
  //  html += '    <td class="right"><input type="text" name="product_gemavail[' + gemavail_row + '][gem]" value="" size="2" /></td>';
    html += '    <td class="right"><select name="product_gemavail[' + gemavail_row + '][gem]">';
    <?php for($i=1; $i<6; $i++) { ?>
    html += '      <option value="<?php echo $i; ?>"><?php echo $i; ?></option>';
    <?php } ?>
    html += '    </select></td>';
//	html += '    <td class="right"><input type="text" name="product_gemavail[' + gemavail_row + '][gemname]" value="" /></td>';
	
	html += '    <td class="right"><select name="product_gemavail[' + gemavail_row + '][gemstone_id]">';
       <?php foreach ($gemlists as $gemlist) { ?>
    html += '      <option value="<?php echo $gemlist['gemstone_id']; ?>"><?php echo $gemlist['gemname']; ?></option>';
    <?php } ?>
	
    html += '    <td class="left"><div class="image"><img src="<?php echo $no_image; ?>" alt="" id="athumb' + gemavail_row + '" /><input type="hidden" name="product_gemavail[' + gemavail_row + '][image]" value="" id="aimage' + gemavail_row + '" /><br /><a onclick="image_upload(\'aimage' + gemavail_row + '\', \'athumb' + gemavail_row + '\');"><?php echo $text_browse; ?></a>&nbsp;&nbsp;|&nbsp;&nbsp;<a onclick="$(\'#thumb' + gemavail_row + '\').attr(\'src\', \'<?php echo $no_image; ?>\'); $(\'#image' + gemavail_row + '\').attr(\'value\', \'\');"><?php echo $text_clear; ?></a></div></td>';
	//html += '    <td class="left"><input type="text" name="product_gemavail[' + gemavail_row + '][defaultnew]" value="" /></td>';
	html += '    <td class="left"><input type="text" name="product_gemavail[' + gemavail_row + '][price]" value="" /></td>';
	html += '   <td class="left"><input type="checkbox" name="product_gemavail[' + gemavail_row + '][defaultnew]" value="0" /></td>';
	html += '   <td class="left"><input type="checkbox" name="product_gemavail[' + gemavail_row + '][statusnew]" value="1" /></td>';

//	html += '    <td class="left"><?php if ($product_gemavail['defaultnew']) { ?>';
//	html += '    <input type="checkbox" name="product_gemavail[<?php echo $gemavail_row; ?>][defaultnew]" value="1" checked="checked" />';
//	html += '   <?php } else { ?>';
//	html += '   <td class="left"><input type="checkbox" name="product_gemavail[' + gemavail_row + '][defaultnew]" value="0" /></td>';
//    html += '    <?php } ?></td>';
	html += '    <td class="left"><a onclick="$(\'#gemavail-row' + gemavail_row + '\').remove();" class="button"><?php echo $button_remove; ?></a></td>';
	html += '  </tr>';
    html += '</tbody>';
	
	$('#gemavail tfoot').before(html);
 
	$('#gemavail-row' + gemavail_row + ' .date').datepicker({dateFormat: 'yy-mm-dd'});
	
	gemavail_row++;
}
//--></script> 

<script type="text/javascript"><!--
var  gemcontent_row = <?php echo $gemcontent_row; ?>;

function addGemcontent() {
	html  = '<tbody id="gemcontent-row' + gemcontent_row + '">';
	html += '  <tr>'; 	
   // html += '    <td class="right"><input type="text" name="product_gemcontent[' + gemcontent_row + '][gem]" value="" size="2" /></td>';
   html += '    <td class="right"><select name="product_gemcontent[' + gemcontent_row + '][gem]">';
    <?php for($i=1; $i<6; $i++) { ?>
    html += '      <option value="<?php echo $i; ?>"><?php echo $i; ?></option>';
    <?php } ?>
    html += '    </select></td>';
	//html += '    <td class="right"><input type="text" name="product_gemcontent[' + gemcontent_row + '][shape]" value="" /></td>';
	html += '    <td class="left"><select name="product_gemcontent[' + gemcontent_row + '][shape_id]">';
      <?php foreach ($shapess as $shapes) { ?>
    html += '      <option value="<?php echo $shapes['shape_id']; ?>"><?php echo $shapes['shape']; ?></option>';
    <?php } ?>
	
   // html += '    <td class="left"><input type="text" name="product_gemcontent[' + gemcontent_row + '][weight]" value="" /></td>';
	html += '    <td class="left"><input type="text" name="product_gemcontent[' + gemcontent_row + '][count]" value="" /></td>';
	html += '    <td class="left"><input type="text" name="product_gemcontent[' + gemcontent_row + '][size]" value="" /></td>';	
	html += '    <td class="left"><select name="product_gemcontent[' + gemcontent_row + '][setting_id]">';
    <?php foreach($labours as $hi1) { ?>
   html += '      <option value="<?php echo $hi1['setting_id']; ?>"><?php echo $hi1['setting']; ?></option>';
   <?php } ?>
    html += '    </select></td>'; 
	html += '    <td class="left"><a onclick="$(\'#gemcontent-row' + gemcontent_row + '\').remove();" class="button"><?php echo $button_remove; ?></a></td>';
	html += '  </tr>';
    html += '</tbody>';
	
	$('#gemcontent tfoot').before(html);
 
	$('#gemcontent-row' + gemcontent_row + ' .date').datepicker({dateFormat: 'yy-mm-dd'});
	
	gemcontent_row++;
}
//--></script> 

<script type="text/javascript"><!--
var  metalavail_row = <?php echo $metalavail_row; ?>;

function addMetalavail() {
	
	html  = '<tbody id="metalavail-row' + metalavail_row + '">';
	html += '  <tr>'; 	
  //  html += '    <td class="right"><input type="text" name="product_metalavail[' + metalavail_row + '][metal]" value="1" size="2" /></td>';
  html += '    <td class="right"><select name="product_metalavail[' + metalavail_row + '][metal]">';
    <?php for($i=1; $i<6; $i++) { ?>
    html += '      <option value="<?php echo $i; ?>"><?php echo $i; ?></option>';
    <?php } ?>
    html += '    </select></td>';
//	html += '    <td class="right"><input type="text" name="product_metalavail[' + metalavail_row + '][metalcode]" value="" /></td>';
	
	html += '    <td class="right"><select name="product_metalavail[' + metalavail_row + '][metal_id]">';
      <?php foreach ($metalcos as $metalco) { ?>
    html += '      <option value="<?php echo $metalco['metal_id']; ?>"><?php echo $metalco['metal_code']; ?></option>';
    <?php } ?>
    html += '    </select></td>';
	
    html += '    <td class="left"><div class="image"><img src="<?php echo $no_image; ?>" alt="" id="bthumb' + metalavail_row + '" /><input type="hidden" name="product_metalavail[' + metalavail_row + '][image]" value="" id="bimage' + metalavail_row + '" /><br /><a onclick="image_upload(\'bimage' + metalavail_row + '\', \'bthumb' + metalavail_row + '\');"><?php echo $text_browse; ?></a>&nbsp;&nbsp;|&nbsp;&nbsp;<a onclick="$(\'#thumb' + metalavail_row + '\').attr(\'src\', \'<?php echo $no_image; ?>\'); $(\'#image' + metalavail_row + '\').attr(\'value\', \'\');"><?php echo $text_clear; ?></a></div></td>';
	
	//html += '    <td class="left"><input type="text" name="product_metalavail[' + metalavail_row + '][defaultnew]" value="" /></td>';
	html += '    <td class="left"><input type="text" name="product_metalavail[' + metalavail_row + '][price]" value="" /></td>';
	html += '    <td class="left"><select name="product_metalavail[' + metalavail_row + '][currency]">';
    <?php foreach($currencies as $currency) { ?>
    html += '      <option value="<?php echo $currency['code']; ?>"><?php echo $currency['title']; ?></option>';
    <?php } ?>
    html += '    </select></td>';
	html += '   <td class="left"><input type="checkbox" name="product_metalavail[' + metalavail_row + '][defaultnew]" value="0" /></td>';
	html += '   <td class="left"><input type="checkbox" name="product_metalavail[' + metalavail_row + '][statusnew]" value="1" /></td>';

	//html += '    <td class="left"><?php if ($product_metalavail['defaultnew']) { ?>';
	//html += '    <input type="checkbox" name="product_metalavail[<?php echo $metalavail_row; ?>][defaultnew]" value="1" checked="checked" />';
	//html += '   <?php } else { ?>';
	//html += '   <input type="checkbox" name="product_metalavail[<?php echo $metalavail_row; ?>][defaultnew]" value="1" />';
    //html += '    <?php } ?></td>';
	html += '    <td class="left"><a onclick="$(\'#metalavail-row' + metalavail_row + '\').remove();" class="button"><?php echo $button_remove; ?></a></td>';
	html += '  </tr>';
    html += '</tbody>';
	
	$('#metalavail tfoot').before(html);
 
	$('#metalavail-row' + metalavail_row + ' .date').datepicker({dateFormat: 'yy-mm-dd'});
	metalavail_row++; 
	//alert(metalavail_row);
	
}
//--></script> 

<script type="text/javascript"><!--
var  metalcontent_row = <?php echo $metalcontent_row; ?>;

function addMetalcontent() {
	html  = '<tbody id="metalcontent-row' + metalcontent_row + '">';
	html += '  <tr>'; 	
    //html += '    <td class="right"><input type="text" name="product_metalcontent[' + metalcontent_row + '][metal]" value="" size="2" /></td>';
	html += '    <td class="right"><select name="product_metalcontent[<?php echo $metalcontent_row; ?>][metal]">';
    <?php for($i=1; $i<6; $i++) { ?>
    html += '   <option value="<?php echo $i; ?>"><?php echo $i; ?></option>';
    <?php } ?>
    html += '    </select></td>';
	 html += '    <td class="left"><input type="text" name="product_metalcontent[' + metalcontent_row + '][weight]" value="" /></td>';
		html += '    <td class="left"><a onclick="$(\'#metalcontent-row' + metalcontent_row + '\').remove();" class="button"><?php echo $button_remove; ?></a></td>';
	html += '  </tr>';
    html += '</tbody>';
	
	$('#metalcontent tfoot').before(html);
 
	$('#metalcontent-row' + metalcontent_row + ' .date').datepicker({dateFormat: 'yy-mm-dd'});
	
	metalcontent_row++;
}
//--></script> 
<script type="text/javascript" src="view/javascript/ckeditor/ckeditor.js"></script> 
<script type="text/javascript"><!--
<?php foreach ($languages as $language) { ?>
CKEDITOR.replace('description<?php echo $language['language_id']; ?>', {
	filebrowserBrowseUrl: 'index.php?route=common/filemanager&token=<?php echo $token; ?>',
	filebrowserImageBrowseUrl: 'index.php?route=common/filemanager&token=<?php echo $token; ?>',
	filebrowserFlashBrowseUrl: 'index.php?route=common/filemanager&token=<?php echo $token; ?>',
	filebrowserUploadUrl: 'index.php?route=common/filemanager&token=<?php echo $token; ?>',
	filebrowserImageUploadUrl: 'index.php?route=common/filemanager&token=<?php echo $token; ?>',
	filebrowserFlashUploadUrl: 'index.php?route=common/filemanager&token=<?php echo $token; ?>'
});
<?php } ?>
//--></script> 
<script type="text/javascript"><!--
$('input[name=\'related\']').autocomplete({
	delay: 0,
	source: function(request, response) {
		$.ajax({
			url: 'index.php?route=catalog/product/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request.term),
			dataType: 'json',
			success: function(json) {		
				response($.map(json, function(item) {
					return {
						label: item.name,
						value: item.product_id
					}
				}));
			}
		});
		
	}, 
	select: function(event, ui) {
		$('#product-related' + ui.item.value).remove();
		
		$('#product-related').append('<div id="product-related' + ui.item.value + '">' + ui.item.label + '<img src="view/image/delete.png" /><input type="hidden" name="product_related[]" value="' + ui.item.value + '" /></div>');

		$('#product-related div:odd').attr('class', 'odd');
		$('#product-related div:even').attr('class', 'even');
				
		return false;
	}
});

$('#product-related div img').live('click', function() {
	$(this).parent().remove();
	
	$('#product-related div:odd').attr('class', 'odd');
	$('#product-related div:even').attr('class', 'even');	
});
//--></script> 
<script type="text/javascript"><!--
var attribute_row = <?php echo $attribute_row; ?>;

function addAttribute() {
	html  = '<tbody id="attribute-row' + attribute_row + '">';
    html += '  <tr>';
	html += '    <td class="left"><input type="text" name="product_attribute[' + attribute_row + '][name]" value="" /><input type="hidden" name="product_attribute[' + attribute_row + '][attribute_id]" value="" /></td>';
	html += '    <td class="left">';
	<?php foreach ($languages as $language) { ?>
	html += '<textarea name="product_attribute[' + attribute_row + '][product_attribute_description][<?php echo $language['language_id']; ?>][text]" cols="40" rows="5"></textarea><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /><br />';
    <?php } ?>
	html += '    </td>';
	html += '    <td class="left"><a onclick="$(\'#attribute-row' + attribute_row + '\').remove();" class="button"><?php echo $button_remove; ?></a></td>';
    html += '  </tr>';	
    html += '</tbody>';
	
	$('#attribute tfoot').before(html);
	
	attributeautocomplete(attribute_row);
	
	attribute_row++;
}

$.widget('custom.catcomplete', $.ui.autocomplete, {
	_renderMenu: function(ul, items) {
		var self = this, currentCategory = '';
		
		$.each(items, function(index, item) {
			if (item.category != currentCategory) {
				ul.append('<li class="ui-autocomplete-category">' + item.category + '</li>');
				
				currentCategory = item.category;
			}
			
			self._renderItem(ul, item);
		});
	}
});

function attributeautocomplete(attribute_row) {
	$('input[name=\'product_attribute[' + attribute_row + '][name]\']').catcomplete({
		delay: 0,
		source: function(request, response) {
			$.ajax({
				url: 'index.php?route=catalog/attribute/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request.term),
				dataType: 'json',
				success: function(json) {	
					response($.map(json, function(item) {
						return {
							category: item.attribute_group,
							label: item.name,
							value: item.attribute_id
						}
					}));
				}
			});
		}, 
		select: function(event, ui) {
			$('input[name=\'product_attribute[' + attribute_row + '][name]\']').attr('value', ui.item.label);
			$('input[name=\'product_attribute[' + attribute_row + '][attribute_id]\']').attr('value', ui.item.value);
			
			return false;
		}
	});
}

$('#attribute tbody').each(function(index, element) {
	attributeautocomplete(index);
});
//--></script> 
<script type="text/javascript"><!--	
var option_row = <?php echo $option_row; ?>;

$('input[name=\'option\']').catcomplete({
	delay: 0,
	source: function(request, response) {
		$.ajax({
			url: 'index.php?route=catalog/option/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request.term),
			dataType: 'json',
			success: function(json) {
				response($.map(json, function(item) {
					return {
						category: item.category,
						label: item.name,
						value: item.option_id,
						type: item.type
					}
				}));
			}
		});
	}, 
	select: function(event, ui) {
		html  = '<div id="tab-option-' + option_row + '" class="vtabs-content">';
		html += '	<input type="hidden" name="product_option[' + option_row + '][product_option_id]" value="" />';
		html += '	<input type="hidden" name="product_option[' + option_row + '][name]" value="' + ui.item.label + '" />';
		html += '	<input type="hidden" name="product_option[' + option_row + '][option_id]" value="' + ui.item.value + '" />';
		html += '	<input type="hidden" name="product_option[' + option_row + '][type]" value="' + ui.item.type + '" />';
		html += '	<table class="form">';
		html += '	  <tr>';
		html += '		<td><?php echo $entry_required; ?></td>';
		html += '       <td><select name="product_option[' + option_row + '][required]">';
		html += '	      <option value="1"><?php echo $text_yes; ?></option>';
		html += '	      <option value="0"><?php echo $text_no; ?></option>';
		html += '	    </select></td>';
		html += '     </tr>';
		
		if (ui.item.type == 'text') {
			html += '     <tr>';
			html += '       <td><?php echo $entry_option_value; ?></td>';
			html += '       <td><input type="text" name="product_option[' + option_row + '][option_value]" value="" /></td>';
			html += '     </tr>';
		}
		
		if (ui.item.type == 'textarea') {
			html += '     <tr>';
			html += '       <td><?php echo $entry_option_value; ?></td>';
			html += '       <td><textarea name="product_option[' + option_row + '][option_value]" cols="40" rows="5"></textarea></td>';
			html += '     </tr>';						
		}
		 
		if (ui.item.type == 'file') {
			html += '     <tr style="display: none;">';
			html += '       <td><?php echo $entry_option_value; ?></td>';
			html += '       <td><input type="text" name="product_option[' + option_row + '][option_value]" value="" /></td>';
			html += '     </tr>';			
		}
						
		if (ui.item.type == 'date') {
			html += '     <tr>';
			html += '       <td><?php echo $entry_option_value; ?></td>';
			html += '       <td><input type="text" name="product_option[' + option_row + '][option_value]" value="" class="date" /></td>';
			html += '     </tr>';			
		}
		
		if (ui.item.type == 'datetime') {
			html += '     <tr>';
			html += '       <td><?php echo $entry_option_value; ?></td>';
			html += '       <td><input type="text" name="product_option[' + option_row + '][option_value]" value="" class="datetime" /></td>';
			html += '     </tr>';			
		}
		
		if (ui.item.type == 'time') {
			html += '     <tr>';
			html += '       <td><?php echo $entry_option_value; ?></td>';
			html += '       <td><input type="text" name="product_option[' + option_row + '][option_value]" value="" class="time" /></td>';
			html += '     </tr>';			
		}
		
		html += '  </table>';
			
		if (ui.item.type == 'select' || ui.item.type == 'radio' || ui.item.type == 'checkbox' || ui.item.type == 'image') {
			html += '  <table id="option-value' + option_row + '" class="list">';
			html += '  	 <thead>'; 
			html += '      <tr>';
			html += '        <td class="left"><?php echo $entry_option_value; ?></td>';
			html += '        <td class="right"><?php echo $entry_quantity; ?></td>';
			html += '        <td class="left"><?php echo $entry_subtract; ?></td>';
			html += '        <td class="right"><?php echo $entry_price; ?></td>';
			html += '        <td class="right"><?php echo $entry_option_points; ?></td>';
			html += '        <td class="right"><?php echo $entry_weight; ?></td>';
			html += '        <td></td>';
			html += '      </tr>';
			html += '  	 </thead>';
			html += '    <tfoot>';
			html += '      <tr>';
			html += '        <td colspan="6"></td>';
			html += '        <td class="left"><a onclick="addOptionValue(' + option_row + ');" class="button"><?php echo $button_add_option_value; ?></a></td>';
			html += '      </tr>';
			html += '    </tfoot>';
			html += '  </table>';
			html += '</div>';	
		}
		
		$('#tab-option').append(html);
		
		$('#option-add').before('<a href="#tab-option-' + option_row + '" id="option-' + option_row + '">' + ui.item.label + '&nbsp;<img src="view/image/delete.png" alt="" onclick="$(\'#vtab-option a:first\').trigger(\'click\'); $(\'#option-' + option_row + '\').remove(); $(\'#tab-option-' + option_row + '\').remove(); return false;" /></a>');
		
		$('#vtab-option a').tabs();
		
		$('#option-' + option_row).trigger('click');		
		
		$('.date').datepicker({dateFormat: 'yy-mm-dd'});
		$('.datetime').datetimepicker({
			dateFormat: 'yy-mm-dd',
			timeFormat: 'h:m'
		});	
			
		$('.time').timepicker({timeFormat: 'h:m'});	
				
		option_row++;
		
		return false;
	}
});
//--></script> 
<script type="text/javascript"><!--		
var option_value_row = <?php echo $option_value_row; ?>;

function addOptionValue(option_row) {	
	html  = '<tbody id="option-value-row' + option_value_row + '">';
	html += '  <tr>';
	html += '    <td class="left"><select name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][option_value_id]"></select><input type="hidden" name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][product_option_value_id]" value="" /></td>';
	html += '    <td class="right"><input type="text" name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][quantity]" value="" size="3" /></td>'; 
	html += '    <td class="left"><select name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][subtract]">';
	html += '      <option value="1"><?php echo $text_yes; ?></option>';
	html += '      <option value="0"><?php echo $text_no; ?></option>';
	html += '    </select></td>';
	html += '    <td class="right"><select name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][price_prefix]">';
	html += '      <option value="+">+</option>';
	html += '      <option value="-">-</option>';
	html += '    </select>';
	html += '    <input type="text" name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][price]" value="" size="5" /></td>';
	html += '    <td class="right"><select name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][points_prefix]">';
	html += '      <option value="+">+</option>';
	html += '      <option value="-">-</option>';
	html += '    </select>';
	html += '    <input type="text" name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][points]" value="" size="5" /></td>';	
	html += '    <td class="right"><select name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][weight_prefix]">';
	html += '      <option value="+">+</option>';
	html += '      <option value="-">-</option>';
	html += '    </select>';
	html += '    <input type="text" name="product_option[' + option_row + '][product_option_value][' + option_value_row + '][weight]" value="" size="5" /></td>';
	html += '    <td class="left"><a onclick="$(\'#option-value-row' + option_value_row + '\').remove();" class="button"><?php echo $button_remove; ?></a></td>';
	html += '  </tr>';
	html += '</tbody>';
	
	$('#option-value' + option_row + ' tfoot').before(html);

	$('select[name=\'product_option[' + option_row + '][product_option_value][' + option_value_row + '][option_value_id]\']').load('index.php?route=catalog/product/option&token=<?php echo $token; ?>&option_id=' + $('input[name=\'product_option[' + option_row + '][option_id]\']').attr('value'));
	
	option_value_row++;
}
//--></script> 
<script type="text/javascript"><!--
var discount_row = <?php echo $discount_row; ?>;

function addDiscount() {
	html  = '<tbody id="discount-row' + discount_row + '">';
	html += '  <tr>'; 
    html += '    <td class="left"><select name="product_discount[' + discount_row + '][customer_group_id]">';
    <?php foreach ($customer_groups as $customer_group) { ?>
    html += '      <option value="<?php echo $customer_group['customer_group_id']; ?>"><?php echo $customer_group['name']; ?></option>';
    <?php } ?>
    html += '    </select></td>';		
    html += '    <td class="right"><input type="text" name="product_discount[' + discount_row + '][quantity]" value="" size="2" /></td>';
    html += '    <td class="right"><input type="text" name="product_discount[' + discount_row + '][priority]" value="" size="2" /></td>';
	html += '    <td class="right"><input type="text" name="product_discount[' + discount_row + '][price]" value="" /></td>';
    html += '    <td class="left"><input type="text" name="product_discount[' + discount_row + '][date_start]" value="" class="date" /></td>';
	html += '    <td class="left"><input type="text" name="product_discount[' + discount_row + '][date_end]" value="" class="date" /></td>';
	html += '    <td class="left"><a onclick="$(\'#discount-row' + discount_row + '\').remove();" class="button"><?php echo $button_remove; ?></a></td>';
	html += '  </tr>';	
    html += '</tbody>';
	
	$('#discount tfoot').before(html);
		
	$('#discount-row' + discount_row + ' .date').datepicker({dateFormat: 'yy-mm-dd'});
	
	discount_row++;
}
//--></script> 
<script type="text/javascript"><!--
var special_row = <?php echo $special_row; ?>;

function addSpecial() {
	html  = '<tbody id="special-row' + special_row + '">';
	html += '  <tr>'; 
    html += '    <td class="left"><select name="product_special[' + special_row + '][customer_group_id]">';
    <?php foreach ($customer_groups as $customer_group) { ?>
    html += '      <option value="<?php echo $customer_group['customer_group_id']; ?>"><?php echo $customer_group['name']; ?></option>';
    <?php } ?>
    html += '    </select></td>';		
    html += '    <td class="right"><input type="text" name="product_special[' + special_row + '][priority]" value="" size="2" /></td>';
	html += '    <td class="right"><input type="text" name="product_special[' + special_row + '][price]" value="" /></td>';
    html += '    <td class="left"><input type="text" name="product_special[' + special_row + '][date_start]" value="" class="date" /></td>';
	html += '    <td class="left"><input type="text" name="product_special[' + special_row + '][date_end]" value="" class="date" /></td>';
	html += '    <td class="left"><a onclick="$(\'#special-row' + special_row + '\').remove();" class="button"><?php echo $button_remove; ?></a></td>';
	html += '  </tr>';
    html += '</tbody>';
	
	$('#special tfoot').before(html);
 
	$('#special-row' + special_row + ' .date').datepicker({dateFormat: 'yy-mm-dd'});
	
	special_row++;
}
//--></script> 
<script type="text/javascript"><!--
function image_upload(field, thumb) {
	$('#dialog').remove();
	
	$('#content').prepend('<div id="dialog" style="padding: 3px 0px 0px 0px;"><iframe src="index.php?route=common/filemanager&token=<?php echo $token; ?>&field=' + encodeURIComponent(field) + '" style="padding:0; margin: 0; display: block; width: 100%; height: 100%;" frameborder="no" scrolling="auto"></iframe></div>');
	
	$('#dialog').dialog({
		title: '<?php echo $text_image_manager; ?>',
		close: function (event, ui) {
			if ($('#' + field).attr('value')) {
				$.ajax({
					url: 'index.php?route=common/filemanager/image&token=<?php echo $token; ?>&image=' + encodeURIComponent($('#' + field).attr('value')),
					dataType: 'text',
					success: function(text) {
						$('#' + thumb).replaceWith('<img src="' + text + '" alt="" id="' + thumb + '" />');
					}
				});
			}
		},	
		bgiframe: false,
		width: 800,
		height: 400,
		resizable: false,
		modal: false
	});
};
//--></script> 
<script type="text/javascript"><!--
var image_row = <?php echo $image_row; ?>;

function addImage() {
    html  = '<tbody id="image-row' + image_row + '">';
	html += '  <tr>';
	html += '    <td class="left"><div class="image"><img src="<?php echo $no_image; ?>" alt="" id="thumb' + image_row + '" /><input type="hidden" name="product_image[' + image_row + '][image]" value="" id="image' + image_row + '" /><br /><a onclick="image_upload(\'image' + image_row + '\', \'thumb' + image_row + '\');"><?php echo $text_browse; ?></a>&nbsp;&nbsp;|&nbsp;&nbsp;<a onclick="$(\'#thumb' + image_row + '\').attr(\'src\', \'<?php echo $no_image; ?>\'); $(\'#image' + image_row + '\').attr(\'value\', \'\');"><?php echo $text_clear; ?></a></div></td>';
	html += '    <td class="right"><input type="text" name="product_image[' + image_row + '][sort_order]" value="" /></td>';
	html += '    <td class="left"><a onclick="$(\'#image-row' + image_row  + '\').remove();" class="button"><?php echo $button_remove; ?></a></td>';
	html += '  </tr>';
	html += '</tbody>';
	
	$('#images tfoot').before(html);
	
	image_row++;
}
//--></script> 
<script type="text/javascript" src="view/javascript/jquery/ui/jquery-ui-timepicker-addon.js"></script> 
<script type="text/javascript"><!--
$('.date').datepicker({dateFormat: 'yy-mm-dd'});
$('.datetime').datetimepicker({
	dateFormat: 'yy-mm-dd',
	timeFormat: 'h:m'
});
$('.time').timepicker({timeFormat: 'h:m'});
//--></script> 
<script type="text/javascript"><!--
$('#tabs a').tabs(); 
$('#languages a').tabs(); 
$('#vtab-option a').tabs();
//--></script> 
<?php echo $footer; ?>