<?php
class ModelSaleMetalmaster extends Model {
	public function addCustomerGroup($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "metal SET metal_code = '" . $this->db->escape($data['metal_code']) . "',metalname = '" . $this->db->escape($data['metalname']) . "',silver_ratio = '" . $this->db->escape($data['silver_ratio']) . "',description = '" . $this->db->escape($data['description']) . "',pricepergram = '" . $this->db->escape($data['pricepergram']) . "',priceperounce = '" . $this->db->escape($data['priceperounce']) . "',ccurrency = '" . $this->db->escape($data['ccurrency']) . "',image = '" . $this->db->escape($data['image']) . "',sort_order = '" . $this->db->escape($data['sort_order']) . "'");
	}
	
	public function editCustomerGroup($metal_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "metal SET metal_code = '" . $this->db->escape($data['metal_code']) . "',metalname = '" . $this->db->escape($data['metalname']) . "',silver_ratio = '" . $this->db->escape($data['silver_ratio']) . "',description = '" . $this->db->escape($data['description']) . "',pricepergram = '" . $this->db->escape($data['pricepergram']) . "',priceperounce = '" . $this->db->escape($data['priceperounce']) . "',ccurrency = '" . $this->db->escape($data['ccurrency']) . "',sort_order = '" . $this->db->escape($data['sort_order']) . "',image = '" . $this->db->escape($data['image']) . "'  WHERE metal_id = '" . (int)$metal_id . "'");
	}
	
	public function deleteCustomerGroup($metal_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "metal WHERE metal_id = '" . (int)$metal_id . "'");
	//	$this->db->query("DELETE FROM " . DB_PREFIX . "product_discount WHERE metal_id = '" . (int)$metal_id . "'");
	}
	
	public function getCustomerGroup($metal_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "metal WHERE metal_id = '" . (int)$metal_id . "'");
		
		return $query->row;
	}
	
	public function getCustomerGroups($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "metal";
		
		$sql .= " ORDER BY metal_code";	
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
			
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getTotalCustomerGroups() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "metal");
		
		return $query->row['total'];
	}
}
?>