<?php
class ModelSaleColourMaster extends Model {
	public function addCustomerGroup($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "colour SET colour_code = '" . $this->db->escape($data['colour_code']) . "',colour_descr = '" . $this->db->escape($data['colour_descr']) . "'");
	}
	
	public function editCustomerGroup($colour_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "colour SET colour_code = '" . $this->db->escape($data['colour_code']) . "',colour_descr = '" . $this->db->escape($data['colour_descr']) . "' WHERE colour_id = '" . (int)$colour_id . "'");
	}
	
	public function deleteCustomerGroup($colour_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "colour WHERE colour_id = '" . (int)$colour_id . "'");
		
	}
	
	public function getCustomerGroup($colour_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "colour WHERE colour_id = '" . (int)$colour_id . "'");
		
		return $query->row;
	}
	
	public function getCustomerGroups($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "colour";
		
		$sql .= " ORDER BY colour_id";	
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
			
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getTotalCustomerGroups() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "colour");
		
		return $query->row['total'];
	}
}
?>