<?php
class ControllerTotalLoyalty extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('total/loyalty');

		$this->document->setTitle = $this->language->get('heading_title');

		$this->load->model('setting/setting');
		$this->load->model('sale/customer_group');
		
		$this->data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();
		$this->load->model('catalog/loyalty');
		$this->data['loyalty_select'] = $this->model_catalog_loyalty->getLoyaltyselect();
		$this->data['loyalty_Discountselect'] = $this->model_catalog_loyalty->getLoyaltyDiscountType();

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->model_setting_setting->editSetting('loyalty', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect(HTTPS_SERVER . 'index.php?route=extension/total&token=' . $this->session->data['token']);
		}
		
		if (isset($this->request->post['loyalty_discount'])) {
			$this->data['loyalty_discounts'] = $this->request->post['loyalty_discount'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['loyalty_discounts'] = $this->model_catalog_loyalty->getLoyaltyDiscounts();
		} else {
			$this->data['loyalty_discounts'] = $this->model_catalog_loyalty->getLoyaltyDiscounts();
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_none'] = $this->language->get('text_none');

		$this->data['entry_total'] = $this->language->get('entry_total');
		$this->data['entry_description'] = $this->language->get('entry_description');
		$this->data['entry_daydateinfor'] = $this->language->get('entry_daydateinfor');
		$this->data['entry_daydate'] = $this->language->get('entry_daydate');
		$this->data['entry_amount'] = $this->language->get('entry_amount');
		$this->data['entry_type'] = $this->language->get('entry_type');
		$this->data['entry_date_start'] = $this->language->get('entry_date_start');
		$this->data['entry_date_end'] = $this->language->get('entry_date_end');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

   		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
		'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_total'),
		'href'      => $this->url->link('extension/total', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
		'href'      => $this->url->link('extension/total', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);

   		$this->document->breadcrumbs[] = array(
       		'text'      => $this->language->get('heading_title'),
       		'href'      => $this->url->link('total/sidewide_discount', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['action'] = HTTPS_SERVER . 'index.php?route=total/loyalty&token=' . $this->session->data['token'];
		
		if (!isset($this->request->get['loyalty_id'])) {
			$this->data['action'] = $this->url->link('total/loyalty/update', 'token=' . $this->session->data['token'] , 'SSL'); 
		} else {
			$this->data['action'] = $this->url->link('total/loyalty/update', 'token=' . $this->session->data['token'] . '&loyalty_id=' . $this->request->get['loyalty_id']. 'SSL');
		}

		$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=extension/total&token=' . $this->session->data['token'];

		if (isset($this->request->post['loyalty_description'])) {
			$this->data['loyalty_description'] = $this->request->post['loyalty_description'];
		} else {
			$this->data['loyalty_description'] = $this->config->get('loyalty_description');
		}
		if (isset($this->request->post['loyalty_daydate'])) {
			$this->data['loyalty_daydate'] = $this->request->post['loyalty_daydate'];
		} else {
			$this->data['loyalty_daydate'] = $this->config->get('loyalty_daydate');
		}
		/* if (isset($this->request->post['loyalty_total'])) {
			$this->data['loyalty_total'] = $this->request->post['loyalty_total'];
		} else {
			$this->data['loyalty_total'] = $this->config->get('loyalty_total');
		}

		if (isset($this->request->post['loyalty_amount'])) {
			$this->data['loyalty_amount'] = $this->request->post['loyalty_amount'];
		} else {
			$this->data['loyalty_amount'] = $this->config->get('loyalty_amount');
		}

		if (isset($this->request->post['loyalty_type'])) {
			$this->data['loyalty_type'] = $this->request->post['loyalty_type'];
		} else {
			$this->data['loyalty_type'] = $this->config->get('loyalty_type');
		}

		if (isset($this->request->post['loyalty_date_start'])) {
			$this->data['loyalty_date_start'] = $this->request->post['loyalty_date_start'];
		} else {
			$this->data['loyalty_date_start'] = $this->config->get('loyalty_date_start');
		}

		if (isset($this->request->post['loyalty_date_end'])) {
			$this->data['loyalty_date_end'] = $this->request->post['loyalty_date_end'];
		} else {
			$this->data['loyalty_date_end'] = $this->config->get('loyalty_date_end');
		} */

		if (isset($this->request->post['loyalty_status'])) {
			$this->data['loyalty_status'] = $this->request->post['loyalty_status'];
		} else {
			$this->data['loyalty_status'] = 0;
		}

		if (isset($this->request->post['loyalty_sort_order'])) {
			$this->data['loyalty_sort_order'] = $this->request->post['loyalty_sort_order'];
		} else {
			$this->data['loyalty_sort_order'] = $this->config->get('loyalty_sort_order');
		}

		$this->load->model('localisation/tax_class');

		$this->data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

		$this->template = 'total/loyalty.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render());
	}
	
	public function update() {
    	$this->load->language('total/loyalty');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/loyalty');
	
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_catalog_loyalty->editloyalty( $this->request->post); 
			$this->session->data['success'] = $this->language->get('text_success');
	
			$this->redirect($this->url->link('total/loyalty', 'token=' . $this->session->data['token'], 'SSL'));
		}
  	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'total/loyalty')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
}
?>