<?php
class ControllerSalerapnet extends Controller {
	private $error = array();
   
	public function index() {
		$this->load->language('sale/rapnet');
 
		$this->document->setTitle($this->language->get('heading_title'));
 		
		$this->load->model('sale/rapnet');
		
		$this->getList();
	}

	public function insert() {
		$this->load->language('sale/rapnet');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/rapnet');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_rapnet->addrapnet($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/rapnet', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function update() {
		$this->load->language('sale/rapnet');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/rapnet');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_rapnet->editrapnet($this->request->get['rapnet_id'], $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/rapnet', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function delete() { 
		$this->load->language('sale/rapnet');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/rapnet');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
      		foreach ($this->request->post['selected'] as $rapnet_id) {
				$this->model_sale_rapnet->deleterapnet($rapnet_id);	
			}
						
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/rapnet', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'metal_code';
		}
		 
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}	
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
			
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/rapnet', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		$this->data['insert'] = $this->url->link('sale/rapnet/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('sale/rapnet/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	
	
		$this->data['rapnets'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$rapnet_total = $this->model_sale_rapnet->getTotalCustomerGroups();
		
		$results = $this->model_sale_rapnet->getGemStonePrices($data);

		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/rapnet/update', 'token=' . $this->session->data['token'] . '&rapnet_id=' . $result['rapnet_id'] . $url, 'SSL')
			);		
		
			$this->data['rapnets'][] = array(
				'rapnet_id' => $result['rapnet_id'],
			//	'gemname' => $result['gemname'],
				'rapnet_id' => $result['rapnet_id'],
				'lowweight' => $result['lowweight'],
				'highweight' => $result['highweight'],
				'clarity_default' => $result['clarity_default'],
				'colour_default' => $result['colour_default'],
				'selected'          => isset($this->request->post['selected']) && in_array($result['rapnet_id'], $this->request->post['selected']),
				'action'            => $action
			);
		}	
	
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_lowclarity'] = $this->language->get('column_lowclarity');
		$this->data['column_highclarity'] = $this->language->get('column_highclarity');
		$this->data['column_gemstone'] = $this->language->get('column_gemstone');
		$this->data['column_action'] = $this->language->get('column_action');
		$this->data['column_lowweight'] = $this->language->get('column_lowweight');
		$this->data['column_highweight'] = $this->language->get('column_highweight');
		$this->data['column_cost'] = $this->language->get('column_cost');
		$this->data['column_lowweight'] = $this->language->get('column_lowweight');
		$this->data['column_highweight'] = $this->language->get('column_highweight');
		$this->data['column_pricetype'] = $this->language->get('column_pricetype');
		$this->data['column_price'] = $this->language->get('column_price');
		$this->data['column_clarity_default'] = $this->language->get('column_clarity_default');
		$this->data['column_colour_default'] = $this->language->get('column_colour_default');
		$this->data['column_appilicablecost'] = $this->language->get('column_appilicablecost');

		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_metal_code'] = $this->url->link('sale/rapnet', 'token=' . $this->session->data['token'] . '&sort=metal_code' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $rapnet_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/rapnet', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		
		$this->data['pagination'] = $pagination->render();				

		$this->data['sort'] = $sort; 
		$this->data['order'] = $order;

		$this->template = 'sale/rapnet_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
 	}

	private function getForm() {
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['entry_code'] = $this->language->get('entry_code');
		$this->data['entry_gemstone'] = $this->language->get('entry_gemstone');
		$this->data['entry_lowclarity'] = $this->language->get('entry_lowclarity');
		$this->data['entry_highclarity'] = $this->language->get('entry_highclarity');
		$this->data['entry_lowcolor'] = $this->language->get('entry_lowcolor');
		$this->data['entry_highcolor'] = $this->language->get('entry_highcolor');
		$this->data['entry_lowweight'] = $this->language->get('entry_lowweight');
		$this->data['entry_highweight'] = $this->language->get('entry_highweight');
		$this->data['entry_shape'] = $this->language->get('entry_shape');
		$this->data['entry_price'] = $this->language->get('entry_price');
		$this->data['entry_pricetype'] = $this->language->get('entry_pricetype');
		$this->data['entry_currency'] = $this->language->get('entry_currency');
		$this->data['entry_variation'] = $this->language->get('entry_variation');
		$this->data['entry_clarity_default'] = $this->language->get('entry_clarity_default');
		$this->data['entry_colour_default'] = $this->language->get('entry_colour_default');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['low_weight'])) {
			$this->data['error_low_weight'] = $this->error['low_weight'];
		} else {
			$this->data['error_low_weight'] = '';
		}
		
 		if (isset($this->error['high_weight'])) {
			$this->data['error_high_weight'] = $this->error['high_weight'];
		} else {
			$this->data['error_high_weight'] = '';
		}
		
 		if (isset($this->error['cost'])) {
			$this->data['error_cost'] = $this->error['cost'];
		} else {
			$this->data['error_cost'] = '';
		}
		
 		if (isset($this->error['lowweight'])) {
			$this->data['error_lowweight'] = $this->error['lowweight'];
		} else {
			$this->data['error_lowweight'] = '';
		}
		
 		if (isset($this->error['highweight'])) {
			$this->data['error_highweight'] = $this->error['highweight'];
		} else {
			$this->data['error_highweight'] = '';
		}
		
 		if (isset($this->error['variation'])) {
			$this->data['error_variation'] = $this->error['variation'];
		} else {
			$this->data['error_variation'] = '';
		}
		
 		if (isset($this->error['pricetype'])) {
			$this->data['error_pricetype'] = $this->error['pricetype'];
		} else {
			$this->data['error_pricetype'] = '';
		}
		
 		if (isset($this->error['clarity_default'])) {
			$this->data['error_clarity_default'] = $this->error['clarity_default'];
		} else {
			$this->data['error_clarity_default'] = '';
		}
		
 		if (isset($this->error['colour_default'])) {
			$this->data['error_colour_default'] = $this->error['colour_default'];
		} else {
			$this->data['error_colour_default'] = '';
		}
		
 		if (isset($this->error['applicable_cost'])) {
			$this->data['error_applicable_cost'] = $this->error['applicable_cost'];
		} else {
			$this->data['error_applicable_cost'] = '';
		}

		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/rapnet', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
			
		if (!isset($this->request->get['rapnet_id'])) {
			$this->data['action'] = $this->url->link('sale/rapnet/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('sale/rapnet/update', 'token=' . $this->session->data['token'] . '&rapnet_id=' . $this->request->get['rapnet_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('sale/rapnet', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if (isset($this->request->get['rapnet_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$rapnet_info = $this->model_sale_rapnet->getGemStoneInfo($this->request->get['rapnet_id']);
		}
		$this->load->model('sale/supplier_group');
		
    	$this->data['suppliers'] = $this->model_sale_supplier_group->getCustomerGroups();

    	if (isset($this->request->post['supplier_group_id'])) {
      		$this->data['supplier_group_id'] = $this->request->post['supplier_group_id'];
		} elseif (!empty($product_info)) {
			$this->data['supplier_group_id'] = $product_info['supplier_group_id'];
		} else {
      		$this->data['supplier_group_id'] = 0;
    	} 

		if (isset($this->request->post['lowweight'])) {
			$this->data['lowweight'] = $this->request->post['lowweight'];
		} elseif (isset($rapnet_info)) {
			$this->data['lowweight'] = $rapnet_info['lowweight'];
		} else {
			$this->data['lowweight'] = '';
		} 

		if (isset($this->request->post['variation'])) {
			$this->data['variation'] = $this->request->post['variation'];
		} elseif (isset($rapnet_info)) {
			$this->data['variation'] = $rapnet_info['variation'];
		} else {
			$this->data['variation'] = '';
		} 
		
		$this->load->model('sale/clarity_master');
			
		$this->data['claritydefaultmasters'] = $this->model_sale_clarity_master->getCustomerGroups();

		if (isset($this->request->post['clarity_default'])) {
			$this->data['clarity_default'] = $this->request->post['clarity_default'];
		} elseif (isset($rapnet_info)) {
			$this->data['clarity_default'] = $rapnet_info['clarity_default'];
		} else {
			$this->data['clarity_default'] = '';
		} 
		
		$this->load->model('sale/colour_master');
			
		$this->data['lowcolordefaultclaritys'] = $this->model_sale_colour_master->getCustomerGroups();

		if (isset($this->request->post['colour_default'])) {
			$this->data['colour_default'] = $this->request->post['colour_default'];
		} elseif (isset($rapnet_info)) {
			$this->data['colour_default'] = $rapnet_info['colour_default'];
		} else {
			$this->data['colour_default'] = '';
		}

		if (isset($this->request->post['highweight'])) {
			$this->data['highweight'] = $this->request->post['highweight'];
		} elseif (isset($rapnet_info)) {
			$this->data['highweight'] = $rapnet_info['highweight'];
		} else {
			$this->data['highweight'] = '';
		}
		/*
		if (isset($this->request->post['pricepercarat'])) {
			$this->data['pricepercarat'] = $this->request->post['pricepercarat'];
		} elseif (isset($gemstoneprice_info)) {
			$this->data['pricepercarat'] = $gemstoneprice_info['pricepercarat'];
		} else {
			$this->data['pricepercarat'] = '';
		}

		if (isset($this->request->post['priceperpiece'])) {
			$this->data['priceperpiece'] = $this->request->post['priceperpiece'];
		} elseif (isset($gemstoneprice_info)) {
			$this->data['priceperpiece'] = $gemstoneprice_info['priceperpiece'];
		} else {
			$this->data['priceperpiece'] = '';
		}
		*/
		
		if ($this->config->get('config_currency_auto')) {
			$this->load->model('localisation/currency');
		
			$this->model_localisation_currency->updateCurrencies();
		}	
		
		$this->load->model('localisation/currency');
		
		$this->data['currencies'] = $this->model_localisation_currency->getCurrencies();

		
		$this->load->model('sale/gemstonelist');
			
		$this->data['gemstonelists'] = $this->model_sale_gemstonelist->getCustomerGroups();
		
		$this->load->model('sale/clarity_master');
			
		$this->data['claritymasters'] = $this->model_sale_clarity_master->getCustomerGroups();

    	if (isset($this->request->post['lowclarity'])) {
      		$this->data['lowclarity'] = $this->request->post['lowclarity'];
    	} elseif (isset($rapnet_info)) { 
			$this->data['lowclarity'] = $rapnet_info['lowclarity'];
		} else {
      		$this->data['lowclarity'] = $this->config->get('config_clarity_id');
    	}
	
		$this->load->model('sale/clarity_master');
			
		$this->data['highclaritymasters'] = $this->model_sale_clarity_master->getCustomerGroups();

    	if (isset($this->request->post['highclarity'])) {
      		$this->data['highclarity'] = $this->request->post['highclarity'];
    	} elseif (isset($rapnet_info)) { 
			$this->data['highclarity'] = $rapnet_info['highclarity'];
		} else {
      		$this->data['highclarity'] = $this->config->get('config_clarity_id');
    	}
	
		$this->load->model('sale/colour_master');
			
		$this->data['lowcolorclaritys'] = $this->model_sale_colour_master->getCustomerGroups();

    	if (isset($this->request->post['lowcolour'])) {
      		$this->data['lowcolour'] = $this->request->post['lowcolour'];
    	} elseif (isset($rapnet_info)) { 
			$this->data['lowcolour'] = $rapnet_info['lowcolour'];
		} else {
      		$this->data['lowcolour'] = $this->config->get('config_colour_id');
    	}
	
		$this->load->model('sale/colour_master');
			
		$this->data['highcolorclaritys'] = $this->model_sale_colour_master->getCustomerGroups();

    	if (isset($this->request->post['highcolour'])) {
      		$this->data['highcolour'] = $this->request->post['highcolour'];
    	} elseif (isset($rapnet_info)) { 
			$this->data['highcolour'] = $rapnet_info['highcolour'];
		} else {
      		$this->data['highcolour'] = $this->config->get('config_colour_id');
    	}
		
		$this->load->model('sale/gemstone');
			
		$this->data['gemshapes'] = $this->model_sale_gemstone->getCustomerGroups();

    	if (isset($this->request->post['shape'])) {
      		$this->data['shape'] = $this->request->post['shape'];
    	} elseif (isset($rapnet_info)) { 
			$this->data['shape'] = $rapnet_info['shape'];
		} else {
      		$this->data['shape'] = $this->config->get('config_shape_id');
    	}
		
	
		$this->template = 'sale/rapnet_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render()); 
	}

	private function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/rapnet')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['lowweight']) < 1) || (utf8_strlen($this->request->post['lowweight']) > 64)) {
			$this->error['lowweight'] = $this->language->get('error_lowweight');
		}

		if ((utf8_strlen($this->request->post['highweight']) < 1) || (utf8_strlen($this->request->post['highweight']) > 64)) {
			$this->error['highweight'] = $this->language->get('error_highweight');
		}

		if ((utf8_strlen($this->request->post['variation']) < 1) || (utf8_strlen($this->request->post['variation']) > 64)) {
			$this->error['variation'] = $this->language->get('error_variation');
		}

		if ((utf8_strlen($this->request->post['clarity_default']) < 1) || (utf8_strlen($this->request->post['clarity_default']) > 64)) {
			$this->error['clarity_default'] = $this->language->get('error_clarity_default');
		}

		if ((utf8_strlen($this->request->post['colour_default']) < 1) || (utf8_strlen($this->request->post['colour_default']) > 64)) {
			$this->error['colour_default'] = $this->language->get('error_colour_default');
		}
/*
		if ((utf8_strlen($this->request->post['pricepercarat']) < 1) || (utf8_strlen($this->request->post['pricepercarat']) > 64)) {
			$this->error['pricepercarat'] = $this->language->get('error_pricepercarat');
		}

		if ((utf8_strlen($this->request->post['priceperpiece']) < 1) || (utf8_strlen($this->request->post['priceperpiece']) > 64)) {
			$this->error['priceperpiece'] = $this->language->get('error_priceperpiece');
		}

		if ((utf8_strlen($this->request->post['pricetype']) < 1) || (utf8_strlen($this->request->post['pricetype']) > 64)) {
			$this->error['pricetype'] = $this->language->get('error_pricetype');
		}
*/

		if ((utf8_strlen($this->request->post['code']) < 1) || (utf8_strlen($this->request->post['code']) > 64)) {
			$this->error['code'] = $this->language->get('error_code');
		}


		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	private function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/rapnet')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$this->load->model('setting/store');
		$this->load->model('sale/customer');
      	
		foreach ($this->request->post['selected'] as $rapnet_id) {
    		if ($this->config->get('config_rapnet_id') == $rapnet_id) {
	  			$this->error['warning'] = $this->language->get('error_default');	
			}  
			
			$store_total = $this->model_setting_store->getTotalStoresByCustomerGroupId($rapnet_id);

			if ($store_total) {
				$this->error['warning'] = sprintf($this->language->get('error_store'), $store_total);
			}
			
			$customer_total = $this->model_sale_customer->getTotalCustomersByCustomerGroupId($rapnet_id);

			if ($customer_total) {
				$this->error['warning'] = sprintf($this->language->get('error_customer'), $customer_total);
			}
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>