<?php
class ControllerAffiliatePolicy extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('affiliate/policy');

		$this->document->title = $this->language->get('heading_title');

		$this->load->model('affiliate/policy');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_affiliate_policy->editSetting('affiliatepcy', $this->request->post);

			if ($this->config->get('config_currency_auto')) {
				$this->load->model('localisation/currency');

				$this->model_localisation_currency->updateCurrencies();
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect(HTTPS_SERVER . 'index.php?route=affiliate/policy');
		}

		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['Title'] = $this->language->get('Title');
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['tab_policy'] = $this->language->get('tab_policy');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

  		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=common/home',
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=affiliate/policy',
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}


		$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=affiliate/policy';
		$this->data['action'] = HTTPS_SERVER . 'index.php?route=affiliate/policy';
		$this->data['stores'] = array();

		$this->data['stores'][] = array(
			'name' => $this->language->get('text_default'),
			'href' => HTTPS_SERVER . 'index.php?route=affiliate/policy'
		);

		$this->load->model('localisation/language');
		$this->data['languages'] = $this->model_localisation_language->getLanguages();

		$languages = $this->model_localisation_language->getLanguages();

		if (isset($this->request->post['config_description_affterms'])) {
			$this->data['config_description_affterms'] = $this->request->post['config_description_affterms'];
		} else {
			$this->data['config_description_affterms'] = $this->config->get('config_description_affterms');
		}
		if (isset($this->request->post['config_description_afftermshead'])) {
			$this->data['config_description_afftermshead'] = $this->request->post['config_description_afftermshead'];
		} else {
			$this->data['config_description_afftermshead'] = $this->config->get('config_description_afftermshead');
		}


//  Affiliate System -- Add on Starts Here

		$this->data['entry_refamount'] = $this->language->get('entry_refamount');

		$this->data['entry_refamount_enable'] = $this->language->get('entry_refamount_enable');


//  Affiliate System -- Add on Ends   Here

		$this->template = 'affiliate/policy.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'affiliate/policy')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			if (!isset($this->error['warning'])) {
				$this->error['warning'] = $this->language->get('error_required_data');
			}
			return FALSE;
		}
	}

}
?>