<?php
//============================================================+
// File name   : example_009.php
// Begin       : 2008-03-04
// Last Update : 2010-12-04
//
// Description : Example 009 for TCPDF class
//               Test Image
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               Manor Coach House, Church Hill
//               Aldershot, Hants, GU12 4RQ
//               UK
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Test Image
 * @author Nicola Asuni
 * @since 2008-03-04
 */

require_once('../tcpdf/config/lang/eng.php');
require_once('../tcpdf/tcpdf.php');

// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator('SilverTresor');
$pdf->SetAuthor('SilverTresor');
$pdf->SetTitle('SilverTresor Gift Voucher');
$pdf->SetSubject('SilverTresor Gift Voucher');
$pdf->SetKeywords('SilverTresor, Gift, Voucher');
 $pdf->SetMargins(400, 150);

$fontname = $pdf->addTTFfont('../tcpdf/fonts/Agency.ttf', 'TrueTypeUnicode', '', 32);
$fontname = $pdf->addTTFfont('../tcpdf/fonts/calibri.ttf', 'TrueTypeUnicode', '', 32);

//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// add a page
$pdf->AddPage();

// set JPEG quality
$pdf->setJPEGQuality(75);

// test fitbox with all alignment combinations

$horizontal_alignments = array('L', 'C', 'R');
$vertical_alignments = array('T', 'M', 'B');


$txt1 = <<<EOD
<font face="calibri" size="18"><span style="font-weight: bold;"> Voucher Amount: $<Value> </span></font>
EOD;
$txt2 = <<<EOD
<font face="calibri" size="16"><span style="font-weight: bold;"> Gifted to: <Email ID></span></font>
EOD;
$txt3 = <<<EOD
<font face="calibri" size="16"><span style="font-weight: bold;"> Gifted from : <Name> </span></font>
EOD;
$txt4 = <<<EOD
<font face="Agency" size="12" > Redeem at <a href=\"www.silvertresor.com.au\">www.silvertresor.com.au</a></font>  
EOD;
$txt5 = <<<EOD
<font face="calibri" size="10"><br><br>Valid Till:   31st Dec 2012</font>
EOD;


$pdf->Image('../image/main2.png', 40, 50, '', '', 'PNG', 'http://www.silvertresor.com.au', 'T', false, 300, '', false, false, 1, false, false, false);

//$pdf->Image('../images/bottom.png', 20, 120, 140, 20, 'PNG', 'http://www.silvertresor.com.au', '', true, 150, '', false, false, 1, false, false, false);
//$pdf->Image('../images/bottom.png', '', '', 120, 30, '', '', 'T', false, 300, '', false, false, 1, false, false, false);
//$pdf->Image('../images/image_demo.jpg', '', '', 40, 40, '', '', '', false, 300, '', false, false, 1, false, false, false);

// -------------------------------------------------------------------
$pdf->writeHTMLCell($w=120, $h=10, $x=65, $y=100, $txt1, $border=0, $ln=1, $fill=0, $reseth=false, $align='', $autopadding=false);
$pdf->writeHTMLCell($w=120, $h=10, $x=80, $y=110, $txt2, $border=0, $ln=1, $fill=0, $reseth=false, $align='', $autopadding=false);
$pdf->writeHTMLCell($w=120, $h=10, $x=75, $y=120, $txt3, $border=0, $ln=1, $fill=0, $reseth=false, $align='', $autopadding=false);
$pdf->writeHTMLCell($w=120, $h=10, $x=80, $y=140, $txt4, $border=0, $ln=1, $fill=0, $reseth=false, $align='', $autopadding=false);
$pdf->writeHTMLCell($w=120, $h=10, $x=86, $y=140, $txt5, $border=0, $ln=1, $fill=0, $reseth=false, $align='', $autopadding=false);
//Close and output PDF document
$pdf->Output('voucher1.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+
