<?php 
class ModelCatalogProductRpt extends Model { 
	public function getProductsViewed($data = array()) {
		$sql = "SELECT pd.name, p.model, p.viewed FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND p.viewed > 0 ORDER BY p.viewed DESC";
					
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}	
	
	
	public function getAllProducts() {
		$query = $this->db->query("SELECT distinct a.product_id FROM " . DB_PREFIX . "product a WHERE a.status=1 and a.product_id not in (select b.product_id from product_to_category b where b.product_id=a.product_id and b.category_id=63) order by a.product_id ");
		
		return $query->rows;
	}
	
	
	public function getAllMarkupProducts($flag) {
		$query = $this->db->query("SELECT a.product_id,a.product_gemavail_id,a.product_metalavail_id,a.product_cost,b.type FROM product_combinations a ,product b WHERE b.status=1 and a.product_id = b.product_id and b.type=0 and flag <> ". $flag ."   limit 1000");
		
		return $query->rows;
	}
	
	public function getMarkup() {
      	$query = $this->db->query("SELECT flag  FROM markup_flag");
		
		return $query->row['flag'];
	}
	
	public function updateMarkup() {
      	$this->db->query("update markup_flag set flag =flag+1  ");
	}
	
	public function getTotalProductsViewed() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE viewed > 0");
		
		return $query->row['total'];
	}
	
	public function	getProductGemCount($product_id) {
    $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_gemcontent WHERE product_id= '" . $product_id . "'");
		return $query->row['total'];
	}
	
	public function	getProductMetalCount($product_id) {
    $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_metalcontent WHERE product_id= '" . $product_id . "'");
		return $query->row['total'];
	}
	
	public function getTotalProductViews() {
      	$query = $this->db->query("SELECT SUM(viewed) AS total FROM " . DB_PREFIX . "product");
		
		return $query->row['total'];
	}
			
	public function reset() {
		$this->db->query("UPDATE " . DB_PREFIX . "product SET viewed = '0'");
	}
	
	public function getPurchased($data = array()) {
		$sql = "SELECT op.name, op.model, SUM(op.quantity) AS quantity, SUM(op.total + op.total * op.tax / 100) AS total FROM " . DB_PREFIX . "order_product op LEFT JOIN `" . DB_PREFIX . "order` o ON (op.order_id = o.order_id)";
		
		if (!is_null($data['filter_order_status_id'])) {
			$sql .= " WHERE o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'";
		} else {
			$sql .= " WHERE o.order_status_id > '0'";
		}
		
		if (!empty($data['filter_date_start'])) {
			$sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}
		
		$sql .= " GROUP BY op.model ORDER BY total DESC";
					
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$query = $this->db->query($sql);
	
		return $query->rows;
	}
	public function getProductReports($product_id) { 
	
	//	$sql = "SELECT DISTINCT p.model,p.product_id,pd.name from product p,product_description pd where p.product_id=pd.product_id";
 		$sql = "SELECT a.model,pd.name,a.product_id,b.gem,b.gemstone_id,d.gemname as gemname,c.metal,e.metalname as metalname,c.metal_id,b.product_gemavail_id,c.product_metalavail_id,b.image as gemimage,c.image as metalimage,b.defaultnew as gemdefault,c.defaultnew as metaldefault,a.type,a.price as final_price,a.image as product_image,  c.* FROM `product` a,product_description pd, product_gemavail b, product_metalavail c,gemstone d,metal e where a.product_id=pd.product_id and pd.language_id=1 and a.product_id=b.product_id and a.product_id=c.product_id and a.product_id= " . $product_id . " and b.gem=1 and c.metal=1 and b.gemstone_id=d.gemstone_id and c.metal_id=e.metal_id order by c.metal_id";
		$query = $this->db->query($sql);
	
		return $query->rows;
	}
	public function getProductReports12($data = array()) {
		$sql = "SELECT DISTINCT p.model,p.product_id,pd.name from product p,product_description pd where p.product_id=pd.product_id and p.product_id =158";
		
		$query = $this->db->query($sql);
	
		return $query->rows;
	}
	public function getProductGemavail($pid) {
      	$query = $this->db->query("SELECT pg.gem,gemname FROM product_gemavail pg,gemstone g where g.gemstone_id=pg.gemstone_id and pg.product_id='" . $pid . "'");
		
		return $query->rows;
	}
	public function getProductGem($pid,$gid) {
      	$query = $this->db->query("SELECT pg.gem,gemname FROM product_gemavail pg,gemstone g where g.gemstone_id=pg.gemstone_id and pg.product_id='" . $pid . "' and pg.gem = '" . $gid . "'");
		
		return $query->rows;
	}
	public function getProductGemDtl($pid) {
      	$query = $this->db->query("SELECT gemname,pg.* FROM product_gemavail pg,gemstone g where g.gemstone_id=pg.gemstone_id and pg.defaultnew=1  and pg.product_id='" . $pid . "' order by gem");
		
		return $query->rows;
	}
	public function getProductMetalavail($pid) {
      	$query = $this->db->query("SELECT metal_code,pricepergram FROM product_metalavail pm,metal m where m.metal_id=pm.metal_id and  pm.product_id='" . $pid . "'");
		
		return $query->rows;
	}
	public function getProductMetal($pid,$mid) {
      	$query = $this->db->query("SELECT metalname  FROM product_metalavail pm,metal m where m.metal_id=pm.metal_id and pm.defaultnew=1 and pm.product_id='" . $pid . "' and pm.metal = '" . $mid . "' ");
		
		return $query->rows;
	}
	
	public function getProductMetalDtl($pid) {
      	$query = $this->db->query("SELECT metalname,pm.* FROM product_metalavail pm,metal m where m.metal_id=pm.metal_id and pm.defaultnew=1 and pm.product_id='" . $pid . "'  order by metal ");
		
		return $query->rows;
	}
	
	
	public function updateAllProductsMetalDtl($metalid) {
      	$query = $this->db->query("SELECT metalname,pm.* FROM product_metalavail pm,metal m where m.metal_id=pm.metal_id and  pm.metal_id='" . $metalid . "'  order by metal ");
		
		$products_all_metalavail =  $query->rows;
		foreach ($products_all_metalavail as $metalavail) {
			$metalinfo =  split(':',$this->getProductMetalCost($metalavail['product_metalavail_id'])); 
			$metal_cost = (float)$metalinfo[0];
			$metal_weight = $metalinfo[1];
			$metal_rate = $metalinfo[2];
			$updateSQL = "update product_metalavail set weight_with_silverratio='". $metal_weight  ."',metal_rate='". $metal_rate  ."',selling_cost='". $metal_cost  ."' where product_metalavail_id='". $metalavail['product_metalavail_id']."'"; 
			$query = $this->db->query($updateSQL);
		}
	}
	
	public function updateAllProductsGemDtl($gemid) {
      	$query = $this->db->query("SELECT gemname,pg.* FROM product_gemavail pg,gemstone g where g.gemstone_id=pg.gemstone_id and  pg.gemstone_id='" . $gemid . "' order by gem");

		$products_all_gemavail =  $query->rows;
		foreach ($products_all_gemavail as $gemavail) {
			$gemcost2 =  split(':',$this->getProductGemstoneCost($gemavail['product_gemavail_id']));
			$gem_cost = (float)$gemcost2[0];
			$gem_weight = $gemcost2[1];
			$gem_size = $gemcost2[2];
			$gem_rate = $gemcost2[3];
			$updateSQL = "update product_gemavail set  selling_weight='". $gem_weight ."',selling_rate='". $gem_rate  ."',selling_cost='". $gem_cost  ."' where product_gemavail_id='". $gemavail['product_gemavail_id']."'"; 
			$query = $this->db->query($updateSQL);	
		}
	}
	
	public function updateProductMetalDtl($pid) {
      	$query = $this->db->query("SELECT metalname,pm.* FROM product_metalavail pm,metal m where m.metal_id=pm.metal_id and  pm.product_id='" . $pid . "'  order by metal ");
		
		$products_all_metalavail =  $query->rows;
		foreach ($products_all_metalavail as $metalavail) {
			$metalinfo =  split(':',$this->getProductMetalCost($metalavail['product_metalavail_id'])); 
			$metal_cost = (float)$metalinfo[0];
			$metal_weight = $metalinfo[1];
			$metal_rate = $metalinfo[2];
			$updateSQL = "update product_metalavail set weight_with_silverratio='". $metal_weight  ."',metal_rate='". $metal_rate  ."',selling_cost='". $metal_cost  ."' where product_metalavail_id='". $metalavail['product_metalavail_id']."'"; 
			$query = $this->db->query($updateSQL);
		}
	}
	
	
	public function updateProductGemDtl($pid) {
      	$query = $this->db->query("SELECT gemname,pg.* FROM product_gemavail pg,gemstone g where g.gemstone_id=pg.gemstone_id and  pg.product_id='" . $pid . "' order by gem");

		$products_all_gemavail =  $query->rows;
		foreach ($products_all_gemavail as $gemavail) {
			$gemcost2 =  split(':',$this->getProductGemstoneCost($gemavail['product_gemavail_id']));
			$gem_cost = (float)$gemcost2[0];
			$gem_weight = $gemcost2[1];
			$gem_size = $gemcost2[2];
			$gem_rate = $gemcost2[3];
			$updateSQL = "update product_gemavail set  selling_weight='". $gem_weight ."',selling_rate='". $gem_rate  ."',selling_cost='". $gem_cost  ."' where product_gemavail_id='". $gemavail['product_gemavail_id']."'"; 
			$query = $this->db->query($updateSQL);	
		}
	}
	
	public function getProductMetalContent($pid) {
    $query = $this->db->query("SELECT  * FROM product_metalcontent   where product_id='" . $pid . "'  order by metal ");
		return $query->rows;
	}
	
	public function getProductDefaultMetalAvail($pid,$metalid) {
    $query = $this->db->query("SELECT  * FROM product_metalavail   where product_id='" . $pid . "'  and defaultnew=1 and metal='" . $metalid . "'");
		return $query->row;
	}
	
	public function getProductDefaultGemAvail($pid,$gemid) {
    $query = $this->db->query("SELECT  * FROM product_gemavail   where product_id='" . $pid . "' and defaultnew=1 and gem='" . $gemid . "'");
		return $query->row;
	}
	
	public function getProducts() {
    $query = $this->db->query("SELECT  * FROM product  where status=1 order by metal  limit 10");
		return $query->rows;
	}
	
	public function getShapes($shape_id) {
    $query = $this->db->query("SELECT shape FROM shape where shape_id=" . $shape_id);
		return $query->row['shape'];
	}
		
	public function getProductGemContent($pid) {
    $query = $this->db->query("SELECT  * FROM product_gemcontent   where product_id='" . $pid . "'  order by gem ");
		return $query->rows;
	}
	
	public function getProductMetalCost($product_metalavail_id) {
		$cost=0;
		$sql = "SELECT a.pricepergram * c.weight * a.silver_ratio as metalcost,a.pricepergram,c.weight as weight,a.*,b.*,c.*  from `metal` a, product_metalavail b, product_metalcontent c WHERE a.metal_id = b.metal_id AND b.product_id = c.product_id AND b.metal = c.metal AND b.product_metalavail_id = '" . (int)$product_metalavail_id . "' ";

		$query = $this->db->query($sql);
		$weight = 0;
		if ($query->num_rows) {
			$cost=$query->row['metalcost'];
			$weight = $query->row['weight'] * $query->row['silver_ratio'] . ':' . $query->row['pricepergram'];
		}else{
 		}
		//return round($this->currency->convert($cost,$query->row['ccurrency'], $this->currency->getCode()),2) . ':' . $weight ;
		return round($this->currency->convert($cost,$query->row['ccurrency'], $this->currency->getCode()),2) . ':' . $weight ;

		//return $cost;
	}
	
	public function getProductGemstoneCost($product_gemavail_id) {
		//$query = $this->db->query("SELECT a.pricepergram * c.weight as metalcost FROM metal a, product_metalavail b, product_metalcontent c WHERE a.metal_id = b.metal_id AND b.product_id = c.product_id AND b.metal = c.metal AND b.product_metalavail_id = '" . (int)$metal . "' ");
		$cost=0;
		
//		$sql="select a.pricepercarat,	a.priceperpiece,d.weight,d.count,b.price	from gemstone_price a, product_gemavail b,colour_clarity c, product_gemcontent d  where  a.gemstone_id	= b.gemstone_id	and a.gemstone_id=c.gemstone_id	and b.product_id  = d.product_id and b.gem=d.gem and a.lowclarity > c.clarity_id and a.highclarity <= c.clarity_id and  a.lowcolour > c.colour_id and a.highcolour <= c.colour_id and b.product_gemavail_id=  '" . $product_gemavail_id . "'" ;
//		$sql="select a.pricepercarat, a.priceperpiece,d.weight,d.count,b.price,c.pricebycart	from gemstone_price a, product_gemavail b, colour_clarity c, product_gemcontent d  where  a.gemstone_id	= b.gemstone_id		and b.product_id  = d.product_id and b.gem=d.gem   and a.gemstone_id=c.gemstone_id and c.clarity_id >= a.lowclarity and c.clarity_id <= a.highclarity and c.colour_id>= a.lowcolour  and c.colour_id <= a.highcolour and d.shape_id = a.shape and b.product_gemavail_id= '" . $product_gemavail_id . "'" ;

    $rapnetFlag_Failed=1;
	
	$sql="select ga.gemstone_id as gemstone_id,ga.rapnet as rapnet, gp.pricetype,gp.price as gcprice,gc.shape_id, gw.weight,gc.count  ,gc.size, gcc.clarity_id, 	gcc.colour_id , gc.setting_id, gp.ccurrency,ga.product_id
	from gemstone_price gp, product_gemavail ga, colour_clarity gcc, product_gemcontent gc , gemstone_weight gw
	where  gp.gemstone_id = ga.gemstone_id and  ga.gemstone_id = gcc.gemstone_id and ga.product_id = gc.product_id 
	and ga.gem=gc.gem and gw.gemstone_id= ga.gemstone_id and ga.product_gemavail_id=  '" . $product_gemavail_id . "'
	and gc.shape_id = gp.shape and gw.shape = gc.shape_id and gw.size_code = gc.size  
	and gcc.clarity_id >= gp.lowclarity and gcc.clarity_id <= gp.highclarity and gcc.colour_id>= gp.lowcolour 
	and gw.weight > gp.lowweight and gw.weight <= gp.highweight
	and gcc.colour_id <= gp.highcolour ";
	//$this->log->write(  $sql );
	$query = $this->db->query($sql);
    if($query->row['rapnet']==1){
//		$this->log->write( 'RapNet Processing Weight : ' . $query->row['weight'] . ' ; Size : ' . $query->row['size'] );
		$weight = $query->row['weight'];

		$sql5="SELECT * FROM `size` where size_code = '" . $query->row['size'] . "'";
		$query5 = $this->db->query($sql5);
		
		$measlength = $query5->row['measlength'];
		$measwidth = $query5->row['measwidth'];

		$sql1="SELECT *,b.shape as shape_data FROM `rapnet_default` a,shape b where a.shape=b.shape_id and lowweight <= " . $weight ."  and highweight>=" . $weight . " limit 1";
		$query1 = $this->db->query($sql1);
		if ($query1->num_rows) {
//				$this->log->write( 'RapNet variation'  . $query1->row['variation']);

				$variation = $query1->row['variation'];	
				//weight >= " . $query1->row['lowweight'] ."  and weight <= " . $query1->row['highweight'] . " and
				$sql2="SELECT * FROM `rapnet_tbl`  where  clarity_id >= " . $query1->row['lowclarity'] . " and clarity_id <= " . $query1->row['highclarity'] . " and colour_id >= " . $query1->row['lowcolour'] . " and colour_id <= " . $query1->row['highcolour'] . " and shape = '" . $query1->row['shape_data'] . "' and  measwidth >= " . ((float)$measwidth - (float)$variation) . " and measwidth <= " .  ((float)$measwidth + (float)$variation) . "   and measlength >= " . ((float)$measlength - (float)$variation) . " and measlength <= " . ((float)$measlength + (float)$variation) . " order by clarity_id desc,colour_id desc,rapnet_final_price asc limit 1";
//				$this->log->write( 'RapNet SQL : '  . $sql2 );
				$query2 = $this->db->query($sql2);
				if ($query2->num_rows) {
					//$cost = $query2->row['rapnet_final_price'] * ( 1 + $query2->row['rapnet_discount_price']);
					$cost = $query2->row['rapnet_final_price'] ;
					$cost = $cost * $query->row['count']; 
					$rapnetFlag_Failed = 0;
					
					$this->session->data[ 'LotNo-' . $query->row['product_id'] . '-' . $product_gemavail_id] = $query2->row['rapnet_lot_no'];
					
//					$this->log->write( ' RapNet Price(USD) : '. $query2->row['rapnet_final_price'] . '  ' . ' ; LotNo-' . $query->row['product_id'] . '-' . $product_gemavail_id );

					$weight = $query->row['weight'] ;
					$size = $query->row['size'] ;
					$shape = $query->row['shape_id'] ;
					$price = $query2->row['rapnet_final_price'];
		
					return round($this->currency->convert($cost,'USD', $this->currency->getCode()),2)  . ':' . $weight . ':' . $size . ':' . $price . ':' . $shape;
				}else{
					//return round($this->currency->convert(1000,'USD', $this->currency->getCode()),2);
					$rapnetFlag_Failed = 1;
				}
		}else{
			//return round($this->currency->convert(1000,'USD', $this->currency->getCode()),2);
			$rapnetFlag_Failed = 1;
		}
		
	}
	if($rapnetFlag_Failed){
	//G1-Gemstone-Shape-Size-Count-Weight-Clarity-Colour-Setting-PriceCaratOrPiece
//		$this->log->write( ' GemStoneId : ' . $query->row['gemstone_id'] . ' ; Size : '. $query->row['size']  . ' ; Shape : '. $query->row['shape_id']  . ' ; Count : '. $query->row['count']  . ' ; Weight : '. $query->row['weight']  );
//		$this->log->write( ' Colour : '. $query->row['colour_id']   . ' Clarity : '. $query->row['clarity_id']   . ' ; Setting : '. $query->row['setting_id']    . ' ; Price : '. $query->row['gcprice'] . ' ; ' . ' ; Price : '. $query->row['ccurrency'] . ' ; ' );


	// pricetype=='0' , then priceperpiece or  pricetype=='1' , then pricepercarat 
		if ($query->num_rows) {
			if($query->row['pricetype']=='1'){
//				$this->log->write( ' Price Type : Price Per Piece'  );

				//$cost=$query->row['priceperpiece'] * $query->row['count'];
				$cost = $query->row['gcprice'] * $query->row['count'];
			}else{
//				$this->log->write( ' Price Type : Price Per Carat'  );
				//$cost=$query->row['pricepercarat'] * $query->row['weight'];
				$cost = $query->row['gcprice'] * $query->row['weight'] * $query->row['count'];
			}
		}else{
			$cost=123;
		}
		
		//return $query->row['metalcost'];
	//	return $cost;

		$weight = $query->row['weight'] ;
		$size = $query->row['size'] ;
		$shape = $query->row['shape_id'] ;
		$price = $query->row['gcprice'];
		
		return round($this->currency->convert($cost,$query->row['ccurrency'], $this->currency->getCode()),2) . ':' . $weight . ':' . $size . ':' . $price . ':' . $shape;
	 }
		
	}
	
	
	public function getProductSettingCost($product_id) {
		$cost = 0;
		$query = $this->db->query("SELECT a.count * b.cost as settingcost,b.ccurrency,a.count,a.setting_id,b.cost as price  FROM " . DB_PREFIX . "product_gemcontent a,laboursettingcost b   WHERE a.setting_id = b.setting_id and a.product_id = '" . (int)$product_id . "'" );
		foreach ($query->rows as $setting) {
//			$this->log->write( ' Setting Id : ' . $setting['setting_id'] . ' ; count : '. $setting['count']  . ' ; Currency : '. $setting['ccurrency']  . ' ; Price : '. $setting['price'] . ' ; Converted Price : ' . $this->currency->convert($setting['settingcost'],$setting['ccurrency'], $this->currency->getCode())  );
			$cost += $this->currency->convert($setting['settingcost'],$setting['ccurrency'], $this->currency->getCode());
		}
		return round($cost,2);
	}
	
	
	public function getProductWeightCost($product_id,$product_details) {
			//$product_details = $this->session->data['product_details'];
			$metalWeight=0;
			$gemWeight=0;
			$totalweight=0;
			foreach ($product_details as $product_detail) {
				if($product_detail['type']=='M')	// Process the selected metal
			  	{
					$query1 = $this->db->query("SELECT b.weight , c.silver_ratio, b.weight * c.silver_ratio as metalWeight FROM " . DB_PREFIX . "product_metalavail a , product_metalcontent b, metal c WHERE a.product_metalavail_id = '" . (int)$product_detail['value'] . "' and a.product_id=b.product_id and a.metal=b.metal and a.metal_id = c.metal_id " ); 
					$metalWeight +=  $query1->row['metalWeight'];
				}else{									// if Metal Selected;
					$query2 = $this->db->query("SELECT b.count , c.weight, (b.count * c.weight / 5) as gemWeight FROM " . DB_PREFIX . "product_gemavail a , product_gemcontent b, gemstone_weight c WHERE a.product_gemavail_id = '" . (int)$product_detail['value'] . "'  and a.product_id=b.product_id and a.gem=b.gem and b.size=c.size_code and b.shape_id=c.shape and a.gemstone_id = c.gemstone_id " );
					$gemWeight += $query2->row['gemWeight'] ;
				}
			}
//			$this->log->write("Metal Weight : " . $metalWeight . "; Gems Weight : " . $gemWeight ); 
			$totalweight = $metalWeight + $gemWeight ;

			$query = $this->db->query("SELECT " . $totalweight . " * cost as labourweightcost,cost,ccurrency as currency  FROM " . DB_PREFIX . "labour_weight_based_costs a  WHERE low_weight <'" .  $totalweight . "' and high_weight >='" .  $totalweight . "' ");
//			$this->log->write("Labout Weight Based Cost : " . $query->row['labourweightcost'] . "; Currency : " . $query->row['currency'] . "; Cost : " . $query->row['cost'] ); 
	//		return round($this->currency->convert($query->row['labourweightcost'],$query->row['currency'], $this->currency->getCode()),2);
			return round($this->currency->convert($query->row['labourweightcost'],$query->row['currency'], $this->currency->getCode()),2); ;
	}

	public function getProductMetalAvalability_Not1($product_id) {
		$query = $this->db->query("SELECT a.*,b.sort_order,b.description FROM " . DB_PREFIX . "product_metalavail a,metal b  WHERE a.metal != 1 and a.metal_id=b.metal_id and a.product_id = '" . (int)$product_id . "' order by b.sort_order");
		return $query->rows;
	}
			
	public function getProductGemstonesAvalability_Not1($product_id) {
		$query = $this->db->query("SELECT a.*,b.gemname FROM " . DB_PREFIX . "product_gemavail a, gemstone b  WHERE a.gem != 1 and a.gemstone_id=b.gemstone_id and  a.product_id = '" . (int)$product_id . "' order by gem");
		return $query->rows;
	}
	
	public function getProductMarkupCost($product_id, $product_cost) { 
		$query = $this->db->query("SELECT overriding_mark_up_ubsolute,overriding_markup_percentage FROM " . DB_PREFIX . "product_vw  WHERE product_id = '" . (int)$product_id . "'");
		if($query->row['overriding_mark_up_ubsolute']){
			$cost =$query->row['overriding_mark_up_ubsolute'] + $product_cost;
//			$this->log->write( 'Product Level Markup Absolute : ' . $query->row['overriding_mark_up_ubsolute']  . '  ; Markup Cost Cost : ' . $cost );
			return $query->row['overriding_mark_up_ubsolute'] + $product_cost ;
		}else{
			if($query->row['overriding_markup_percentage']){
				$cost = $product_cost + ($query->row['overriding_markup_percentage']  * $product_cost /100);
//				$this->log->write( 'Product Level Markup Percentage : ' . $query->row['overriding_markup_percentage']  . '  ; Markup Cost Cost : ' . $cost );
				return ($product_cost + ($query->row['overriding_markup_percentage'] * $product_cost / 100));
			}else{
				if( (int)$this->config->get('pricelimit_four') <= $product_cost ){
					$ovrd_percentage = (int)$this->config->get('overriding_five') ; 
				}else if( (int)$this->config->get('pricelimit_three') <= $product_cost ){
					$ovrd_percentage = (int)$this->config->get('overriding_four') ; 
				}else if( (int)$this->config->get('pricelimit_two') <= $product_cost ){
					$ovrd_percentage = (int)$this->config->get('overriding_three') ; 
				}else if( (int)$this->config->get('pricelimit_one') <= $product_cost ){
					$ovrd_percentage = (int)$this->config->get('overriding_two') ; 
				}else{
					$ovrd_percentage = (int)$this->config->get('overriding_one') ; 
				} 
				$cost = $product_cost + (($ovrd_percentage - 100)  * $product_cost / 100);
//				$this->log->write( 'Store Level Markup Percentage : ' . $ovrd_percentage  . '  ; Markup Cost Added : ' .  $cost );
				return ($product_cost + ($ovrd_percentage  * $product_cost /100));
			}
		}
	} 
	
	public function getTotalPurchased($data) {
      	$sql = "SELECT COUNT(DISTINCT op.model) AS total FROM `" . DB_PREFIX . "order_product` op LEFT JOIN `" . DB_PREFIX . "order` o ON (op.order_id = o.order_id) ";

		if (!is_null($data['filter_order_status_id'])) {
			$sql .= " WHERE o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'";
		} else {
			$sql .= " WHERE o.order_status_id > '0'";
		}
		
		if (!empty($data['filter_date_start'])) {
			$sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}
		
		$query = $this->db->query($sql);
				
		return $query->row['total'];
	}
}
?>