<?php   
class ControllerCommonHeader extends Controller {
protected function index() {
		$this->data['title'] = $this->document->getTitle(); 
		
		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$this->data['base'] = $this->config->get('config_ssl');
		} else {
			$this->data['base'] = $this->config->get('config_url');
		}
		
		$this->data['description'] = $this->document->getDescription();
		$this->data['keywords'] = $this->document->getKeywords();
		$this->data['links'] = $this->document->getLinks();	 
		$this->data['styles'] = $this->document->getStyles();
		$this->data['scripts'] = $this->document->getScripts();
		$this->data['lang'] = $this->language->get('code');
		$this->data['direction'] = $this->language->get('direction');
		$this->data['google_analytics'] = html_entity_decode($this->config->get('config_google_analytics'), ENT_QUOTES, 'UTF-8');
		
		$this->language->load('common/header');
		
		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$server = HTTPS_IMAGE;
		} else {
			$server = HTTP_IMAGE;
		}	
				
		if ($this->config->get('config_icon') && file_exists(DIR_IMAGE . $this->config->get('config_icon'))) {
			$this->data['icon'] = $server . $this->config->get('config_icon');
		} else {
			$this->data['icon'] = '';
		}
		
		$this->data['name'] = $this->config->get('config_name');
				
		if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
			$this->data['logo'] = HTTP_IMAGE . $this->config->get('config_logo');
		} else {
			$this->data['logo'] = '';
		}
		
		
		// Rakuten LinkShare Integration - Starts Here
		
		if (isset($this->request->get['siteID'])) 
		{
			$this->session->data['rakuten_siteID'] = $this->request->get['siteID'];
			$this->data['siteID'] = $this->request->get['siteID'];
		} else {
			if(isset($this->session->data['rakuten_siteID'])){
				$this->data['siteID']= $this->session->data['rakuten_siteID'];
				$this->session->data['rakuten_siteID'] = $this->session->data['rakuten_siteID'];
			}else{
				$this->data['siteID']= '';
				$this->session->data['rakuten_siteID'] = '';			
			}
		}
		
		// Rakuten LinkShare Integration - Ends Here
		
		
		// Affiliate Starts here
	
		$this->data['text_AffiliatesHead'] = $this->language->get('text_AffiliatesHead');
		if ($this->affiliate->isLogged())
		{
			$this->data['text_addbanner'] = $this->language->get('text_addbanner');
			$this->data['addbanner'] = HTTP_SERVER . 'index.php?route=affiliate/banners&add=yes';
		} else {
			$this->data['addbanner']= '';
		}
		$this->data['affiliate'] = HTTP_SERVER . 'index.php?route=affiliate/account';
		
    // Affiliate Ends here

		
		// Calculate Totals
		$total_data = array();					
		$total = 0;
		$taxes = $this->cart->getTaxes();
		$this->data['cartcount'] = $this->cart->countProducts();
		
		if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {						 
			$this->load->model('setting/extension');
			
			$sort_order = array(); 
			
			$results = $this->model_setting_extension->getExtensions('total');
			
			foreach ($results as $key => $value) {
				$sort_order[$key] = $this->config->get($value['code'] . '_sort_order');
			}
			
			array_multisort($sort_order, SORT_ASC, $results);
			
			foreach ($results as $result) {
				if ($this->config->get($result['code'] . '_status')) {
					$this->load->model('total/' . $result['code']);
		
					$this->{'model_total_' . $result['code']}->getTotal($total_data, $total, $taxes);
				}
			}
		}
		
		$this->data['text_home'] = $this->language->get('text_home');
		$this->data['text_wishlist'] = sprintf($this->language->get('text_wishlist'), (isset($this->session->data['wishlist']) ? count($this->session->data['wishlist']) : 0));
		$this->data['text_cart'] = $this->language->get('text_cart');
		$this->data['text_items'] = sprintf($this->language->get('text_items'), $this->cart->countProducts() + (isset($this->session->data['vouchers']) ? count($this->session->data['vouchers']) : 0), $this->currency->format($total));
    		$this->data['text_search'] = $this->language->get('text_search');
		$this->data['text_welcome'] = sprintf($this->language->get('text_welcome'), $this->url->link('account/login', '', 'SSL'), $this->url->link('checkout/cart', '', 'SSL'));
		$this->data['logged'] = '';
		if($this->customer->isLogged()) {
		$this->data['logged'] = $this->customer->isLogged();
		$this->data['text_logged'] = sprintf($this->language->get('text_logged'), $this->url->link('account/edit', '', 'SSL'), $this->customer->getFirstName(), $this->url->link('account/logout', '', 'SSL'));
		
		} elseif($this->designer->isLogged()) {
		$this->data['logged'] = $this->designer->isLogged();
		$this->data['text_logged'] = sprintf($this->language->get('text_logged'), $this->url->link('desaccount/edit', '', 'SSL'), $this->designer->getFirstName(), $this->url->link('desaccount/logout', '', 'SSL'));
		}elseif($this->valuer->isLogged()) {
		$this->data['logged'] = $this->valuer->isLogged();
		$this->data['text_logged'] = sprintf($this->language->get('text_logged'), $this->url->link('valuers/edit', '', 'SSL'), $this->valuer->getFirstName(), $this->url->link('valuers/logout', '', 'SSL'));
		}
		$this->data['text_account'] = $this->language->get('text_account');
    	$this->data['text_checkout'] = $this->language->get('text_checkout');
    	$this->data['text_blogs'] = $this->language->get('text_blogs');
		$this->data['text_language'] = $this->language->get('text_language');
    	$this->data['text_currency'] = $this->language->get('text_currency');
    	$this->data['text_designs'] = $this->language->get('text_designs');
				
		$this->data['home'] = $this->url->link('common/home');
//		$this->data['designer'] = $this->url->link('desaccount/login');
		$this->data['designer'] = 'designers';
		$this->data['valuer'] = $this->url->link('valuers/login');
		$this->data['wishlist'] = $this->url->link('account/wishlist');
		
		$this->data['account'] = $this->url->link('account/account', '', 'SSL');
		$this->data['cart'] = $this->url->link('checkout/cart');
		$this->data['blogss'] = $this->url->link('information/blog');
		$this->data['newdesigns'] = $this->url->link('information/myown');
		$this->data['designer_list'] = $this->url->link('desaccount/designerlist');
		$this->data['valuer_list'] = $this->url->link('valuers/valuerlist');
		$this->data['checkout'] = $this->url->link('onecheckout/checkout', '', 'SSL');
		
		if (isset($this->request->get['filter_name'])) {
			$this->data['filter_name'] = $this->request->get['filter_name'];
		} else {
			$this->data['filter_name'] = '';
		}
		
		$this->load->model('catalog/information');
		$this->data['Information'] = $this->model_catalog_information->getInformation(50);

		
		$this->data['action'] = $this->url->link('common/home');

		if (!isset($this->request->get['route'])) {
			$this->data['redirect'] = $this->url->link('common/home');
		} else {
			$data = $this->request->get;
			
			unset($data['_route_']);
			
			$route = $data['route'];
			
			unset($data['route']);
			
			$url = '';
			
			if ($data) {
				$url = '&' . urldecode(http_build_query($data, '', '&'));
			}			
			
			$this->data['redirect'] = $this->url->link($route, $url);
		}

    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && isset($this->request->post['language_code'])) {
			$this->session->data['language'] = $this->request->post['language_code'];
		
			if (isset($this->request->post['redirect'])) {
				$this->redirect($this->request->post['redirect']);
			} else {
				$this->redirect($this->url->link('common/home'));
			}
    	}		
						
		$this->data['language_code'] = $this->session->data['language'];
		
		$this->load->model('localisation/language');
		
		$this->data['languages'] = array();
		
		$results = $this->model_localisation_language->getLanguages();
		
		foreach ($results as $result) {
			if ($result['status']) {
				$this->data['languages'][] = array(
					'name'  => $result['name'],
					'code'  => $result['code'],
					'image' => $result['image']
				);	
			}
		}

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && isset($this->request->post['currency_code'])) {
      		$this->currency->set($this->request->post['currency_code']);
			
			unset($this->session->data['shipping_methods']);
			unset($this->session->data['shipping_method']);
				
			if (isset($this->request->post['redirect'])) {
				$this->redirect($this->request->post['redirect']);
			} else {
				$this->redirect($this->url->link('common/home'));
			}
   		}
   		
		$this->data['currency_code'] = $this->currency->getCode(); 
		
		$this->load->model('localisation/currency');
		 
		 $this->data['currencies'] = array();
		 
		$results = $this->model_localisation_currency->getCurrencies();	
		
		foreach ($results as $result) {
			if ($result['status']) {
   				$this->data['currencies'][] = array(
					'title'        => $result['title'],
					'code'         => $result['code'],
					'symbol_left'  => $result['symbol_left'],
					'symbol_right' => $result['symbol_right']				
				);
			}
		}
		
		// Menu
		$this->load->model('catalog/category');
		$this->load->model('catalog/product');
		
		$this->data['categories'] = array();
					
		$categories = $this->model_catalog_category->getCategories(0);
		
		foreach ($categories as $category) {
			if ($category['top']) {
				$children_data = array();
				
				$children = $this->model_catalog_category->getCategories($category['category_id']);
				
				foreach ($children as $child) {
					$data = array(
						'filter_category_id'  => $child['category_id'],
						'filter_sub_category' => true	
					);		
						
					$product_total = $this->model_catalog_product->getTotalProducts($data);
					if($product_total){
						$catname  = $child['name'] . ' (' . $product_total . ')' ;
					 }else{
					 	$catname  = $child['name'] ;
   				        }
					if($child['category_url']=='0' ||  $child['category_url']=='' ||  $child['category_url']==' '){
					    $children_data[] = array(
						'name'  => $catname,
						'href'  => $this->url->link('product/category', 'path=' . $category['category_id'] . '_' . $child['category_id'])	
					    );	
					}else{
					    $children_data[] = array(
						'name'  => $catname,
						'href'  => $child['category_url'] 
 					    );					
					}		
				}
				if($category['category_url']=='0' ||  $category['category_url']=='' ||  $category['category_url']==' '){
					$cat_href=$this->url->link('product/category', 'path=' . $category['category_id']);
				}else{
					$cat_href=$category['category_url'];
				}
				// Level 1
				$this->data['categories'][] = array(
					'name'     => $category['name'],
					'children' => $children_data,
					'column'   => $category['column'] ? $category['column'] : 1,
					'href'     => $cat_href
				);
			}
		}
				
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/header.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/header.tpl';
		} else {
			$this->template = 'default/template/common/header.tpl';
		}
		
    	$this->render();
	} 	
}
?>