<?php  
class ControllerModuleBPPCP extends Controller {
	protected function index($setting) {
		$this->language->load('module/bp_pcp');
		
		$this->load->model('blog/post');
	
		$this->data['text_read'] 		 = $this->language->get('text_read');
		$this->data['text_comments'] 	 = $this->language->get('text_comments');
		$this->data['text_more_stories'] = $this->language->get('text_more_stories');
		
		$limit = (int)$this->config->get('bp_pcp_more_stories') + 1;
		
		$selected_left   = explode(',', $this->config->get('bp_pcp_selected_left'));
		$selected_right  = explode(',', $this->config->get('bp_pcp_selected_right'));
		
		$this->data['left_category_posts'] = $this->getPCPCategoryPosts($selected_left, $limit);
		$this->data['right_category_posts'] = $this->getPCPCategoryPosts($selected_right, $limit);
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/bp_pcp.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/bp_pcp.tpl';
		} else {
			$this->template = 'default/template/module/bp_pcp.tpl';
		}
		
		$this->render();
	}
	
	private function getPCPCategoryPosts($categories_ids, $limit){
		$category_post_data = array();
		
		$this->load->model('blog/category');
		$this->load->model('blog/post');
		$this->load->model('tool/image');
		
		$sort  = 'p.date_added';
		$order = 'DESC';
		
		if ($categories_ids) {
			foreach($categories_ids as $category_id){
				
				$category_info = $this->model_blog_category->getCategory($category_id);
				
				if ($category_info){
					
					$posts = array();
				
					$data = array(
						'filter_category_id' => $category_id, 
						'filter_sub_category'=> $this->config->get('bp_pcp_sub_category'),
						'sort'               => $sort,
						'order'              => $order,
						'start'              => 0,
						'limit'              => $limit
					);
					
					$results = $this->model_blog_post->getPosts($data);
					
					if ($results){
						foreach($results as $result){
							
							if ($result['image']){
								$image = $this->model_tool_image->resize($result['image'], 100,70);
								$small_image = $this->model_tool_image->resize($result['image'], 32,32);
							} else {
								$image = $this->model_tool_image->resize('blog_no_image.jpg', 100,70);
								$small_image = $this->model_tool_image->resize('blog_no_image.jpg', 32,32);
							}
						
							$posts[] = array(
								'post_id'           => $result['post_id'],
								'image'             => $image,
								'small_image'       => $small_image,
								'name'              => $result['name'],
								'short_description' => utf8_substr(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')), 0, 85) . '..',
								'comments'          => $result['reviews'],
								'href'              => $this->url->link('blog/post', 'post_id=' . $result['post_id'], 'SSL')
							);
						}
					}
					
					$category_post_data[] = array(
						'category_id' => $category_info['category_id'],
						'name'        => $category_info['name'],
						'href'        => $this->url->link('blog/category', 'bpath=' . $category_info['category_id'], 'SSL'),
						'posts'       => $posts
					);
				}
			}
		}
		
		return $category_post_data;
	}
}
?>