<?php  
class ControllerModuleBPAboutAuthor extends Controller {
	protected function index($setting) {
		$this->language->load('module/bp_about_author');
		
		$this->load->model('blog/post');
		$this->load->model('blog/author');
		
		if (isset($this->request->get['post_id'])){
			
			$post_info = $this->model_blog_post->getPost($this->request->get['post_id']);
			$date_added = date($this->language->get('date_format_short'), strtotime($post_info['date_added']));
			$href_author_posts = $this->url->link('blog/search', 'filter_author_id=' . $post_info['author_id'], 'SSL');
			$total_posts = $this->model_blog_author->getTotalPostsByAuthorId($post_info['author_id']);
			
			$this->data['heading_title'] = $this->language->get('heading_title');
			$this->data['text_about_author'] = sprintf($this->language->get('text_about_author'), $date_added, $href_author_posts, $post_info['author_name'], $total_posts);
	
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/bp_about_author.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/module/bp_about_author.tpl';
			} else {
				$this->template = 'default/template/module/bp_about_author.tpl';
			}
			
			$this->render();
		}
	}
}
?>